;     written 10/3/84 gwf
;NEWNAME --- This program will rename (and even change directories)
; of a given file. The drive, path, and name of the file to be
; renamed is the first parameter sent. The new path and name is the
; second parameter sent.

;
; DEFINTION --- An absolute file name is the drive designator
;   followed by the complete path from the root to the actual
;   file name. E.g. PED3.EXE lives in the \SYS\PL directory on
;   on the C drive. Its absolute file name is:
;		 C:\SYS\PL\PED3.EXE
;
;
;     
;       CALL NEWNAME(OLD.NAME,NEW.NAME)	 
; Call with parameters present absolute name +CHR$(0) as first
;  parameter, desired absolute name +CHR$(0) as second parameter.
;  The drive designator on the second parameter can be omitted
;  if the drive designator on the first parameter is the default
;  drive. Otherwise, both drive designators must be present.
;     
;
;		      Example program to compile
;
;		  10 color 7,1:cls
;		  20 input"Present location & name ",ans$
;		  30 X$=ans$+CHR$(0)
;		  40 input"Desired location & name ",ans$
;		  50 Y$=ans$+CHR$(0)'
;		  60 print"Just before call ";time$
;		  70 CALL NEWNAME(X$,Y$)
;		  80 print"Just after call ";time$
;
;
re_name equ	56h	;Rename a file function call
doscall equ	21h	;DOS interrupt number



;Names must have a byte zero to indicate their termination
;				called ASCIIZ


;The manual says the preceeding drive indicator is not necessary
;  on the new name. I cannot get it to work without it,
;  Unless the drive to be used is the default drive.
;  For best results use the drive!

;*****************************************************************************


cseg	segment  'CODE'         ;define code segment
;---------------------------------------------------------------------

   assume cs:cseg
   public newname
newname proc far	;main part of program



;set up stack for return
	push bp 	;save for return
	mov  bp,sp	;set base for passed names
	push ds 	;save old data segment
	push es 	;save for return


;MAIN PART OF PROGRAM.
;DX points to old name

	mov  si,[bp+8]	     ;get address of second parameter
	mov  ax,[si+2]	     ;get actual address of string
	mov  dx,ax	     ;location of old name put in DX
;DI points to new name
	mov  si,[bp+6]	     ;get address of first parameter
	mov  ax,[si+2]	     ;get actual address of string
	mov  di,ax	     ;location of new name put in DI
	mov  ah,re_name      ;rename function number
	int  doscall	     ;Call DOS

	pop  es
	pop  ds
	pop  bp
	ret  4			;return to calling program
				;   (4 since 2 parameters passed)
newname endp			;end of main part of program
;---------------------------------------------------------------------
cseg	ends		;end of code segment
;*********************************************************************
	end		;end of assembly
