{$A+,B-,D+,E-,F-,I-,L+,N-,O-,R-,S-,V-}
{$M 8096,0,0}

PROGRAM UpLIB;

USES
  DOS, MiscDOS;

VAR
  LIBmask : PathStr;           { libs to check }
  LIBpath : PathStr;           { drive/directory of libs  }
  TLIBpathname : PathStr;      { full path to TLIB.EXE }
  TASMpathname : PathStr;      { full path to TASM.EXE }
  ASMpath : PathStr;           { path string to asm files. }


  PROCEDURE FindReplace(Find  : STRING;
                        VAR St : STRING;
                        Replace : STRING);
    { Replace all instances of "Find" in string "St" with "Replace" }
  VAR
    i     : Integer;
  BEGIN
    REPEAT
      i := pos(Find, St);
      IF i <> 0 THEN BEGIN
        Delete(St, i, Length(Find));
        Insert(Replace, St, i);
      END;
    UNTIL i = 0;
  END;

  PROCEDURE GetParams;
  { parse command line and set some global variables. }
  BEGIN
    WriteLn('UPLIB 1.0  Copyright 1989 Don Strenczewilk');

    IF ParamCount = 0 THEN BEGIN
      WriteLn('UPLIB updates LIB files created with TLIB.');
      Err(^J'UPLIB LIBmask [asm file search path string]');
    END;

    { get/set the LIB file mask and path }
    LIBmask := FExpand(ParamStr(1));
    LIBpath := FilePart(LIBmask, 'D');
    LIBmask := LIBpath + FilePart(LIBmask, 'N') + '.LIB';

    { find TLIB.EXE and TASM.EXE }
    TLIBpathname := 'TLIB.EXE';
    FindAFile(TLIBpathname);
    IF TLIBpathname = '' THEN
      Err('Cannot find TLIB.EXE.');

    TASMpathname := 'TASM.EXE';
    FindAFile(TASMpathname);
    IF TASMpathname = '' THEN
      Err('Cannot find TASM.EXE.');

    { get path to ASM files, if specified on command line. }
    ASMpath := ParamStr(2);
    { try to fix some common PATH parsing errors. }
    FindReplace('\;', ASMpath, ';');
    IF (Length(ASMpath) > 0) AND (ASMpath[Length(ASMpath)] = ';')
    THEN Dec(ASMpath[0]);      { remove trailing ';' }
  END;

  FUNCTION Execute(Path, CmdLine : STRING; Display : Boolean) : Boolean;
    { EXEC Path with CmdLine parameters.  Returns true if successful. }
  VAR
    Doserr : Integer;
  BEGIN
    IF Display THEN
      WriteLn(FilePart(Path, 'N'), ' ', CmdLine);
    Exec(Path, CmdLine);
    Doserr := DosError;
    IF Doserr <> 0 THEN WriteLn('DOS error: ', i2s(Doserr), '  ', Path);
    Execute := (Doserr = 0) AND (DosExitCode = 0) and (IoResult = 0);
  END;

  FUNCTION WhiteSpace(c : Char) : Boolean;
    { returns true if "c" is whitespace }
  BEGIN
    WhiteSpace := (c = ^i) OR (c = ' ');
  END;

  PROCEDURE UpdateLIBs;
    { Main procedure. }
  CONST
    ListFile = 'UPLIB.WRK';    { created by TLIB to find module names. }
  VAR
    LIBsr : Searchrec;
    LIBfn, ASMfn : PathStr;
    ASMname : STRING[9];       { just the filename part of the current ASM file }
    ASMtime : LongInt;         { the timestamp of the current ASM file }
    S     : STRING;
    TF    : Text;
    f     : FILE;
    i     : Integer;
  BEGIN                        { UpdateLIBs }
    FindFirst(LIBmask, 0, LIBsr);
    WHILE DosError = 0 DO BEGIN
      LIBfn := LIBpath + LIBsr.Name;
      WriteLn(^J'Updating: ', LIBfn);

      { create LIB list file to get module names. }
      IF NOT Execute(TLIBpathname, LIBfn + ' ,' + ListFile, False)
      THEN Err('Cannot make library listing.');

      Assign(TF, ListFile);
      Reset(TF); CheckIO;
      ReadLn(TF); CheckIO;     { Skip past "Publics by module" line. }
      WHILE NOT eof(TF) DO BEGIN

        ReadLn(TF, S); CheckIO;
        IF (Length(S) > 0) AND NOT(WhiteSpace(S[1])) THEN BEGIN

          { a line with a module name was found }
          i := 1;              { extract just the module name. }
          WHILE (i <= Length(S)) AND NOT(WhiteSpace(S[i]))
          DO Inc(i);
          S := Copy(S, 1, i - 1) + '.ASM';

          ASMfn := FSearch(S, ASMpath); { find the ASM file }
          IF ASMfn = '' THEN WriteLn(S, ' not found.')
          ELSE BEGIN           { the ASM file was found }

            Assign(f, ASMfn);  { get ASM file time stamp }
            Reset(f); CheckIO;
            getftime(f, ASMtime);
            Close(f); CheckIO;
            IF LIBsr.Time < ASMtime THEN BEGIN

              { ASM file was modified later than the LIB file. }
              WriteLn;
              ASMname := FilePart(ASMfn, 'N');
              { compile ASM file with TASM and update LIB file with TLIB }
              IF NOT(Execute(TASMpathname, '/T ' + ASMfn + ' ' + ASMname, True))
              OR NOT(Execute(TLIBpathname, LIBfn + ' +-' + ASMname, True))
              THEN BEGIN       {Not successful. Clean up and abort }

                { restore date on lib file so any other files that need to }
                { be proceessed, will be on the next run of UPLIB. }
                SetFileTime(LIBfn, LIBsr.Time);

                Close(TF); CheckIO; { get rid of work file. }
                Erase(TF); CheckIO;
                Err('');       { abort. }
              END ELSE BEGIN   { Successful update. }

                { update time stamp on asm file so it won't get updated }
                { again on the next run of UPLIB if it needs to abort }
                { prematurely on this run. }
                SetFileTime(ASMfn, LIBsr.Time);

                { erase the .OBJ file }
                Assign(f, ASMname + '.OBJ');
                Erase(f); CheckIO;
              END;             { successful update }
            END;               { if LIBdate < ASMdate }
          END;                 { if asm file found }
        END;                   { if ASMfn = a module name }
      END;                     { while not eof TF }
      Close(TF); CheckIO;      { get rid of UPLIB.WRK }
      Erase(TF); CheckIO;
      FindNext(LIBsr);         { Find next file to match LIBmask. }
    END;                       { while doserror = 0 }
  END;

BEGIN
  GetParams;
  UpdateLIBs;
END.
