; TES.ASM        
; Interrupt caller to be used with TSR-EXE.EXE

.model small

.stack 80h

.data
string          db      12 dup (10,13),25 dup (20h),'Next keystroke will' 
                db      ' trigger interupt',12 dup (10,13),'$'
string2         db      5 dup (10,13),'Returned from interrupt','$'
load_check      db      12 dup (10,13)
                db      'Have you loaded TSR-EXE.EXE into memory?'
                db      2 dup (10,13), '"y" or "n"',11 dup (10,13),'$'
exit_message    db      12 dup (10,13), 'Exiting program........'
                db      10 dup (10,13),'$'

.code

start:

mov ax,@data
mov ds,ax
mov es,ax

;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
; The  following  simply asks if TSR.EXE has been loaded into memory.
;  it is  an  important step, as there is no attempt made anywhere to
;  see if there is a current handler already loaded for int 60h which
;  if  called  (as done here)  without  a handler, the computer would
;  of course hang.

mov dx, offset load_check
mov ah, 09h
int     21h

answercheck:
mov ah, 00h
int 16h
cmp al, 'y'
je  done
cmp al, 'Y'
je  done
cmp al, 'n'
jne not_n
mov dx, offset exit_message
mov ah, 09h
int     21h
jmp exit
not_n:
cmp al, 'N'
jne answercheck
jmp exit

done:

mov dx,offset string
mov ah, 09h
int 21h

mov ah,00h
int 16h

int 60h

mov dx,offset string2
mov ah,09h
int 21h

exit:

mov ah,04ch
int 21h
end start
end
