; TraceInt.Asm    --   Copyright (c) 1995 by Jannes Faber
;
; Downloaded from:
;             Professional Programmers' Pages
;              http://www.fys.ruu.nl/~faber
;
; This is a sample program using my Hercules routines. It displays some
; registers on the Hercules display every time the interrupt being traced
; is called.
;
; I didn't make it to accept command line parameters or something like that,
; if you need to change the int to trace, which functions to exclude,
; which registers to display or any other conditions, you just alter the
; program a little and then reassemble.
;
; Of course if anyone changes this program to do accept parameters somehow,
; I'd really like to see it and distribute it on my page.
;
; OK, enough crap ...
;
; Below you can specify the int that you would like to trace.
IntNr           EQU     21h
;
; Below (StartLine) specifies the first line that this program should use on
; the Hercules screen. Just in case you use the Hercules screen for other
; purposes at the same time.
StartLine      EQU     15
;
; There's one more thing that you can specify, see the comments one page down.
; 
; Now the program:
;
        .MODEL  TINY
        .386
        .CODE
        .STARTUP
        
        jmp     Install                 ; Jump over data and resident code

INCLUDE Hercules.Inc                    ; my Hercules routines

; Data must be in code segment so it won't be thrown away with Install code.

OldHandler      DWORD   ?               ; Address of original timer routine

NewHandler PROC   FAR
        sti
        
        pushf
;
; Below you can specify under which conditions you want to see something on
; the Hercules screen.
;  (unmark the next line and it's .ENDIF if you want restrictions)
;        .IF     ah != 4Fh ; only diplay these functions e.g.
        push    ax
        push    cx
        push    dx
        push    ds
        push    si

        mov     dx, cs
        mov     ds, dx

        mov     cx, 4
        mov     dx, ax
        call    hVal
        
        mov     ah, 7
        call    Hprint0

        pop     si
        pop     ds
        pop     dx
        pop     cx
        pop     ax
;        .ENDIF              ; Unmark this line too...
        popf

        jmp    cs:OldHandler
NewHandler ENDP

Install PROC
        mov     bx, StartLine
        call    HsetStart

        mov     ax, 3500h + IntNr       ; Request function 35h
        int     21h                     ; Get vector for timer (interrupt 08)
        mov     WORD PTR OldHandler[0], bx; Store address of original
        mov     WORD PTR OldHandler[2], es;   timer interrupt
        mov     ax, 2500h + IntNr       ; Request function 25h
        mov     dx, OFFSET NewHandler     ; DS:DX points to new timer handler
        int     21h                     ; Set vector with address of NewHandler

        mov     dx, OFFSET Install      ; DX = bytes in resident section
        mov     cl, 4
        shr     dx, cl                  ; Convert to number of paragraphs
        inc     dx                      ;   plus one
        mov     ax, 3100h               ; Request function 31h, error code=0
        int     21h                     ; Terminate-and-Stay-Resident

Install ENDP
        
        END
