;;
;;      Simple TSR to 'tame' the Borland C++ IDE.
;;
;;      Whenever the IDE runs any DOS utilities (like IMPLIB.EXE), something
;;      like the following occurs (some guesses involved):
;;
;;      1  - BCW.EXE creates the file C:\$$PIPE$$.LCK.
;;      2  - BCW.EXE starts CAPDOS.EXE, passing the command line it wants
;;           CAPDOS.EXE to run.
;;      3a - CAPDOS.EXE executes the command line.
;;      4a - CAPDOS.EXE erases the file C:\$$PIPE$$.LCK.
;;      3b - BCW.EXE executes the loop FindFirst( C:\$$PIPE$$.LCK ) until
;;           it has been erased.
;;
;;      Under straight Windows 3.1, this doesn't pose any problems as the
;;      DOS window can be made to execute exclusively (and Windows is not
;;      preemptive).
;;
;;      Under OS/2, this can occasionally cause SEVER system degredation as
;;      the polling loop doesn't execute any idle interrupts (and resources
;;      are pulled to handle the FindFirst request).
;;
;;      What this TSR does is check for any DOS FindFirst calls with
;;      $$PIPE$$.LCK on the tail of the filespec.  If this is the case,
;;      the TSR will first release a timeslice.
;;
;;      As shown under the System Resources utility (MEMSZ*.ZIP), the
;;      effect of this TSR is dramatic (temporarily setting the CAPDOS
;;      VDM DOS_BACKGROUND_EXECUTION to Off to isolate the IDE component):
;;
;;              Without the TSR, CPU Load = 100%
;;              With the TSR, CPU Load = 0%
;;
;;      Disclaimer:     While this TSR works for me, I have not tested it
;;                      for you.  If it doesn't work, don't sue me.
;;
;;      Thanks to Ralph Brown, et. al., for uncovering the Release Time Slice
;;      function call.
;;
;;      Version 1.0
;;
;;      Author: Rob Hannah
;;              rhannah@uhc.com

TITLE	'Tame Borland C++ IDE'
IDEAL
WARN
P386N

SEGMENT	CODE PARA
	ASSUME	cs:CODE, ds:nothing, es:nothing
	ORG	100h
start:
	jmp	short Initialize

;;
;;	Ram-Resident variable stuff.
;;	Note:  I've pulled out alot of the incedental code (like the
;;	double install, uninstall, etc. routines).
;;
;Signature	db	'TAMEBCW  RVH3'	; Tail of signature used to test if
;					; installed / uninstall.  Also uses
;					; above jmp instruction (3 bytes).
;		db	1ah		; Stop the DOS TYPE command.
;SignatureSize	=	($ - start)

FindFile	db	"$$PIPE$$.LCK"


ISR21:
	cmp	ah, 4eh			; FindFirst?
	je	short @@fn4e

@@done:			db	0eah	; Jump direct - saves 4 bytes.
	int21ptr	dd	0

;;
;;	Check the filespec pointer.  The method used is to find the end
;;	of the ASCIIZ string and compare backwards.  This will allow for
;;	a pathspec-independent comparison against $$PIPE$$.LCK (the
;;	synchronizing file).
;;
@@fn4e:
	push	es			; Save any register we use.
	push	di
	push	si
	push	cx
	push	ax

	push	ds			; Find end of ASCIIZ filespec.
	pop	es
	mov	di, dx
	xor	cx, cx
	mov	ax, cx
	dec	cx
	repne	scasb

;;
;;	I'm making 2 (benign) assumptions here:
;;
;;		1 - I found the NULL terminator.
;;		2 - CLD is in effect.
;;
;;	If either of these is false, the net effect is that we won't
;;	find what we were looking for.
;;

	mov	cx, size FindFile	; Size of our comparison.
	lea	si, [ di - size FindFile - 1 ]
					; DS:SI should now point to the
					; offset where FindFile would occur
					; in the filespec.
	push	cs			; Set ES:DI to FindFile.
	pop	es
	mov	di, offset cs:FindFile
	rep	cmpsb			; Compare...
	jne	short @@cont		; ...if we miss, skip idle interrupt.

;;
;;	Execute an idle interrupt to let OS/2 catch it's breath.
;;	From the Ralph Brown Interrupt List (reformatted to fit):
;;
;;	INT 2F - MS Windows, DPMI, various -
;;	RELEASE CURRENT VIRTUAL MACHINE TIME-SLICE
;;
;;		AX = 1680h
;;	Return:	AL = status
;;			00h if the call is supported
;;			80h (unchanged) if the call is not supported
;;
;;	Notes:	Programs can use this function in idle loops to enhance
;;		performance under multitaskers; this call is supported by
;;		MS Windows 3.0, DOS 5+, DPMI 1.0+, and in OS/2 2.0+ for
;;		multitasking DOS applications does not block the program;
;;		it just gives up the remainder of the time slice.
;;
;;		Should not be used by Windows-specific programs.
;;
;;		When called very often without intermediate screen output
;;		under WIN 3+, the VM will go into an idle-state and will not
;;		receive the next slice before 8 seconds. This time can be
;;		changed in SYSTEM.INI through "IdleVMWakeUpTime=<seconds>".
;;		Setting to zero results in a long wait.

	mov	ax, 1680h
	int	2fh

@@cont:
	pop	ax
	pop	cx
	pop	si
	pop	di
	pop	es
	jmp	@@done
EndTSR:



;;
;;	Initialization and test routines.
;;
IFDEF	DEBUG				; Debugging?
	FileSpec	db	"C:\$$PIPE$$.LCK", 0
ENDIF

Initialize:
	ASSUME	ds:CODE

	ENVSEGMENT = 2ch		; Offset for Environment segment.
	mov	es, [ ENVSEGMENT ]	; Free our associated environment
					; block.
        mov     ah, 49h	
        int     21h

	mov	ax, 3521h		; Get original interrupt vector.
	int	21h
	mov	[ word ptr int21ptr ], bx
					; Set our jumpback point.
	mov	[ word ptr int21ptr + 2 ], es

	mov	dx, offset ISR21	; Set the new interrupt.
	mov	ah, 25h
	int	21h

IFDEF	DEBUG				; Debugging?
	mov	dx, offset FileSpec	; Try it out.
	mov	ah, 4eh
	int	21h

	mov	[ byte ptr offset FileSpec + 6 ], 0
					; Force a failure.
	mov	dx, offset FileSpec
	mov	ah, 4eh
	int	21h



	mov	dx, [ word ptr int21ptr ]
					; Restore interrupt vector.
	mov	ax, 2521h
	int	21h

	mov	ax, 4c00h		; All done.
	int	21h
ENDIF

;;
;;	Resize the initialization stuff out of allocated memory.  Since
;;	memory allocation is specified in 16-byte paragraphs, we've got to
;;	insure that ALL of the ISR fits.  This may mean a few bytes lost.
;;	Pity.  Also, this b the point where we b going TSR.
;;
	mov	dx, offset EndTSR
	add	dx, 0fh
	shr	dx, 4
	mov	ax, 3100h
	int	21h
ENDS
END	start