;  ROUTINE TO SEARCH FOR ONE STRING WITHIN ANOTHER
;
strsearch	proc	far
;
	push	si		; save registers
	push	di
	push	cx
;
; get length of destination and point to first byte
	mov	si,dx		; use source index
	lodsw			; get the length of destination
	mov	cx,ax		; use the length as a count
	mov	dx,si		; text begins here
;
strsearch1:
; point indices to beginning of source and destination
	mov	si,bx		; load source index
	mov	di,dx		; load destination index
;
; scan for match
	mov	al,[si+2]	; get the first character
	cld			; forward direction
	repnz	scasb		; scan for match
	jcxz	strsearch2	; quit if found no match 
;
; got a match of first characters - now check the entire string
	mov	dx,di		; save current destination loc
	dec	di		; beginning of word
	lodsw			; get length of source
	xchg	cx,ax		; use source count and save dest count
	repz	cmpsb		; compare the two strings
	jcxz	strsearch3	; it's a match if no more source
;
; continue the scan
	xchg	cx,ax		; use destination count
	jmp	strsearch1	; back for more scanning of dest
;
; no match is possible
strsearch2:
	mov	al,0		; unsuccessful outcome
	jmp	strsearchexit
;
; found a match
strsearch3:
	dec	dx		; point to beginning of match
	mov	al,0FFh		; successful match
	jmp	strsearchexit
;
strsearchexit:
	pop	cx		; restore registers
	pop	di
	pop	si
	ret
;
strsearch	endp
                        