page     60,80

title    STEPRATE  A program to change the step rate of Floppy drives
;
; Before I receive any flames on the goodness of the following code, I
; would like to say that I find the 8088 destruction set disgusting.  I
; would have written this program in C (or some language which shelters
; me from the architecture but I have an inherent abhorance of 32K programs
; which do something as simple as this.
; If you do not like the way I wrote it, the feel free to rewrite it.
; In case you have not guessed, DEMENTed REGISTERS and I do not get along
; together.

.radix   16

;***** Equates *********************************************************

cr       equ      0Dh      ;carriage return character
lf       equ      0Ah      ;line feed character

;********************************************
datarea  segment
         org      80h
count    db       ?
buffr    db       20d  dup (?)      ;input for step rate
sm       db       'Floppy Drive Step Rate is set to $'
m12      db       '12$'
m8       db       '9$'
m6       db       '6$'
m3       db       '3$'
mu       db       'UNKNOWN$'
rms      db       ' ms.',cr,lf,'$'
minval   db       '3, 6, 9 or 12 are the only recognized step rates.'
         db       cr,lf,'$'
datarea  ends


;***** Main Program ****************************************************

code     segment
         assume   cs:code, es:code, ds:datarea, ss:stk_seg

; Start--- Set up the stack so that DOS will be able to find it's
; DS when we return.  Ain't it disgusting that we have to fool with
; such nonsense!

start    proc     far
         push     ds       ;save old data segment
         sub      ax,ax    ;put zero in ax
         push     ax       ;save it on stack


; see if a step rate entered from the keyboard 

         mov      bx, offset count  ;get the number of characters entered
         mov      ah,[bx]
         mov      al,ah    ;keep count in ah
         cmp      al,0     ;see if any input
         jz       noinput
         mov      dx,0     ;set number to 0
loop:
         inc      bx       ;point to character buffer
         mov      al,[bx]
         cmp      al,' '
         jz       aloop    ;step past spaces
         cmp      al,'0'
         jc       noinput
         cmp      al,'9'+1
         jnc      noinput
         sub      al,'0'
         push     ax       ;I suppose that there is some instruction
         mov      al,dl    ; to ADD HL in the 8088 set. But I'm not gonna
         add      al,al    ; look it up, anyhow times 2
         mov      ah,al    ;and save it
         add      al,al    ;times 4
         add      al,al    ;times 8
         add      al,ah    ;+ 2 = 10
         mov      dl,al
         pop      ax
         add      al,dl
         mov      dl,al
aloop:
         sub      ah,1     ;see if we are out of characters yet
         jnz      loop     ;if not, stay at it till we run out (or bomb out)
         mov      al,dl
         mov      dl,0e0h  ;set for 3 ms step rate
         cmp      al,3
         jz       valid
         mov      dl,0d0h
         cmp      al,6     ; try for 6
         jz       valid
         mov      dl,0c0h
         cmp      al,9     ;or 9
         jz       valid
         mov      dl,0b0h
         cmp      al,12d   ; mayhaps 12
         jz       valid

; If we get to this point, we don't know what they have entered.
; Therefore, bomb out.
; set data segment register to where the messages are (I think)

         mov      ax,datarea
         mov      ds,ax

         mov      dx, offset minval
         mov      ah,9
         int      21h
         ret

; a valid number has been entered, change the step rate to it

valid:
         push     ds       ; Save the data segment
         mov      bx,78h   ;point to pointer for floppy drive tables
         mov      ax,0
         mov      ds,ax    ;set to segment 0
         mov      ax,[bx]  ;get the pointer
         mov      bx,ax    ;into the bx register
         mov      al,[bx]  ;now get the present step rate
         and      al,0fh   ;remove the old step rate
         or       al,dl    ;put in the new step rate
         mov      [bx],al  ;and put it back where it goes
         mov      ah,0     ;now call on the BIOS to
         int      13h      ;reload the set floppy disk controller
         pop      ds       ; Reset the Data Segment

; if we get to this point, we have either had no specified step rate
; or a new step rate has been successfully loaded.  Let's tell 'em
; what they got.

noinput:

         push     ds       ;save present data segment

         mov      bx,78h   ;point to pointer for floppy drive tables
         mov      ax,0
         mov      ds,ax    ;set to segment 0
         mov      ax,[bx]  ;get the pointer
         mov      bx,ax    ;into the bx register
         mov      al,[bx]  ;now get the step rate
         pop      ds
         push     ax       ;save the step rate on the stack

         mov      ax,datarea        ;no comment
         mov      ds,ax

         mov      dx, offset sm     ;print beginning of message
         mov      ah,9
         int      21h

         pop      ax       ;get the step rate back

         and      al,0f0h  ;just interested in the step rate

         cmp      al,0b0h
         jnz      ms8
         mov      dx, offset m12
         jmp      pms
ms8:
         cmp      al,0c0h
         jnz      ms6
         mov      dx, offset m8
         jmp      pms
ms6:
         cmp      al,0d0h
         jnz      ms3
         mov      dx, offset m6
         jmp      pms
ms3:
         cmp      al,0e0h
         jnz      msu
         mov      dx, offset m3
         jmp      pms
msu:
         mov      dx, offset mu
pms:
         mov      ah,9
         int      21h       ;print step rate

         mov      dx, offset rms    ;then print rest of message
         mov      ah,9
         int      21h

         ret      ; back to DOS

start    endp
code     ends
         
;*********************************************
stk_seg  segment stack
         db       20 dup ('stack   ')
stk_seg  ends

         end      start




