IFDEF   ??version       ; Only defined with TASM
LOCALS                  ; Enable Local Labels
ENDIF                   ; NOTE: Local labels are default with MASM if a
                        ;       language specifier is used with the .MODEL
                        ;       statement

;[]----------------------[ PUSH MULTIPLE REGISTERS ]-------------------------[]
;| Macro to simplify pushing multiple registers.   Up to ten registers        |
;| (including) the flags (identified by the keyword FLAGS) can be passed      |
;| as arguments to the macro.  The PUSHA instruction should be used for cases |
;| where 5 or 6 registers are pushed.  This macro is, however, ideal for cases|
;| where all but one register must be preserved (For example when some result |
;| is returned in one register in a lengthy function).                        |
;[]--------------------------------------------------------------------------[]
@PUSH   MACRO   v0,v1,v2,v3,v4,v5,v6,v7,v8,v9,v10
IFNB    <v10>                                   ;; Was Eleventh argument empty ?
@Error  <Too many arguments in call to @PUSH>   ;;     NO:Generate Error msg
ENDIF
IRP     $val,<v0,v1,v2,v3,v4,v5,v6,v7,v8,v9>    ;; Process each argument
IFB     <$val>                                  ;; Reached end of arguments ?
EXITM                                           ;;        Yes: Exit the macro
ELSEIFIDNI <$val>,<FLAGS>                       ;; Are we pushing the flags ?
        pushf
ELSE
        ;- If 286/386/486 code generation is enable, the arguments can
        ;- even be immediates
        push    $val
ENDIF
ENDM
ENDM



;[]----------------------[ POP  MULTIPLE REGISTERS ]-------------------------[]
;| Macro to simplify popping multiple registers.   Up to ten registers        |
;| (including) the flags (identified by the keyword FLAGS) can be passed      |
;| as arguments to the macro.  The POPA instruction should be used for cases  |
;| where 5 or 6 registers are poped.  This macro is, however, ideal for cases |
;| where all but one register must be preserved (For example when some result |
;| is returned in one register in a lengthy function).                        |
;[]--------------------------------------------------------------------------[]
@POP    MACRO   v0,v1,v2,v3,v4,v5,v6,v7,v8,v9,v10
IFNB    <v10>                                   ;; Was Eleventh argument empty ?
@Error  <Too many arguments in call to @POP>    ;;     NO:Generate Error Msg
ENDIF
IRP     $val,<v9,v8,v7,v6,v5,v4,v3,v2,v1,v0>    ;; Reverse the Order !!!
IFNB    <$val>                                  ;; Skip empty arguments
IFIDNI <$val>,<FLAGS>                           ;; Are we popping the flags ?
        popf
ELSE
        pop     $val
ENDIF
ENDIF
ENDM
ENDM


