;
; Equates
;
TRUE		EQU	001h
FALSE		EQU	000h

DISK_REQUEST	EQU	000h		;Disk I/O Request
TAPE_REQUEST	EQU	001h		;Tape I/O Request

;
; Video Bus Monitoring
;
VIDEO_SEG	EQU	0B800h
VIDEO_OFS	EQU	79 * 2
VIDEO_COLOR	EQU	00600h		;Light Red

;
; ST-01 Card Registers
;
SCSI_CARD_SEG	EQU	0DE00h		;Base Segment of Card
SCSI_CMD_PORT	EQU	01A00h		;Offset to Command Port
SCSI_DATA_PORT	EQU	01C00h		;Offset to Data Port

STACK_SIZE	EQU	1024		;Our Local Stack

;
; How the 16 bit sector number is broken down
; into a sector and cylinder number.
;
; x = Cylinder, y = track, always have only 1 head
;
; xxxx xxxx xxxx yyyy
;
		if large_drives
SECT_TRACK	EQU	16		;Sectors per Track
ROUND_CYL	EQU	0FFF0h		;Round Sectors to nearest Cylinder
CLUSTSIZE	EQU	8		;Number of Sectors to a Cluster
		else
SECT_TRACK	EQU	16		;Sectors per Track
ROUND_CYL	EQU	0FFF0h		;Round Sectors to nearest Cylinder
CLUSTSIZE	EQU	4		;Number of Sectors to a Cluster
SECT_2_FS	EQU	10		;How far to shift for
					;Total Sectors to Fat Sectors
		endif

;
; The max target to check for (0-X).
; If using 'reserve_addr', this should not execede 6!
;
MAXUNIT		EQU	6		;Maximum Unit Number

P_SECT		EQU	512		;Physical Sector Size

;
; CHUNK_MASK is the maximum number of sectors to access in one
; SCSI request.  It MUST be a power of two, and CHUNK_MASK * P_SECT
; MUST be <= 64K to prevent segment wrap problems.
;
CHUNK_MAX	EQU	32

CMDENABLE	EQU	080h		;Enable the output drivers
CMDENINTR	EQU	040h		;Enable Interrupt
CMDPARITY	EQU	020h		;Enable Parity
CMDSTARB	EQU	010h		;Start Bus Arbitration
CMDATTN		EQU	008h		;Assert ATTN
CMDBSY		EQU	004h		;Assert BSY
CMDSEL		EQU	002h		;Assert SEL
CMDRST		EQU	001h		;Assert RST

		if scsi_parity
CMDBASE		EQU	CMDPARITY	;Base value of all commands
		else
CMDBASE		EQU	000h		;Base value of all commands
		endif

STARBCOMPL	EQU	080h		;Arbitration Complete
STPARERR	EQU	040h		;Parity Error
STSEL		EQU	020h		;SEL Asserted
STREQ		EQU	010h		;REQ Asserted
STCD		EQU	008h		;C/D Asserted
STIO		EQU	004h		;I/O Asserted
STMSG		EQU	002h		;MSG Asserted
STBSY		EQU	001h		;BSY Asserted

REQ_MASK	EQU	STCD or STIO or STMSG
REQ_DATAOUT	EQU	000h		;Data Out Phase
REQ_DATAIN	EQU	STIO		;Data In Phase
REQ_CMDOUT	EQU	STCD		;Command Out Phase
REQ_STATIN	EQU	STCD or STIO	;Status In Phase
REQ_MSGOUT	EQU	STMSG or STCD	;Msg Out Phase
REQ_MSGIN	EQU	STMSG or STCD or STIO ;Msg In Phase

COK		EQU	0		;Command Completed OK
CNOCONNECT	EQU	1		;Unable to Connect to Target
CBUSBUSY	EQU	2		;Bus Busy
CTIMEOUT	EQU	3		;Timeout waiting for Response
CERROR		EQU	4		;Target Return Error
CBUSY		EQU	5		;Target was Busy
CDISCONNECT	EQU	6		;Target Disconnected
COFFLINE	EQU	7		;Target Went Offline
CMSGOUT		EQU	8		;Target Request Message Out???
CPARERR		EQU	9		;Parity Error Detected
CSELERR		EQU	10		;Re-Select Detected

SCSI_TESTREADY	EQU	000h		;Test Unit Ready (6 byte)
SCSI_REWIND	EQU	001h		;Rewind (6 byte)
SCSI_REQSENSE	EQU	003h		;Request Sense (6 byte)
SCSI_FORMATUNIT	EQU	004h		;Format Disk (6 byte)
SCSI_REASSIGN	EQU	007h		;Reassign Bad Block (6 byte)
SCSI_WRITEFM	EQU	010h		;Write File Marks (6 byte)
SCSI_SPACE	EQU	011h		;Space Tape (6 byte)
SCSI_INQUIRY	EQU	012h		;Inquire (6 byte)
SCSI_MODE_SET	EQU	015h		;Mode Select (6 byte)
SCSI_ERASE	EQU	019h		;Erase Tape (6 byte)
SCSI_MODE_GET	EQU	01Ah		;Mode Sense (6 byte)
SCSI_LOAD	EQU	01Bh		;Load / Unload Tape (6 byte)
SCSI_READSIZE	EQU	025h		;Read Drive Capacity (10 byte)
		if extended_io
SCSI_READBLK	EQU	028h		;Read Sectors (10 byte)
SCSI_WRITEBLK	EQU	02Ah		;Write Sectors (10 byte)
		else
SCSI_READBLK	EQU	008h		;Read Sectors (6 byte)
SCSI_WRITEBLK	EQU	00Ah		;Write Sectors (6 byte)
		endif
SCSI_VERIFYBLK	EQU	02Fh		;Verify Blocks (10 byte)

MSG_COMPLETE	EQU	000h		;Command is Complete
MSG_EXTEND	EQU	001h		;Extended Message Follows
MSG_SAVE	EQU	002h		;Save Data Pointers
MSG_RESTORE	EQU	003h		;Restore Data Pointers
MSG_DISCONNECT	EQU	004h		;Disconnect Requested
MSG_ERROR	EQU	005h		;Error Detected
MSG_ABORT	EQU	006h		;Abort the Command
MSG_REJECT	EQU	007h		;Reject the Command
MSG_NOP		EQU	008h		;No Operation
MSG_PARITY	EQU	009h		;Parity Error Occured
MSG_RESET	EQU	00Ch		;Reset the Unit
MSG_IDENTIFY	EQU	080h		;Identify Yourself

;
; Test Unit Ready Retry Count
;
READY_RETRY	EQU	10		;Wait 10 seconds for ready

;
; Command Retry Count
;
MAX_RETRY	EQU	3		;Retry 3 times

;
; Sense sub types
;
SENSE_CCS	EQU	070h		;Extended Sense Available

;
; Format sub types
;
FORMAT_NORMAL	EQU	000h		;Format with known defect list
FORMAT_ADDING	EQU	010h		;Format with additional bad blocks
FORMAT_ORIG	EQU	018h		;Format with original bad block list

;
; Load sub types
;
LOAD_TAPE	EQU	001h		;Load
UNLOAD_TAPE	EQU	000h		;Unload

;
; We write one filemark at the end of a tape
; so that we can space forward over stuff.
;
CLOSE_FM_CNT	EQU	001h
