;
; Process an ioctl request for the current unit
;
; return 'C' on error
;
scsi_ioctl	proc
		mov	al,es:[bx].rh19_minor		;Get the minor number
		cmp	al,40h				;Set Device Params?
		jnz	scsi_i_42h
		clc
		jmp	scsi_i_exit

scsi_i_42h:	cmp	al,42h				;Format and Verify?
		jnz	scsi_i_60h
		mov	di,es:[bx].rh19_buf_ofs		;Get the Param Buffer
		mov	ax,es:[bx].rh19_buf_seg
		mov	es,ax
		mov	ax,es:[di].ioctl_fmt_cyl	;Cylinder
		mov	bx,SECT_TRACK
		mul	bx				;Convert to Sector
		mov	cx,es:[di].ioctl_fmt_head	;Head
		or	cx,cx
		jz	head0_42h
head_loop_42h:	add	ax,SECT_TRACK			;Add Head Tracks
		adc	dx,0
		loop	head_loop_42h
head0_42h:	mov	bx,0
		mov	cx,es:[di].ioctl_fmt_len	;How Many Tracks
len_loop_42h:	add	bx,SECT_TRACK			;Convert to Sectors
		loop	len_loop_42h
		mov	cx,bx

		ife large_drives
		mov	di,cur_bpb			;Add Drive Offset
		mov	dx,[di].bpb_hs_msw
		endif

		call	scsi_verify
		jmp	scsi_i_exit

scsi_i_60h:	cmp	al,60h				;Get Device Params?
		jnz	scsi_i_61h
build_bpb:	mov	si,cur_bpb			;Get the Current BPB
		mov	di,es:[bx].rh19_buf_ofs		;Get the Param Buffer
		mov	ax,es:[bx].rh19_buf_seg
		mov	es,ax
		mov	es:[di].dpb_special,05h		;Sect Same/Use Cur BPB
		mov	es:[di].dpb_type,05h		;Fixed Disk
		mov	es:[di].dpb_attr,0001h		;Not Removable
		if large_drives
		mov	dx,[si].bpb_ts_msw
		mov	ax,[si].bpb_ts_lsw
		else
		mov	dx,0
		mov	ax,[si].bpb_ts
		endif
		add	ax,1				;Sectors (1-n)
		adc	dx,0
		mov	bx,SECT_TRACK
		div	bx
		mov	es:[di].dpb_cyl,ax
		mov	es:[di].dpb_media,0		;????
		mov	es:[di].dpb_sectors,SECT_TRACK	;Sectors per Track

		push	di
		lea	di,es:[di].dpb_bpb		;Copy the bpb into
		mov	cx,size bpb			;the requestors buffer
		cld
	rep	movsb
		pop	di

		lea	di,es:[di].dpb_track		;Build the Track List
		mov	cx,SECT_TRACK
		mov	ax,0				;Start with Sector 0
scsi_i_t_loop:	mov	es:[di],ax			;Sector Number
		inc	ax
		inc	di
		inc	di
		mov	word ptr es:[di],P_SECT		;Sector Size
		inc	di
		inc	di
		loop	scsi_i_t_loop
		clc
		jmp	short scsi_i_exit

scsi_i_61h:	cmp	al,61h				;Read Track?
		jnz	scsi_i_62h
		mov	di,es:[bx].rh19_buf_ofs		;Get the Param Buffer
		mov	ax,es:[bx].rh19_buf_seg
		mov	es,ax
		mov	ax,es:[di].ioctl_read_cyl	;Cylinder
		mov	bx,SECT_TRACK
		mul	bx				;Convert to Sector
		mov	cx,es:[di].ioctl_read_head	;Head
		or	cx,cx
		jz	head0_61h
head_loop_61h:	add	ax,SECT_TRACK			;Add Head Tracks
		adc	dx,0
		loop	head_loop_61h
head0_61h:	add	ax,es:[di].ioctl_read_sect	;Offset into the Track
		adc	dx,0
		mov	cx,es:[di].ioctl_read_len	;How Many Sectors

		ife large_drives
		mov	di,cur_bpb			;Add Drive Offset
		mov	dx,[di].bpb_hs_msw
		endif

		call	scsi_verify
		jc	scsi_i_error
		mov	es,rh_seg
		mov	bx,rh_off
		jmp	build_bpb

scsi_i_62h:	cmp	al,62h				;Verify?
		jnz	scsi_i_error
		mov	di,es:[bx].rh19_buf_ofs		;Get the Param Buffer
		mov	ax,es:[bx].rh19_buf_seg
		mov	es,ax
		mov	ax,es:[di].ioctl_fmt_cyl	;Cylinder
		mov	bx,SECT_TRACK
		mul	bx				;Convert to Sector
		mov	cx,es:[di].ioctl_fmt_head	;Head
		or	cx,cx
		jz	head0_62h
head_loop_62h:	add	ax,SECT_TRACK			;Add Head Tracks
		adc	dx,0
		loop	head_loop_62h
head0_62h:	mov	bx,0
		mov	cx,es:[di].ioctl_fmt_len	;How Many Tracks
len_loop_62h:	add	bx,SECT_TRACK			;Convert to Sectors
		loop	len_loop_62h
		mov	cx,bx

		ife large_drives
		mov	di,cur_bpb			;Add Drive Offset
		mov	dx,[di].bpb_hs_msw
		endif

		call	scsi_verify
		jmp	short scsi_i_exit

scsi_i_error:	stc
scsi_i_exit:	ret
scsi_ioctl	endp

;
; Process an ioctl_write request
;
scsi_ioctl_write proc
		mov	di,es:[bx].rh12_buf_ofs		;Get The Command
		mov	ax,es:[bx].rh12_buf_seg		;Buffer
		mov	es,ax
		mov	ax,es:[di].ioc_command		;What Command

;
; Format Disk Unit
;
		cmp	al,'F'				;Format?
		jnz	try_erase
		mov	ax,es:[di].ioc_param1		;Get Interleave
		mov	bx,es:[di].ioc_buf_ofs		;Get Buffer Offset
		mov	cx,es:[di].ioc_buf_len		;Get Buffer Length
		mov	dx,es:[di].ioc_param2		;Get Format Type
		mov	es,es:[di].ioc_buf_seg		;Get Buffer Seg
		lea	di,cmd_format			;Insert into Command
		mov	[di].fmt_cmd_il_b1,ah
		mov	[di].fmt_cmd_il_b0,al
		mov	[di].fmt_cmd_type,dl
		call	docmd
		jnc	format_exit
		call	scsi_sense
format_exit:	jmp	scsi_i_w_exit

;
; Erase Tape Unit
;
try_erase:	cmp	al,'E'				;Erase?
		jnz	try_rewind
		lea	di,cmd_erase			;Now Erase Tape
		call	docmd
		jnc	erase_exit
		call	scsi_sense
erase_exit:	jmp	scsi_i_w_exit

;
; Rewind Tape Unit
;
try_rewind:	cmp	al,'R'				;Rewind?
		jnz	try_load
		lea	di,cmd_rewind			;Now Rewind Tape
		call	docmd
		jnc	rewind_exit
		call	scsi_sense
rewind_exit:	jmp	scsi_i_w_exit

;
; Load Tape on Open
;
try_load:	cmp	al,'L'				;Load?
		jnz	try_noload
		mov	load_flag,TRUE
		jmp	scsi_i_w_exit

;
; No Load Tape on Open
;
try_noload:	cmp	al,'N'				;No Load?
		jnz	try_space
		mov	load_flag,FALSE
		jmp	scsi_i_w_exit

;
; Space Tape
;
try_space:	cmp	al,'S'				;Space?
		jnz	try_filemark
		mov	ax,es:[di].ioc_param1		;Get Count
		mov	bx,es:[di].ioc_param2		;Get Type
		lea	di,cmd_space			;Insert into Command
		mov	[di].space_cmd_code,bl
		mov	[di].space_cmd_cnt2,ah		;Dup of ah
		mov	[di].space_cmd_cnt1,ah
		mov	[di].space_cmd_cnt0,al
		call	docmd
		jnc	scsi_i_w_exit
		call	scsi_sense
		jmp	scsi_i_w_exit

;
; Write Filemarks
;
try_filemark:	cmp	al,'M'				;Mark?
		jnz	try_remap
		mov	ax,es:[di].ioc_param1		;Get Count
		lea	di,cmd_twritefm			;Insert into Command
		mov	[di].fm_cmd_cnt_b1,ah
		mov	[di].fm_cmd_cnt_b0,al
		call	docmd
		jnc	scsi_i_w_exit
		call	scsi_sense
		jmp	scsi_i_w_exit

;
; Reassign Block
;
try_remap:	cmp	al,'A'				;ReAssign?
		jnz	scsi_i_w_error
		mov	bx,es:[di].ioc_buf_ofs		;Get Buffer Offset
		mov	cx,es:[di].ioc_buf_len		;Get Buffer Length
		mov	es,es:[di].ioc_buf_seg		;Get Buffer Seg
		lea	di,cmd_remap			;Command
		call	docmd
		jnc	scsi_i_w_exit
		call	scsi_sense
		jmp	scsi_i_w_exit

scsi_i_w_error:	stc
scsi_i_w_exit:	ret
scsi_ioctl_write endp
