; Program to start a screen saver using EXEC call
;   Saver program is started after <MaxTick> timer ticks without
;   any keyboard activity.
;  
;   Saver program can be almost any .com or .exe file smaller than
;   about 130k bytes.
;
;   To install, type SAVSCRN /[PATH]:Filename.ext
;   where Filename.ext is the name of the screen saver and [PATH] is
;   the full path of the screen saver program.
;
;  Chris Friedersdorf, chrisf@vonl.com
;
NAME     SAVSCRN
;  Macro for saving of registers to be used
PUSHR    MACRO  REGLST
         IFB    <REGLST>
         push   ax
         push   bx
         push   cx
         push   dx
         push   si
         push   di
         push   ds
         push   es
         push   bp
         ENDIF
         IRP    REG,<REGLST>
         push   REG
         ENDM
         ENDM
;  Macro for restoring registers pushed with PUSHR
POPR     MACRO  REGLST
         IFB    <REGLST>
         pop    bp
         pop    es
         pop    ds
         pop    di
         pop    si
         pop    dx
         pop    cx
         pop    bx
         pop    ax
         ENDIF
         IRP    REG,<REGLST>
         pop    REG
         ENDM
         ENDM

CODE    SEGMENT       ;para 'CODE'
         ASSUME CS:CODE,DS:CODE,ES:CODE
         ORG    100h                    ;  PSP
START:   jmp    BEGIN                   ;  jumping to loading of driver
;----------------------------------------------------------

STAC     DB     4096 dup (0)
ERR00    DB     '*** SAVSCRN ***  DOS is active !! ', 0
ERR01    DB     '*** SAVSCRN ***  Invalid function number !', 0
ERR02    DB     '*** SAVSCRN ***  File is not found !!', 0
ERR03    DB     '*** SAVSCRN ***  Path is not found !!', 0
ERR04    DB     '*** SAVSCRN ***  Too many files been opened !!', 0
ERR05    DB     '*** SAVSCRN ***  Access is not allowed !!', 0
ERR06    DB     '*** SAVSCRN ***  Error in logical number !!', 0
ERR07    DB     '*** SAVSCRN ***  Block of memory control is destroyed !!', 0
ERR08    DB     '*** SAVSCRN ***  Lack of memory !!', 0
ERR09    DB     '*** SAVSCRN ***  Error of memory block address !!', 0
ERR10    DB     '*** SAVSCRN ***  Wrong operating environment !!', 0
ERR11    DB     '*** SAVSCRN ***  Invalid format !!', 0
ADRERR   DW     ERR01, ERR02, ERR03, ERR04, ERR05, ERR06
         DW     ERR07, ERR08, ERR09, ERR10, ERR11
ErrOK0   DB     '==> Ouch!!!  Did not allocate memory on INSTALL', 0
ErrOK1   DB     '==> Ouch!!!  Did not release memory in EXEPRG', 0
ErrOK2   DB     '==> Ouch!!!  Did not allocate memory on EXEPRG', 0
askmem   DW     2000h          ;  Amount of memory reserved for child process
MaxTick  DW     1092           ;  1092 = 60 seconds
NumTick  DW     MaxTick

DOSFLG   LABEL  DWORD          ;  address of DOS activity indicator
OFFFLG   DW     0              ;  offset of activity indicator:   BX
SEGFLG   DW     0              ;  segment address of activity indicator: ES
;
OLD09H   LABEL  DWORD          ;  address of standart vector  INT 09H
OFF09H   DW     0              ;  offset of standart   INT 09h
SEG09H   DW     0              ;  segment address of  INT 09h
;
OLD13H   LABEL  DWORD          ;  entry point of standart  INT13H
OFF13H   DW     0              ;  address of old vector  INT13H
SEG13H   DW     0              ;  segment address of old  INT13H
;
OLD28H   LABEL  DWORD          ;  entry point of standart INT28H
OFF28H   DW     0              ;  address of old vector  INT28H
SEG28H   DW     0              ;  segment address of old  INT28H
;
SSKEEP   DW     0              ;  stack segment of calling program
SPKEEP   DW     0              ;  stack pointer of calling program
OLDPSP   DW     0              ;  PSP of calling program
PSP0     DW     0              ;  PSP of the TSR
DTANEW   DW     64 dup (0)     ;  DTA area for child process
DTAADR   LABEL  DWORD
DTAOFF   DW     0
DTASEG   DW     0
VIDEO    DW     0              ;  address of videobuffer
CURSX    DB     0              ;  position of cursor
CURSY    DB     0              ;  line of cursor
MODE     DB     0              ;  display mode
FLAG0    DB     0              ;  flag of starting a job
FLAG1    DB     0              ;  flag of activity of a job
EOS      DB     0              ;  indicator of end of ASCIIZ -string
DL0      DB     0              ;  cursor set position

InBios   DB     0                       ;  activity flag of INT 13h (BIOS)
PATH     DB     64 dup (0)              ;  -66 path for starting
PRES     DW     1234                    ;  -2  driver presence code

;----------------------------------------------------------
;
;  New  handler  for INT09h
;
;----------------------------------------------------------
INT09H   PROC   FAR                  ;  new handler for  INT 09h
         cli                         ;  disable interrupts
         PUSHR                       ;
         cmp    CS:FLAG1,1
         je     RET09
         mov    ax,CS:MaxTick
         mov    CS:NumTick,ax        ;  Key pressed when job not active
RET09:   pushf                       ;  flag register for  IRET (from INT 09H)
         Call   CS:OLD09H            ;  call old handler for  INT 09H
         POPR                        ;  restore registers
         sti                         ;  enable interrupts
         IRET                        ;  exit interrupt handling
INT09H   ENDP

;----------------------------------------------------------
;
;  New Handler for Timer interrupt INT 08H
;
;----------------------------------------------------------
INT08H  PROC    FAR
        cli                             ;  disable interrupts
        cmp     CS:NumTick,0            ;  Time passed, ready to start?
        je      OK1
        dec     CS:NumTick
        jmp     OLD08
OK1:    cmp     CS:FLAG1,1              ;  job active ?
        je      OLD08                   ;  wait for finish
        mov     CS:FLAG0,1              ;  job waiting to start
        cmp     CS:InBios,1             ;  exchange with disk ?
        je      OLD08                   ;  wait for finish
        PUSHR   <es,bx>                 ;
        LES     bx,CS:DOSFLG            ;  address of DOS activity flag
        cmp     byte ptr ES:[bx],0      ;  DOS not active ?
        POPR    <bx,es>                 ;
        jnz     OLD08                   ;   wait for finish
;  Constructing stack for starting a job (on IRET from  INT 08h)
        pushf                           ;  flags register for IRET (INT 08h)
        push    cs                      ;  segment address for exit
        lea     cx,EXEPRG               ;  address of program for starting job
        push    cx                      ;  put onto stack for  IRET
OLD08:  DB      0EAh                    ;  code of  JMP FAR ...  instruction
OLD08H  LABEL   DWORD                   ;  entry point of standard INT08H
OFF08H  DW      0                       ;  address of old vector  INT08H
SEG08H  DW      0                       ;  segment address of old  INT08H
INT08H  ENDP

;-- EXEPRG: calls another program  ------------------------------------
;-- Input     : DS:DX = Address of the program name                    
;-- Output    : Carry flag = 1: Error (AX = error code)                
;-- Registers : AX and FLAGS are affected                              
                                                                       
EXEPRG    PROC FAR                                                    
                                                                       
          ;Send command line to its own buffer and count characters ----
                                                                                 
          cli
          mov     cs:merkss,ss      ;SS and SP must be stored in         
          mov     cs:merksp,sp      ;variables in code segment           
          mov     ax,cs             ;
          mov     SS,ax             ;  segment of new stack
          lea     SP,STAC+4096      ;  switch to interior stack
          sti

          PUSHR
                                                                       
;-- Store 64 words from the DOS stack ----------------------
                                                                                                            
          mov  cx,64             ;Loop counter
          mov  ds,cs:merkss      ;DS:SI indicates end of DOS stack
          mov  si,cs:merksp
                                                                                                            
tsrs1:    push word ptr [si]     ;Push word from DOS stack to this stack
          inc  si                ;and make SI the next stack
          inc  si                ;word
          loop tsrs1             ;Process all 64 words
          
;  Save old process (address of PSP of interrupted program)
          mov     ah,51h            ;  Could also use int 21h, function 62h
          int     21h               ;  GetProcess
          mov     CS:OLDPSP,bx      ;  PSP  of interrupted process
          
;  Save old DTA (of interrupted program)          
          mov     ah,2fh            ;  read address of current DTA
          int     21h               ;
          mov     CS:DTASEG,es      ;
          mov     CS:DTAOFF,bx      ;  save  DTA address

          Call    SAVESCR           ;  save screen
                                                                    
          mov     bx,CS:PSP0        ;  address of PSP of resident program
          mov     ah,50h            ;
          int     21h               ;  SetProcess
          cli

          mov     es,CS:ResSEG      ;  Release memory block reserved for child
          mov     ax,4900h
          int     21h
          cli
          mov     bx,ax            ;  termination code For Int 21h, Sub 49h
          jnc     ExitOK1          ;  normal termination
;  Determination of error type and message output (CF =1)
          mov     ax,cs            ;
          mov     ds,ax            ;  segment address of path and name of file
          lea     bx,ErrOK1
          Call    ERROR            ;  output error message
          
ExitOK1:  mov  ax,cs               ;  Memory released, proceed
          mov  ds,ax
          mov  es,ax
          lea  bx,parblock         ;  Parameter block for EXEC function
          mov  CS:[bx+2],offset comline  ; Command line for child process
          mov  CS:[bx+4],cs              ; (not used in current version)
          mov     CS:FLAG0,0        ;  clear flag of waiting to start
          mov     CS:FLAG1,1        ;  job activity flag
          lea  dx,PATH              ;  path and filename for child process
          mov  bx,offset parblock   ;  ES:BX points to parameter block     
          mov  ax,4B00h             ;  Function number for EXEC function   
          int  21h                  ;  Call DOS function                   
          mov     bx,ax             ;  termination code of  EXEC
          mov     CS:FLAG1,0        ;  clear job activity flag
          mov     ax,CS:MaxTick     ;  Reset keyboard inactivity flag
          mov     CS:NumTick,ax
          jnc     ExitNorm          ;  normal termination
;  Determination of error type and message output (CF =1)
          mov     ax,cs             ;
          mov     ds,ax             ;  segment address of path and name of file
          dec     bx                ;
          shl     bx,1              ;  *2
          lea     bx,ADRERR [bx]    ;  address of element of addresses table
          mov     bx,[bx]           ;  address of message
          Call    ERROR             ;  output error message

ExitNorm: mov     ax,5801h          ;  Set Memory allocation strategy
          mov     bx,02h            ;    strategy = high memory first  
          int     21h

try2:     mov     bx,cs:askmem      ;  Reallocate memory block before returning
          mov     ax,4800h          ;  to interrupted process
          int     21h
          mov     bx,ax             ;  termination code of  Int 21h, sub 48h
          mov     CS:ResSEG,ax      ;  Save address of reserved segment
          jnc     ExitOK2           ;  normal termination
          dec     cs:askmem         ;  If memory allocation refused, ask for
          jnz     try2              ;     less memory
;  Determination of error type and message output (CF =1)
          lea     bx,ErrOK2         ;  No memory available for allocation
          Call    ERROR             ;  output error message
          
ExitOK2:  mov     ax,5801h          ;  Set memory allocation strategy
          mov     bx,00h            ;    strategy = low memory first  
          int     21h
          
          Call    RESTSCR           ;  restore screen
          
;  Restore old DTA (interrupted program)
          lds     dx,CS:DTAADR      ;  address of  DTA of interrupted program
          mov     ah,1Ah            ;
          int     21h               ;  return  DTA  of interrupted program
          
;  Restore old process (address of PSP  of interrupted program)
          mov     bx,CS:OLDPSP      ;  PSP  of interrupted process
          mov     ah,50h            ;
          int     21h               ;  SetProcess
          
;-- Restore DOS stack --------------------------------------
                                                                                                            
          mov  cx,64             ; Loop counter
          mov  ds,cs:merkss      ; Load DS:SI with ending
          mov  si,cs:merksp      ; address of DOS stack
          add  si,128            ; Set SI to start of DOS stack
tsrs2:    dec  si                ; SI to previous stack word
          dec  si
          pop  word ptr [si]     ; Pop word from this stack to DOS
          loop tsrs2             ; Process all 64 words
          
          POPR                                                            

          cli                     ; Set stack segment and   
          mov  ss,cs:merkss       ;   stack pointer interrupts to their   
          mov  sp,cs:merksp       ;   original values                     
          sti                     ; Re-enable interrupt                 
                                                                       
          IRET                    ; Return to interrupted process                                                                                             
                                                                       
         ;-- Variables of this routine only addressable through CS ----
                                                                       
merkss    dw (?)                  ;Accepts SS during program call      
merksp    dw (?)                  ;Accepts SP during program call      
parblock  equ this word           ;Parameter block for EXEC function   
          dw 0                    ;Environment block                   
          dw ?                    ; offset comline         
          dw ?                    ; CODE segment               
          dd 0                    ;No data in PSP #1                   
          dd 0                    ;No data in PSP #2                   
                                                                       
comline   db 128 dup (?)          ;Accepts modified command line       
                                  ;  (not used in current version)                                     
EXEPRG    endp                                                         

;----------------------------------------------------------
;
;  New Handler for INT 13h (disk) interrupt
;
;----------------------------------------------------------
INT13H  PROC    FAR
        mov     CS:InBios,1             ;  disk activity flag
        pushf                           ;  flags register for  IRET (INT 13H)
        Call    CS:OLD13H               ;  call old handler for INT 13H
        mov     CS:InBios,0             ;  disk is not active
        IRET                            ;
INT13H  ENDP

;----------------------------------------------------------
;
;  New Handler for Multiplexer INT 28h interrupt
;
;----------------------------------------------------------
INT28H  PROC    FAR
        pushf                        ;  flags register for  IRET (INT 28h)
        Call    CS:OLD28H            ;  call old handler for  INT 28H
        cli                          ;  disable all interrupts
        cmp     CS:FLAG0,1           ;  job waiting to start ?
        jne     RET28                ;
        cmp     CS:FLAG1,1           ;  job active ?
        je      RET28                ;  wait for termination
        cmp     CS:InBios,1          ;  disk exchange ?
        je      RET28                ;  wait for termination
        PUSHR   <es,bx>              ;
        LES     bx,CS:DOSFLG         ;  address of  DOS activity flag
        cmp     byte ptr ES:[bx],1   ;  DOS  not active ?
        POPR    <bx,es>              ;
        ja      RET28                ;  wait for termination
;  Constructing stack for starting a job (on IRET from  INT 28h)
        pushf                        ;  flags register for IRET (INT 28h)
        push    cs                   ;  segment address for exit
        lea     cx,exeprg            ;  address of program for starting job
        push    cx                   ;  put onto stack for  IRET
        sti
        IRET                         ;
;  Restoring registers and exit
RET28:  sti                          ;  enable all interrupts
        IRET                         ;
INT28H  ENDP

;-----------------------------------------------------------
;
;  Subroutine for error message output
;
;  BX  -address of start of a text string
;
;-----------------------------------------------------------
ERROR   PROC    NEAR
        PUSHR                     ;  save registers
        mov     bp,80             ;  characters count
        mov     dh,24             ;  line of output =25
        mov     dl,0              ;  column of output =1
        Call    PUTSTR            ;  output message
        mov     di,1000           ;  signal frequency  1000 h
        mov     bx,25             ;  time of signal  0.25 seconds
        Call    SOUND             ;  output sound signal
        mov     cx,20             ;  time of delay (in ticks)
        Call    DELAY             ;  generate delay
        POPR                      ;  restore registers
        ret                   
ERROR   ENDP

;-----------------------------------------------------------
;
;  Subroutine for screen output of text
;
;  BX  -address of text string start
;
;  BP  -characters counter
;
;  DH  -starting line of cursor  (0 --- 24)
;
;  DL  -starting column of cursor (0 --- 79)
;
;  On achieving  0  remained part of string is cleared
;
;-----------------------------------------------------------
PUTSTR  PROC    NEAR
        mov     byte ptr CS:EOS,0       ;  clear End Of String flag
Cycle1: push    bx                      ;  save address of character
        xor     bh,bh                   ;  screen N  0
        mov     ah,2                    ;  function of cursor setting
        int     10h                     ;  set cursor
        pop     bx                      ;  restore address of character
        mov     al,[bx]                 ;
        cmp     byte ptr CS:EOS,0       ;  is end of string achieved ?
        jz      Zero                    ;
        mov     al,' '                  ;  transmitt space
        jmp     short  Putsym           ;
;  Check for End Of String (character =0)
Zero:   and     al,al                   ;  End Of String ?
        jnz     Putsym                  ;
        mov     CS:DL0,dl               ;  position for cursor setting
        mov     byte ptr CS:EOS,1       ;  End Of Sring is found
Putsym: mov     ah,07h                  ;  grey characters on dark background
        Call    WRCHAR                  ;  write character to the cursor position
        inc     bx                      ;  modify address of text
        inc     dl                      ;  modify cursor position
        dec     bp                      ;  counter of rest of characters
        jg      Cycle1                  ;  to the start of cycle
;  Set cursor to the end of the output line
        xor     bh,bh                   ;  screen # 0
        mov     ah,2                    ;  function for cursor setting
        mov     dl,CS:DL0               ;  position for cursor setting
        int     10h                     ;  set cursor
        ret
PUTSTR  ENDP

;-----------------------------------------------------------
;
;  Subroutine for writing character to cursor position
;
;  AL  -character being written
;
;  AH  -required attribute
;
;
;-----------------------------------------------------------
WRCHAR  PROC    NEAR
        push    bx                ;
        mov     bx,ax             ;  save character + attribute
        mov     al,dh             ;  multiplier - line of cursor
        mov     cl,160            ;  multiplier =160
        mul     cl                ;  calculate offset of video buffer
        xor     cx,cx             ;
        mov     cl,dl             ;  to add cursor column
        sal     cx,1              ;  *2
        add     ax,cx             ;  offset is calculated
;  Writing one character + attribute to video buuffer
        mov     di,ax             ;
        mov     ax,CS:VIDEO       ;  segment address of video buffer
        mov     ES,ax             ;
        mov     ES:[DI],bx        ;  move character + attribute
        add     DI,2              ;
        pop     bx
        ret
WRCHAR  ENDP

;-----------------------------------------------------------
;
;  Subroutine for generating of delay (in ticks)
;
;  CX  -time of delay
;
;-----------------------------------------------------------
DELAY   PROC    NEAR
        PUSHR   <ax,dx,es>
        mov     ax,40h               ;
        mov     ES,ax                ;  segment address of BIOS area
        sti                          ;  enable interrupts
T0:     mov     dx,ES:[6Ch]          ;  starting time (in ticks)
T1:     cmp     dx,ES:[6Ch]          ;  has time  gone ?
        je      T1                   ;  no !!!
        loop    T0                   ;
        POPR    <es,dx,ax>
        ret
DELAY   ENDP

;----------------------------------------------------------
;
;  Subroutine for outputting sound of a given tone
;
;  Frequency   -  di register (from  21  to  65535  h)
;
;  Duration -  bx register (in hundredths of second)
;
;----------------------------------------------------------
SOUND    PROC   NEAR
         PUSHR
         mov    al,0B6h           ;  write timer mode
         out    43h,al            ;  write to control register
         mov    dx,14h            ;  high part of divisor
         mov    ax,4F38h          ;  DX:AX = 1331000
         div    di                ;  1331000/frequency
         out    42h,al            ;  write low part
         mov    al,ah             ;
         out    42h,al            ;  write high part
         in     al,61h            ;  read port B
         mov    ah,al             ;  remember state of port B
         or     al,3              ;  resolution of timer and sound
         out    61h,al            ;
;  Generation of delay in hundredth of second (value in   BX)
Waitr:   mov    cx,2801           ;  duration 0.01 s
         loop   $                 ;  delay  0.01 s
         dec    bx                ;  has time gone ?
         jnz    Waitr             ;  no
         mov    al,ah             ;
         out    61h,al            ;  restore state of port B
         POPR                     ;
         ret                     ;
SOUND    ENDP

;----------------------------------------------------------
;
;  Procedure for saving the state of screen
;
;----------------------------------------------------------
SAVESCR PROC    NEAR
        PUSHR                     ;
        mov     ah,0Fh            ;  function for reading current mode
        int     10h               ;  determine current mode
        mov     CS:MODE,al        ;  sceen mode is read
        mov     ah,3              ;  read cursor position
        xor     bh,bh             ;  page number
        int     10h               ;
        mov     CS:CURSY,dh       ;  cursor line
        mov     CS:CURSX,dl       ;  cursor column
;  Read video buffer for saving
        mov     ax,CS:VIDEO       ;  address of video buffer
        mov     ds,ax             ;  move it to DS
        push    cs                ;
        pop     es                ;  output data segment
        xor     si,si             ;  address of start of video buffer
        lea     di,BUFER          ;  address of saving buffer
        cld                       ;  direction - forward !
        mov     cx,2000           ;  number of words
        rep     movsw             ;  read  2000  words of screen
        POPR                      ;
ExitS:  ret
SAVESCR ENDP

;----------------------------------------------------------
;
;  Procedure for restoring screen state
;
;----------------------------------------------------------
RESTSCR PROC    NEAR
        PUSHR                     ;
        xor     ah,ah             ;  function for setting mode
        mov     al,CS:MODE        ;  read screen mode
        int     10h               ;  set screen mode
;  Restoring video buffer
        mov     ax,CS:VIDEO       ;  address of video buffer
        mov     es,ax             ;  address to ES
        push    cs                ;
        pop     ds                ;  original data segment
        lea     si,BUFER          ;  address of saving buffer
        xor     di,di             ;  address of start of video buffer
        cld                       ;  direction - forward !
        mov     cx,2000           ;  number of words
        rep     movsw             ;  restore  2000  words of screen
;  Restoring position of cursor
        mov     ah,2              ;  set cursor position
        xor     bh,bh             ;  number of page
        mov     dh,CS:CURSY       ;  cursor line
        mov     dl,CS:CURSX       ;  cursor column
        int     10h               ;
        POPR                      ;
ExitR:  ret
RESTSCR ENDP

ResSEG  DW      0
BUFER   DB      4000 dup (0)      ;  buffer for  saving screen

;----------------------------------------------------------
;
;  Program for initial loading of resident part of Screen Saver
;
;----------------------------------------------------------
;  Check for presence already loaded driver  SAVSCRN

BEGIN:  
        mov     ax,3509h          ;  read address of current vector for INT 09h
        int     21h               ;  ES:BX  -address of vector
        mov     ax,es:[bx-2]      ;  driver presence code
        mov     LOD,0             ;  don't load driver
        cmp     ax,PRES0          ;  is driver in memory already ?
        je      M20               ;  yes, process parameters
        mov     LOD,1             ;  loading of driver is required
        mov     ax,cs             ;
        mov     ES,ax             ;
        lea     di,INT09H         ;  ES:DI -address of new vector  INT09H
        jmp     short M21
;  Processing command string (if present)
M20:    xor     di,di                   ;
        mov     ES,di                   ;  segment address =0
        les     di,ES:[24h]             ;  ES:DI  -address of old vector
M21:    mov     ADRINT,di               ;  address of start of vector for INT09H
        mov     bx,80h                  ;  address of length of parameters field
        mov     cl,[bx]                 ;  length of parameters field
        xor     ch,ch                   ;  CX -length of command string
        and     cl,cl                   ;  are parameters absent ?
        jz      NOPATH                  ;  they're absent !!!
        inc     bx                      ;
;  Processing parameters of command string
M22:    mov     al,[bx]                 ;  character from command string
        cmp     al,'/'                  ;  start of parameter ?
        je      M23                     ;
        inc     bx                      ;  address of next character
        loop    M22                     ;  to start of cycle
        jmp     ERPATH                  ;
;----------------------------------------------------------------------
;  Outputting message about absence of parameters and request for input
;----------------------------------------------------------------------
NOPATH: lea     dx,ERR1                 ;  parameters are absent
        mov     ax,cs                   ;  data segment in code segment
        mov     ds,ax                   ;
        mov     ah,9                    ;  code of text output function
        int     21h                     ;  output message
TASK2:  
        mov     ax,cs                   ;  data segment in code segment
        mov     ds,ax                   ;
        lea     dx,ERR3                 ;  parameters are absent
        mov     ah,9                    ;  code of text output function
        int     21h                     ;  output message
        Call    INPUT                   ;  request for  parameters input
        mov     cl,LENG                 ;  length of field
        cmp     LENG,0                  ;  empty input ?
        jna     Exit00                  ;  exit
        lea     bx,PATH                 ;  parameters field from  PATH string
        cmp     byte ptr PATH,'/'       ;
        je      M23                     ;  continue work
        lea     bx,PATH-1               ;  parametrs field from  PATH string
        jmp     short M23               ;  path without "/"
Exit00: mov     ax,4c00h                ;  terminate program with 0 code
        int     21h                     ;  return to  MS-DOS
;  Output message on error in parameters
ERPATH: lea     dx,ERR4                 ;  error in parameters
        mov     ax,cs                   ;  data segment in code segment
        mov     ds,ax                   ;
        mov     ah,9                    ;  code of text output function
        int     21h                     ;  output message
        jmp     short TASK2             ;
;---------------------------------------------------------------------
;  Clearing the path of file being loaded
;  ES:DI  -address of entry point of   INT09H (in the program)
;---------------------------------------------------------------------
M23:    push    cx                      ;  counter for length of  PATH  field
        inc     bx                      ;
        mov     cx,64                   ;  length of path
        xor     al,al                   ;
        sub     di,66                   ;  address of start of PATH
        cld                             ;
        rep     stosb                   ;  clear  PATH (ES:DI)
        pop     cx                      ;
;  Passing the path for file being loaded (DS:BX)
        sub     di,64                   ;  address of start of   PATH
M24:    mov     al,[bx]                 ;  character of name from (DS:BX)
        cmp     al,' '                  ;  end of name ?
        jna     M25                     ;
        stosb                           ;  pass character to  PATH
        inc     bx                      ;  address of next character
        loop    M24                     ;  to the start of the cycle
;  Output message onchanging parameters of driver
M25:    cmp     LOD,1                   ;  is load required ?
        je      REGIM                   ;  yes, it is
        mov     di,1000                 ;  frequency  1000 h
        mov     bx,25                   ;  duration  0.25 s
        Call    SOUND                   ;  output sound signal
        lea     dx,LOAD1                ;
        mov     ah,9                    ;  code of text output function
        int     21h                     ;  output message
        mov     ax,4c00h                ;  terminate program with 0 code0
        int     21h                     ;  return to  MS-DOS
;------------------------------------------------------------------------
;  Determining the segment address of video buffer
;------------------------------------------------------------------------
REGIM:   mov    ax,cs               ;
         mov    ds,ax               ;  data segment in code segment
         mov    VIDEO,0B000H        ;  address of video buffer for monochrom display
         mov    ax,40h              ;  segment address of  BIOS area
         mov    ES,ax               ;  ES -address of  BIOS data area
         mov    al,ES:[10h]         ;  read hardware list  0040 : 0010
         and    al,30h              ;  clear bits out of interest
         cmp    al,30h              ;  is it a monochrom display ?
         je     Modvec              ;  yes !
         mov    VIDEO,0B800H        ;  address of video buffer for color display
;  Get the address of DOS activity flag (int 34h)
MODVEC: mov     ah,34h            ;  Get the address of DOS activity flag
        int     21h               ;  address of flag in  ES:BX
        mov     SEGFLG,ES         ;
        mov     OFFFLG,BX         ;
        mov     PSP0,cs           ;
        cli                       ;  disable interrupts for the time of substitution
;  Reading and saving the old vector  INT08H
        mov     ax,3508h          ;  read  address of current vector INT 08h
        int     21h               ;  ES:BX  -address been read
        mov     OFF08H,bx         ;  pass address of old vector
        mov     SEG08H,es         ;  pass segment address of old vector
        lea     dx,INT08H         ;  DS:DX -address of new vector
        mov     ax,2508h          ;  activate new interrupt  INT 08h  vector
        int     21h               ;
;  Modify address of keyboard interrupt INT 09H vector
        mov     ax,3509h          ;  read  address of current vector  INT 09h
        int     21h               ;  ES:BX  -address been read
        mov     OFF09H,bx         ;  pass address of old vector
        mov     SEG09H,es         ;  pass segment address of old vector
        lea     dx,INT09H         ;  DS:DX -address of new vector
        mov     ax,2509h          ;  activate new interrupt  vector  INT 09h
        int     21h               ;
;  Reading and modyfying an old vector for interrupt 13h
        mov     ax,3513H          ;  read  address of current vector  INT 13H
        int     21h               ;  ES:BX  -address been read
        mov     OFF13H,bx         ;  pass address of old vector
        mov     SEG13H,es         ;  pass segment address of old vector
        lea     dx,INT13H         ;  DS:DX -address of new vector
        mov     ax,2513H          ;  activate new interrupt  vector   INT 13H
        int     21h               ;
;  Reading and modyfying an old vector for interrupt 28h
        mov     ax,3528h          ;  read  address of current vector  INT 28h
        int     21h               ;  ES:BX  -address been read
        mov     OFF28H,bx         ;  pass address of old vector
        mov     SEG28H,es         ;  pass segment address of old vector
        lea     dx,INT28H         ;  DS:DX -address of new vector
        mov     ax,2528h          ;  activate new interrupt  vector  INT 28h
        int     21h               ;
        sti                       ;  enable interrupts (substitutions have been performed)
;  Loading the resident part of the program
        lea     dx,LOAD0          ;  address of message
        mov     ah,9              ;  code of text output function
        int     21h               ;  output message on driver loading
        lea     dx,BEGIN          ;  length of resident part  (byte)
KEEP:   mov     cl,4              ;
        shr     dx,cl             ;  length of resident part in paragraphs
        add     dx,20             ;  16  paragraphs for  PSP + 4
        mov     LENGCO,dx         ;  Save length of Resident Code (paragraphs)
        mov     bx,dx             ;  Release unused memory
        mov     ax,cs
        mov     es,ax
        mov     ax,4A00h
        int     21h
        
        mov     ax,5801h     ;  Set memory allocation strategy
        mov     bx,02h       ;     strategy = high memory first
        int     21h

        mov     bx,2000h     ;  Reserve 2000h paragraphs for screen saver
        mov     ax,4800h     ;  (otherwise some programs reserve all
        int     21h          ;  remaining memory and screen saver can't load)
          
        mov     bx,ax             ;  termination code of  EXEC
        mov     ResSEG,ax         ;  Store reserved segment in ResSEG
        jnc     ExitOK0           ;  normal termination
;  Determination of error type and message output (CF =1)
          mov     ax,cs             ;
          mov     ds,ax             ;  segment address of path and name of file
          lea     bx,ErrOK0
          Call    ERROR             ;  output error message
        
ExitOK0:
        mov     ax,5801h           ; Set memory allocation strategy
        mov     bx,00h             ;   strategy = low memory first
        int     21h

        mov     dx,LENGCO         ;  Length of resident code in paragraphs
        mov     ax,3100h          ;  terminate and state resident
        int     21h               ;  TERMINATE
;----------------------------------------------------------
;
;  Procedure for parameters input (path of job to be started)
;
;  ES:DI  -address of INT09H  vector
;
;  CX     -length of string input (on exitting procedure)
;
;----------------------------------------------------------
INPUT   PROC    NEAR
        PUSHR
        PUSHR   <es,di>                 ;  ES:DI  -address  INT09H
        push    cs                      ;
        pop     es                      ;  data segment in code segment
        lea     di,LENG                 ;  address for start of clearing
        mov     cx,81                   ;  length of string being cleared
        xor     al,al                   ;  clearing character =0
        cld                             ;
        rep     stosb                   ;  clear string
        lea     dx,MAX                  ;  DS:DX -address of start of string
        mov     ah,0Ah                  ;  input string
        int     21h                     ;
;  Passing the input parameters to the  PATH field
        POPR    <di,es>                 ;  ES:DI  -address of INT09H
        sub     di,66                   ;  address of start of PATH
        xor     ch,ch                   ;  clear high part
        mov     cl,LENG                 ;  length of input information
        lea     si,PATH                 ;
        rep     movsb                   ;  pass the path been input
        mov     byte ptr es:[di],0      ;  end of path indicator
        POPR                            ;
        ret                            ;  exit
INPUT   ENDP

;----------------------------------------------------------
;
;  Procedure for search of a given key word in  PATH field
;
;  DS:BX  -address of start of parameters field on running
;
;  DS:SI  -address of standard (key word)
;
;  DX     -length of standard
;
;  CX     -length of field for parameter search
;
;  CF =1  -parameter is not found
;
;----------------------------------------------------------
COMPAR  PROC    NEAR
;  Reducing letters to capitals
M100:   mov     al,[bx]                 ;  character from  PATH field
        cmp     al,'a'                  ;  character < a ?
        jb      M101                    ;
        cmp     al,'z'                  ;  character > z ?
        ja      M101                    ;
        and     al,0DFh                 ;  reduce to capitals
;  Searching for coinsiding characters of parameter string and standard
M101:   cmp     [si],al                 ;  is character of standard found ?
        je      M102                    ;  compare next character
        inc     bx                      ;  address of nextcharacter from  PATH
        loop    M100                    ;  continue search
        jmp     short  Nocomp           ;  paramener not found
M102:   inc     si                      ;  address of next byte of standard
        inc     bx                      ;  address of next byte of   PATH
        dec     dx                      ;  length of rest of standard
        jz      Normal                  ;
        loop    M100                    ;  continue search
;  Exit on key parameter not found
Nocomp: stc                             ;  CF =1 - error indicator
        ret                            ;  exit
;  Exit on key parameter  found
Normal: clc                             ;  clear carry flag
        ret                            ;  exit
COMPAR  ENDP

;------------------------------------------------------------------------
;
;  Transforming two characters into byte   (ASCII ---> HEX)
;
;  Input:
;  -----
;  AH  -lower byte of a numeral (transformed into right nybble)
;  AL  -higher byte of a numeral (transformed into left nybble)
;
;  Output:
;  ------
;  AL  -output result (two nybbles for hex numerals)
;
;  CF =1 -transformation error code
;
;------------------------------------------------------------------------
;
SYMHEX  PROC    NEAR
        Call    TRANS             ;  transforming numeral from AL
        jc      ExitH             ;  exit on error
        shl     al,1              ;  shift nybble to the left  (higher part)
        shl     al,1              ;
        shl     al,1              ;
        shl     al,1              ;  left nybble  of result is in AL
        xchg    al,ah             ;  AL - higher byte for right nybble
        Call    TRANS             ;  transform character from  AL
        jc      ExitH             ;  exit on error
        or      al,ah             ;  merge right + left nybbles
        clc                       ;  normal transformation indicator
ExitH:  ret                      ;  result in AL
SYMHEX  ENDP

;----------------------------------------------------------
;
;  Transforming a character into a hex
;
;  AL  -given character of hex numeral (ASCII -input)
;
;  AL  -transformed hex numeral (right nybble)
;
;----------------------------------------------------------
TRANS   PROC    NEAR
        cmp     al,30h            ;  character < 0 ?
        jl      ErrorH            ;  error
        cmp     al,39h            ;  character >  9 ?
        jg      Caps              ;  test for capitals A----F
        sub     al,30h            ;  subtract constant for ciphers
        jmp     short Eoc         ;
;  Transforming capitals    A----F
Caps:   cmp     al,41h            ;  character < A ?
        jl      ErrorH            ;  error
        cmp     al,46h            ;  character > F ?
        jg      Little            ;  test for small letters a --- f
        sub     al,37h            ;  subtract constant for small letters
        jmp     short Eoc         ;
;  Transforming small letters  a----f
Little: cmp     al,61h            ;  character < a ?
        jl      ErrorH            ;  error
        cmp     al,66h            ;  character > F ?
        jg      ErrorH            ;  error
        sub     al,57h            ;  subtract constant for small letters
; Transformation  peformed without errors
Eoc:    clc                       ;  clear carry flag
        ret                      ;  normal exit
;  Error on character transformation error
ErrorH: stc                       ;  carry flag on error
        ret
TRANS   ENDP

;----------------------------------------------------------
LOD     DB      0                 ;
PRES0   DW      1234              ;  TSR presence code
ADRINT  DW      0                 ;  address of entry point of  INT09H vector
BX0     DW      0                 ;  address after path in PATH field
CX0     DW      0                 ;  length of rest of parameters field
LOAD0   DB      10,13,'Driver  *** SAVSCRN ***  is loaded $',13,10
LOAD1   DB      10,13,'*** SAVSCRN ***  PATH is changed !! $ ',13,10
ERR1    DB      10,13,'*** SAVSCRN ***  PATH is absent !!$'
ERR3    DB      10,13,'Enter:   /PATH:File.ext     ', 13, 10, '$'
ERR4    DB      10,13,'*** SAVSCRN ***  Errors in parameters !!$ '
        DB      13,10
MAX     DB      80                ;  maximum length of input string
LENG    DB      0                 ;  actual length of input string
LENGCO  DW      0                 ;  Length of resident code in paragraphs
CODE    ENDS
        END     START
