comment	|

	This program reads and reports the current contents of the Inter-
	Application Communications Area (IAC).

	The IAC is 16 bytes beginning at addr 0040:00F0h. Any program can
	write information to the IAC for another program to read. Please
	note: unless the first program directly	invokes the second program,
	it cannot protect the IAC from being altered by an intervening program.
	The IAC can be used, for instance, to pass an address from one program
	to the next.

	Written for MASM 5.0 by Hardin Brothers for PCResource. The original
	appeared in the April 1988 issue of their magazine. Entire contents of
	the April 1988 issue (C) Copyright 1988 by
				IDG Communications/Peterborough, Inc.

	Hardin Brothers is a freelance programmer and technical writer. Write
	to him at 280 N. Campus Ave., Upland, CA  91786. Enclose a self-
	addressed, stamped envelope for a reply.

	|

LF	equ	0Ah	; linefeed char
CR	equ	0Dh	; carriage return char
STDOUT	equ	1	; standard output device

EXIT	macro	val
	mov	AH, 4Ch		; INT 21h service 4Ch: exit from program
				; also returns a value. replaces old INT 20h.
	mov	AL, val		; return value byte
	int	21h
	endm

	.MODEL	SMALL
	.STACK

	.DATA
hexasc		db	'0123456789ABCDEF'

title$		db	CR, LF
		db	'Contents of Inter-Application Communication Area'
		db	' (IAC):', CR, LF, CR, LF
ltitle		equ	$-title$

byte$		db	' '
cnvt$		db	'  h'
lbyte		equ	$-byte$

	.CODE

start:	mov	AX, @data
	mov	DS, AX		; initialize data seg register
	lea	DX, title$	; addr DS:DX points to output string
	mov	CX, ltitle	; output string byte count
	mov	BX, STDOUT	; write to standard output device
	mov	AH, 40h		; INT 21h service 40h: write to file/device
	int	21h
	mov	AX, 0040h	; BIOS information segment
	mov	ES, AX		; initialize ES
	mov	SI, 0F0h	; start of IAC
	mov	CX, 10h		; length of IAC in bytes

lp:	mov	AL, ES:[SI]	; get a byte from IAC
	push	CX
	push	BX		; save loop count and device handle
	call	convert		; convert bytes to ASCII
	pop	BX		; restore handle
	lea	DX, byte$	; addr DS:DX points to output string
	mov	CX, lbyte	; string byte count
	mov	AH, 40h
	int	21h
	pop	CX		; restore loop count
	inc	SI		; point to next byte in IAC
	loop	lp		; continue loop
	mov	AH, 02h		; INT 21h service 02h: write a char to stdout
	mov	DL, CR
	int	21h
	mov	AH, 02h
	mov	DL, LF
	int	21h
	EXIT	0		; normal termination value

convert:
	lea	DI, cnvt$	; DS:DI points to storage area
	lea	BX, hexasc	; DS:BX points to ASCII translation string
	mov	AH, AL		; keep copy of byte
	mov	CL, 4		; set nibble count
	shr	AL, CL		; move top nibble down
	xlat	BX		; translate nibble to ASCII char
	mov	[DI], AL	; store ASCII char
	inc	DI		; point to next char space
	mov	AL, AH		; restore byte
	and	AL, 0Fh		; mask top nibble
	xlat	BX		; translate
	mov	[DI], AL	; store char
	ret

	end	start

