
comment #

pix320.com displays the image that follows the code in the VGA 320x200
by 256 color mode.  The image is made using gifdcd from an appropriate
.gif file.  For example, this will make porsche.com from porsche.gif
assuming porsche.gif is a 320x200 .gif image:

        C>gifdcd/w porsche
        porsche is 320x200x5 bits and 4 bits/color with a global color map
         background color is 0
         image: start 0/0 pixels from left/top, is 320x200 sequential
          code size = 5 bits
          decompressed image = 64000 pixels
         file properly terminated (but extra data at end)

        C>copy pix320.com/b+porsche.pix/b porsche.com

#

pix320 segment
 assume cs:pix320,ds:pix320,es:pix320,ss:pix320
  org 100h
start:
  mov sp,100h
        ; select 320x200x8 VGA mode.
  mov ax,13h
  int 10h
        ; write 256 color palette.
  mov ax,1012h
  mov bx,0
  mov cx,256
  mov dx,offset image+16
  int 10h
        ; turn off screen.
  mov dx,03c4h
  mov al,1
  out dx,al
  inc dx
  in al,dx
  or al,020h
  out dx,al
        ; copy image to screen.
  cld
  mov si,offset image+16+768
  sub di,di
  mov ax,0a000h
  mov es,ax
  assume es:nothing
  mov cx,32000
  rep movsw
        ; turn on screen.
  mov dx,03c4h
  mov al,1
  out dx,al
  inc dx
  in al,dx
  and al,0dfh
  out dx,al
        ; wait for keystroke.
  mov ah,0
  int 16h
        ; restore screen and return.
  mov ax,3
  int 10h
  int 20h
        ; image starts at even byte after code.
  even
image label byte
pix320 ends
end start
