
comment #

pix640.exx displays the image that follows the code in the extended
Paradise VGA 640x480 by 256 color mode.  The image is made using gifdcd
from an appropriate .gif file.  For example, this will make paint.exe
from paint.gif assuming paint.gif is a 640x480 .gif image:

        C>gifdcd/w paint
        paint is 640x480x8 bits and 6 bits/color with a global color map
         background color is 0
         image: start 0/0 pixels from left/top, is 640x480 sequential
          code size = 8 bits
          decompressed image = 307200 pixels
         file properly terminated

        C>copy pix640.exx/b+paint.pix/b paint.exe

To make the file pix640.exx, the pix640.exe program that this .asm file
generates must be truncated.  Here are the commands (the responses for
tasm and tlink are not shown):

        C>tasm pix640
        C>tlink pix640
        C>ren pix640.exe pix640.exx
        C>debug pix640.exx
        -rcx
        CX B680
        :370
        -rbx
        BX 0004
        :0
        -w
        Writing 0370 bytes
        -q
        C>

If the program below is changed, the 370 value above must be changed.
Use the search command in debug to find the first string of 0ah's.  That
address minus 100h is the new value.  For example, the command:

        -s100lf000 a a a a a

will report 0470 for this program.

#

stk segment para stack
 db 256 dup(?)
stk ends

pix640 segment
 assume cs:pix640,ds:nothing,es:nothing,ss:stk
start:
        ; select 640x480x8 VGA mode.
  mov ax,5fh
  int 10h
        ; write 256 color palette.
  mov ax,1012h
  mov bx,0
  mov cx,256
  sub dx,dx
  mov si,seg imgpal
  mov es,si
  assume es:nothing
  int 10h
        ; turn off screen.
  mov dx,03c4h
  mov al,1
  out dx,al
  inc dx
  in al,dx
  or al,020h
  out dx,al
        ; set up segment registers for copy.
  cld
  mov ax,0a000h
  mov es,ax
  assume es:nothing
  mov ax,seg imgpix0
  mov ds,ax
  assume ds:nothing
        ; unlock Paradise registers.
  mov dx,03ceh
  mov ax,050fh
  out dx,ax
        ; copy image to screen in five pieces.
  mov ax,9
 cplp:
   out dx,ax
   sub si,si
   mov di,si
   mov cx,(640*(480/5))/2
   rep movsw
   mov bx,ds
   add bx,(640*(480/5))/16
   mov ds,bx
   add ah,(640*(480/5))/4096
   cmp ah,5*((640*(480/5))/4096)
   jb cplp
  pop ds
  assume ds:nothing
        ; turn on screen.
  mov dx,03c4h
  mov al,1
  out dx,al
  inc dx
  in al,dx
  and al,0dfh
  out dx,al
        ; wait for keystroke.
  mov ah,0
  int 16h
        ; restore screen and return.
  mov ax,3
  int 10h
  mov ax,4c00h
  int 21h
pix640 ends

imghdr segment para
  db 16 dup (10)
imghdr ends
imgpal segment para
  db (3*256) dup (11)
imgpal ends
imgpix0 segment para
  db (640*(480/5)) dup (0)
imgpix0 ends
imgpix1 segment para
  db (640*(480/5)) dup (1)
imgpix1 ends
imgpix2 segment para
  db (640*(480/5)) dup (2)
imgpix2 ends
imgpix3 segment para
  db (640*(480/5)) dup (3)
imgpix3 ends
imgpix4 segment para
  db (640*(480/5)) dup (4)
imgpix4 ends

end start
