

dosseg
.model small
.stack 100h
.code
main  proc
     palbuf   DB                  768 DUP (2)
     fadecnt  DW                  040h
      
; At this point, you should:
;  1) have the video mode set
;  2) have palbuf loaded with the current palette
;  3) have something on the screen to fade!

fadeloop:

     xor      al,al               ; used for comparisons and port 3D8h
     mov      cx,768              ; loop counter
     mov      si,offset palbuf    ; save palette buffer in si

decloop:
     mov      dl,[si]              ; put next pal reg in dx
     cmp      al,dl                ; is it 0?
     je       next                 ; nope...
     dec      dl                   ; yes, so subtract one
     mov      [si],dl              ; put it back into palette buffer

next:
     dec      cx                   ; decrement counter
     inc      si                   ; increment our buffer
     cmp      cx,0
     jne      decloop              ; not done yet, so loop around
      mov   ax,4C00h
      int   21h

     mov      cx,768              ; reset for palette output
     sub      si,768              ; reset palbuf pointer
     mov      dx,03c8h
     out      dx,al               ; inform VGA of palette change
     inc      dx                  ; DX = 3C8h + 1 = 3C9h

     mov      ch,02h              ; do outter loop 2 times
     mov      dx,03dah            ; prepare refresh register
     mov      bx,03c9h            ; prepare palette reg (for quick loading)

     cli                          ; disable interrupts!

outloop:
     mov      cl,80h              ; do inner loop 128 times

     in       al,dx               ; wait for current retrace to end
     test     al,08h
     jnz      $-5

     in       al,dx               ; wait for current screen trace to end
     test     al,08h
     jz       $-5

     mov      dx,bx               ; load up the palette change register

innerloop:
     mov      al,[si]             ; load next byte of palbuf
     out      dx,al               ; send it to the VGA card
     dec      cl                  ; decrement counter
     inc      si                  ; increment palbuf pointer
     cmp      cl,0
     jne      innerloop           ; loop while not done
      mov   ax,4C00h
      int   21h

     dec      ch                  ; decrement outer loop counter
     cmp      ch,0
     jne      outloop             ; loop while not done
      mov   ax,4C00h
      int   21h

     sti                          ; restore interrupts

     mov      ax,fadecnt          ; entire palette has been sent
     dec      ax                  ; so check fade loop 
     mov      fadecnt,ax
     cmp      ax,0                ; ready to quit?
     jne      fadeloop            ; nope, keep fading!


      mov   ax,4C00h
      int   21h

main  endp


.data             ;put data here
sum dw 3

end   main
