{ Example for using complex mathematics unit PasCmplx}
{ (c)1994 by Alex Klimovitski                        }

{ This program doesn't perform anything meaningful,  }
{ except that it gives an example of using PasCmplx. }
{ If you are looking for more sense, see PASFFT.PAS. }

program CmplxTest;

{$G+}

uses WinCrt, PasCmplx;
{ Delete 'WinCrt' if your target is DOS or DPMI }

var
  a, b, c, d: Double;
  z, p, q: Complex;
  I: Integer;
  W: Word;
begin
  WriteLn(CTest87);
  z := Cj;
  WriteLn('j = ', CReal(z), '+j', CImag(z));
  z := C1;
  WriteLn('1 = ', CReal(z), '+j', CImag(z));

  Write('a, b>');
  ReadLn(a, b);
  z := Cmplx(a, b);
  WriteLn('z = ', CReal(z), '+j', CImag(z));
  WriteLn('z- = ', CReal(Conjug(z)), '+j', CImag(Conjug(z)));

  for I := 0 to 7 do
  begin
    if CCheck(CIPow(z, I)) <> 0 then
    begin
      WriteLn('z^', I, ': Can''t calculate power');
      Continue;
    end;
    WriteLn('z^', I, ':', CReal(CIPow(z, I)), CImag(CIPow(z, I)));
    WriteLn('z^', I, ':', CReal(CRPow(z, I)), CImag(CRPow(z, I)));
    WriteLn('z^', I, ':', CReal(CPow(z, Cmplx(I, 0))), CImag(CPow(z, Cmplx(I, 0))));
  end;

  Write('c, d>');
  ReadLn(c, d);

  p := Cmplx(c, d);
  WriteLn('p = ', CReal(p), '+j', CImag(p));
  WriteLn('p- = ', CReal(Conjug(p)), '+j', CImag(Conjug(p)));

  q := CAdd(z, p);
  WriteLn('q = z + p = ', CReal(q), '+j', CImag(q));

  q := CSub(z, p);
  WriteLn('q = z - p = ', CReal(q), '+j', CImag(q));

  q := CMul(z, p);
  WriteLn('q = z * p = ', CReal(q), '+j', CImag(q));

  q := CDiv(z, p);
  if CCheck(q) <> 0 then
    WriteLn('q = z / p: invalid division')
  else
  begin
    WriteLn('q = z / p = ', CReal(q), '+j', CImag(q));
    WriteLn('Check it:');
    q := CMul(q, p);
    WriteLn('z = q * p = ', CReal(q), '+j', CImag(q));
  end;

  WriteLn('|z| = ',CAbs(z), '; arg(z) = ',CArg(z));

  z := Cmplx(a, b);
  q := CExp(z);
  if Lo(CTest(q)) > C87Ok then
    WriteLn('Invalid real part of exp(z)');
  if Hi(CTest(q)) > C87Ok then
    WriteLn('Invalid complex part of exp(z)');

  WriteLn('exp(z) = ', CReal(q), '+j', CImag(q));
  WriteLn('Check it:');
  WriteLn('exp(z) = ', Exp(a) * Cos(b), '+j', Exp(a) * Sin(b));
  p := CLn(q);
  WriteLn('z =? ln(exp(z)) = ', CReal(p), '+j', CImag(p));
  WriteLn('exp(z) =? exp(ln(exp(z))) = ', CReal(CExp(p)), '+j', CImag(CExp(p)));
end.