/*
    BCDOP.HPP

    BCD number library - header file

    class tBcd:  Declarations for a BCD class using OPBCD-routines
                 from Turbo Power Software
                 (The t in tBcd means "type", a very useful convention
                  for public identifiers:
                  t = type, c = constant, p = pointer, r = reference)

    1993 by Jens Reckendorf, Vectron Systems GmbH,
            48163 Mnster, Germany  CIS: 100060,661

    Link with OPBCD.ASM in the version modified for C++.

    If you do not need iostream-support undefine __tBcdStreamIO__
    and recompile BCDOP.CPP. In this case these routines do not
    need anything of the runtime library (FYI: This code was
    developed for an embedded system with a very simple own
    runtime lib).

    Further details in OPBCD.ASM and BCDOP.CPP.
*/

#define __tBcdStreamIO__

#ifndef __cplusplus
  #error Must use C++ for the type tBcd.
#endif

#ifdef __tBcdStreamIO__
  #include <iostream.h>
#endif

class tBcd
  {
    public:
      // Constructors
      tBcd () {};                            // Does nothing
      tBcd (long x);                         // Init with long x

      // Bcd manipulations
      friend tBcd BcdAbs (tBcd&);            // Returns absolute value
      friend tBcd BcdInt (tBcd&);            // Returns integer part
      friend tBcd BcdFrac (tBcd&);           // Returns fractional part

      // Conversion to long
      friend long BcdRound (tBcd&);          // Rounds to long
      friend long BcdTrunc (tBcd&);          // Greatest long less or equal

      // String conversions
      friend void BcdStr (char*, tBcd&, unsigned char Width, unsigned char Places);
        // Converts Bcd to string, char* must have enough room for result
      friend int BcdVal (char* St, tBcd& a);
        // String to Bcd; returns 0 if ok, error position if not okay

      // Operator Functions; they do what you expect
      friend tBcd operator+ (tBcd&, tBcd&);
      friend tBcd operator- (tBcd&, tBcd&);
      friend tBcd operator* (tBcd&, tBcd&);
      friend tBcd operator/ (tBcd&, tBcd&);
      friend int operator== (tBcd&, tBcd&);
      friend int operator!= (tBcd&, tBcd&);
      friend int operator>= (tBcd&, tBcd&);
      friend int operator<= (tBcd&, tBcd&);
      friend int operator> (tBcd&, tBcd&);
      friend int operator< (tBcd&, tBcd&);

      tBcd operator+ () {return *this;};
      tBcd operator- ();

      #ifdef __tBcdStreamIO__
        // Streamio functions (<< uses os.width and os.precision)
        friend ostream& operator<< (ostream&, tBcd&);
        friend istream& operator>> (istream&, tBcd&);
      #endif

      // Implementation
    private:
      char number[10];
  };
