 PAGE	81,128
 TITLE	XRPRNT	- Print	Cross Ref Listing
 SUBTTL	V1.0 - May 1986	- Cross	Reference Facility
;
;=============================================================================|
;	     Copyright 1986 - Dan Daetwyler - Springdale, AR 72764	      |
;=============================================================================|
	.SALL
;
DATA	SEGMENT	BYTE PUBLIC 'DATA'
;
	PUBLIC	PAGNO,LCNT
;
	EXTRN	MNAMES:BYTE,MEXTN:BYTE,MPUBN:BYTE,MPCNT:WORD
;
ENAM1	DB	12 DUP (?)
	DB	' in '
ENAM2	DB	12 DUP (?)
	DB	' ref by: ',0
CRLF	DB	13,10,0
;
CCNT	DW	90
LCNT	DB	90
PAGNO	DB	0
;
LXREF	DB	15,27,'0CROSS REFERENCE LISTING  --  Page  ',0
;
DATA	ENDS
;
CODE	SEGMENT	BYTE PUBLIC 'CODE'
	ASSUME	CS:CODE,DS:DATA,ES:DATA
;
;==============================================================================
; Entry	Point	XRPRNT							      |
;==============================================================================
;									      |
; This module uses the sorted public  references table to drive	through	the   |
; X reference listing.	All stacks are used.				      |
;									      |
; Entry	conventions:	None.						      |
;									      |
; Returns:		None.						      |
;									      |
;==============================================================================
;
	EXTRN	XRSRCH:NEAR
;
	PUBLIC	XRPRNT
;
XRPRNT	PROC	NEAR
	MOV	CX,MPCNT		;Count of publics
	MOV	SI,OFFSET MPUBN		;Point to stack
LP:	CMP	LCNT,74
	JBE	NOPAG
	CALL	DOPAGE
NOPAG:	CALL	CLEAR			;Prepare print line buffer
	MOV	DI,OFFSET ENAM1
	CALL	MOVE			;Put name in buffer
	PUSH	SI
	MOV	SI,WORD	PTR [SI+14]	;Load module name pointer
	MOV	DI,OFFSET ENAM2
	CALL	MOVE
	MOV	SI,OFFSET ENAM1
	CALL	PRINT
	POP	SI
	MOV	DX,CCNT			;Load remaining	line length
	MOV	DI,OFFSET MEXTN		;Point to start	of external names
XLP:	CALL	XRSRCH			;Search	for external reference
	JC	NOMORE
	XCHG	BX,SI
	CALL	BMOVE
	XCHG	BX,SI
	ADD	DI,15
	JMP	XLP
NOMORE:	CALL	DCRLF
	ADD	SI,16			;Step to next stack entry
	LOOP	LP
	RET
XRPRNT	ENDP
;
MOVE	PROC	NEAR
	PUSH	SI
	PUSH	DI
	PUSH	CX
	XOR	CX,CX
	MOV	CL,BYTE	PTR [SI]
	INC	SI
	REP	MOVSB
	POP	CX
	POP	DI
	POP	SI
	RET
MOVE	ENDP
;
BMOVE	PROC	NEAR
	PUSH	CX
	MOV	CL,BYTE	PTR [SI]		;Get name length
	XOR	CH,CH
	INC	SI
	SUB	DX,CX
	JC	EOL
	JZ	EOL
	DEC	DX
	JNZ	BNORM
EOL:	PUSH	SI
	PUSH	CX
	CALL	DCRLF
	MOV	CX,127
	SUB	CX,CCNT
	MOV	DL,' '
	MOV	AH,5
BPLP:	INT	21H
	LOOP	BPLP
	POP	CX
	POP	SI
	MOV	DX,CCNT
BNORM:	MOV	AH,5
	PUSH	DX
BNLP:	LODSB
	MOV	DL,AL
	INT	21H
	LOOP	BNLP
	MOV	DL,' '
	INT	21H
	POP	DX
	POP	CX
	RET
BMOVE	ENDP
;
CLEAR	PROC	NEAR
	PUSH	DI
	PUSH	CX
	MOV	CX,12
	MOV	AL,' '
	MOV	DI,OFFSET ENAM1
	REP	STOSB
	MOV	CX,12
	MOV	DI,OFFSET ENAM2
	REP	STOSB
	POP	CX
	POP	DI
	RET
CLEAR	ENDP
;
PRINT	PROC	NEAR
	PUSH	SI
	PUSH	DX
	PUSH	CX
	MOV	AH,5
PLP:	LODSB
	OR	AL,AL
	JZ	PDNE
	MOV	DL,AL
	INT	21H
	JMP	PLP
PDNE:	POP	CX
	POP	DX
	POP	SI
	RET
PRINT	ENDP
;
DOPAGE	PROC	NEAR
	PUSH	SI
	PUSH	CX
	MOV	LCNT,0
	CMP	PAGNO,0
	JE	SKIPFF
	MOV	DL,12
	MOV	AH,5
	INT	21H			;Restore page
SKIPFF:	MOV	SI,OFFSET LXREF
	MOV	AH,5
SLP:	LODSB
	OR	AL,AL
	JZ	SDNE
	MOV	DL,AL
	INT	21H
	JMP	SLP
SDNE:	INC	PAGNO
	MOV	AL,PAGNO
	AAM
	OR	AX,'00'
	MOV	DL,AH
	MOV	AH,5
	PUSH	AX
	INT	21H
	POP	AX
	MOV	DL,AL
	INT	21H
	CALL	DCRLF
	CALL	DCRLF
	POP	CX
	POP	SI
	RET
DOPAGE	ENDP
;
DCRLF	PROC	NEAR
	PUSH	SI
	PUSH	CX
	MOV	SI,OFFSET CRLF
	MOV	CX,2
	MOV	AH,5
DCLP:	LODSB
	MOV	DL,AL
	INT	21H
	LOOP	DCLP
	INC	LCNT
	POP	CX
	POP	SI
	RET
DCRLF	ENDP
;
CODE	ENDS
;
	END
