 PAGE	81,128
 TITLE	XRDISK	- Output array to disk file
 SUBTTL	V1.0 - May 1986	- Cross	Reference Facility
;
;=============================================================================|
;	     Copyright 1986 - Dan Daetwyler - Springdale, AR 72764	      |
;=============================================================================|
	.SALL
;
DATA	SEGMENT	BYTE PUBLIC 'DATA'
;
	EXTRN	FHAN:WORD,MPUBN:BYTE,MPCNT:WORD,MEXTN:BYTE
;
FLAG	DW	-1
TBLEN	DW	?
;
EMSG	DB	13,10,'Write failure on output file$'
;
DATA	ENDS
;
CODE	SEGMENT	BYTE PUBLIC 'CODE'
	ASSUME	CS:CODE,DS:DATA,ES:DATA
;
;==============================================================================
; Entry	Point	XRDISK							      |
;==============================================================================
;									      |
; This procedure forms the cross ref array into	a disk file.  The array	      |
; format of the	file has a complete table of the public	names associated      |
; with an offset in the	file to	the entries for	that name.  This array is     |
; prefixed by a	word giving the	length of the table (maximum entries=1000).   |
; Its form is name length (byte), name (byte string max	of 12),		      |
; and offset (word).  Following	this entry is the individual entries for      |
; each name.  The individual entries follow the	form: length of	module	      |
; name (byte), module name (byte string),and repetitive	external references   |
; each having the form length of name (byte), name (byte string).  The end    |
; of an	individual entry is flagged by a word of 0FFFFH.		      |
;									      |
; Entry	conventions:	None.						      |
;									      |
; Returns:		None.						      |
;									      |
;==============================================================================
;
	EXTRN	XRSRCH:NEAR
;
	PUBLIC	XRDISK
;
XRDISK	PROC	NEAR
	MOV	SI,OFFSET MPUBN		;  and point to	start of stack
	MOV	AX,MPCNT		;Load count of entries
	ADD	AX,AX
	ADD	AX,AX
	ADD	AX,AX
	ADD	AX,AX			;* 16
	MOV	TBLEN,AX		;Save table length
	MOV	AX,2
	MOV	DX,OFFSET TBLEN
	CALL	WRITE
	MOV	CX,TBLEN
	MOV	DX,OFFSET MPUBN
	MOV	AH,40H
	MOV	BX,FHAN
	INT	21H			;Do dummy write	of table
	MOV	CX,MPCNT
LP:	MOV	BX,WORD	PTR [SI+14]	;Point to module name
	CALL	WHERE			;Get current seek location
	PUSH	AX
	MOV	AL,BYTE	PTR [BX]	;Get name length
	XOR	AH,AH
	MOV	DX,BX
	INC	AX
	CALL	WRITE			;Write public module name
	POP	AX			;Get current seek location
	MOV	WORD PTR [SI+14],AX
	MOV	DI,OFFSET MEXTN
XLP:	CALL	XRSRCH			;Search	for externals
	JC	DONE
	MOV	AL,BYTE	PTR [BX]	;Load length of	extrnal	name
	XOR	AH,AH
	INC	AX
	MOV	DX,BX
	CALL	WRITE
	ADD	DI,15
	JMP	XLP
DONE:	MOV	AX,2
	MOV	DX,OFFSET FLAG
	CALL	WRITE
	ADD	SI,16
	LOOP	LP
	MOV	DX,2
	XOR	CX,CX
	MOV	AX,4200H
	MOV	BX,FHAN
	INT	21H			;Seek to start of file
	MOV	DX,OFFSET MPUBN
	MOV	CX,TBLEN
	MOV	AH,40H
	INT	21H			;Write table to	beginning of file
	MOV	AH,3EH
	INT	21H			;Close file
	RET
XRDISK	ENDP
;
WHERE	PROC	NEAR
	PUSH	DX
	PUSH	CX
	PUSH	BX
	XOR	CX,CX
	MOV	DX,CX
	MOV	BX,FHAN
	MOV	AX,4201H
	INT	21H
	POP	BX
	POP	CX
	POP	DX
	RET
WHERE	ENDP
;
WRITE	PROC	NEAR
	PUSH	CX
	PUSH	BX
	MOV	BX,FHAN
	MOV	CX,AX
	MOV	AH,40H
	INT	21H
	CMP	AX,CX
	JNE	WFAIL
	POP	BX
	POP	CX
	RET
WFAIL:	MOV	DX,OFFSET EMSG
	MOV	AH,9
	INT	21H
	MOV	AX,4C04H
	INT	21H
WRITE	ENDP
;
CODE	ENDS
;
	END
