
 ;==================================================================
 ;
 ;  NETTRAP.ASM     19/6/96 Jerry French  ISS Ltd
 ;
 ;  NETTRAP                               ' Install
 ;  NETTRAP /R                            ' De-Install
 ;  NETTRAP /W [/R]                       ' Override Windows Check
 ;
 ;  Purpose : Fake a Date when read via Int 21h and Scroll Lock is on
 ;            To fool NETSCAPE v2.0B5
 ;
 ;  Method  : Hook Int 21h
 ;            Check for AH = 3Dh
 ;            if not JUMP to old Int 21h  -  Vital as can be exiting to DOS
 ;
 ;            if true then CALL old Int 21h
 ;            fix date on return
 ;
 ;  NOTE    : Int 21h MUST be jumped to - as can be exiting to DOS
 ;
 ;            This only beeps ONCE but always frigs the date
 ;            if the scroll lock is on
 ;
 ;            The first time it finds the date needs frigging
 ;            it makes a beep, afterwards silent until a genuine date
 ;            has been returned
 ;
 ;  USE     : Install BEFORE loading Windows
 ;            turn Scroll Lock on when just before entering NETSCAPE
 ;
 ;  Acknowlegements : Spontaneous Assembler for use of Macros
 ;                    Ray Duncan MSDOS Encyclopedia for TSRs
 ;                    David Jurgens HELPPC for general reference tool
 ;                    Undocumented DOS for Windows info
 ;
 ;  Idealy the TSR would detect NETSCAPE from the enviroment, which can
 ;  be located from the PSP.  Windows retains the PSP but unfortunately
 ;  the enviroment segment at PSP:002C does not point to the enviroment
 ;  hence the Scroll Lock cludge.

 ;  To Compile :  MASM nettrap;
 ;                LINK nettrap;                 (ignore stack warning)
 ;                EXE2BIN nettrap nettrap.com


 ; ===================={ start of macros }==========================

.push           macro   r0,r1,r2,r3,r4,r5,r6,r7,r8,r9
  irp $reg,<r0,r1,r2,r3,r4,r5,r6,r7,r8,r9>
    IFNB <$reg>
         push    $reg
    ENDIF
  endm
endm


.pop            macro   r0,r1,r2,r3,r4,r5,r6,r7,r8,r9
  irp $reg,<r9,r8,r7,r6,r5,r4,r3,r2,r1,r0>
    IFNB <$reg>
         pop     $reg
    ENDIF
  endm
endm




.msg           MACRO   Msg
               LOCAL   Lab1, Lab2

               jmp     Lab2

Lab1           db      Msg, 13, 10, '$'
Lab2:
               push    DX
               lea     DX, Lab1
               call    PrintLine
               pop     DX
endm

 ; ====================={ End of macros }===========================

FakeYear      equ  1996
FakeMonth     equ  01
FakeDay       equ  07

Version       equ  'v1.09'
TsrName       equ  'NETTRAP'

CODE          SEGMENT PARA PUBLIC 'CODE'
              ASSUME CS:CODE
              ORG 100h

interrupt     equ    21h
UCASE         equ    11011111b


Header        equ    $
BEGIN:        jmp    INSTALL

Old_Int       LABEL  DWORD
Hold_Int      dw     2 dup (?)


CommandLen    dw     0

cmd_tail      equ    82h     ;first character
tail_cnt      equ    80h     ;tail count


InIntFlag     dw     0

BeepDoneFlag  db     0
FakeFlag      db     0

Marker        db     'ISS Ltd NETTRAP JF 19/6/96'
Marker_len    equ    $ - Marker


New_Int       PROC   NEAR

              ; --------{ entry point for new int }---------

              cli
              pushf                             ; save flags for next int
              cmp    AH, 2Ah                    ; is it Get Date
              je     NewGetDate                 ; yes so divert


              popf                              ; not our call
              jmp    Old_Int                    ; so jump into the old int


NewGetDate:

              call   Old_Int                    ; quickly do rest of int
              pushf                             ; store flags

              cmp    CS:InIntFlag, 0            ; are we already in this int
              jne    QUIT

              inc    CS:InIntFlag


              ; --- so they just went in and got the date
              ;     AL is Day of week (0=Sunday)
              ;     CX is year (1980-2099)
              ;     DH is month (1-2)
              ;     DL is day (1-31)


              .push  DS, SI, ES, DI, AX, BX, CX, DX

              mov    CS:FakeFlag, 0

              mov    AX, 40h                    
              mov    ES, AX

              mov    DI, 17h
              mov    AL, ES:[DI]                ; pick up keyboard flags

              test   AL, 16                     ; check for scroll lock
              jnz    LockIsOn

                                                ; so the lock is off
              mov    CS:BeepDoneFlag, 0         ; reset the beep flag
              jmp    QuitTests                  ; and get out

              ;
              ; --- scroll lock is on
              ;

LockIsOn:
              mov    CS:FakeFlag, 1

              cmp    CS:BeepDoneFlag, 1         ; do we beep
              je     @F

              mov    AH, 0Fh
              int    10h                        ; display page in BH

              mov    AH, 0Eh                    ; AH = INT 10H function number
              mov    AL, 7                      ; AL = 07H (bell character)
              int    10h                        ; emit a beep
                                                ; BL should really have colour
              mov    CS:BeepDoneFlag, 1
@@:

QuitTests:
              .pop   DS, SI, ES, DI, AX, BX, CX, DX

FakeIt:
              cmp    CS:FakeFlag, 1
              jne    DONE

              mov    CX, FakeYear               ; <--- this is the new year
              mov    DH, FakeMonth
              mov    DL, FakeDay

              ; ------------------------------------------

DONE:
              dec    CS:InIntFlag
QUIT:         
              popf                              ; restore flags
              RETF   2                          ; lose first inbound flags

New_Int       ENDP



EndMark       db     'END OF RESIDENT CODE'     ; useful for debugging

Code_Len      dw     ( ($-Header)/16 ) + (100h/16) + 2


 ;=========================================================================
 ;                        INSTALLATION
 ;
 ;                 NON RESIDENT SECTION FOLLOWS
 ;
 ;          GENERIC TSR INSTALLATION / REMOVAL ROUTINE
 ;
 ;=========================================================================


INSTALL       PROC   NEAR
              ASSUME DS:CODE,ES:CODE


Install_It:   mov    AX, CS
              mov    DS, AX
              mov    ES, AX
              CLD

              ; --- set up default flags - just as a reminder

              mov    RemoveFlag, 0
              mov    AlreadyInstalledFlag, 0
              mov    WinIgnoreFlag, 0

              ; --- Re-format the command line

              call   StripCommandLine

              ; --- now check for length of command line

              cmp    CommandLen, 0
              jne    @F
              
              jmp    COMMAND_LINE_DONE

@@:

              ; --- Check for /R in Command Line

              mov    DI, Cmd_Tail
              mov    CX, CommandLen

              mov    AL, '/'
@@:           repne  SCASB
              jne    @F
              cmp    BYTE PTR ES:[DI], 'R'
              jne    @B
              mov    RemoveFlag, 1
@@:

              ; --- Check for /W in Command Line

              mov    DI, Cmd_Tail
              mov    CX, CommandLen

              mov    AL, '/'
@@:           repne  SCASB
              jne    @F
              cmp    BYTE PTR ES:[DI], 'W'
              jne    @B
              mov    WinIgnoreFlag, 1
@@:


              ; --- Other Command line checks can go above here


COMMAND_LINE_DONE:

              ;
              ; --- check if the TSR is already installed
              ;

              mov    AH, 35h                     ; get the existing vector
              mov    AL, interrupt               ; old int location
              int    21h

              mov    Hold_Int, BX                ; store it regardless
              mov    Hold_Int[2], ES

                                                 ; ES has seg of code
              mov    SI, OFFSET Marker
              mov    DI, SI
              mov    CX, Marker_Len
              repe   cmpsb                       ; compare markers
              jne    @F                          ; out if not there

              mov    AlreadyInstalledFlag, 1     ; so it is installed
@@:
                                                 ; ES is now Resident Seg
              ;
              ; --- Check for Windows
              ;

              call   WinCheck
              jc     @F
              jmp    WIN_DONE
@@:

              .msg   < TsrName, ' - Windows or Task Switcher Found' >

              cmp    WinIgnoreFlag, 0
              jne    @F

              .msg   'this will not continue - use /W to Override'
              jmp    EXIT_NO_TSR

@@:
              .msg   < '/W switch set - This is a very bad idea !!', 13,10 >

WIN_DONE:

              ;
              ; --- DECISION TABLE
              ;     so now decide what to do
              ;


              cmp    AlreadyInstalledFlag, 0
              je     NO_TSR_TABLE

              ;
              ; --- here we already have a TSR installed
              ;
              ;     ES: has segment of installed TSR

              cmp    RemoveFlag, 1
              jne    @F
              jmp    REMOVE_TSR
@@:

              ; --- the TSR is already resident


              .msg   < TsrName, ' Date Trap already installed' >
              .msg   'use:  /R to Remove'

              jmp    EXIT_NO_TSR

              ; =========================================
              ;
              ; --- here the TSR is not already installed
              ;
              ;

NO_TSR_TABLE:

              cmp    RemoveFlag, 1
              jne    @F

              .msg   ' Date Trap NOT present - Cannot Remove'
              jmp    EXIT_NO_TSR

@@:
              jmp    INSTALL_NOW


              ; =========================================
              ;
              ; --- Remove the TSR
              ;

REMOVE_TSR:
              push   DS
              lds    DX, ES:Old_Int              ; grab old int data DS:DX
              mov    AH, 25h
              mov    AL, interrupt               ; and restore interrupt
              int    21h
              pop    DS

              mov    AH, 49h                     ; deallocate program
              int    21h
              jc     ER_MSG

              mov    ES, ES:[44]                 ; deallocate enviroment
              mov    AH, 49h                     ; deallocate program
              int    21h
              jc     ER_MSG

              .msg   < TsrName, ' Netscape Trap REMOVED' >

              jmp    EXIT_NO_TSR

ER_MSG:       .msg   'memory deallocation problem'

EXIT_NO_TSR:  mov    AH, 4Ch                     ; ===== EXIT to DOS ===>
              int    21h

              ; =========================================
              ;
              ; --- install the TSR Now

INSTALL_NOW:  
              push   DS                          ; ES is not yet local
              pop    ES


              ; --- now install the new interrupt handler

              mov    AH, 25h                     ; point to new int routine
              mov    AL, interrupt               ;
              lea    DX, New_Int
              int    21h


              .msg   < TsrName, ' - ISS Ltd (c) 1996 - ', Version >
              .msg   'Netscape Date Trap Installed'
              .msg   'Date frigged if Scroll Lock is ON'



              ; --- now exit - go TSR

              mov    DX, CS:Code_Len

              mov    AH, 31h
              mov    AL, 0                       ; return error code
              int    21h                         ; === Go TSR ===>


INSTALL       ENDP

              ; ------------------------------------------
              ; Non Resident Utility to Print data pointed to by DX

PrintLine     PROC   NEAR

              push   AX
              mov    AH, 9
              int    21h
              pop    AX

              ret

PrintLine     ENDP

              ; ------------------------------------------
              ; strip ' ' from the command line
              ; replace terminating 13 with 0
              ; store length in CommandLen

StripCommandLine     PROC   NEAR

              mov    SI, Cmd_Tail
              mov    DI, SI
              mov    CX, 0
              mov    CL, [SI-2]                  ; take the length from DOS

              mov    BX, 0                       ; we build length in BX
              jcxz   STRIP_DONE

STRIP_01:     lodsb                              ; strip ' '
                                                 ; ' / r' becomes '/R'
              cmp    AL, ' '
              je     STRIP_02

              call   UCaseAL
              stosb
              inc    BX

STRIP_02:     loop   STRIP_01

              mov    AL, 0
              mov    [DI-1], AL                  ; put ASCIIZ terminator

              cmp    BX, 1                       ; just a trailing <CR>
              ja     @F
              mov    BX, 0
@@:

STRIP_DONE:
              mov    CommandLen, BX

              ret

StripCommandLine     ENDP

              ; ------------------------------------------
              ; Non Resident Utility to Upper Case AL

UCaseAL       PROC   NEAR

              cmp    AL, 'z'
              ja     @F
              cmp    AL, 'a'
              jb     @F

              and    AL, UCase
@@:
              ret

UCaseAL       ENDP

              ; ------------------------------------------
              ; Check for Windows Running
              ; Carry Flag set if Windows is running

WinCheck      PROC   NEAR

              .push  DS, SI, ES, DI, AX, BX, CX, DX

              ; --- First check if 2F is uninstalled

              mov    AH, 35h                     ; get 2F vector in ES:BX
              mov    AL, 2Fh                     ; old int location
              int    21h
              cmp    BX, 0
              jne    @F
              mov    BX, ES
              cmp    BX, 0
              je     WC_NoWin                    ; no 2F so assume Ok
@@:

              ; --- Check if Windows 3.1+ running

              mov    AX, 160Ah
              int    2Fh
              cmp    AX, 0                       ; AX = 0 if found
              je     WC_WinFound

              ; --- Check if Windows Enhanced mode running

              mov    AX, 1600h
              int    2Fh
              cmp    AL, 80h                     ; Obsolete XMS sign found
              jne    @F
              cmp    AL, 0                       ; AL <> 0 if Win found
              jne    WC_WinFound
@@:

              ; --- Check if DOSSHELL type task switcher is present

              mov    AX, 4680h
              int    2Fh
              cmp    AX, 0                       ; AX = 0 if Win Found
              je     WC_WinFound

              ; --- so we fall through
WC_NoWin:     CLC
              jmp    WC_Quit

WC_WinFound:  STC

WC_Quit:
              .pop   DS, SI, ES, DI, AX, BX, CX, DX
              ret

WinCheck      ENDP


              ; ------------------------------------------
              ; Non Resident data


RemoveFlag            db  0
AlreadyInstalledFlag  db  0
WinIgnoreFlag         db  0


CODE          ENDS
              END    BEGIN

