	Title NETRCV - Receives messages from NETSEND

;	Usage:
;
;	NETRCV FRED
;	NETRCV ADMIN*
;	NETRCV *
;
;	You may choose to receive only messages destined for you,
;	messages destined to anyone in a group, or all messages
;	sent on the network.  Actually this program receives all
;	messages and then pattern matches to see if it should
;	display the message or not.
;
;	NETSEND HOTLIPS Dinner at my place at 8:00
;
;	The receiver hear a beep on the speaker and would see
;
;	;; [3624361805] - HOTLIPS Dinner at my place at 8:00
;
;	The number in "[]" is the node address from the adapter that
;	sent the message.
;
;
;	Author: Jack Schoof, President, ARTISOFT, Inc. Tucson, AZ
;

	ASSUME CS:MAIN_CODE,DS:MAIN_DATA

FCB1	EQU 5DH 			;WHERE THE FCB IS STORED IN THE PSP

;
;	NCB DEFINITION
;
NCBDEF	STRUC				;PRE FILLED WITH ALL ZEROES
NCB_COMMAND	DB 0
NCB_RETCODE	DB 0
NCB_LSN 	DB 0
NCB_NUM 	DB 0
NCB_BUFFER	DD 0			;POINTER TO MESSAGE BUFFER
NCB_LENGTH	DW 0			;NUMBER OF BYTES IN BUFFER
NCB_CALLNAME	DB 16 DUP (0)
NCB_NAME	DB 16 DUP (0)
NCB_RTO 	DB 0
NCB_STO 	DB 0
NCB_POST	DD 0			;POINTER TO POST ADDRESS
NCB_LANA_NUM	DB 0
NCB_CMD_CPLT	DB 0
NCB_RESERVED	DB 14 DUP (0)		;RESERVED
NCBDEF	ENDS

;
;	NCB COMMANDS
;
NO_WAIT 		EQU 80H
NCB_ADD_GROUP_NAME	EQU 36H
NCB_RECEIVE_DATAGRAM	EQU 21H

SOM	SEGMENT 'SOM'
START_OF_MEMORY EQU THIS DWORD
SOM	ENDS

MAIN_DATA	SEGMENT PUBLIC 'DATA'

MATCH_NAME	DB 8 DUP (?)
RCV_BUFFER	DB 128 DUP (?)

ERROR		DB 7,'NETBIOS ERROR: '
SIZE_ERROR	EQU $-ERROR

DTA_PSP 	DW 0

SEGEOM		DW SEG END_OF_MEMORY	;BECAUSE OF BUG IN MASM 5.1 (SEE LATER)

RNCB		NCBDEF <>			;DEFINE NCB

	ORG RNCB.NCB_NAME		;GROUP NAME TO ADD
	DB 'NETSEND_GROUP',0,0,10	;10 AT THE END TO NOT NAME CONFLICT
	ORG RNCB+SIZE NCBDEF		;WITH NETWORK OPERATING SYSTEMS

MAIN_DATA	ENDS

MAIN_CODE	SEGMENT PUBLIC 'CODE'

BEGIN:	PUSH ES
	POP DS				;DS = PSP LOCATION
	MOV AX,SEG MAIN_DATA
	MOV ES,AX			;ES = SEG MAIN_DATA
	MOV ES:DTA_PSP,DS		;SAVE THE PSP
	MOV SI,FCB1			;POINT TO FILE1 IN THE PSP
	MOV DI,OFFSET MATCH_NAME	;AND TO OUR INTERNAL MATCH NAME
	MOV CX,8			;8 CHARACTERS MAX
	REP MOVSB			;MOVE DS:SI TO ES:DI 8 BYTES
	PUSH ES
	POP DS				;NOW DS = MAIN_DATA

	MOV RNCB.NCB_COMMAND,NCB_ADD_GROUP_NAME
	MOV BX,OFFSET RNCB		;ES:BX = RNCB
	INT 5CH 			;ADD THE GROUP NAME NOW
	TEST AL,AL			;ANY PROBLEMS WITH THE GROUP?
	JNZ COMPLAIN			;COMPLAIN TO THE USER

	CALL SETUP_RECEIVE		;GET A RECEIVE READY FOR ANY MESSAGES
	TEST AL,AL			;ERRORS ON THE RECEIVE?
	JZ TSR_NOW			;NO THEN TERMINATE AND STAY RESIDENT

COMPLAIN:
	MOV DX,OFFSET ERROR		;POINT TO ERROR TEXT TO SAY
	MOV AH,40H			;WRITE TO FILE COMMAND
	MOV BX,2			;STANDARD ERROR HANDLE
	MOV CX,SIZE_ERROR		;GET SIZE OF TEXT
	INT 21H 			;COMPLAIN ABOUT THE ERROR
	MOV AL,RNCB.NCB_CMD_CPLT	;GET THE ERROR NUMBER
	CALL HEX2			;DISPLAY IT
	CALL CRLF			;AND A NEWLINE
	MOV AL,RNCB.NCB_CMD_CPLT
	MOV AH,4CH			;EXIT CODE IS NETBIOS ERROR NUMBER
	INT 21H 			;SO A BATCH FILE CAN TEST FOR PROBS

ENVADDR EQU 44

TSR_NOW:
	MOV ES,DTA_PSP			;GET PSP ADDRESS
	MOV ES,ES:ENVADDR		;GET ENVIRONMENT ADDRESS
	MOV AH,49H			;FREE ENVIRONMENT MEMORY
	INT 21H 			;SAVES SOME SPACE

	MOV AX,3100H			;TSR SYSTEM CALL
;	MOV DX,SEG END_OF_MEMORY	;TAKE THE END OF MEMORY
;	   * CANT DO ABOVE BECAUSE OF BUG IN MASM 5.1 SO MUST DO NEXT LINE *
	MOV DX,SEGEOM			;GET THE SEGMENT OF EOM
	SUB DX,SEG START_OF_MEMORY
	ADD DX,11H			;ADD 11H FOR PSP
	MOV ES,DTA_PSP
	INT 21H 			;TERMINATE AND STAY RESIDENT

;
;	THIS BEGINS THE TSR PART OF THE CODE
;
;	RCV_MESSAGE IS THE POST ADDRESS FOR THE RECEIVE DATAGRAM
;	ALL RECEIVE DATAGRAMS SENT TO THE GROUP NAME NETSEND_GROUP
;	WILL POST HERE.
;
RCV_MESSAGE:
	PUSH AX 			;SAVE ALL THE REGISTERS
	PUSH BX 			;JUST TO BE SURE
	PUSH CX 			;IBM SAYS THAT THEY SHOULD BE
	PUSH DX 			;SAVED BY THE NETBIOS, BUT
	PUSH SI 			;ALL OF THEM DO NOT
	PUSH DI
	PUSH ES
	PUSH DS
	STI				;TURN INTERRUPTS BACK ON
	MOV AX,SEG MAIN_DATA
	MOV DS,AX			;POINT TO OUR DATA
	MOV CX,RNCB.NCB_LENGTH		;GET THE LENGTH OF THE RECEIVE
	MOV SI,OFFSET RCV_BUFFER	;POINT TO THE RECEIVE BUFFER
	MOV DI,OFFSET MATCH_NAME	;AND THE MATCH NAME
NXTCHR: LODSB				;GET DS:SI INTO AL
	CMP AL,'*'			;HAVE WE HIT A STAR?
	JZ MATCHED			;YES THEN WE MATCHED
	MOV AH,[DI]			;NO THEN CHECK OUR INTERNAL NAME
	CMP AH,'?'			;A QUESTION MARK ON THE RECEIVER?
	JZ MATCHED			;DOS CHANGES * TO QUESTION MARKS IN FCB
	CMP AL,'a'			;CONVERT TO LOWER CASE
	JC NOTLC			;LESS THAN AN 'a'
	CMP AL,'z'+1
	JNC NOTLC			;GREATER THAN A 'z'
	SUB AL,'a'-'A'			;SUBTRACT THE RIGHT AMOUNT TO MAKE UC
NOTLC:	CMP AH,AL			;ARE THEY NOW BOTH THE SAME?
	JNZ REJECT			;NO THEN REJECT THE RECEIVE
	CMP AL,' '			;IF THEY ARE BOTH SPACES THEN WE
	JZ MATCHED			;MATCHED
	INC DI				;UPDATE THE DI POINTER
	LOOP NXTCHR			;AND KEEP GOING
MATCHED:
	CALL CRLF
	MOV AL,';'
	CALL OUTCH
	CALL OUTCH
	MOV AL,' '
	CALL OUTCH
	MOV AL,'['			;DISPLAY THE ";; ["
	CALL OUTCH
	MOV SI,OFFSET RNCB.NCB_CALLNAME+10 ;POINT TO WHO SENT THE MESSAGE
	MOV CX,6			;6 END DIGITS ARE ADAPTER ADDRESS
ADPTD:	LODSB
	PUSH CX
	CALL HEX2			;DISPLAY THE DIGITS
	POP CX
	LOOP ADPTD			;UNTIL ALL DONE
	MOV AL,']'
	CALL OUTCH
	MOV AL,' '
	CALL OUTCH
	MOV AL,'-'
	CALL OUTCH
	MOV AL,' '
	CALL OUTCH			;DISPLAY THE "] - "

	MOV SI,OFFSET RCV_BUFFER	;POINT TO THE RECEIVE BUFFER AGAIN
	MOV CX,RNCB.NCB_LENGTH		;AND THE LENGTH AGAIN
CHLOOP: LODSB				;GET THE CHARACTER
	CALL OUTCH
	LOOP CHLOOP			;OUT THE CHARACTERS GO
	CALL CRLF			;NEWLINE
	MOV AL,7			;BELL CHARACTER
	CALL OUTCH			;BEEP AT END OF LINE
REJECT: CALL SETUP_RECEIVE		;START A RECEIVE FOR NEXT TIME
	POP DS
	POP ES
	POP DI
	POP SI
	POP DX
	POP CX
	POP BX
	POP AX				;RESTORE THE WORLD
	IRET				;AND RETURN FROM THE POST

CRLF:	MOV AL,0DH
	CALL OUTCH
	MOV AL,0AH
OUTCH:	MOV AH,0EH
	XOR BX,BX
	INT 10H 			;DISPLAY CHARACTER
	RET

SETUP_RECEIVE:
	MOV RNCB.NCB_LENGTH,128 	;WE CAN RECEIVE UP TO 128 BYTES
	MOV WORD PTR RNCB.NCB_BUFFER,OFFSET RCV_BUFFER
	MOV WORD PTR RNCB.NCB_BUFFER+2,ES
	MOV WORD PTR RNCB.NCB_POST,OFFSET RCV_MESSAGE
	MOV WORD PTR RNCB.NCB_POST+2,CS
	MOV RNCB.NCB_COMMAND,NO_WAIT+NCB_RECEIVE_DATAGRAM
	MOV BX,OFFSET RNCB
	INT 5CH 			;SETUP THE RECEIVE
	RET				;AND RETURN

HEX2:	MOV BL,AL
	MOV CL,4
	ROL BL,CL			;ROTATE TO GET THE TOP DIGIT
	CALL HEXDIG			;DISPLAY THE FIRST DIGIT
	MOV CL,4
	ROL BL,CL			;THEN FALL INTO HEXDIG FOR LAST ONE
HEXDIG: MOV AL,BL			;HEX CHARACTER IN BL
	AND AL,0FH			;MASK OFF BOTTOM NIBBLE
	ADD AL,'0'			;ADD ASCII OFFSET
	CMP AL,'9'			;ABOVE 9?
	JLE PRINT_CHAR
	ADD AL,'A'-'9'-1		;THEN ADD CORRECT AMOUNT TO GET A-F
PRINT_CHAR:
	PUSH BX
	CALL OUTCH
	POP BX
	RET

MAIN_CODE	ENDS

EOM	SEGMENT 'EOM'
END_OF_MEMORY	EQU THIS DWORD
EOM	ENDS

MAIN_STACK	SEGMENT STACK
	DW 100H DUP (?)
MAIN_STACK	ENDS

	END BEGIN
