;************************* EQUATES **************************
sc	=	2	;these are values to
rl	=	3	;initialize
mode	=	3	;the timer chip
bcd	=	0
cnword	=	sc*40h + rl*10h +mode*2 + bcd
on	=	1
off	=	0
s_port	=	3fch	;this is the address of modem control port
rt	=	4dh	;the following are self explanitory
lft	=	4bh
up	=	48h
dn	=	50h
cr	=	0dh
tab	=	09h
bs	=	08h
esc	=	1bh
pgup	=	49h
pgdn	=	51h
del	=	53h
codes	segment para 'code'
assume cs:codes,ds:codes,es:codes
	org	100h
start:	jmp	begin
factor	db	0ffh	;00  for 4.77 machines or ff for fast machines
time	dw	3000h	;these are the initial constants for timing
s_time	dw	3000h	;This one is for space timing
			;At slower speeds spaces are increased more
			;to leave characters sounding normal.
wt_val	dw	3	;Initial normal weight value 3 x dit length
;
abort	dw	?	;This is for bail out of deep nest.
sound	db	on
key	db	off	;flag for keying feature
;
row	db	13
col	db	10
temp	db	?
corner	dw	0
buff	db	3000 dup(?)

cd_key	record	hi:8,lo:4	;8 hi bits for code, lo 4 for number
				;of elements.
;
;	THIS IS A TABLE FOR NUMBERS AND LETTERS
;
table	cd_key	<11111b,5>	;	0
	cd_key	<11110b,5>	;	1
	cd_key	<11100b,5>	;	2
	cd_key	<11000b,5>	;	3
	cd_key	<10000b,5>	;	4
	cd_key	<00000b,5>	;	5
	cd_key	<00001b,5>	;	6
	cd_key	<00011b,5>	;	7
	cd_key	<00111b,5>	;	8
	cd_key	<01111b,5>	;	9
	cd_key	<00010b,2>	;	A
	cd_key	<00001b,4>	;	B
	cd_key	<00101b,4>	;	C
	cd_key	<00001b,3>	;	D
	cd_key	<00000b,1>	;	E
	cd_key	<4,4>	;	F
	cd_key	<3,3>	;	G
	cd_key	<0,4>	;	H
	cd_key	<0,2>	;	I
	cd_key	<14,4>	;	J
	cd_key	<5,3>	;	K
	cd_key	<2,4>	;	L
	cd_key	<3,2>	;	M
	cd_key	<1,2>	;	N
	cd_key	<7,3>	;	O	
	cd_key	<6,4>	;	P
	cd_key	<11,4>	;	Q
	cd_key	<2,3>	;	R
	cd_key	<0,3>	;	S
	cd_key	<1,1>	;	T
	cd_key	<4,3>	;	U
	cd_key	<8,4>	;	V
	cd_key	<6,3>	;	W
	cd_key	<9,4>	;	X
	cd_key	<13,4>	;	Y
	cd_key	<3,4>	;	Z
	cd_key	<12,6>	;	?
	cd_key	<51,6>	;	,
	cd_key	<42,6>	;	.
	cd_key	<9,5>	;	/
	cd_key	<0,8>	;	*	(used for mistake)
	cd_key	<40,6>	;	;	(used for sk)

;
;	END OF TABLE
;
mess1	db	'WB8BIL CODE GENERATOR','$'
mess2	db	'Written by:','$'
mess3	db	'Gregg C.Anderson','$'
mess4	db	'247 Hill St.','$'
mess5	db	'Ishpeming, Mi. 49849','$'
mess6	db	'Copyright (c) 1985, Gregg Anderson, All rights reserved.','$'
choice1	db	'1 - SET SPEED','$'
choice2	db	'2 - SET WEIGHT','$'
choice3	db	'3 - START','$'
choice4	db	'4 - BUFFER FUNCTIONS','$'
choice5	db	'5 - KEY OUTPUT','$'
choice6	db	'6 - SCRATCH PAD','$'
choice7	db	'7 - QUIT','$'
wt_mess	db	'1 - NORMAL     2 - HEAVY','$'
s_mess1	db	'SELECT THE DESIRED SPEED','$'

s_mess2		db	'1 - SLOWEST','$'
s_mess3		db	'2','$'
s_mess4		db	'3 - SLOW','$'
s_mess5		db	'4','$'
s_mess6		db	'5 - MEDIUM','$'
s_mess7		db	'6','$'
s_mess8		db	'7 - FAST','$'
s_mess9		db	'8','$'
s_mess10	db	'9 - FASTEST','$'

k_mess1		db	'KEY OUTPUT MENU','$'
k_mess2		db	'1 - KEY WITH SOUND','$'
k_mess3		db	'2 - KEY WITHOUT SOUND','$'
k_mess4		db	'3 - SOUND WITHOUT KEYING','$'
b_mess1	db	'BUFFERED OPERATIONS MENU','$'
b_mess2	db	'1 - LOAD A BUFFER','$'
b_mess3	db	'2 - SEND A BUFFER','$'
b_mess4 db	'3 - LOAD BUFFERS FROM DISK','$'
b_mess5	db	'4 - SAVE BUFFERS ON DISK','$'
b_mess9	db	'5 - PRACTICE ASCII FILE','$'
b_mess6	db	'6 - RETURN TO MAIN MENU','$'
b_mess7 db	'Choose A Buffer F-1 to F-10','$'
b_mess8	db	'Enter Desired Text (End With A Carriage Return)','$'
esc1	db	'Esc for Menu$'
;
buffer	struc			;structure to allocate buffers
max	db	0feh		;max of 254 characters
act	db	?		;actual number gets placed here
msg	db	0feh dup(0dh)	;this is the space for characters
buffer	ends
;
one	buffer	<,,>	;first of 10 buffers
two	buffer	<,,>	
three	buffer	<,,>	
four	buffer	<,,>	
five	buffer	<,,>	
six	buffer	<,,>	
seven	buffer	<,,>	
eight	buffer	<,,>	
nine	buffer	<,,>	
ten	buffer	<,,>	
	db	1ah
;
fcb	db	00		;The following sets up fcb for reading 
fname	db	'codebuff'	;and writing the buffer file.
ext	db	'dat'
block	dw	0000
	dw	?
	dd	?
	dw	?
	db	10 dup(?)
rec_num	db	00
	dw	2 dup($)
dta	db	80h dup(?)

cur_rec	db	00
w_top	db	201		;following sets up the graphics for windows
	db	65 dup(205)
	db	187,'$'
w_sides	db	186
w_bottom	db	200
		db	65 dup(205)
		db	188,'$'
;
box_top		db	201
		db	31 dup(205)
		db	187,'$'
box_sides	db	186
		db	31 dup(32)
		db	186,'$'
box_bottom	db	200
		db	31 dup(205)
		db	188,'$'
in_ptr		dw	?
out_ptr		dw	?
big_buf		dw	256 dup(?)	;Buffer for type ahead
pract_num	dw	1 dup(?)
pname	db	'Enter file path\name: ','$'
pname2	db	50
pn_len	db	?
pr_n		db	51 dup(?)
handle	dw	1 dup(?)
o_err	db	'Cannot open the file','$'
r_err	db	'Read failed','$'
fail		db	?
;------------------------------------------------------------
begin	proc	near
	mov	ax,sp
	mov	abort,ax	;set the bailout for stack pointer.
	cmp	factor,00	;check for fast machine
	je	over2
	mov	ax,time
	shl	ax,1
	mov	time,ax
	mov	ax,s_time
	shl	ax,1
	mov	s_time,ax
over2:	call	cls
;
	call	boxit
	call	set_dta	
over:	
	call	cls_b
	mov	in_ptr,0
	mov	out_ptr,0
	call	menu
	call	t_init
	call	t_set
	call	cls_b
;
;the following sets the "esc for menu" mess in reverse video.
;
	call	esd
;
	mov	ah,02	;set cursor
	mov	bh,00	;page 0
	mov	dh,13	;row 13
	mov	dl,00	;column 0
	int	10h

;
;	HERE BEGINS THE ACTUAL CONVERSION FROM ASCII
;
getkey:
	mov	ah,1
	int	16h
	jz	no_hit
	mov	ah,0
	int	16h
	cmp	al,esc
	je	over
	cmp	al,bs	;This is test
	jne	not_bk	;This is test
	mov	bx,out_ptr
	cmp	bx,in_ptr
	je	getkey
	dec	in_ptr	;This is test
	dec	in_ptr	;This is test
	jmp	getkey	;This is test
not_bk:
	mov	bx,in_ptr
	mov	big_buf[bx],ax
	inc	bx
	inc	bx
	cmp	bx,512
	jle	not_full
	mov	ax,0
not_full:
	mov	in_ptr,bx
no_hit:	mov	bx,out_ptr
	cmp	bx,in_ptr
	je	getkey
	mov	ax,big_buf[bx]
	inc	bx
	inc	bx
	cmp	bx,512
	jle	not_full2
	mov	bx,0
not_full2:
	mov	out_ptr,bx
	cmp	ah,3bh
	jl	not_f
	cmp	ah,44h
	jg	not_f
	call	b_line
	jmp	getkey
not_f:
	call	putchar
	call	screen	;no - call routine to check for valid character.
	jmp	getkey	;do it again
a_done:	call	cls
	ret
begin	endp
;------------------------------------------------------------
t_init	proc
	mov	al,cnword	;initialize timer chip
	out	43h,al
	ret
t_init	endp
;------------------------------------------------------------
esd	proc
	mov	ax,0600h	;scroll
	mov	bh,70h		;reverse attribute
	mov	cx,0b21h	;row 11,column 33
	mov	dx,0b2eh	;to row 11,column 46
	int	10h
;
	mov	ah,02	;set cursor
	mov	bh,00	;page 0
	mov	dh,11	;row 11
	mov	dl,34	;column 0
	int	10h
;
	
	lea	dx,esc1	;Esc to get menu
	mov	ah,09
	int	21h
	ret
esd	endp
;------------------------------------------------------------
t_set	proc
	mov	ax,1300		;set tone to approx 1000hz
	out	42h,al
	mov	al,ah
	out	42h,al
	ret
t_set	endp
;------------------------------------------------------------
dit	proc		;dit procedure
	push	dx
	push	cx
	push	bx
	push	ax
	mov	cx,time	;number of loops for sound on
	call	make	;routine to turn on sound
dit_ct:
	loop	dit_ct
	call	unmake	;routine to turn off sound
	call	build
	mov	cx,time	;number of loops for space between dits
spc_ct:
	loop	spc_ct
	pop	ax
	pop	bx
	pop	cx
	pop	dx
	ret
dit	endp
;------------------------------------------------------------
dah	proc
	push	dx
	push	cx
	push	bx
	push	ax
	mov	cx,wt_val	;set the length of dah's
				;wt_val * length of dit
next:
	push	cx
	mov	cx,time		;length of dit
	call	make
dah_ct:
	loop	dah_ct
	pop	cx
	dec	cx
	jnz	next
	call	unmake
	call	build
	mov	cx,time	;time for space between dah and next element
spc:	
	loop	spc
	pop	ax
	pop	bx
	pop	cx
	pop	dx
	ret
dah	endp
;------------------------------------------------------------
serial	dw	0ffffh	;This was spot for serial no. when prog was to be sold
;------------------------------------------------------------
make	proc
	cmp	sound,on
	jne	make2
	call	snd_on
make2:	cmp	key,on
	jne	make3
	call	key_on
make3:	ret
make	endp
;------------------------------------------------------------
unmake	proc
	cmp	sound,on
	jne	unmak2
	call	snd_off
unmak2:	cmp	key,on
	jne	unmak3
	call	key_off
unmak3:	ret
unmake	endp
;------------------------------------------------------------
snd_on	proc		;procedure to turn on the sound
	in	al,61h
	or	al,3
	out	61h,al
	ret
snd_on	endp
;------------------------------------------------------------
snd_off	proc		;procedure to turn off the sound
	in	al,61h
	and	al,0fch
	out	61h,al
	ret
snd_off	endp
;------------------------------------------------------------
key_on	proc		;procedure to turn on the DTR
	push	dx
	mov	dx,s_port	;load dx with adr of modem cntrl port
	in	al,dx
	or	al,01h		;turn on the least bit
	out	dx,al
	pop	dx
	ret
key_on	endp
;------------------------------------------------------------
key_off	proc		;procedure to turn off the DTR
	push	dx
	mov	dx,s_port
	in	al,dx
	and	al,0feh		;turn off the first bit
	out	dx,al
	pop	dx
	ret
key_off	endp
;------------------------------------------------------------
space	proc		;this is the procedure for spacing
			;between characters. 
	push	cx
	mov	cx,4
do:
	push	cx
	mov	cx,s_time	;basic space timing element
				;note that s_time is greater than
				;time at low speeds to keep char
				;sounding normal.
down:
	loop	down
	pop	cx
	dec	cx
	jnz	do
	pop	cx
	ret
space	endp
;------------------------------------------------------------
screen 	proc		;routine to check for valid input
	cmp	al,'?'
	je	huh
	cmp	al,','
	je	comma
	cmp	al,'.'
	je	period
	cmp	al,'/'
	je	slash
	cmp	al,' '
	je	space2
	cmp	al,'*'	;* is char used for 8 dits for mistake.
	je	oops
	cmp	al,';'
	je	sk
	cmp 	al,48	;is it less than a zero?
	jl	bad
	cmp	al,57	;is it less than or equal to a 9?
	jle	number
	cmp	al,65	;is it less than a upper case A?
	jl	bad
	cmp	al,90	;is it less or equal to Z?
	jle	alpha
	cmp	al,97	;is it less than a lower case a?
	jl	bad
	cmp	al,122	;is it less or equal to z?
	jle	lwr_al
	jmp	bad
huh:	mov	bx,72
	call	decode	;call to decode a valid character
	jmp	bad
comma:	mov	bx,74
	call	decode
	jmp	bad
period:	mov	bx,76
	call	decode
	jmp	bad
slash:	mov	bx,78
	call	decode
	jmp	bad
oops:	mov	bx,80
	call	decode
	jmp	bad
sk:	mov	bx,82
	call	decode
	jmp	bad
number:	sub	al,30h	;convert number to relative position in table.
	mov	ah,0
	shl	ax,1	;multiply by 2 to get word position
	mov	bx,ax
	call	decode
	jmp	bad
lwr_al:	sub	al,32	;make lower case letters upper case for
			;table referencing.
			;
alpha:	sub	al,55	;convert letter to relative position in table.
	mov	ah,0
	shl	ax,1
	mov	bx,ax
	call	decode
	jmp	bad
space2:	call	sp_bar
bad:	ret
screen	endp
;------------------------------------------------------------
decode	proc
	mov	ax,table[bx]	;move the value at the bx'th
				;element of the table int ax register.
	mov	dx,ax
	and	dx,mask lo	;make dx contain number of elements
	mov	cl,hi		;put bit offset of code portion
				;into cl
	shr	ax,cl		;position code at right end of word.
	mov	cx,dx		;move element count into cx
do_it:
	test	ax,1		;test first bit for dah
	jz	dt_call		;no jump to dit routine.
	call	dah		
	jmp	finish
dt_call:
	call	dit
finish:
	shr	ax,1		;move next bit into position
	loop	do_it	
	call	space		;call to space between char routine
	ret
decode	endp
;------------------------------------------------------------
sp_bar	proc		;procedure for space between words
	push	cx
	mov	cx,2
s_agn:	
	push	cx
	mov	cx,4
d025:
	push	cx
	mov	cx,time	;basic space timing element
				;note that s_time is greater than
				;time at low speeds to keep char
				;sounding normal.
down20:
	loop	down20
	pop	cx
	dec	cx
	jnz	d025
	pop	cx

	loop	s_agn
	pop	cx
	ret
sp_bar	endp
;------------------------------------------------------------
menu	proc	;initial main menu routine
mnu:
;
	call	heading
	mov	ah,02
	mov	bh,00
	mov	dh,11
	mov	dl,15
	int	10h
;
	lea	dx,choice1	;SET SPEED
	mov	ah,09
	int	21h
;
	mov	ah,02
	mov	bh,00
	mov	dh,13
	mov	dl,15
	int	10h
;
	lea	dx,choice2	;SET WEIGHT
	mov	ah,09
	int	21h
;
	mov	ah,02
	mov	bh,00
	mov	dh,15
	mov	dl,15
	int	10h
;
	lea	dx,choice3	;START
	mov	ah,09
	int	21h
;
	mov	ah,02
	mov	bh,00
	mov	dh,17
	mov	dl,15
	int	10h
;
	lea	dx,choice4	;BUFFER FUNCTIONS
	mov	ah,09
	int	21h
;
	mov	ah,02
	mov	bh,00
	mov	dh,19
	mov	dl,15
	int	10h
;
	lea	dx,choice5	;KEY OUTPUT
	mov	ah,09
	int	21h
;
	mov	ah,02
	mov	bh,00
	mov	dh,21
	mov	dl,15
	int	10h
;
	lea	dx,choice6	;SCRATCH PAD
	mov	ah,09
	int	21h
;
	mov	ah,02
	mov	bh,00
	mov	dh,23
	mov	dl,15
	int	10h
;
	lea	dx,choice7	;QUIT
	mov	ah,09
	int	21h
;
	mov	ah,02
	mov	bh,00
	mov	dh,24
	mov	dl,15
	int	10h

	call	select	;call routine for selecting the op desired
	call	cls_b
	jmp	mnu
	ret
menu	endp	
;------------------------------------------------------------
cls	proc			;Clear Screen Procedure
	mov	ax,0600h	;scroll
	mov	bh,07		;normal attribute
	mov	cx,0000		;row 0,column 0
	mov	dx,184fh	;to row 18h,column 4fh (24,79)
	int	10h
	ret
cls	endp
;------------------------------------------------------------
cls_b	proc			;Clear Bottom of Screen Procedure 
	mov	ax,0600h	;scroll
	mov	bh,07		;normal attribute
	mov	cx,0b00h	;row 11,column 0
	mov	dx,184fh	;to row 18h,column 4fh (24,79)
	int	10h
	ret
cls_b	endp
;------------------------------------------------------------
cls_w	proc		
	mov	ax,0600h
	mov	bh,07	
	mov	ch,13
	mov	cl,10
	mov	dh,22	
	mov	dl,69
	int	10h
	ret
cls_w	endp
;------------------------------------------------------------
select	proc			;Routine for making menu selections
wrong:	mov	ah,00		;input character with no echo
	int	16h	
	cmp	al,30h		;check for value between ascii 0
	jle	wrong
	cmp	al,37h		;and ascii 6
	jg	wrong
	cmp	al,31h
	je	spd
	cmp	al,32h
	je	wt
	cmp	al,33h
	je	go
	cmp	al,34h
	je	buf_op
	cmp	al,35h
	je	key_c
	cmp	al,36h
	je 	pad
	mov	ax,abort
	mov	sp,ax
	jmp	a_done
pad:	call  s_pad
	ret
spd:	call	speed		;call to speed setting routine
	ret
wt:	call	weight		;call to weight setting routine
	ret
go:	pop	ax
	ret
buf_op:	call	cls_b
	call	b_menu		;call for buffer menu routine
	ret
key_c:	call	cls_b
	call	key_menu
	ret
select	endp
;------------------------------------------------------------
key_menu	proc
	call	cls_b
	mov	ah,02	;Set cursor
	mov	bh,00	;page 0
	mov	dh,11	;row 11
	mov	dl,32	;column 32
	int	10h	

	lea	dx,k_mess1		;KEY OUTPUT MENU
	mov	ah,09
	int	21h

;
	mov 	ah,02
	mov	bh,00
	mov	dh,14
	mov	dl,20
	int	10h
;
	lea	dx,k_mess2	;1 - KEY WITH SOUND
	mov	ah,09
	int	21h
;
	mov	ah,02
	mov	bh,00
	mov	dh,16
	mov	dl,20
	int	10h
;
	lea	dx,k_mess3	;2 - KEY WITHOUT SOUND
	mov	ah,09
	int	21h
;
	mov	ah,02
	mov	bh,00
	mov	dh,18
	mov	dl,20
	int	10h
;
	lea	dx,k_mess4	;3 - SOUND WITHOUT KEYING
	mov	ah,09
	int	21h		
	call	k_sel
	ret
key_menu	endp
;------------------------------------------------------------
k_sel	proc
k_wr2:	mov	ah,00
	int	16h	
	cmp	al,30h
	jle	k_wr2
	cmp	al,33h
	jg	k_wr2
	cmp	al,31h
	je	k_s
	cmp	al,32h
	je	k_ns
	mov	sound,on
	mov	key,off
	ret
k_s:	mov	sound,on
	mov	key,on
	ret
k_ns:	mov	sound,off
	mov	key,on
	ret
k_sel	endp
;------------------------------------------------------------
b_menu	proc
	call	t_init
	call	t_set
st_b:	call	cls_b
	mov	ah,02	;set cursor
	mov	bh,00	;page 0
	mov	dh,11	;row 11
	mov	dl,27	;column 27
	int	10h
;	
	lea	dx,b_mess1	;BUFFERED OPERATIONS MENU
	mov	ah,09
	int	21h
;
	mov 	ah,02
	mov	bh,00
	mov	dh,13
	mov	dl,20
	int	10h
;
	lea	dx,b_mess2	;1 - LOAD A BUFFER 
	mov	ah,09
	int	21h
;
	mov	ah,02
	mov	bh,00
	mov	dh,15
	mov	dl,20
	int	10h
;
	lea	dx,b_mess3	;2 - SEND A BUFFER
	mov	ah,09
	int	21h
;
	mov	ah,02
	mov	bh,00
	mov	dh,17
	mov	dl,20
	int	10h

	lea	dx,b_mess4	;3 - LOAD BUFFERS FROM DISK
	mov	ah,09
	int	21h
;
	mov	ah,02
	mov	bh,00
	mov	dh,19
	mov	dl,20
	int	10h

	lea	dx,b_mess5	;4 - SAVE BUFFERS ON DISK
	mov	ah,09
	int	21h
;
	mov	ah,02
	mov	bh,00
	mov	dh,21
	mov	dl,20
	int	10h
;
	lea	dx,b_mess9	;5 - LOAD PRACTICE FILE
	mov	ah,09
	int	21h
;
	mov	ah,02
	mov	bh,00
	mov	dh,23
	mov	dl,20
	int	10h
;
	lea	dx,b_mess6	;6 - RETURN TO MAIN MENU
	mov	ah,09
	int	21h		
;
	mov	ah,02
	mov	bh,00
	mov	dh,24
	mov	dl,20
	int	10h
;
	call	buf_sel		;call for selecting from buff menu
	jmp	st_b
	ret
b_menu	endp
;------------------------------------------------------------
speed	proc		;routine for speed menu
			;and setting of speeds
	call	cls_b
	mov	ah,02	;set cursor
	mov	bh,00	;page 0
	mov	dh,11	;row 11
	mov	dl,27	;column 27
	int	10h
;	
	lea	dx,s_mess1	;SELECT THE DESIRED SPEED
	mov	ah,09
	int	21h
;
	mov	ah,02
	mov	bh,00
	mov	dh,13
	mov	dl,20
	int	10h
;
	lea	dx,s_mess2
	mov	ah,09
	int	21h
;
	mov	ah,02
	mov	bh,00
	mov	dh,14
	mov	dl,20
	int	10h
;
	lea	dx,s_mess3
	mov	ah,09
	int	21h
;
	mov	ah,02
	mov	bh,00
	mov	dh,15
	mov	dl,20
	int	10h
;
	lea	dx,s_mess4
	mov	ah,09
	int	21h
;
	mov	ah,02
	mov	bh,00
	mov	dh,16
	mov	dl,20
	int	10h
;
	lea	dx,s_mess5
	mov	ah,09
	int	21h
;
	mov	ah,02
	mov	bh,00
	mov	dh,17
	mov	dl,20
	int	10h
;
	lea	dx,s_mess6
	mov	ah,09
	int	21h		
;
	mov	ah,02
	mov	bh,00
	mov	dh,18
	mov	dl,20
	int	10h
;
	lea	dx,s_mess7
	mov	ah,09
	int	21h
;
	mov	ah,02
	mov	bh,00
	mov	dh,19
	mov	dl,20
	int	10h
;
	lea	dx,s_mess8
	mov	ah,09
	int	21h		
;
	mov	ah,02
	mov	bh,00
	mov	dh,20
	mov	dl,20
	int	10h
;
	lea	dx,s_mess9
	mov	ah,09
	int	21h
;
	mov	ah,02
	mov	bh,00
	mov	dh,21
	mov	dl,20
	int	10h
;
	lea	dx,s_mess10
	mov	ah,09
	int	21h		
;
wrong2:	mov	ah,00
	int	16h	
	cmp	al,30h
	jle	wrong2
	cmp	al,39h
	jg	wrong2
	cmp	al,31h
	je	sloest
	cmp	al,32h
	je	s_2
	cmp	al,33h
	je	slow
	cmp	al,34h
	je	s_4
	cmp	al,35h
	je	medium
	cmp	al,36h
	je	s_6
	cmp	al,37h
	je	fast
	cmp	al,38h
	je	s_8
	mov	time,2300h
	mov	s_time,2300h
	jmp	xx1
sloest:	mov	s_time,6800h
	mov	time,3800h
	jmp	xx1
s_2:	mov	s_time,6000h
	mov	time,3400h
	jmp	xx1
slow:	mov	s_time,5000h
	mov	time,3000h
	jmp	xx1
s_4:	mov	s_time,4000h
	mov	time,3000h
	jmp	xx1
medium:	mov	s_time,3000h
	mov	time,3000h
	jmp	xx1
s_6:	mov	time,2800h
	mov	s_time,2800h
	jmp	xx1
fast:	mov	time,2600h
	mov	s_time,2600h
	jmp	xx1
s_8:	mov	time,2400h
	mov	s_time,2400h
xx1:	mov	ah,factor
	cmp	ah,00
	je	xx2
	mov	ax,time
	shl	ax,1
	mov	time,ax
	mov	ax,s_time
	shl	ax,1
	mov	s_time,ax
xx2:	ret
speed	endp
;------------------------------------------------------------	
weight	proc		;routine for setting wt_val
	mov	ah,02	;set cursor
	mov	bh,00	;page 0
	mov	dh,24	;row 24
	mov	dl,10	;column 10
	int	10h
;	
	lea	dx,wt_mess	;1 - NORMAL      2 - HEAVY
	mov	ah,09
	int	21h
wrong3:	mov	ah,00
	int	16h	
	cmp	al,31h
	je	nml
	cmp	al,32h
	jne	wrong3
	mov	wt_val,04
	ret
nml:	mov	wt_val,03
	ret	
weight	endp
;------------------------------------------------------------
buf_sel	proc			;routine for making selections
				;from buff menu
no_gd:	mov	ah,00
	int	16h
	cmp	al,30h
	jle	no_gd
	cmp	al,37h
	jge	no_gd
	cmp	al,33h
	je	r_disk
	cmp	al,34h
	je	w_disk
	cmp	al,31h
	je	b_load
	cmp	al,35h
	je	file_r
	cmp	al,32h
	jne	n_send
	jmp	b_send
n_send:	pop	ax
	ret
r_disk:
	call	dtb
	ret
file_r:
	call	practice
	ret
w_disk:	
	call	create
	call	btd
	ret
b_load:	call	cls_b
	mov	ah,02	;set cursor
	mov	bh,00	;page 0
	mov	dh,11	;row 11
	mov	dl,26	;column 26
	int	10h
	lea	dx,b_mess7
	mov	ah,09
	int	21h
nope:	mov	ah,0
	int	16h	;get the scan code of key
	cmp	ah,3bh	;is it less than F1
	jl	nope
	cmp	ah,44h	;is it greater than F10
	jg	nope
	push	ax	;put the scan code onto the stack
	call	cls_b
	mov	ah,02	;set cursor
	mov	bh,00	;page 0
	mov	dh,11	;row 11
	mov	dl,0	;column 0
	int	10h
	lea	dx,b_mess8
	mov	ah,09
	int	21h
	mov	ah,02	;set cursor
	mov	bh,00	;page 0
	mov	dh,13	;row 13
	mov	dl,0	;column 0
	int	10h
	pop	ax	;pop the scan code off of the stack
	cmp	ah,3bh	;these next cmp's find which funct key was hit
	je	first
	cmp	ah,3ch
	je	second
	cmp	ah,3dh
	je	third
	cmp	ah,3eh
	je	fourth
	cmp	ah,3fh
	je	fifth
	cmp	ah,40h
	je	sixth
	cmp	ah,41h
	je	seventh
	cmp	ah,42h
	je	eighth
	cmp	ah,43h
	je	ninth
tenth:	lea	dx,ten
	call	loader	;call the buffer loader routine
	ret
first:	lea	dx,one
	call	loader
	ret
second:	lea	dx,two
	call	loader
	ret
third:	lea	dx,three
	call	loader
	ret
fourth:	lea	dx,four
	call	loader
	ret
fifth:	lea	dx,five
	call	loader
	ret
sixth:	lea	dx,six
	call	loader
	ret
seventh:
	lea	dx,seven
	call	loader
	ret
eighth:	lea	dx,eight
	call	loader
	ret
ninth:	lea	dx,nine
	call	loader
	ret
b_send:	call	cls_b	;this begins the buffer send section
;
	mov	ah,02	;set cursor
	mov	bh,00	;page 0
	mov	dh,11	;row 11
	mov	dl,26	;column 26
	int	10h
;
	lea	dx,b_mess7
	mov	ah,09
	int	21h
nopes:	mov	ah,0
	int	16h	;check for scan code to find funct key
	cmp	ah,3bh
	jl	nopes
	cmp	ah,44h
	jg	nopes
	push	ax
	call	cls_b
	mov	ah,02	;set cursor
	mov	bh,00	;page 0
	mov	dh,11	;row 11
	mov	dl,0	;column 0
	int	10h
	pop	ax
	cmp	ah,3bh
	je	firsts
	cmp	ah,3ch
	je	seconds
	cmp	ah,3dh
	je	thirds
	cmp	ah,3eh
	je	fourths
	cmp	ah,3fh
	je	fifths
	cmp	ah,40h
	je	sixths
	cmp	ah,41h
	je	sevenths
	cmp	ah,42h
	je	eighths
	cmp	ah,43h
	je	ninths
	lea	bx,ten[2] 	;reference the position of message in
	call	sender		;list of buffers
	ret
firsts:	lea	bx,one[2]
	call	sender
	ret
seconds:
	lea	bx,two[2]
	call	sender
	ret
thirds:	lea	bx,three[2]
	call	sender
	ret
fourths:
	lea	bx,four[2]
	call	sender
	ret
fifths:	lea	bx,five[2]
	call	sender
	ret
sixths:	lea	bx,six[2]
	call	sender
	ret
sevenths:
	lea	bx,seven[2]
	call	sender
	ret
eighths:
	lea	bx,eight[2]
	call	sender
	ret
ninths:	lea	bx,nine[2]
	call	sender
	ret
buf_sel	endp
;------------------------------------------------------------
loader	proc		;load buffer routine
	mov	ax,0c0ah
	int	21h
	ret
loader	endp
;------------------------------------------------------------
sender	proc		;send buffer routine
	mov	al,[bx]
msg_ptr:
	call	putchar	;call to display the sent char
	push	bx
	call	screen
	pop	bx
	inc	bx
	mov	al,[bx]
	call	esc_ch
	cmp	al,13	;check for carriage return
	jne	msg_ptr
	ret
sender	endp
;------------------------------------------------------------
putchar	proc		;routine to display char sent from buffer
	push	dx
	mov	dl,al
	mov	ah,02
	int	21h
	pop	dx
	ret
putchar	endp
;------------------------------------------------------------
set_dta	proc
	lea	dx,dta
	mov	ah,1ah
	int	21h
	ret
set_dta endp
;------------------------------------------------------------
create	proc	
	lea	dx,fcb
	mov	ah,16h
	int	21h
	ret
create	endp
;------------------------------------------------------------
open	proc
	lea	dx,fcb
	mov	ah,0fh
	int	21h
	ret
open	endp
;------------------------------------------------------------
read	proc
	lea	dx,fcb
	mov	ah,14h
	int	21h
	ret
read	endp
;------------------------------------------------------------
write	proc
	lea	dx,fcb
	mov	ah,15h
	int	21h
	ret
write	endp
;------------------------------------------------------------
close	proc
	lea	dx,fcb
	mov	ah,10h
	int	21h
	ret
close	endp
;------------------------------------------------------------
dtb	proc
	call	open
	cmp	al,0ffh
	je		fnt1
	lea	si,dta
	lea	di,one
	mov	cx,20
dtb1:	push	cx
	call	read
	mov	cx,80h
	rep	movsb
	pop	cx
	lea	si,dta
	loop	dtb1
	call	close
	mov	rec_num,00
fnt1:	ret
dtb	endp
;------------------------------------------------------------
btd	proc
	call	open
	cmp	al,0ffh
	je	fnt2
	lea	di,dta
	lea	si,one
	mov	cx,20
btd1:	push	cx
	mov	cx,80h
	rep	movsb
	call	write
	pop	cx
	lea	di,dta
	loop	btd1
	call	close
	mov	rec_num,00
fnt2:	ret
btd	endp
;------------------------------------------------------------
b_line	proc
	cmp	ah,3bh
	je	f1
	cmp	ah,3ch
	je	f2
	cmp	ah,3dh
	je	f3
	cmp	ah,3eh
	je	f4
	cmp	ah,3fh
	je	f5
	cmp	ah,40h
	je	f6
	cmp	ah,41h
	je	f7
	cmp	ah,42h
	je	f8
	cmp	ah,43h
	je	f9
	lea	bx,ten[2] 	;reference the position of message in
	call	sender		;list of buffers
	ret
f1:	lea	bx,one[2]
	call	sender
	ret
f2:
	lea	bx,two[2]
	call	sender
	ret
f3:	lea	bx,three[2]
	call	sender
	ret
f4:
	lea	bx,four[2]
	call	sender
	ret
f5:	lea	bx,five[2]
	call	sender
	ret
f6:	lea	bx,six[2]
	call	sender
	ret
f7:
	lea	bx,seven[2]
	call	sender
	ret
f8:
	lea	bx,eight[2]
	call	sender
	ret
f9:	lea	bx,nine[2]
	call	sender
	ret
b_line	endp
;------------------------------------------------------------
cur_top	proc
	mov	ah,02	;set cursor
	mov	bh,00	;page 0
	mov	dh,13	;row 11
	mov	dl,10	;column 0
	int	10h
	ret
cur_top	endp
;------------------------------------------------------------
cur_bot	proc
	mov	ah,02	;set cursor
	mov	bh,00	;page 0
	mov	dh,22	;row 11
	mov	dl,10	;column 0
	int	10h
	ret
cur_bot	endp
;------------------------------------------------------------
getchar	proc	
	mov	ah,0
	int	16h
	ret
getchar	endp
;------------------------------------------------------------
strip	proc
	cmp	ah,up
	jne	st10
	call	c_up
	mov	ax,0
	ret
st10:	cmp	ah,dn
	jne	st20
	call	c_dn
	mov	ax,0
	ret
st20:	cmp	ah,rt
	jne	st30
	call	c_rt
	mov	ax,0
	ret
st30:	cmp	ah,lft
	jne	st40
	call	c_lt
	mov	ah,0
	ret
st40:	cmp	al,cr
	jne	st50
	call	crlf
	mov	ax,0
	ret
st50:	cmp	al,bs
	jne	st60
	call	c_bs
	mov	ax,0
	ret
st60:	cmp	al,tab
	jne	st70
	mov	ax,0
	ret
st70:	cmp	ah,pgdn
	jne	st80
	call	p_dn
	mov	ax,0
	ret
st80:	cmp	ah,pgup
	jne	st90
	call	p_up
	mov	ax,0
	ret
st90:	cmp	ah,del
	jne	st100
	call	unbuf
	mov	ax,0	
st100:	ret
strip	endp
;------------------------------------------------------------
unbuf	proc
	mov	cx,3000
	mov	di,0
ub10:	mov	buff[di],0
	inc	di
	loop	ub10
	call	cls_w
	mov	di,0
	mov	row,13
	mov	corner,0
	mov	col,10
	call	pos_c
	mov	ax,0
	ret
unbuf	endp
;------------------------------------------------------------
p_up	proc
	cmp	corner,540
	jle	pu10
	sub	corner,600
	mov	di,corner
	jmp	pu20
pu10:	mov	corner,0
	mov	di,0
pu20:	mov	cx,599
	mov	row,13
	mov	col,10
	call	pos_c
	mov	si,corner
pu30:	mov	al,buff[si]
	call	putch
	inc	si
	loop	pu30
	mov	di,corner
	mov	col,10
	mov	row,13
	call	pos_c
	ret
p_up	endp
;------------------------------------------------------------
p_dn	proc
	cmp	corner,2400
	jge	pd20
	cmp	corner,1800
	jl	pd5
	call	cls_w
pd5:	add	corner,600
	mov	si,corner
	mov	di,corner
	push	di
	mov	col,10
	mov	row,13
	call	pos_c
	mov	cx,599
pd10:	mov	al,buff[si]
	call	putch
	inc	si
	cmp	si,2999
	jge	pd16
pd15:	loop	pd10
pd16:	pop	di
	mov	col,10
	mov	row,13
	call	pos_c
pd20:	ret
p_dn	endp	
;------------------------------------------------------------
p_top	proc
	mov	cx,60
	call	cur_top
	mov	bx,corner
pt10:	mov	al,buff[bx]
	call	putchar
	inc	bx
	loop	pt10
	call	pos_c
	ret
p_top	endp	
;------------------------------------------------------------
p_bot	proc
	call	cur_bot
	mov	cx,60
	mov	bx,corner
	add	bx,540
pb10:	mov	al,buff[bx]
	call	putchar
	inc	bx
	loop	pb10
	call	pos_c
	ret
p_bot	endp
;------------------------------------------------------------
c_up	proc
	cmp	row,13
	je	cup10
	dec	row
	sub	di,60
	call	pos_c
	ret
cup10:	cmp	corner,0
	je	cup20
	call	scroll_dn
	sub	corner,60
	sub	di,60
	call	p_top
cup20:	ret
c_up	endp
;------------------------------------------------------------
c_dn	proc
	cmp	row,22
	je	cd10
	inc	row
	add	di,60
	call	pos_c
	ret
cd10:	cmp	corner,2400
	je	cd20
	call	scroll_up
	add	corner,60
	add	di,60
	call	p_bot
cd20:	ret
c_dn	endp
;------------------------------------------------------------
c_rt	proc
	cmp	col,69
	je	crt10
	inc	col
	inc	di
	call	pos_c
	ret
crt10:	cmp	row,22
	je	crt20
	mov	col,10
	inc	row
	inc	di
	call	pos_c
	ret
crt20:	cmp	corner,2400
	je	crt30
	call	scroll_up
	inc	di
	add	corner,60
	mov	col,10
	call	p_bot
crt30:	ret
c_rt	endp
;------------------------------------------------------------
c_lt	proc
	cmp	col,10
	je	clt10
	dec	col
	dec	di
	call	pos_c
	ret
clt10:	cmp	row,13
	je	clt20
	dec	row
	mov	col,69
	dec	di
	call	pos_c
	ret
clt20:	cmp	corner,0
	je	clt30
	call	scroll_dn
	mov	col,69
	dec	di
	sub	corner,60
	call	p_top
	call	pos_c
clt30:	ret
c_lt	endp
;------------------------------------------------------------
scroll_up	proc
	mov	ah,6
	mov	al,1
	mov	bh,07
	mov	ch,13
	mov	cl,10
	mov	dh,22
	mov	dl,69
	int	10h
	ret
scroll_up	endp
;------------------------------------------------------------
scroll_dn	proc
	mov	ah,07
	mov	al,1
	mov	bh,07
	mov	ch,13
	mov	cl,10
	mov	dh,22
	mov	dl,69
	int	10h
	ret
scroll_dn	endp
;------------------------------------------------------------
putch	proc
	push	cx
	mov	ah,10
	mov	bh,0
	mov	cx,1
int	10h
	pop	cx
	mov	buff[di],al
	call	c_rt	
	ret
putch	endp
;------------------------------------------------------------
c_bs	proc
	call	c_lt
	mov	al,0
	call	putch
	call	c_lt
	ret
c_bs	endp
;------------------------------------------------------------
crlf	proc
	mov	dl,69
	sub	dl,col
	mov	dh,0
	add	di,dx
	mov	col,69
	call	c_rt
	ret
crlf	endp
;------------------------------------------------------------
pos_c	proc
	push	ax
	mov	ah,02	;set cursor
	mov	bh,00	;page 0
	mov	dh,row
	mov	dl,col
	int	10h
	pop	ax
	ret
pos_c	endp
;------------------------------------------------------------
s_pad	proc
;this is the experimental scratch pad procedure
	call	cls_b
	call	window
	mov	row,13
	mov	col,10
	call	pos_c
	mov	di,0
	mov	cx,599
	mov	si,0
p5:	mov	al,buff[si]
	call	putch
	inc	si
	loop	p5
	mov	row,13
	mov	col,10
	mov	di,0
	mov	corner,0
	call	pos_c
p10:	call	getchar
	call	strip
	cmp	ax,0
	je	p10
	cmp	al,esc
	je	p20
	call	putch
	jmp	p10
p20:	ret
s_pad	endp
;------------------------------------------------------------	
window	proc

;
	mov	ah,02
	mov	bh,00
	mov	dh,11	;row 11
	mov	dl,6	;col 6
	int	10h
;
	lea	dx,w_top
	mov	ah,09
	int	21h
;
	mov	temp,12
	mov	cx,12
w1:	push	cx
	mov	ah,02
	mov	bh,0
	mov	dh,temp
	mov	dl,6
	int	10h
	mov	al,w_sides
	call	putchar
	mov	ah,02
	mov	bh,00
	mov	dh,temp
	mov	dl,72
	int	10h
	mov	al,w_sides
	call	putchar
	pop	cx
	inc	temp
	loop	w1
;
	mov	ah,02
	mov	bh,00
	mov	dh,24
	mov	dl,6
	int	10h
;
	lea	dx,w_bottom
	mov	ah,09
	int	21h
	call	esd
	ret
window	endp
;------------------------------------------------------------
esc_ch	proc
	push	ax
	mov	ah,1
	int	16h
	jz	nk
	cmp	al,esc
	jne	nk
	pop	ax
	mov	al,13
	ret
nk:	pop	ax
	ret
esc_ch	endp
;------------------------------------------------------------
practice	proc
	call	cls
	mov	ah,02
	mov	bh,0
	mov	dh,0
	mov	dl,0
	int 10h
;
	lea	dx,pname
	mov	ah,09
	int	21h
	mov 	dx,offset pname2
	call	loader
	mov	fail,0
	call	open2
	cmp	fail,0ffh
	je	p_fail
	call	read2
	cmp	fail,0ffh
	je	p_fail
	call	cls
	mov	ah,02
	mov	bh,0
	mov	dh,0
	mov	dl,0
	int	10h
	mov	cx,pract_num
	mov	si,0
pr01:push cx
	mov	al,b_area[si]
	push	ax
	call	putchar
	pop	ax
	call	screen
	inc	si
	pop	cx
	loop	pr01
	call	close2
p_fail:
	call	cls
	call	boxit
	call heading
	ret
practice	endp
;------------------------------------------------------------
open2	proc
	push	dx
	push	bx
	push	ax
	lea	dx,pr_n
	mov	bl,pn_len
	mov	bh,0
	mov	[pr_n+bx],0
	mov	al,0
	mov	ah,3dh
	int	21h
	jc	o_fail
	mov	handle,ax
	pop	ax
	pop	bx
	pop	dx
	ret
o_fail:
	lea	dx,o_err
	mov	ah,09
	int	21h
	mov	cx,30000
ll:	nop
	nop
	loop ll
	mov	fail,0ffh
	pop	ax
	pop	bx
	pop	dx
	ret
open2	endp
;------------------------------------------------------------
read2	proc
	push	dx
	push	cx
	push	bx
	push	ax
	mov	bx,handle
	mov	cx,10000
	mov	ah,3fh
	lea	dx,b_area
	int	21h
	jc	r_fail
	mov	pract_num,ax
	pop	ax
	pop	bx
	pop	cx
	pop	dx
	ret
r_fail:
	lea	dx,r_err
	mov	ah,09
	int	21h
	mov	fail,0ffh
	pop	ax
	pop	bx
	pop	cx
	pop	dx
	ret
read2	endp
;------------------------------------------------------------
close2	proc
	mov	bx,handle
	mov	ah, 3eh
	int	21h
	ret
close2	endp
;------------------------------------------------------------
build	proc
	mov	ah,1
	int	16h
	jz	di2
	mov	ah,0
	int	16h
	cmp	al,esc
	jne	not_e1
	call	close2
	mov	ax,abort
	mov	sp,ax
	jmp	over2
not_e1:
	cmp	al,bs	;This is test
	jne	not_bs	;This is test
	mov	bx,out_ptr
	cmp	bx,in_ptr
	je	di2
	dec	in_ptr	;This is test
	dec	in_ptr	;This is test
	jmp	di2	;This is test
not_bs:

	mov	bx,in_ptr
	mov	big_buf[bx],ax
	inc	bx
	inc	bx
	cmp	bx,512
	jle	di3
	mov	bx,0
di3:
	mov	in_ptr,bx
di2:	ret
build	endp
;------------------------------------------------------------
boxit	proc	
	mov	ax,0600h	;scroll
	mov	bh,70h		;reverse attribute
	mov	cx,0017h	;row 0,column 23
	mov	dx,0237h	;to row 2,column 55
	int	10h
;
	mov	ah,02	;set cursor
	mov	bh,00	;page 0
	mov	dh,0	;row 0
	mov	dl,23	;column 23
	int	10h
;
	lea	dx,box_top
	mov	ah,09
	int	21h
;
	mov	ah,02	;set cursor
	mov	bh,00	;page 0
	mov	dh,1	;row 1
	mov	dl,23	;column 23
	int	10h
;
	lea	dx,box_sides
	mov	ah,09
	int	21h
;
	mov	ah,02	;set cursor
	mov	bh,00	;page 0
	mov	dh,2	;row 2
	mov	dl,23	;column 23
	int	10h
;
	lea	dx,box_bottom
	mov	ah,09
	int	21h
;
	ret
boxit	endp
;------------------------------------------------------------
heading	proc
	mov	ah,02	;set cursor
	mov	bh,00	;page 0
	mov	dh,01	;row 1
	mov	dl,29	;column 29
	int	10h
;	
	lea	dx,mess1	;WB8BIL CODE GENERATOR
	mov	ah,09
	int	21h
;
	mov	ah,02
	mov	bh,00
	mov	dh,3
	mov	dl,12
	int	10h
;
	lea	dx,mess6	;(c) 1985, Gregg Anderson
	mov	ah,09
	int	21h
;
	mov	ah,02
	mov	bh,00
	mov	dh,05
	mov	dl,40
	int	10h
;
	lea	dx,mess2	;WRITTEN BY
	mov	ah,09
	int	21h
;
	mov	ah,02
	mov	bh,00
	mov	dh,07
	mov	dl,45
	int	10h
;
	lea	dx,mess3	;GREGG C. ANDERSON
	mov	ah,09
	int	21h
;
	mov	ah,02
	mov	bh,00
	mov	dh,08
	mov	dl,45
	int	10h
;
	lea	dx,mess4	;247 HILL ST.
	mov	ah,09
	int	21h
;
	mov	ah,02
	mov	bh,00
	mov	dh,09
	mov	dl,45
	int	10h
;
	lea	dx,mess5	;ISHPEMING, MI 49849
	mov	ah,09
	int	21h
	ret
heading	endp
;------------------------------------------------------------
b_area		db	10000 dup(?)
;------------------------------------------------------------
codes	ends
;************************************************************
	end	start
