	PAGE	,120
	TITLE	CIF002 - CIF UPDATE PROGRAM
	.SALL
;****************************************************
; DAVID RICHMOND, 01/22/89 - LAUREL COMPUTER SERVICES
;****************************************************
	IF1
	INCLUDE	MACRO.LIB
	INCLUDE MACRO2.LIB
	INCLUDE DSKMACRO.LIB
	INCLUDE MAPMACRO.LIB
	ENDIF
;
CODESG	SEGMENT	PARA PUBLIC
	ASSUME	DS:CODESG,ES:CODESG,CS:CODESG
	ORG	100H
;
;********************************************
; P R O G R A M   I N I T I A L I Z A T I O N
;
MAIN	PROC	FAR
BEGIN:	PUSH	DS
	SUB	AX,AX
	PUSH	AX
	MOV	AX,CS
	MOV	DS,AX
	MOV	ES,AX
	JMP	TAG1
;
;******************************
; L I N K A G E   S E C T I O N
;
	EXTRN	MAP4A:NEAR	;SCREEN TEMPLATE.
	EXTRN	MAP5A:NEAR	;SAMPLE DATA FIELDS.
	EXTRN	CIF002A:NEAR	;LOAD INDEX.
	EXTRN	CIF002B:NEAR	;SEARCH INDEX.
	SR005		;DECIMAL ARITHMETIC MODULE.
	SR006		;KEYBOARD/PRINTER MODULE.
	SR007		;BINARY ARITHMETIC MODULE.
	SR013		;BASIC MAPPING SYSTEM.
;
;******************************
; W O R K I N G   S T O R A G E
;
	FCB	FILE1,'CONTROL CIF'	;CONTROL FILE.
	FCB	FILE2,'MASTERS CIF'	;MASTER FILE.
	FCB	FILE4,'OVRINDEXCIF'	;OVERFLOW INDEX.
;
LIT1	DB	'Inactive'
LIT2	DB	'Deleted'
LIT3	DB	'Casual'
LIT4	DB	'Weekly'
LIT5	DB	'Monthly'
LIT6	DB	'Quarterly'
LIT7	DB	'Semi-Annual'
LIT8	DB	'Annually'
LIT9	DB	'Other'
LIT10	DB	'Oops'
LITB	DB	'Active'
LITF	DB	'Pledge'
LITG	DB	'.00'
;
WORK1	DB	19 DUP(?)	;EXTERNAL DECIMAL.
WORK2	DB	19 DUP(?)
WORK3	DB	19 DUP(?)
WORK4	DB	9 DUP(?)	;PACKED DECIMAL.
WORK5	DB	9 DUP(?)
WORK6	DB	9 DUP(?)
WORK7	DB	9 DUP(?)
WORK8	DB	8 DUP(?)
WORK9	DB	6 DUP(?)
WORK10	DD	0
WORK11	DW	0
STRING1	DB	35 DUP(?)	;COMMAND LINE INPUT AREA.
;
FLAG2	DB	' '		;CURRENT COMMAND.
FLAG3	DB	' '		;PREVIOUS COMMAND.
FCBYTE	DB	0		;FIELD CONTROL BYTE.
SCODE	DB	0		;SCAN CODE (FOR CURSOR CONTROL).
GCODE	DB	09H		;GRAPHIC REPRESENTATION.
;
MSG1	DB	'Posting date set to mm/dd/yy.$'
MSG2	DB	'Posting date improperly specified.$'
MSG3	DB	80 DUP(' '),'$'
MSG4	DB	'Mount CIF diskette.$'
MSG5	DB	'Specify drive nbr (A or B) when ready:$'
MSG7	DB	'Cannot Open Control File.$'
MSG8	DB	'Cannot Open Master File.$'
MSG9	DB	'Program Terminated.$'
MSG10	DB	'Invalid Command Code.$'
MSG11	DB	'Record nnnn successfully written.$'
MSG12	DB	'Record number not specified.$'
MSG13	DB	'Update Rejected.  Mapping area is empty.$'
MSG14	DB	'Record nnnn sucessfully rewritten.$'
MSG15	DB	'Cannot read control record.$'
MSG16	DB	'Cannot write master record. Disk probably full.$'
MSG17	DB	'Record nnnn not found. nnnn is last record written.$'
MSG18	DB	'I/O error on Master rewrite. Try again.$'
MSG19	DB	'Cannot rewrite updated control record.$'
MSG20	DB	'Contact program vendor.$'
MSG21	DB	'Unauthorized control key was pressed.$'
MSG22	DB	'Update Program ready to go.$'
MSG24	DB	'Payment amount invalid or not specified.$'
MSG25	DB	'Person',27H
	DB	's name improperly specified.$'
MSG26	DB	'Can',27H
	DB	't find specified person.$'
MSG28	DB	'Cannot open overflow index.$'
MSG29	DB	'Now loading overflow index.$'
MSG30	DB	'Empty record slot.$'
MSG31	DB	35 DUP(' ')
	DB	'$'
MSG32	DB	'Control Updated. Next Record To Be Added is XXXX.$'
;
CBRN	DB	0,0,0		;CURRENT BLOCK & RECORD NBR.  
RECNBR	DB	'0000$'		;RECORD NBR, DISPLAY FORMAT.
BLANKS	DB	'    $'
K300	DB	'0300'
DDZERO	DD	0
DWZERO	DW	0
PDZERO	DB	20H,0,0,0,0,0,0,0,0
PD1	DB	20H,0,0,0,0,0,0,0,01H
BNBR	DW	0
SRCHARG	DB	26 DUP(' ')	;INDEX SEARCH ARG.
	DB	'0000'
	DB	0DH,0AH
HITFLAG	DB	' '
SLEN	DW	0		;SCAN LENGTH.
PDATE	DB	'mm/dd/yy'	;POSTING DATE.
DEVNBR	DW	0		;DEVICE NUMBER.
PARMA	DW	OFFSET SRCHARG
	DW	OFFSET SLEN
	DW	OFFSET RECNBR
NFLAG	DB	' '		;NAME FORMAT FLAG.
;
; CONTROL RECORD I/O AREA
;
CRECORD	DB	'0000'		;NEXT RECORD NBR.
	DB	'$'
	DB	'NONE'		;PREVIOUS RECORD NBR.
	DB	'$'
RESTART	DB	0,0,0		;RESTART CBN/CRN (FOR CONTINUE).
	DB	496 DUP(0)
	DB	0DH,0AH,1AH
;
; MASTER RECORD I/O AREA
;
MRECORD	DB	' '		;MASTER RECORD NAME FLAG.
MRLNAME	DB	16 DUP(' ')	;LAST NAME.
MRFNAME	DB	12 DUP(' ')	;FIRST & MIDDLE NAME.
MRSTRET	DB	30 DUP(' ')	;STREET NBR & NAME.
MRCITY	DB	15 DUP(' ')	;CITY.
MRSTATE	DB	'  '		;STATE.
MRZIP	DB	'     '		;ZIP CODE.
MRSTAT	DB	' '		;FILE STATUS (A, I, OR D).
MRPAR	DB	' '		;PARTICIPATION (P OR C).
MRDATEP	DB	'      '	;DATE OF PLEDGE (MMDDYY).
MRPAYPL	DB	' '		;PAYMENT PLAN (W, M, Q, S, A OR O).
MRPYAMT	DB	'        '	;PAYMENT AMOUNT.
MRAMTPL	DB	'        '	;AMOUNT OF PLEDGE.
MRPDWPL	DB	'        '	;AMT PAID WITH PLEDGE.
MRPTDAT	DB	'        '	;PAYMENTS TO DATE.
MRBAL	DB	'        '	;BALANCE DUE.
MRPDT1	DB	'      '	;PAYMENT 1 DATE.
MRPAM1	DB	'        '	;PAYMENT 1 AMOUNT.
MRPDT2	DB	'      '	;PAYMENT 2 DATE.
MRPAM2	DB	'        '	;PAYMENT 2 AMOUNT.
MRPDT3	DB	'      '	;PAYMENT 3 DATE.
MRPAM3	DB	'        '	;PAYMENT 3 AMOUNT.
MRPDT4	DB	'      '        ;PAYMENT 4 DATE.
MRPAM4	DB	'        '	;PAYMENT 4 AMOUNT.
MRPDT5	DB	'      '	;PAYMENT 5 DATE.
MRPAM5	DB	'        '	;PAYMENT 5 AMOUNT.
MRPDT6	DB	'      '	;PAYMENT 6 DATE.
MRPAM6	DB	'        '	;PAYMENT 6 AMOUNT.
MRPDT7	DB	'      '	;PAYMENT 7 DATE.
MRPAM7	DB	'        '	;PAYMENT 7 AMOUNT.
MRPDT8	DB	'      '
MRPAM8	DB	'        '
MRPDT9	DB	'      '
MRPAM9	DB	'        '
MRPDT10	DB	'      '
MRPAM10	DB	'        '
MRPDT11	DB	'      '
MRPAM11	DB	'        '
MRPDT12	DB	'      '
MRPAM12	DB	'        '
MRPDT13	DB	'      '
MRPAM13	DB	'        '
MRPDT14	DB	'      '
MRPAM14	DB	'        '
MRPDT15	DB	'      '
MRPAM15	DB	'        '
MRPDT16	DB	'      '
MRPAM16	DB	'        '
MRPDT17	DB	'      '
MRPAM17	DB	'        '
MRPDT18	DB	'      '
MRPAM18	DB	'        '
MRPDT19	DB	'      '
MRPAM19	DB	'        '
MRPDT20	DB	'      '
MRPAM20	DB	'        '
MRPDT21	DB	'      '
MRPAM21	DB	'        '
MRPDT22	DB	'      '
MRPAM22	DB	'        '
MRPDT23	DB	'      '
MRPAM23	DB	'        '
MRPDT24	DB	'      '
MRPAM24	DB	'        '
MRNDT1	DB	'      '	;NOTIFICATION 1 DATE.
MRNMSG1	DB	' '		;NOTIFICATION 1 TYPE.  
MRNDT2	DB	'      '	;NOTIFICATION 2 DATE.
MRNMSG2	DB	' '		;NOTIFICATION 2 TYPE.
MRNDT3	DB	'      '
MRNMSG3	DB	' '
MRNDT4	DB	'      '
MRNMSG4	DB	' '
MRNDT5	DB	'      '
MRNMSG5	DB	' '
MRNDT6	DB	'      '
MRNMSG6	DB	' '
	DB	'  '
MRCRTN	DB	0DH		;CARRIAGE RETURN SYMBOL.
MRLFEED	DB	0AH		;LINE FEED SYMBOL.
;
; M A P 6   I / O   A R E A
;
	BGNMAP	MAP6
	MAPFD	M6NAME,3,9,7,29
	MAPFD	M6STRET,4,9,7,30
	MAPFD	M6CITY,5,9,7,15
	MAPFD	M6STATE,5,32,7,2
	MAPFD	M6ZIP,5,40,7,5
	MAPFD	M6STAT,3,73,7,8
	MAPFD	M6PAR,5,73,7,6
	MAPFD	M6DATEP,7,27,7,8	;DATE OF PLEDGE.
	MAPFD	M6PAYPL,8,27,7,12	;PAYMENT PLAN.
	MAPFD	M6PYAMT,9,27,7,8	;PAYMENT AMOUNT.
	MAPFD	M6AMTPL,7,59,7,8	;AMOUNT OF PLEDGE.
	MAPFD	M6PDWPL,8,59,7,8	;AMT PAID WITH PLEDGE.
	MAPFD	M6PTDAT,9,59,7,8	;PAYMENTS TO DATE.
	MAPFD	M6BAL,10,59,7,8		;BALANCE DUE.
	MAPFD	M6PDT1,14,1,7,8		;PAYMENT 1 DATE.
	MAPFD	M6PAM1,14,11,7,8	;PAYMENT 1 AMOUNT.
	MAPFD	M6PDT2,15,1,7,8		;PAYMENT 2 DATE.
	MAPFD	M6PAM2,15,11,7,8	;PAYMENT 2 AMOUNT.
	MAPFD	M6PDT3,16,1,7,8
	MAPFD	M6PAM3,16,11,7,8
	MAPFD	M6PDT4,17,1,7,8
	MAPFD	M6PAM4,17,11,7,8
	MAPFD	M6PDT5,18,1,7,8
	MAPFD	M6PAM5,18,11,7,8
	MAPFD	M6PDT6,19,1,7,8
	MAPFD	M6PAM6,19,11,7,8
	MAPFD	M6PDT7,20,1,7,8
	MAPFD	M6PAM7,20,11,7,8
	MAPFD	M6PDT8,21,1,7,8
	MAPFD	M6PAM8,21,11,7,8
	MAPFD	M6PDT9,14,22,7,8
	MAPFD	M6PAM9,14,32,7,8
	MAPFD	M6PDT10,15,22,7,8
	MAPFD	M6PAM10,15,32,7,8
	MAPFD	M6PDT11,16,22,7,8
	MAPFD	M6PAM11,16,32,7,8
	MAPFD	M6PDT12,17,22,7,8
	MAPFD	M6PAM12,17,32,7,8
	MAPFD	M6PDT13,18,22,7,8
	MAPFD	M6PAM13,18,32,7,8
	MAPFD	M6PDT14,19,22,7,8
	MAPFD	M6PAM14,19,32,7,8
	MAPFD	M6PDT15,20,22,7,8
	MAPFD	M6PAM15,20,32,7,8
	MAPFD	M6PDT16,21,22,7,8
	MAPFD	M6PAM16,21,32,7,8
	MAPFD	M6PDT17,14,43,7,8
	MAPFD	M6PAM17,14,53,7,8
	MAPFD	M6PDT18,15,43,7,8
	MAPFD	M6PAM18,15,53,7,8
	MAPFD	M6PDT19,16,43,7,8
	MAPFD	M6PAM19,16,53,7,8
	MAPFD	M6PDT20,17,43,7,8
	MAPFD	M6PAM20,17,53,7,8
	MAPFD	M6PDT21,18,43,7,8
	MAPFD	M6PAM21,18,53,7,8
	MAPFD	M6PDT22,19,43,7,8
	MAPFD	M6PAM22,19,53,7,8
	MAPFD	M6PDT23,20,43,7,8
	MAPFD	M6PAM23,20,53,7,8
	MAPFD	M6PDT24,21,43,7,8
	MAPFD	M6PAM24,21,53,7,8
	MAPFD	M6NDT1,15,66,7,8	;NOTIFICATION 1 DATE.
	MAPFD	M6NMSG1,15,75,7,6	;NOTIFICATION 1 TYPE.
	MAPFD	M6NDT2,16,66,7,8
	MAPFD	M6NMSG2,16,75,7,6
	MAPFD	M6NDT3,17,66,7,8
	MAPFD	M6NMSG3,17,75,7,6
	MAPFD	M6NDT4,18,66,7,8
	MAPFD	M6NMSG4,18,75,7,6
	MAPFD	M6NDT5,19,66,7,8
	MAPFD	M6NMSG5,19,75,7,6
	MAPFD	M6NDT6,20,66,7,8
	MAPFD	M6NMSG6,20,75,7,6
	ENDMAP
;
OVRINDX	DB	2560 DUP(0FFH)		;OVERFLOW INDEX.
	DB	32 DUP(0FFH)
	PAGE
;**************************************
; P R O C E D U R E   D I V I S I O N *
;**************************************
; HOUSKEEPING ROUTINE
;
TAG1:	CALL	MAP4A		;CLEAR SCREEN & BUILD TEMPLATE.
	RESET	KEYBD		;RESET SR006 EXITS.
	CALL	MAP5A		;INSERT DUMMY DATA & MESSAGES.
	RESET	KEYBD
	BLANK	STRING1,35	;CLEAR KEYBOARD INPUT AREA.
	READKB	STRING1,23,15,5	;WAIT FOR ENTER TO CONTINUE.
	SETMAP	MAP6
	CLRMAP			;BLANK SCREEN DATA FIELDS.
	MAPOUT
	SHIP	23,15,MSG3+15	;CLEAR COMMAND LINE.
	SHIP	24,1,MSG3	;CLEAR MESSAGE DISPLAY LINE.
	BLANK	STRING1,35	;CLEAR INPUT AREA.
	SHIP	23,15,MSG4	;MOUNT MSG.
	SHIP	24,1,MSG5	;REQUEST DISKETTE DRIVE.
	READKB	STRING1,24,40,5
	CMP	STRING1,'#'	;CHECK PREEMPTORY TERMINATE.
	BE	TAG13
	MOV	AL,STRING1 	;GET DEVICE ID.
	AND	AL,0FH		;ERASE ZONE BITS.
	MOV	BYTE PTR DEVNBR,AL
	MOV	AX,DEVNBR
	MOV	FILE1,AL
	MOV	FILE2,AL
	MOV	FILE4,AL
	OPEN	FILE1,OLD,ERROR1
	OPEN	FILE2,OLD,ERROR2
	LEA	SI,DEVNBR
	CALL	CIF002A			;CALL INDEX LOADER.
	SHIP	24,1,MSG3		;CLEAR MSG LINE.
	SHIP	23,15,MSG3+15		;CLEAR COMMAND LINE.
	OPEN	FILE4,OLD,ERRORD
	GET	FILE1,CRECORD,512,ERROR3
	SHIP	24,1,MSG29
	LEA	BX,OVRINDX
TAG4:	FILL	MRECORD,512,0FFH
	GET	FILE4,MRECORD,512,TAG5
	CMP	MRECORD,0FFH
	BE	TAG5A			;QUIT ON EMPTY SECTOR.
	MOVL	BX,MRECORD,512
	ADD	BX,512
	B	TAG4
TAG5:	ADD	BX,512
	MOVL	BX,MRECORD,512
TAG5A:	CLOSE	FILE4
	FILL	MRECORD,512,20H
	SETKB	QUERY,QUERY,SCODE
	SHIP	24,1,MSG3	;CLEAR MSG DISPLAY LINE.
	SHIP	24,1,MSG22	;ADVISE READY TO GO.
	SHIP	4,73,CRECORD	;NEXT RECORD NBR.
	SHIP	23,15,MSG3+15	;CLEAR COMMAND DISPLAY LINE.
	BLANK	STRING1,35	;CLEAR COMMAND INPUT AREA.
	B	KBCTL		;REQUEST FIRST COMMAND.
;
;********************************************
; C O M M A N D   I N T E R P R E T A T I O N
;
TAG6:	SHIP	24,1,MSG3	;CLEAR MSG DISPLAY LINE.
KBCTL:	BLANK	STRING1,35
	SHIP	23,15,MSG3+15	;CLEAR COMMAND LINE.
	READKB	STRING1,23,15,35
TAG6A:	SHIP	24,1,MSG3	;CLEAR MSG LINE.
	SHIP	3,37,MSG3+79	;CLEAR TAG END OF NAME FIELD.
	CMP	STRING1,'P'	;POST PAYMENT?
	BE	TAG54
	CMP	STRING1,'p'
	BE	TAG54
	MOV	AL,FLAG2	;SHIFT COMMAND HISTORY.
	MOV	FLAG3,AL
	MOV	AL,STRING1
	MOV	FLAG2,AL
	CMP	STRING1,'C'	;CLEAR SCREEN?
	BE	TAG7
	CMP	STRING1,'c'
	BE	TAG7
	CMP	STRING1,'A'	;ADD NEW RECORD?
	BE	TAG8
	CMP	STRING1,'a'
	BE	TAG8
	CMP	STRING1,'R'	;READ OLD RECORD?
	BE	TAG9
	CMP	STRING1,'r'
	BE	TAG9
	CMP	STRING1,'U'	;UPDATE OLD RECORD?
	BE	TAG10
	CMP	STRING1,'u'
	BE	TAG10
	CMP	STRING1,'F'	;FIND PERSON?
	BE	TAG16
	CMP	STRING1,'f'
	BE	TAG16
	CMP	STRING1,'D'	;SET POSTING DATE?
	BE	TAG53
	CMP	STRING1,'d'
	BE	TAG53
	CMP	STRING1,'X'	;REFRESH SCREEN?
	BE	TAG7A
	CMP	STRING1,'x'
	BE	TAG7A
	CMP	STRING1,'T'	;TERMINATE PROGRAM?
	BE	TAG11
	CMP	STRING1,'t'
	BE	TAG11
	CMP	STRING1,'Z'	;RESET CONTROL RECORD?
	BE	TAG60
	CMP	STRING1,'z'
	BE	TAG60
	SHIP	24,1,MSG10	;INVALID COMMAND CODE.
	B	KBCTL
;
;************************
; C L E A R   S C R E E N
;
TAG7:	SETMAP	MAP6		;INITIALIZE BMS.
	CLRMAP			;CLEAR MAP AREA.
	MAPOUT			;CLEAR DATA BUCKETS ON SCREEN.
	SHIP	4,73,BLANKS	;CLEAR RECNBR DISPLAY FIELD.
	B	TAG6
TAG7A:	CALL	MAP4A		;CLEAR & REBUILD TEMPLATE.
	SETKB	QUERY,QUERY,SCODE
	B	TAG7
;
;****************************
; A D D   N E W   R E C O R D
;
TAG8:	MOV	NFLAG,' '	;CLEAR NAME FLAG.
	CALL	SUBR4		;UPDATE DISPLAY RECORD NBR.
	CALL	SUBR1		;MOVE DATA TO RECORD.
	SETCBRN	FILE2,RESTART	;SET RECORD POINTER.
	PUT	FILE2,MRECORD,512,ERROR4
	GETCBRN	FILE2,RESTART	;SAVE RECORD POINTER.
	SETMAP	MAP6
	CLRMAP			;CLEAR MAPPING AREA.
	MAPOUT			;BLANK SCREEN DATA FIELDS.
	SHIP	4,73,CRECORD    ;INSERT NEXT RECORD NBR.
	MOVL	MSG11+7,CRECORD+5,4
	CALL	SUBR13		;UPDATE OVERFLOW INDEX.
	SHIP	23,15,MSG31	;CLEAR COMMAND DISPLAY AREA.
	SHIP	24,1,MSG11	;ADVISE RECORD ADDED.
	BLANK	STRING1,35	;CLEAR COMMAND INPUT AREA.
	B	KEY1
;
;************************************
; D I S P L A Y   O L D   R E C O R D
;
TAG9:	CMP	STRING1+2,' '	;CHECK FOR RECORD NBR.
	BE	ERROR5
	CALL	SUBR6		;CONSTRUCT CBRN KEY.
TAG9A:	SETMAP	MAP6
	CLRMAP
	SETCBRN	FILE2,CBRN	;SET NEW RECORD POINTER.
	GET	FILE2,MRECORD,512,ERROR6
	CMP	MRECORD,0FFH	;CHECK FOR EMPTY SLOT.
	BE	ERRORG
	MOV	FLAG3,'R'
	CALL	SUBR3		;MOVE DATA TO INTERMEDIATE.
TAG9B:	MAPOUT			;SEND MAP TO SCREEN.
	SHIP	4,73,RECNBR	;OVERRIDE DISPLAYED RCD NBR.
	B	KBCTL
;
;********************************************
; R E W R I T E   U P D A T E D   R E C O R D
;
TAG10:	CMP	M6NAME,' '
	BE	ERROR7		;UPDATE REJECTED.
	CALL	SUBR1		;MOVE DATA TO RECORD.
	SETCBRN	FILE2,CBRN	;RESET RECORD POINTER.
	PUT	FILE2,MRECORD,512,ERROR8
	SETMAP	MAP6
	CLRMAP			;BLANK SCREEN DATA FIELDS.
	MAPOUT
	MOVL	MSG14+7,RECNBR,4
	SHIP	24,1,MSG14
	B	KBCTL
;
;**********************************
; T E R M I N A T E   P R O G R A M
;
TAG11:	SETCBRN	FILE1,DDZERO
	PUT	FILE1,CRECORD,512,ERROR9	;UPDATE CONTROL.
	CLOSE	FILE1
	CLOSE	FILE2
	SETCBRN	FILE4,DDZERO
	LEA	BX,OVRINDX		;UPDATE OVERFLOW INDEX.
TAG11A:	MOVL	MRECORD,BX,512
	CMP	MRECORD,0FFH
	BE	TAG11B
	PUT	FILE4,MRECORD,512,TAG11B
	ADD	BX,512
	B	TAG11A
TAG11B:	CLOSE	FILE4
	SHIP	23,50,MSG9
	STOPRUN
;
;****************************
; E R R O R S   R O U T I N E
;
ERROR1:	SHIP	24,1,MSG7
	B	TAG13
ERROR2:	SHIP	24,1,MSG8
	B	TAG13
ERROR3:	SHIP	24,1,MSG15
	B	TAG13
ERROR4:	SHIP	24,1,MSG16
	B	TAG11
ERROR5:	SHIP	24,1,MSG12
	B	KBCTL
ERROR6:	MOVL	MSG17+23,CRECORD+5,4
	MOVL	MSG17+7,RECNBR,4
	SHIP	24,1,MSG17
	B	KBCTL
ERROR7:	SHIP	24,1,MSG13
	B	KBCTL
ERROR8:	SHIP	24,1,MSG18
	B	KBCTL
ERROR9:	SHIP	24,1,MSG19
	B	TAG14
ERRORA:	SHIP	24,1,MSG25
	B	KBCTL
ERRORB:	SHIP	24,1,MSG26
	B	KBCTL
ERRORD:	SHIP	24,1,MSG28
	B	TAG13
ERRORE:	SHIP	24,1,MSG2
	B	KBCTL
ERRORF:	SHIP	24,1,MSG24
	B	KBCTL
ERRORG:	CLRMAP
	MOVL	M6NAME+4,MSG30,18
	CALL	SUBR12		;BUILD DISPLAY RCD NBR.
	B	TAG9B
TAG12:	SHIP	23,50,MSG9
	B	TAG11
TAG13:	SHIP	23,50,MSG9
	STOPRUN
TAG14:	SHIP	24,67,MSG20
	B	TAG11
;
;********************************************
; K E Y B O A R D   Q U E R Y   R O U T I N E
;
;	THIS ROUTINE IS AUTOMATICALLY ENTERED FROM THE KEYBOARD
;	MODULE WHENEVER ANY NON-GRAPHIC KEY IS PRESSED.
;
QUERY:	SHIP	24,1,MSG31	;CLEAR MSG AREA FIRST.
	CMP	SCODE,28	;ENTER/RETURN?
	BE	TAG15
	CMP	SCODE,59	;PFK1?
	BE	KEY1
	CMP	SCODE,60	;PFK2?
	BE	KEY15
	CMP	SCODE,61	;PFK3?
	BE	KEY63
	CMP	SCODE,62	;PFK4?
	BE	KBCTL
	CMP	SCODE,67	;PFK9?
	BE	TAG51
	CMP	SCODE,68	;PFK10?
	BE	TAG52
	SHIP	24,1,MSG21	;INVALID CONTROL KEY.
	B	KBCTL
TAG15:	CMP	STRING1,' '
	BE	KBCTL
	B	TAG6A		;INTERPRET COMMAND KEYED.
KEY1:	MAPIN	1		;BEGIN DATA ENTRY AT FIELD 1.
KEY15:	MAPIN	15		;BEGIN DATA ENTRY AT FIELD 15.
KEY63:	MAPIN	63		;BEGIN DATA ENTRY AT FIELD 63.
;
;**************************
; L O C A T E   P E R S O N
;
TAG16:	MOV	FLAG3,'R'
	CMP	STRING1+2,' '
	BE	ERRORA
	CMP	STRING1+2,'*'
	BE	TAG17
	CMP	STRING1+2,'+'
	BE	TAG18
	MOVL	SRCHARG,STRING1+2,26	;LOAD SEARCH ARG.
	MOV	SLEN,26			;SET SCAN LENGTH.
	B	TAG19
TAG17:	CALL	SUBR7		;BUILD SEARCH ARGUMENT.
	B	TAG19
TAG18:	CALL	SUBR9		;BUILD SHORT SEARCH ARG.
TAG19:	LEA	SI,PARMA
	CALL	CIF002B		;SEARCH PRIMARY INDEX.
	CMP	RECNBR,'9'	;CHECK FOR MATCH.
	BE	TAG48		;IF NO, TRY OVERFLOW INDEX.
TAG47:	BLANK	STRING1,35
	MOVL	STRING1+2,RECNBR,4	;EXTRACT RECORD NBR.
	B	TAG9			;DISPLAY THE RECORD.
TAG48:	LEA	BX,OVRINDX	;SET ENTRY POINTER.
	B	TAG50
TAG49:	ADD	BX,32		;BUMP POINTER TO NEXT.
TAG50:	CMP	BYTE PTR [BX],0FFH	;CHECK FOR EMPTY ENTRY.
	BE	ERRORB		;ADVISE CAN'T FIND PERSON.
	CALL	SUBR8		;CHECK ARG AGAINST ENTRY.
	CMP	HITFLAG,'E'	;CHECK FOR MATCH.
	BNE	TAG49		;LOOP TILL MATCH OR INDEX END.
	MOVL	RECNBR,BX+26,4	;EXTRACT RECORD NBR.
	B	TAG47		;PROCESS HIT.
;
;********************************
; S C R O L L   B A C K W A R D S
;
TAG51:	DECCBRN	CBRN
	CALL	SUBR12		;UPDATE DISPLAY RECORD NBR.
	MOV	FLAG3,'R'
	B	TAG9A
;
;******************************
; S C R O L L   F O R W A R D S
;
TAG52:	INCCBRN	CBRN
	CALL	SUBR12
	MOV	FLAG3,'R'
	B	TAG9A
;
;************************
; STORE DATE FOR POSTINGS
;
TAG53:	CMP	STRING1+2,' '
	BE	ERRORE
	MOVL	PDATE,STRING1+2,8
	MOVL	MSG1+20,PDATE,8
	SHIP	24,1,MSG3
	SHIP	24,1,MSG1
	B	KBCTL
;
;************************
; P O S T   P A Y M E N T
;
TAG54:	CMP	STRING1+2,' '
	BE	ERRORF
	MOV	FLAG3,'R'
	BLANK	WORK1,19
	MOVL	WORK1+1,STRING1+2,8
	CALL	SUBR10			;ALIGN AMOUNT.
	PACK	WORK4,WORK2		;PACK PAYMENT AMOUNT.
	TEST	WORK4,40H		;VALIDITY CHECK.
	BM	ERRORF
	CMP	M6PDT24,' '		;MAKE SURE THERE'S ROOM
	BE	TAG55			;  FOR POSTING.
	CALL	SUBR11			;ROLL PAYMENT HISTORY.
	MOVL	M6PDT24,PDATE,8
	MOVL	M6PAM24,WORK2+1,8
	B	TAG58
TAG55:	LEA	BX,M6PDT1
	B	TAG57
TAG56:	ADD	BX,38
TAG57:	CMP	BYTE PTR [BX],' '	;LOOK FOR EMPTY SLOT.
	BNE	TAG56
	MOVL	BX,PDATE,8
	MOVL	BX+19,WORK2+1,8
TAG58:	BLANK	STRING1,35
	BLANK	WORK1,19
	MOVL	WORK1+1,M6PTDAT,8	;PAYMENTS TO DATE.
	CALL	SUBR10			;ALIGN AMOUNT.
	PACK	WORK5,WORK2
	APK	WORK4,WORK5,WORK6
	BLANK	WORK1,19
	UNPK	WORK1,WORK6
	CALL	SUBR10
	MOVL	M6PTDAT,WORK2+1,8
	CMP	M6PAR,'P'
	BNE	TAG59			;BRANCH IF NON-PARTICIPATING.
	MOVL	WORK1+1,M6BAL,8		;BALANCE DUE.
	CALL	SUBR10
	PACK	WORK5,WORK2
	SPK	WORK5,WORK4,WORK6
	BLANK	WORK1,19
	UNPK	WORK1,WORK6
	CALL	SUBR10
	MOVL	M6BAL,WORK2+1,8
TAG59:	SETMAP	MAP6
	MAPOUT
	SHIP	4,73,RECNBR
	B	TAG6
;
;****************************************
; R E S E T   C O N T R O L   R E C O R D
;
TAG60:	MOVL	STRING1+2,K300,4
	CALL	SUBR6			;CONVERT TO CBRN FORMAT.
	SETCBRN	FILE2,CBRN		;START SCAN AT RECORD 300.
	MOV	CX,150			;SET 1ST SHIFT FOR NO HIT.
	GET	FILE2,MRECORD,512,ERROR6
	CMP	MRECORD,0FFH		;CHECK FOR EMPTY SLOT.
	BNE	TAG61
	CALL	SUBR15			;SHIFT CBRN DOWN 150.
	JMP	TAG62
TAG61:	CALL	SUBR14			;SHIFT CBRN UP 150.
TAG62:	MOV	CX,75			;SET 2ND SHIFT FOR NO HIT.
	GET	FILE2,MRECORD,512,ERROR6
	CMP	MRECORD,0FFH
	BNE	TAG63
	CALL	SUBR15			;SHIFT CBRN DOWN 75.
	JMP	TAG64
TAG63:	CALL	SUBR14			;SHIFT CBRN UP 75.
TAG64:	MOV	CX,37
	GET	FILE2,MRECORD,512,ERROR6
	CMP	MRECORD,0FFH
	BNE	TAG65
	CALL	SUBR15			;SHIFT CBRN DOWN 37.
	JMP	TAG66
TAG65:	CALL	SUBR14			;SHIFT CBRN UP 37.
TAG66:	MOV	CX,19
	GET	FILE2,MRECORD,512,ERROR6
	CMP	MRECORD,0FFH
	BNE	TAG67
	CALL	SUBR15			;SHIFT CBRN DOWN 19.
	JMP	TAG68
TAG67:	CALL	SUBR14			;SHIFT CBRN UP 19.
TAG68:	MOV	CX,10
	GET	FILE2,MRECORD,512,ERROR6
	CMP	MRECORD,0FFH
	BNE	TAG69
	CALL	SUBR15			;SHIFT CBRN DOWN 10.
	JMP	TAG70
TAG69:	CALL	SUBR14			;SHIFT CBRN UP 10.
TAG70:	MOV	CX,5
	GET	FILE2,MRECORD,512,ERROR6
	CMP	MRECORD,0FFH
	BNE	TAG71
	CALL	SUBR15			;SHIFT CBRN DOWN 5.
	JMP	TAG72
TAG71:	CALL	SUBR14			;SHIFT CBRN UP 5.
TAG72:	GET	FILE2,MRECORD,512,ERROR6
	CMP	MRECORD,0FFH
	BE	TAG74			;SCAN BACKWARDS.
;
; SCAN FORWARDS
;
TAG73:	INCCBRN	CBRN
	SETCBRN	FILE2,CBRN
	GET	FILE2,MRECORD,512,ERROR6
	CMP	MRECORD,0FFH
	BNE	TAG73			;SCAN TO 1ST EMPTY SLOT.
	JMP	TAG75
;
; SCAN BACKWARDS
;
TAG74:	DECCBRN	CBRN
	SETCBRN	FILE2,CBRN
	GET	FILE2,MRECORD,512,ERROR6
	CMP	MRECORD,0FFH
	BE	TAG74			;SCAN TO 1ST FILLED SLOT.
	INCCBRN	CBRN			;RESET TO 1ST EMPTY SLOT.
;
TAG75:	MOVL	RESTART,CBRN,3		;UPDATE CONTROL RECORD CBRN.
	CALL	SUBR12			;CONVERT TO DISPLAY FORMAT.
	MOVL	CRECORD,RECNBR,4	;INSERT INTO CONTROL RECORD.
	MOVL	MSG32+44,RECNBR,4
	DECCBRN	CBRN
	CALL	SUBR12
	MOVL	CRECORD+5,RECNBR,4	;INSERT PREV RECORD NBR.
	MOV	CRECORD+4,'$'		;RESTORE DELIMITERS.
	MOV	CRECORD+9,'$'
	SHIP	24,1,MSG32		;ADVISE COMMAND COMPLETED.
	JMP	KBCTL			;AWAIT NEXT COMMAND.
;
MAIN	ENDP
	PAGE
;********************************************
; P E R F O R M E D   S U B R O U T I N E S *
;********************************************
; MOVE MAPPED DATA TO MASTER RECORD
;
SUBR1	PROC	NEAR
	CMP	M6NAME,'#'	;FORCE NAME CHANGE?
	BE	SRT1X
	CMP	NFLAG,'+'
	BE	SRT1B		;DONT PROCESS NAME FOR OLD MASTER.
	CMP	M6NAME,'*'
	BE	SRT1A
	MOVL	MRLNAME,M6NAME,28	;MOVE NAME AS IS.
	MOV	MRECORD,' '		;POST NAME AS UNSTRUCTURED.
	B	SRT1B
SRT1X:	MOV	M6NAME,'*'
SRT1A:	CALL	SUBR2			;DE-STRUCTURE NAME.
SRT1B:	MOVL	MRSTRET,M6STRET,30
	MOVL	MRCITY,M6CITY,15
	MOVL	MRSTATE,M6STATE,2
	MOVL	MRZIP,M6ZIP,5
	MOV	AL,M6STAT		;FILE STATUS.
	MOV	MRSTAT,AL
	MOV	AL,M6PAR		;PARTICIPATION CODE.
	MOV	MRPAR,AL
	CDATE	MRDATEP,M6DATEP		;DATE OF PLEDGE.
	MOV	AL,M6PAYPL		;PAYMENT PLAN CODE.
	MOV	MRPAYPL,AL
	MOVL	MRPYAMT,M6PYAMT,8	;AMT OF PAYMENT.
	MOVL	MRAMTPL,M6AMTPL,8	;AMT OF PLEDGE.
	MOVL	MRPDWPL,M6PDWPL,8	;PAID WITH PLEDGE.
	MOVL	MRPTDAT,M6PTDAT,8	;PAYMENTS TO DATE.
	MOVL	MRBAL,M6BAL,8		;REMAINING BALANCE.
	CDATE	MRPDT1,M6PDT1		;PAYMENT 1 DATE.
	MOVL	MRPAM1,M6PAM1,8		;PAYMENT 1 AMOUNT.
	CDATE	MRPDT2,M6PDT2
	MOVL	MRPAM2,M6PAM2,8
	CDATE	MRPDT3,M6PDT3
	MOVL	MRPAM3,M6PAM3,8
	CDATE	MRPDT4,M6PDT4
	MOVL	MRPAM4,M6PAM4,8
	CDATE	MRPDT5,M6PDT5
	MOVL	MRPAM5,M6PAM5,8
	CDATE	MRPDT6,M6PDT6
	MOVL	MRPAM6,M6PAM6,8
	CDATE	MRPDT7,M6PDT7
	MOVL	MRPAM7,M6PAM7,8
	CDATE	MRPDT8,M6PDT8
	MOVL	MRPAM8,M6PAM8,8
	CDATE	MRPDT9,M6PDT9
	MOVL	MRPAM9,M6PAM9,8
	CDATE	MRPDT10,M6PDT10
	MOVL	MRPAM10,M6PAM10,8
	CDATE	MRPDT11,M6PDT11
	MOVL	MRPAM11,M6PAM11,8
	CDATE	MRPDT12,M6PDT12
	MOVL	MRPAM12,M6PAM12,8
	CDATE	MRPDT13,M6PDT13
	MOVL	MRPAM13,M6PAM13,8
	CDATE	MRPDT14,M6PDT14
	MOVL	MRPAM14,M6PAM14,8
	CDATE	MRPDT15,M6PDT15
	MOVL	MRPAM15,M6PAM15,8
	CDATE	MRPDT16,M6PDT16
	MOVL	MRPAM16,M6PAM16,8
	CDATE	MRPDT17,M6PDT17
	MOVL	MRPAM17,M6PAM17,8
	CDATE	MRPDT18,M6PDT18
	MOVL	MRPAM18,M6PAM18,8
	CDATE	MRPDT19,M6PDT19
	MOVL	MRPAM19,M6PAM19,8
	CDATE	MRPDT20,M6PDT20
	MOVL	MRPAM20,M6PAM20,8
	CDATE	MRPDT21,M6PDT21
	MOVL	MRPAM21,M6PAM21,8
	CDATE	MRPDT22,M6PDT22
	MOVL	MRPAM22,M6PAM22,8
	CDATE	MRPDT23,M6PDT23
	MOVL	MRPAM23,M6PAM23,8
	CDATE	MRPDT24,M6PDT24
	MOVL	MRPAM24,M6PAM24,8
	CDATE	MRNDT1,M6NDT1		;NOTIFICATION 1 DATE.
	MOV	AL,M6NMSG1
	MOV	MRNMSG1,AL		;NOTIFICATION 1 CODE.
	CDATE	MRNDT2,M6NDT2
	MOV	AL,M6NMSG2
	MOV	MRNMSG2,AL
	CDATE	MRNDT3,M6NDT3
	MOV	AL,M6NMSG3
	MOV	MRNMSG3,AL
	CDATE	MRNDT4,M6NDT4
	MOV	AL,M6NMSG4
	MOV	MRNMSG4,AL
	CDATE	MRNDT5,M6NDT5
	MOV	AL,M6NMSG5
	MOV	MRNMSG5,AL
	CDATE	MRNDT6,M6NDT6
	MOV	AL,M6NMSG6
	MOV	MRNMSG6,AL
	RET
SUBR1	ENDP
;
;******************
; STRUCTURE NAME
;
SUBR2	PROC	NEAR
	MOV	MRECORD,'*'
	BLANK	MRLNAME,16
	BLANK	MRFNAME,12
	MOV	SI,0
	MOV	DI,0
	MOV	CX,28
SRT2A:	MOV	AL,[M6NAME+SI+1]
	MOV	[MRLNAME+DI],AL
	INC	SI
	INC	DI
	DEC	CX
	CMP	CX,0
	BE	SRT2D
	CMP	[M6NAME+SI+1],','
	BNE	SRT2A
	MOV	DI,0
SRT2B:	INC	SI
	DEC	CX
	CMP	CX,0
	BE	SRT2D
	CMP	[M6NAME+SI+1],' '
	BE	SRT2B
SRT2C:	MOV	AL,[M6NAME+SI+1]
	MOV	[MRFNAME+DI],AL
	INC	DI
	INC	SI
	DEC	CX
	CMP	DI,12
	BNLL	SRT2D
	CMP	SI,28
	BNLL	SRT2D
	CMP	CX,0
	BNE	SRT2C
SRT2D:	RET
SUBR2	ENDP
;
;**************************************
; MOVE DATA FROM RECORD TO MAPPING AREA
;
SUBR3	PROC	NEAR
	MOV	NFLAG,' '
	CMP	MRECORD,'*'		;CHECK FOR STRUCTURED NAME.
	BE	SRT3A
	MOVL	M6NAME,MRLNAME,28	;MOVE NAME AS IS.
	B	SRT3B
SRT3A:	CALL	SUBR5			;RESTRUCTURE NAME.
SRT3B:	MOV	NFLAG,'+'		;SET 'DONT UPDATE NAME' FLAG.
	MOVL	M6STRET,MRSTRET,30
	MOVL	M6CITY,MRCITY,15
	MOVL	M6STATE,MRSTATE,2
	MOVL	M6ZIP,MRZIP,5
	CMP	MRSTAT,'A'
	BE	SRT3C
	CMP	MRSTAT,'I'
	BE	SRT3D
	CMP	MRSTAT,'D'
	BE	SRT3E
	MOV	M6STAT,'?'
	B	SRT3F
SRT3C:	MOVL	M6STAT,LITB,6		;ACTIVE.
	B	SRT3F
SRT3D:	MOVL	M6STAT,LIT1,8		;INACTIVE.
	B	SRT3F
SRT3E:	MOVL	M6STAT,LIT2,7		;DELETED.
SRT3F:	CMP	MRPAR,'P'
	BE	SRT3G
	CMP	MRPAR,'C'
	BE	SRT3H
	MOV	M6PAR,'?'
	B	SRT3I
SRT3G:	MOVL	M6PAR,LITF,6		;PLEDGE.
	B	SRT3I
SRT3H:	MOVL	M6PAR,LIT3,6		;CASUAL.
SRT3I:	XDATE	M6DATEP,MRDATEP
	CMP	MRPAYPL,'W'
	BE	SRT3J
	CMP	MRPAYPL,'M'
	BE	SRT3K
	CMP	MRPAYPL,'Q'
	BE	SRT3L
	CMP	MRPAYPL,'S'
	BE	SRT3M
	CMP	MRPAYPL,'A'
	BE	SRT3N
	MOVL	M6PAYPL,LIT9,5		;OTHER.
	B	SRT3O
SRT3J:	MOVL	M6PAYPL,LIT4,6		;WEEKLY.
	B	SRT3O
SRT3K:	MOVL	M6PAYPL,LIT5,7		;MONTHLY.
	B	SRT3O
SRT3L:	MOVL	M6PAYPL,LIT6,9		;QUARTERLY.
	B	SRT3O
SRT3M:	MOVL	M6PAYPL,LIT7,11		;SEMI-ANNUAL.
	B	SRT3O
SRT3N:	MOVL	M6PAYPL,LIT8,8		;ANNUALLY.
SRT3O:	MOVL	M6PYAMT,MRPYAMT,8	;PAYMENT AMT.
	MOVL	M6AMTPL,MRAMTPL,8	;AMT OF PLEDGE.
	MOVL	M6PDWPL,MRPDWPL,8	;AMT PAID WITH PLEDGE.
	MOVL	M6PTDAT,MRPTDAT,8	;AMT PAID TO DATE.
	MOVL	M6BAL,MRBAL,8		;BALANCE DUE.
	XDATE	M6PDT1,MRPDT1		;PAYMENT 1 DATE.
	MOVL	M6PAM1,MRPAM1,8		;PAYMENT 1 AMOUNT.
	XDATE	M6PDT2,MRPDT2
	MOVL	M6PAM2,MRPAM2,8
	XDATE	M6PDT3,MRPDT3
	MOVL	M6PAM3,MRPAM3,8
	XDATE	M6PDT4,MRPDT4
	MOVL	M6PAM4,MRPAM4,8
	XDATE	M6PDT5,MRPDT5
	MOVL	M6PAM5,MRPAM5,8
	XDATE	M6PDT6,MRPDT6
	MOVL	M6PAM6,MRPAM6,8
	XDATE	M6PDT7,MRPDT7
	MOVL	M6PAM7,MRPAM7,8
	XDATE	M6PDT8,MRPDT8
	MOVL	M6PAM8,MRPAM8,8
	XDATE	M6PDT9,MRPDT9
	MOVL	M6PAM9,MRPAM9,8
	XDATE	M6PDT10,MRPDT10
	MOVL	M6PAM10,MRPAM10,8
	XDATE	M6PDT11,MRPDT11
	MOVL	M6PAM11,MRPAM11,8
	XDATE	M6PDT12,MRPDT12
	MOVL	M6PAM12,MRPAM12,8
	XDATE	M6PDT13,MRPDT13
	MOVL	M6PAM13,MRPAM13,8
	XDATE	M6PDT14,MRPDT14
	MOVL	M6PAM14,MRPAM14,8
	XDATE	M6PDT15,MRPDT15
	MOVL	M6PAM15,MRPAM15,8
	XDATE	M6PDT16,MRPDT16
	MOVL	M6PAM16,MRPAM16,8
	XDATE	M6PDT17,MRPDT17
	MOVL	M6PAM17,MRPAM17,8
	XDATE	M6PDT18,MRPDT18
	MOVL	M6PAM18,MRPAM18,8
	XDATE	M6PDT19,MRPDT19
	MOVL	M6PAM19,MRPAM19,8
	XDATE	M6PDT20,MRPDT20
	MOVL	M6PAM20,MRPAM20,8
	XDATE	M6PDT21,MRPDT21
	MOVL	M6PAM21,MRPAM21,8
	XDATE	M6PDT22,MRPDT22
	MOVL	M6PAM22,MRPAM22,8
	XDATE	M6PDT23,MRPDT23
	MOVL	M6PAM23,MRPAM23,8
	XDATE	M6PDT24,MRPDT24
	MOVL	M6PAM24,MRPAM24,8
	XDATE	M6NDT1,MRNDT1		;NOTIFICATION 1 DATE.
	MOV	AL,MRNMSG1
	MOV	M6NMSG1,AL		;NOTFICATION 1 CODE.
	XDATE	M6NDT2,MRNDT2
	MOV	AL,MRNMSG2
	MOV	M6NMSG2,AL
	XDATE	M6NDT3,MRNDT3
	MOV	AL,MRNMSG3
	MOV	M6NMSG3,AL
	XDATE	M6NDT4,MRNDT4
	MOV	AL,MRNMSG4
	MOV	M6NMSG4,AL
	XDATE	M6NDT5,MRNDT5
	MOV	AL,MRNMSG5
	MOV	M6NMSG5,AL
	XDATE	M6NDT6,MRNDT6
	MOV	AL,MRNMSG6
	MOV	M6NMSG6,AL
	LEA	BX,M6NMSG1
	MOV	CX,6
	B	SRT3Q
SRT3P:	ADD	BX,36
	DEC	CX
	CMP	CX,0
	BE	SRT3R
SRT3Q:	CMP	BYTE PTR [BX],' '
	BE	SRT3R
	CMP	BYTE PTR [BX],'O'
	BNE	SRT3P
	MOVL	BX,LIT10,4		;OOPS NOTICE.
	B	SRT3P
SRT3R:	RET
SUBR3	ENDP
;
;************************************
; UPDATE RECORD NUMBER DISPLAY FIELDS
;
SUBR4	PROC	NEAR
	MOVL	RECNBR,CRECORD,4	;EXTRACT NEXT NBR.
	MOVL	CRECORD+5,RECNBR,4	;UPDATE PREVIOUS.
	MOVL	WORK1+1,RECNBR,4
	MOV	WORK1,04H
	PACK	WORK4,WORK1
	APK	WORK4,PD1,WORK4
	BLANK	WORK2,19
	UNPK	WORK2,WORK4
SRT4A:	CMP	WORK2+4,' '
	BNE	SRT4B
	MOV	AL,WORK2+3
	MOV	WORK2+4,AL
	MOV	AL,WORK2+2	;RIGHT SHIFT, LEFT ZERO-FILL.
	MOV	WORK2+3,AL
	MOV	AL,WORK2+1
	MOV	WORK2+2,AL
	MOV	WORK2+1,'0'
	B	SRT4A
SRT4B:	MOVL	CRECORD,WORK2+1,4
	RET
SUBR4	ENDP
;
;**********************************
; R E - S T R U C T U R E   N A M E
;
SUBR5	PROC	NEAR
	MOV	NFLAG,'+'
	MOVL	M6NAME,MRFNAME,12
	MOV	SI,24
SRT5A:	DEC	SI
	CMP	[M6NAME+SI],' '
	BE	SRT5A
	ADD	SI,2
	MOV	CX,16
	MOV	DI,0
SRT5B:	MOV	AL,[MRLNAME+DI]
	MOV	[M6NAME+SI],AL
	INC	SI
	INC	DI
	DEC	CX
	CMP	CX,0
	BNE	SRT5B
	RET
SUBR5	ENDP
;
;******************************************************
; GENERATE CURRENT BLOCK & RECORD NBR FOR DIRECT ACCESS
;
SUBR6	PROC	NEAR
	BLANK	WORK1,19
	MOVL	WORK1+1,STRING1+2,4
SRT6A:	CMP	WORK1+4,' '
	BNE	SRT6B
	MOV	AL,WORK1+3
	MOV	WORK1+4,AL
	MOV	AL,WORK1+2
	MOV	WORK1+3,AL	;RIGHT ALIGN, LEFT ZERO FILL.
	MOV	AL,WORK1+1
	MOV	WORK1+2,AL
	MOV	WORK1+1,'0'
	B	SRT6A	
SRT6B:	MOV	WORK1,04H
	MOVL	RECNBR,WORK1+1,4        ;LOAD DISPLAY FIELD.
	PACK	WORK4,WORK1
	MOVL	WORK10,DDZERO,4
	CVB	WORK10,WORK4		;MAINFRAME FORMAT.
	MOV	AX,WORD PTR WORK10+2
	XCHG	AH,AL			;CONVERT TO PC FORMAT.
	MOV	BNBR,AX
	GENCBRN	CBRN,BNBR		;GENERATE CBRN KEY.
	RET
SUBR6	ENDP
;
;**********************
; BUILD SEARCH ARGUMENT
;
SUBR7	PROC	NEAR
	BLANK	SRCHARG,26
	MOV	SLEN,26		;SET SCAN LENGTH.
	MOV	DI,0
	MOV	SI,0
	B	SRT7B
SRT7A:	INC	SI
	CMP	[STRING1+3+SI],','	;CHECK DELIMITER.
	BE	SRT7C
	CMP	SI,26
	BNLL	SRT7F
SRT7B:	MOV	AL,[STRING1+3+SI]
	MOV	[SRCHARG+DI],AL
	INC	DI
	CMP	DI,26
	BNLL	SRT7F
	B	SRT7A
SRT7C:	INC	SI
	CMP	SI,26
	BNLL	SRT7F
	CMP	[STRING1+3+SI],' '
	BE	SRT7C
	MOV	DI,16
	B	SRT7E
SRT7D:	INC	SI
	CMP	SI,26
	BNLL	SRT7F
SRT7E:	MOV	AL,[STRING1+3+SI]
	MOV	[SRCHARG+DI],AL
	INC	DI
	CMP	DI,26
	BNLL	SRT7F
	B	SRT7D
SRT7F:	RET
SUBR7	ENDP
;
;***************************************
; COMPARE SEARCH ARGUMENT TO INDEX ENTRY
;
SUBR8	PROC	NEAR
	CMPL	SRCHARG,BX,SLEN
	BC	HI,SRT8A
	BC	LO,SRT8B
	B	SRT8C
SRT8A:	MOV	HITFLAG,'H'
	B	SRT8D
SRT8B:	MOV	HITFLAG,'L'
	B	SRT8D
SRT8C:	MOV	HITFLAG,'E'
SRT8D:	RET
SUBR8	ENDP
;
;****************************
; BUILD SHORT SEARCH ARGUMENT
;
SUBR9	PROC	NEAR
	BLANK	SRCHARG,26
	MOV	SLEN,16
	MOV	SI,0
	B	SRT9B
SRT9A:	INC	SI
	CMP	SI,16
	BNLL	SRT9C
SRT9B:	MOV	AL,[STRING1+3+SI]
	CMP	AL,','
	BE	SRT9C
	MOV	[SRCHARG+SI],AL
	B	SRT9A
SRT9C:	RET
SUBR9	ENDP
;
;*********************
; ALIGN PAYMENT AMOUNT
;
SUBR10	PROC	NEAR
	B	SRT10A
SRT10X:	MOV	WORK1+1,'0'	;LEFT ZERO FILL.
SRT10A:	CMP	WORK1+8,' '
	BNE	SRT10C
	MOV	SI,7		;BEGIN RIGHT JUSTIFICATION.
SRT10B:	MOV	AL,[WORK1+SI]
	MOV	[WORK1+SI+1],AL
	DEC	SI
	CMP	SI,0
	BE	SRT10X
	B	SRT10B
SRT10C:	MOV	SI,1
SRT10D:	CMP	[WORK1+SI],'.'	;CHECK EMBEDDED DECIMAL POINT.
	BE	SRT10E
	INC	SI
	CMP	SI,9
	BLL	SRT10D
	MOVL	WORK1+9,LITG,3	;FORCE CENTS PORTION.
	MOVL	WORK2+1,WORK1+4,8
	B	SRT10F
SRT10E:	MOVL	WORK2+1,WORK1+1,8
SRT10F:	MOV	WORK2,08H	;SET LENGTH KEY.
	RET
SUBR10	ENDP
;
;****************************************
; R O L L   P A Y M E N T   H I S T O R Y
;
SUBR11	PROC	NEAR
	MOV	CL,23
	LEA	BX,M6PDT1
	LEA	BP,M6PDT2
	B	SRT11B
SRT11A:	ADD	BX,38
	ADD	BP,38
SRT11B:	MOVLR	BX,BP,8
	DEC	CL
	CMP	CL,1
	BNLA    SRT11A
	BLANK	M6PDT24,8
	MOV	CL,23
	LEA	BX,M6PAM1
	LEA	BP,M6PAM2
	B	SRT11D
SRT11C:	ADD	BX,38
	ADD	BP,38
SRT11D:	MOVLR	BX,BP,8
	DEC	CL
	CMP	CL,1
	BNLA    SRT11C
	BLANK	M6PAM24,8
	RET
SUBR11	ENDP
;
;**************************************
; CONVERT CBRN TO DISPLAY RECORD NUMBER
;
SUBR12	PROC	NEAR
	GENRNBR	WORK11,CBRN
	MOV	AX,WORK11
	XCHG	AH,AL
	MOV	WORD PTR WORK10+2,AX
	CVD	WORK4,WORK10
	BLANK	WORK1,19
	UNPK	WORK1,WORK4
	CALL	SUBR10
	MOVL	RECNBR,WORK2+2,4
	RET
SUBR12	ENDP
;
;****************************
; ADD ENTRY TO OVERFLOW INDEX
;
SUBR13	PROC	NEAR
	MOVL	SRCHARG,MRLNAME,26
	MOVL	SRCHARG+26,CRECORD+5,4
	LEA	BX,OVRINDX
	B	SRT13B
SRT13A:	ADD	BX,32
SRT13B:	CMP	BYTE PTR [BX],0FFH
	BE	SRT13C
	B	SRT13A
SRT13C:	MOVL	BX,SRCHARG,32
	RET
SUBR13	ENDP
;
;*****************************
; SHIFT FILE2 CBRN UP CX TIMES
;
SUBR14	PROC	NEAR
	GETCBRN	FILE2,CBRN
SRT14A:	INCCBRN CBRN
	DEC	CX
	CMP	CX,0
	BNE	SRT14A
	SETCBRN	FILE2,CBRN
	RET
SUBR14	ENDP
;
;*******************************
; SHIFT FILE2 CBRN DOWN CX TIMES
;
SUBR15	PROC	NEAR
	GETCBRN	FILE2,CBRN
SRT15A:	DECCBRN	CBRN
	DEC	CX
	CMP	CX,0
	BNE	SRT15A
	SETCBRN	FILE2,CBRN
	RET
SUBR15	ENDP
;
;*****************************************************************
CODESG	ENDS
	END	BEGIN
