MUL_F    PROC     NEAR
;***************************************************************
;                        floating point
;                    multiplication routine
;***************************************************************
         PUSH     SI              ;save index registers
         PUSH     DI
         SUB      DX,DX           ;clear work registers
         MOV      AX,DX
         MOV      BX,DX
         MOV      CX,DX
;                            check for zero operand
         OR       DX,[DI]+2       ;OP1 high word in DX
         JZ       MF2             ;zero only if operand is 0
         OR       CX,[SI]+2       ;OP2 high word in CX
         JZ       MF2
;                            compute exponent
         MOV      AL,DH           ;E1 in AX
         MOV      BL,CH           ;E2 in BX
         SUB      BX,128          ;subtract bias
         ADD      AX,BX           ;E=E1+E2+bias
;
         MOV      BX,[SI]         ;get OP2 low word in BX
         MOV      SI,AX           ;save exponent in SI
         MOV      AX,[DI]         ;get OP1 low word in AX
         SUB      DH,DH           ;clear high bytes
         MOV      CH,DH           ;M1 is DL:AX; M2 is CL:BX
;                            compute result sign
         MOV      DI,DX
         XOR      DI,CX
         AND      DI,10000000B    ;isolate sign bit in DI
;                            restore leading ones
         OR       DL,10000000B
         OR       CL,10000000B
;                            multiply mantissas
         CALL     MUL32           ;47-48 bit product in AX:CX:BX
;
         OR       AX,AX           ;is it normalized?
         JS       MF1
;                            normalize product
         SHL      BX,1            ;shift it left 1
         RCL      CX,1
         RCL      AX,1
         SUB      SI,1            ;and decrement exponent
;                            check for overflow
MF1:     CMP      SI,255
         JG       MF3             ;exit if exponent > 255
;                            check for underflow
         CMP      SI,0
         JLE      MF4             ;exit if exponent <= 0
;                            reformat for output
         MOV      DL,AH           ;mantissa in DL:AX
         MOV      AH,AL
         MOV      AL,CH
         MOV      DH,CL           ;trailing bits in DH
         MOV      CX,BX           ;and CX
         MOV      BX,SI           ;exponent in BH
         MOV      BH,BL
         JMP      R0              ;ROUND in addition routine
MF2:     JMP      FINISH
MF3:     JMP      OVER_F
MF4:     JMP      UNDER_F
MUL_F    ENDP