Title   M
Page    80,132
Code    Segment
;
; For MASM 4.0
;
        Org     100h
Assume  cs:code,ds:code
m:      call    bgn             ; Print banner, init storage
        call    hdr             ; Result AX --> 1st MCB blk
        call    str             ; Save data on PSP,Size,Seg
        call    srt             ; Sort data on PSP order
        call    lst             ; List data on terminal
        ret                     ; End of storage chain
;
bgn:    lea     dx,banner       ; DX --> banner
        mov     ah,9
        int     21h             ;  ...print it
        lea     di,banner
        mov     cx,SEGSIZ       ; SEGSIZ = banner size
        xor     ax,ax
        rep     stosb
        ret
;
hdr:    mov     ah,52h          ; Point to DOS variable
        int     21h             ;  ...area
        sub     bx,2            ; Get storage anchor
        mov     ax,es:[bx]      ;  ...get storage base
        ret
;
str:    mov     es,ax           ; Get base of storage block
        mov     ax,es:1
        or      ax,ax           ; Is there a PSP?
        je      str5            ;  ...no, unused block
        lea     bx,seglst       ; bx --> seglst
;
str0:   cmp     [bx],ax         ; This entry?
        je      str1            ;  ...this entry, update size, inc seg count
        cmp     word ptr [bx],0 ; New entry?
        je      str1            ;  ...yes, create 5 bytes as per next line
        add     bx,5            ; 2 bytes PSP, 2 bytes size, 1 byte seg count
        jmp     str0
;
str1:   mov     [bx],ax         ; Store (same) PSP
        mov     ax,es:3         ; Get size in segments
        add     [bx+2],ax       ;  ...add in seg size
        inc     byte ptr [bx+4] ; One more segment
;
str5:   mov     ax,es           ; Load base in segments
        add     ax,es:3         ; Add length in segments
        inc     ax              ;  ...add one more for MCB
        cmp   byte ptr es:0,"Z" ; End of chain, quit
        jne     str             ;  ...no, continue storing
done:   ret
;
srt:    lea     bx,seglst       ; Yes, bubble sort on PSP
srt1:   mov     ax,[bx+5]       ; Get next PSP
        or      ax,ax           ;  ...done
        je      done            ;  ...yes
        cmp     [bx],ax         ; This PSP less than next one
        ja      swp             ;  ...no, do exchange
        add     bx,5            ; Else check next PSP
        jmp     srt1            ;  ...continue

swp:    xor     si,si           ; secondary register
;
swp1:   mov     al,[bx+si]
        mov     ah,[bx+si+5]
        mov     [bx+si],ah
        mov     [bx+si+5],al
        inc     si
        cmp     si,5
        jb      swp1
        jmp     srt             ; Still more sorting to do
;
lst:    lea     bx,seglst       ;  ...print out stored results
lst1:   cmp     word ptr [bx],0 ;  ...done?
        je      done            ; Punt if so
        call    status          ;  ...else print program status
        add     bx,5            ;  ...get next program entry
        jmp     lst1            ;  ...continue
;
status: mov     bp,[bx]         ; Get address of PSP
        call    number          ;  ...octal
        mov     bp,3            ; Get number of spaces
        call    spc             ;  ...do it
        mov     al,[bx+4]       ; Get number of segments
        add     al,"0"          ;  ...convert to decimal
        call    out
        mov     bp,4
        call    spc
        mov     bp,[bx+2]       ; Size of segment(s)
        call    dec             ;  ...decimal
        mov     bp,5            ; Number of spaces
        call    spc             ;  ...do it
        mov     bp,26           ; Allow 26 spaces
        call    name            ; Name of caller
        call    spc             ;  ...pad
        call    comand          ; Get command line
        call    crlf            ;  ...new line
        ret                     ;  ...back to caller
;
number: push    ax
        push    cx
        push    dx
        mov     cx,4
again:  rol     bp,1
        rol     bp,1
        rol     bp,1
        rol     bp,1
        mov     ax,bp
        and     al,0Fh
        add     al,"0"
        cmp     al,"9"
        jbe     yok
        add     al,"A"-"9"-1
yok:    call    out
        loop    again
        pop     dx
        pop     cx
        pop     ax
        ret
;
dec:    push    ax
        push    bx
        push    cx
        push    dx
        lea     bx,table
        mov     cx,5
        mov     dx,bp
        mov     zero,0                  ; Leading zero flag
digit:  mov     ax,dx
        xor     dx,dx
        div     word ptr [bx]
        add     bx,2
        or      zero,al
        je      blank
        add     al,"0"
print:  call    out
        loop    digit
        pop     dx
        pop     cx
        pop     bx
        pop     ax
        ret
;
blank:  mov     al," "
        jmp     print
;
table   dw      10000,1000,100,10,1
zero    db      0
;
crlf:   push    ax                      ; Generate a new line
        mov     al,13
        call    out
        mov     al,10
        call    out
        pop     ax
        ret
;
name:   push    es                      ; Try to get program name
        push    ax
        push    bx
        push    di
        mov     ax,[bx]                 ; Get PSP address
        dec     ax
        mov     es,ax                   ; ES = MCB address
        inc     ax                      ; Restore PSP address
        cmp     es:1,ax                 ; PSP immediately follow MCB?
        jne     noname                  ; Punt, weird PSP (IO.SYS or DOS.SYS)
        mov     es,ax                   ; ES = PSP address
        mov     ax,es:2Ch               ; Get environment segment
        or      ax,ax                   ;  ...does it exist
        je      noname                  ; Punt, no
        dec     ax                      ;  ...Environment has its own MCB
        mov     es,ax                   ; ES = MCB address
        mov     di,es:1                 ;  ...is it our PSP in the MCB?
        cmp     [bx],di                 ;  ...Our PSP must own environment
        jne     noname                  ; Punt, wrong PSP in environment MCB
        inc     ax                      ;  ...we own environment, get PSP
        mov     es,ax                   ; ES = Environment Segment
        xor     di,di                   ; Prepare to scan environment
        cld                             ;  ...forwards
        mov     al,0                    ;  ...look for nul
l:      scasb                           ; We want to find
        jne     l
        scasb                           ; Two successive null bytes
        jne     l
        scasw                           ; Skip next word
;
ll:     mov     al,es:[di]              ; Program path starts here
        inc     di
        or      al,al
        je      noname                  ; Punt, null at end of name
        call    outuc                   ;  ...print in upper case
        dec     bp                      ;  ...show one space used
        je      noname                  ;  ...format field overflow
        jmp     ll                      ;  ...else get next char
;
noname: pop     di                      ; Common exit, BP has unused spaces
        pop     bx
        pop     ax
        pop     es
        ret
;
comand: push    ds                      ; Try to get the command
        push    cx
        push    ax
        push    si
        mov     ds,[bx]                 ; Load the PSP
        mov     si,80h                  ;  ...counted parameters start here
        lodsb                           ; Load count byte
        mov     cl,al
        mov     ch,0                    ; CX = count
        jcxz    com1                    ;  ...no arguments
        cmp     byte ptr [si]," "       ;  ...must begin with leading blank
        jne     com1                    ; Punt, command portion recycled
;
com:    lodsb                           ; Get character
        call    outuc                   ;  ...print upper case
        loop    com                     ;  ...until done
;
com1:   pop     si                      ; Common exit
        pop     ax
        pop     cx
        pop     ds
        ret
;
outuc:  push    ax                      ; Print char in upper case
        and     al,127                  ;  ...no parity
        cmp     al,"a"
        jb      outuc1                  ; OK, already upper case
        sub     al,"a"-"A"              ;  ...else make upper case
outuc1: call    out                     ; Print character
        pop     ax
        ret
;
out:    push    ax                      ; Print/save char in AL
        push    dx
        mov     dl,al
        mov     ah,2
        int     21h
        pop     dx
        pop     ax
        ret
;
spc:    push    ax                      ; BP has number of spaces to print
        or      bp,bp
        je      spc2
spc1:   mov     al," "
        call    out
        dec     bp
        jne     spc1
spc2:   pop     ax
        ret
;
seglst  label   byte
;
banner  db      "PSP   blks Segments   Program"
        db      "                    Command Line",13,10
        db      "----  ---- --------   -------"
        db      "                    ------------",13,10,"$"
SEGSIZ  =$-seglst                       ;  Size to clear
code    ends
end     M
