;key_code.asm
;assemble and link as key_code.exe
;writes a key's scan code and ascii code in hex to the screen
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
; Downloaded from:
;       Professional Programmers' Pages
;        http://www.fys.ruu.nl/~faber
;
; But all credits go to :
;                 Robert Ree
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
              .model small                  ;
              .stack                        ;
              .data                         ;
programmer    db  "Robert Ree"              ;

vid_seg       dw  0b800h                    ;vga is default
reg_attr      db  07h                       ;white on black
attr_1        db  0dh                       ;bright magenta on black
attr_2        db  0eh                       ;bright yellow  on black
key_buffer    db  6 dup (?)                 ;2+(SPACE)+2+(ZERO)
header_msg    db  "AH AL",0                 ;
xit_msg       db  "Control+Break to Exit!",0;

screen_pos_1  equ 160                       ;AH AL header message location
screen_pos_2  equ 320                       ;video offset for key codes to write

              .code
prog_start:   mov  ax,@data                 ;
              mov  ds,ax                    ;

              push ds                       ;save data segment for a moment
              mov  ax,40h                   ;
              mov  ds,ax                    ;point to bios segment
              cmp  word ptr ds:[63h],03b4h  ;do people still have mono?
              pop  ds                       ;retrieve data segment now
              mov  al,2                     ;(preload with vga 80x25 video mode)
              jne  assume_vga               ;if not, assume color

;change defaults to mono values

              sub  [vid_seg],800h           ;go for b&w
              mov  [reg_attr],7             ;and bw screen attributes
              mov  [attr_1],70h             ;b&W reverse attrute
              mov  [attr_2],0fh             ;bright on black attribute
              mov  al,7                     ;80x25 b&w video mode

;cls for output

assume_vga:   mov  ah,0                     ;cls by asking dos
              int  10h                      ;to set video mode

              mov  ah,[reg_attr]            ;normal screen attribute
              mov  di,0                     ;exit message goes here
              mov  si,offset xit_msg        ;Control/Break message
              call echo_string              ;write msg to screen

              mov  ah,[attr_1]              ;load screen attribute
              mov  di,screen_pos_1          ;point to video offset
              mov  si,offset header_msg     ;"AH AL" header message
              call echo_string              ;write message to screen

;now wait for key from user

get_key:      mov  ah,10h                   ;ask dos for a key via a
              int  16h                      ;bios call

              cmp  ax,0                     ;ax=0000=control/break entered?
              je   end_prog                 ;head for the exit

continue:     mov  di,offset key_buffer     ;else point to our local buffer
              push ax                       ;save key codes in ax
              mov  al,ah                    ;we need to convert word in ax to hex ASCII
              call bin_t_ascii              ;convert upper byte first

              mov  al,20h                   ;ASCII code for a space char
              stosb                         ;to our buffer

              pop  ax                       ;retrieve value
              call bin_t_ascii              ;now convert lower byte

;scan and ascii key codes are now ready for screen display

              mov  ah,[attr_2]              ;screen attribute
              mov  si,offset key_buffer     ;point to converted code
              mov  di,screen_pos_2          ;video buffer offset
              call echo_string              ;write values to the screen
              jmp  get_key                  ;and get the next key

end_prog:     mov  ax,4c00h                 ;return to dos
              int  21h                      ;thank-u-dos

;our sub routines are next
;this routine converts a binary value in al to an ascii character value

bin_t_ascii:  xor  ah,ah                    ;clear upper byte
              mov  cl,16                    ;we are working with hex values
              div  cl                       ;so divide by 16
              call ascii_1                  ;convert to bin/ascii
              stosb                         ;store in buffer
              mov  al,ah                    ;remainder is left in al
              call ascii_1                  ;convert to hex/ascii
              stosb                         ;store in buffer
              ret                           ;return to caller

;next routine converts value in al to a hex/ascii character we can print

ascii_1:      add  al,30h                   ;we want range "0" to "9"
              cmp  al,39h                   ;not greater than "9"?
              jle  ascii_2                  ;jump if less or equal
              add  al,7                     ;else bump to value "A" to "F"
ascii_2:      ret                           ;and return to caller

;our last routine writes a zero terminated string directly to the screen

echo_string:  mov  bx,[vid_seg]             ;
              mov  es,bx                    ;video segment in extra segment
echo_char:    lodsb                         ;load character
              or   al,al                    ;
              jz   xit_echo                 ;
              stosw                         ;and write to screen
              jmp  echo_char                ;

xit_echo:     mov  ax,ds                    ;
              mov  es,ax                    ;restore es to data segment
              ret                           ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
end           prog_start                    ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
