;
; INT09.ASM by Celso Minnitti, Jr
;
; Date: 09/03/1992 to 07-30-1993
;
; Compile:  TASM INT09
;	    TLINK /t INT09
;

; This program will handle the INTerrupt 9 and output the values of
; port 60h, and port 61h every time one key is pressed.

; Port 60h = (keyboard data, scan code of key)
; Port 61h = (control status of 8255)

SC_F10		EQU 44h ; scancode of F10 key
ATTR		EQU 3Fh

code   segment byte public 'CODE'
       assume cs:code, ds:code, es:code
       org    100h

start:          call    cls                      ; clear screen
		call	init			 ; initialize vidseg variable
		call	simgd			 ; show imagedata
		mov	ax,0C00h		 ; ah= row, al=col
		call	gotoxy			 ; put cursor at row=12, col=0

		mov	ax,3509h		 ; get int9
		int	21h
		push	es			 ; save seg
		push	bx			 ; save off

		mov	ax,2509h		 ; set int9
		mov	dx,offset int_9
		int	21h

ag:		cmp	[exit],1
		jne	ag
		mov	ax,2509h		 ; restore int 9
		pop	dx			 ; seg
		pop	ds			 ; off
		int	21h
		mov	ax,4c00h		 ; exit to DOS
		int	21h


;**************************************************************************
;		    INT 9 (IRQ 1, Keyboard Interrupt)
;**************************************************************************

int_9:          push    ax
		push	di
		push	es

		mov	es,cs:[vidseg]

		mov	di, 01*160 + 09*2
		in	al,60h
		call	print8h 		 ; print value of int 60h

		mov	di, 02*160 + 09*2
		in	al,61h
		call	print8h 		 ; print value of int 61h

		in	al,60h			 ; read the scan code data
		cmp	al,SC_F10		 ; F10 press?
		jne	int91
		mov	cs:[exit],1		 ; if yes, then exit =1

int91:		in	al,61h			 ;
		push	ax			 ; save control status
		or	al,80h			 ; set bit 7 (latch) of 8255
		out	61h,al			 ; to acknowlodge data
		pop	ax			 ; restore control status
		out	61h,al

		mov	al,20h			 ; send EOI to 8259 (PIC)
		out	20h,al
		pop	es
		pop	di
		pop	ax
		iret

;**************************************************************************
;			    PRINTxH, x=8 bits
;
;		 AL, = # to print in hexadecimal at ES:DI
;		      ES:DI= SEG:OFF of video memory
;**************************************************************************
print8h 	proc	near
		push	ax
		push	cx
		push	dx
		push	di

pri81:		mov	cx,2
		mov	dl,al
		mov	ah,ATTR
pri82:		rol	dl,1
		rol	dl,1
                rol     dl,1
                rol     dl,1

		mov	al,dl
		and	al,0fh
		daa
		add	al,0f0h
		adc	al,40h
		stosw
		loop	pri82

		pop	di
		pop	dx
		pop	cx
		pop	ax
		ret
print8h 	endp

;**************************************************************************
;				   CLS
;**************************************************************************
cls             proc    near
		push	ax
		push	bx
		push	cx
		push	dx
		mov	ah,6
		mov	al,0
		xor	cx,cx
		mov	dh,24
		mov	dl,79
		mov	bh,7
		int	10h
		pop	dx
		pop	cx
		pop	bx
		pop	ax
		ret
cls             endp

;**************************************************************************
;				  GOTOXY
;			     AH= row, AL= col
;**************************************************************************
gotoxy		proc	near
		push	ax
                push    bx
		mov	dx,ax
		mov	ah,2
		mov	bh,0			 ; page 0
		int	10h
		pop	bx
		pop	ax
                ret
gotoxy          endp


simgd:		mov	cx,IMAGEDATA_LENGTH
		mov	si,offset IMAGEDATA
		xor	di,di
		mov	es,[vidseg]
		call	uncrunch
		ret

;**************************************************************************
;				   INIT
; Initialize:
; vidseg = B800 (color) or B000 (mono)
;**************************************************************************
init		proc	near
		push	ds
		xor	ax,ax
		mov	ds,ax
                mov     al,byte ptr ds:[410h]
		pop	ds

		and	al,30h
		cmp	al,30h
		mov	ax,0B800h
		jnz	init1
		mov	ax,0B000h
init1:		mov	word ptr [vidseg],ax
		ret
init		endp
                
;**************************************************************************
;				 UNCRUNCH
;		   for crunched images from TheDraw v4.3
;
;                 DS:SI = Crunched image source pointer
;		  ES:DI = Display address pointer
;		  CX	= Length of ImageData source data
;**************************************************************************

uncrunch	proc	near

       PUSH    SI		       ;Save registers.
       PUSH    DI
       PUSH    AX
       PUSH    CX
       PUSH    DX

       MOV     DX,DI                   ;Save X coordinate for later.
       XOR     AX,AX                   ;Set Current attributes.
       CLD

LOOPA: LODSB                           ;Get next character.
       CMP     AL,27                   ;Does user want to toggle the blink
       JNZ     ForeGround              ;attibute?
       XOR     AH,128                  ;Done.
       JMP     Short Next

ForeGround:
       CMP     AL,16                   ;If less than 16, then change the
       JNC     BackGround              ;foreground color.  Otherwise jump.
       AND     AH,70H                  ;Strip off old foreground.
       OR      AH,AL
       JMP     Short Next

BackGround:
       CMP     AL,24                   ;If less than 24, then change the
       JZ      NextLine                ;background color.  If exactly 24,
       JNC     MultiOutput             ;then jump down to next line.
       SUB     AL,16                   ;Otherwise jump to multiple output
       ADD     AL,AL                   ;routines.
       ADD     AL,AL
       ADD     AL,AL
       ADD     AL,AL
       AND     AH,8FH                  ;Strip off old background.
       OR      AH,AL
       JMP     Short Next

NextLine:
       ADD     DX,160                  ;If equal to 24,
       MOV     DI,DX                   ;then jump down to
       JMP     Short Next              ;the next line.

MultiOutput:
       CMP     AL,25                   ;If equal to 25,
       JNZ     NotMultiSpaces          ;then use the
       LODSB                           ;following code as
       PUSH    CX                      ;a count and output
       XOR     CH,CH                   ;said number of
       MOV     CL,AL                   ;spaces.
       MOV     AL,32
       JMP     Short StartOutput       ;Use below loop.

NotMultiSpaces:
       CMP     AL,26                   ;If equal to 26, then using
       JNZ     NormalLetter            ;the following two codes, display
       LODSB                           ;<x> number of <y> characters.
       DEC     CX                      ;Adjust main counter.
       PUSH    CX                      ;Display as many of
       XOR     CH,CH                   ;whatever the user
       MOV     CL,AL                   ;wants.
       LODSB                           ;Get character.

StartOutput:
       JCXZ    Stop                    ;Abort if already at zilch.
LOOPB: STOSW
       LOOP    LOOPB
Stop:  POP     CX
       DEC     CX                      ;Adjust main counter.

NormalLetter:
       STOSW                           ;Save screen letter.

Next:  JCXZ    Done                    ;Get next, unless CX
       LOOP    LOOPA                   ;has already gone to zero.

Done:  POP     DX                      ;Restore registers.
       POP     CX
       POP     AX
       POP     DI
       POP     SI
       RET

uncrunch	endp

; TheDraw Assembler Crunched Screen Image

IMAGEDATA_WIDTH EQU 41
IMAGEDATA_DEPTH EQU 11
IMAGEDATA_LENGTH EQU 243
IMAGEDATA LABEL BYTE
        DB      11,19,'',26,10,'Ŀ',16,25,4,'Hit the following keys'
        DB      ':',24,19,' ',14,'in ',0,'60h=',15,'44 ',11,'',24,''
        DB      ' ',14,'in ',0,'61h=',15,'30 ',11,'',16,25,4,15,'Ct'
        DB      'rl-Alt-Del',24,11,19,'',25,10,'',16,25,4,14,'Caps'
        DB      ' Lock',24,11,19,'',14,'F10 to exit',11,'',16,25,4,15
        DB      'Num Lock',24,25,17,14,'Scrool Lock',24,25,17,15,'An'
        DB      'y HotKey at all...',24,24,25,17,11,'or ',14,19,'F10'
        DB      16,' ',11,'to exit.',24,24,15,'Intriguing? See ',12,'I'
        DB      'NT09.ASM ',15,'for details.',24


exit		db	0
vidseg		dw	0

code            ends
end		start

