	 PAGE	 64,132 	       ;PAGE WIDTH,LENGTH
	 .SALL
	 TITLE	 PC/AT DIAGNOSTIC - SEEK TEST
; **********************************************************************
; *								       *
; *	MODULE NAME    HDSEEK					       *
; *	AUTHOR	       JIM BRACKING				       *
; *								       *
; *	DECSRIPTION    THIS PROGRAM PERFORMS THE FOLLOWING	       *
; *		       FUNCTIONS:				       *
; *								       *
; *		       1. THIS ROUTINE MAKES TWO PASSES. THE FIRST     *
; *			  PASS IS SEQUENTIAL AND THE SECOND PASS       *
; *			  PERFORMS RANDOM SEEKS OF AT LEAST 10 CYLS.   *
; *								       *
; **********************************************************************
;
; **********************************************************************
; *			EXTERNAL PROGRAM REFERENCES		       *
; **********************************************************************
	 EXTRN	 SCRMGR:NEAR
; **********************************************************************
; *			  EXTERNAL DATA REFERENCES		       *
; **********************************************************************
	 INCLUDE HDDATA.ASM
; **********************************************************************
; *			EXTERNAL SUBROUTINE REFERENCES		       *
; **********************************************************************
	 INCLUDE HDSUB.ASM
; **********************************************************************
; *			    PUBLIC DECLARES			       *
; **********************************************************************
	 PUBLIC  HDSEEK
; **********************************************************************
; *				 MACROS 			       *
; **********************************************************************
;
	 IF1
	 INCLUDE HD.MAC
	 INCLUDE \SCRMGR\SCRNWORK.MAC
	 ENDIF
; **********************************************************************
; *								       *
; *			       BEGIN				       *
; *								       *
; **********************************************************************
CSEG	 SEGMENT PARA PUBLIC 'CODE'
	 ASSUME CS:CSEG
HDSEEK PROC    NEAR
	 ASSUME  DS:CSEG	       ;DATA SEGMENT
	 JMP	 BY_ID		       ;JMP AROUND ID
	 ID	 HDSEEK
	 INCLUDE \SCRMGR\SCRNWORK.ASM
; **********************************************************************
; *			 EQUATES AND STRUCTURES 		       *
; **********************************************************************
	 INCLUDE HDEQU.ASM
; **********************************************************************
; *				 SCREENS			       *
; **********************************************************************
  SFIELD X00,X01,,@LABEL,RV,23,02,'CTRL-F1 TO START'
  SFIELD X01,X02,,@LABEL,RV,23,29,'ESC FOR THE MAIN MENU'
  SFIELD X02,X00,,@LABEL,RV,23,62,'CTRL-BRK TO STOP'
;
  SFIELD XI0,XI1,,@LABEL,LO,19,05,'DRIVE =>'
  SFIELD XI1,XI2,1,@EX+@NUM+@UC+@NFULL+@REQ,LO,19,14
  SFIELD XI2,XI3,,@LABEL,LO,20,05,'(1 OR 2)'
  SFIELD XI3,XI4,,@LABEL,LO,19,20,'RUN CONTINIOUSLY =>'
  SFIELD XI4,XI5,1,@UC+@EX+@YN+@NFULL+@REQ,LO,19,40
  SFIELD XI5,XI0,,@LABEL,LO,20,26,'(Y OR N)'
;
  SFIELD XS0,XS1,,@LABEL,LO,19,46,'STATUS =>'
  SFIELD XS1,XS0,,@LABEL,LO,19,56,'** IDLE **   '
;
  SFIELD XS2,XS3,,@LABEL,LO,19,46,'STATUS =>'
  SFIELD XS3,XS2,,@LABEL,HI,19,56,'** WORKING **'
;
  SFIELD XC0,XC1,,@LABEL,LO,20,46,'CYLINDER =>'
  SFIELD XC1,XC0,04,@LABEL,LO,20,58
;
  SFIELD XE0,XE1,,@LABEL,LO,21,46,'ERRORS =>'
  SFIELD XE1,XE0,05,@LABEL,LO,21,56
;
  SFIELD T05,T05,,@LABEL,RV,17,34,'SEEK TEST'
;
BY_ID:
HDSEEK ENDP
; *********************************************************************
; *								      *
; *				SEEK TEST			      *
; *								      *
; *********************************************************************
SEEK	 PROC
	 CLS	 LO,4,1,23,78	       ;CLEAR THE SCREEN
	 BOX	 17,0,08,80,LO	       ;OUTLINE
	 WRITEC  0CCH,LO,17,0,1        ;  THE
	 WRITEC  0B9H,LO,17,79,1       ;  SCREEN
	 WRITE	 T05		       ;TYPE OF TEST
	 WRITE	 X00		       ;COMMANDS
SK_00:
	 WRITE	 XS0		       ;STATUS
	 LEA	 BX,XI1 	       ;DRIVE ENTRY
	 MOV	 [BX].S_ATTR,LO        ;RESTORE ATTRIBUTE
	 CMP	 ALL_SW,0FFH	       ;RUN ALL TEST??
	 JE	 SK_01		       ;YES
	 MOV	 [BX].S_DATA,' '       ;CLEAR DRIVE
	 JMP	 SK_01A 	       ;CONTINUE
SK_01:
	 LEA	 BX,XI4 	       ;Y/N ENTRY
	 MOV	 [BX].S_ATTR,LO        ;RESTORE ATTRIBUTE
	 MOV	 [BX].S_DATA,'Y'       ;DEFAULT NO
	 MOV	 AL,DR		       ;FETCH DRIVE NUMBER
	 INC	 AL		       ;NUMBER
	 OR	 AL,30H 	       ;MAKE IT A NUMBER
	 MOV	 [BX].S_DATA,AL        ;SET IT IN THE MESSAGE
	 WRITE	 XI0		       ;DRIVE + INTERLEAVE
	 JMP	 SK_20		       ;CONTINUE
SK_01A:
	 LEA	 BX,XI4 	       ;Y/N ENTRY
	 MOV	 [BX].S_ATTR,LO        ;RESTORE ATTRIBUTE
	 MOV	 [BX].S_DATA,'N'       ;DEFAULT NO
	 WRITE	 XI0		       ;DRIVE + INTERLEAVE
SK_02:
	 READR	 BX		       ;FETCH DRIVE AND INTERLEAVE
	 CALL	 TRANS_KEY	       ;TRANSLATE THE KEY
	 JNC	 SK_04		       ;SUCESSFULL
SK_03:
	 CALL	 BEEP		       ;RING THE BELL
	 JMP	 SK_02		       ;TRY AGAIN
SK_04:
	 CMP	 AL,ESC_KEY	       ;ESCAPE KEY??
	 JNE	 SK_05		       ;NO
	 JMP	 EXIT		       ;RETURN
SK_05:
	 CMP	 AL,C_BRK	       ;CONTROL BREAK KEY??
	 JNE	 SK_07		       ;NO
	 JMP	 SEEK		       ;YES - START OVER
SK_07:
	 CMP	 AL,C_F1	       ;CTRL_F1??
	 JNE	 SK_03		       ;NO - INVALID KEY
	 LEA	 BX,XI1 	       ;DRIVE ENTRY
	 MOV	 [BX].S_ATTR,LO        ;RESTORE ATTRIBUTE
	 MOV	 AL,[BX].S_DATA        ;FETCH DRIVE NUMBER
	 CMP	 AL,'1'                ;VALID DRIVE??
	 JE	 SK_08		       ;YES
	 CMP	 AL,'2'                ;VALID DRIVE??
	 JE	 SK_08		       ;YES
	 MOV	 [BX].S_ATTR,HI        ;HIGHLIGHT IT
	 PMSG	 22		       ;DISPLAY THE MESSAGE
	 CALL	 BEEP		       ;RING THE BELL
	 WRITE	 XI0		       ;DRIVE + INTERLEAVE
	 JMP	 SK_02		       ;TRY AGAIN
SK_08:
	 AND	 AL,0FH 	       ;ADJUST
	 DEC	 AL		       ;  DRIVE NUMBER
	 CMP	 AL,NUM_DR	       ;DRIVE INSTALLED
	 JB	 SK_10		       ;YES
	 MOV	 [BX].S_ATTR,HI        ;HIGHLIGHT IT
	 PMSG	 21		       ;DISPLAY THE MESSAGE
	 CALL	 BEEP		       ;RING THE BELL
	 WRITE	 XI0		       ;DRIVE + INTERLEAVE
	 JMP	 SK_02		       ;TRY AGAIN
SK_10:
	 MOV	 DR,AL		       ;SAVE DRIVE NUMBER
	 LEA	 BX,XI1 	       ;DRIVE ENTRY
	 MOV	 [BX].S_ATTR,LO        ;RESTORE ATTRIBUTE
	 WRITE	 XI0		       ;DRIVE
SK_20:
	 CALL	 READ_PARMS	       ;FETCH DRIVE PARMS
	 MOV	 CUR_HD,0	       ;INITIALIZE
	 MOV	 CUR_SEC,1	       ; THE
	 MOV	 CUR_CYL,0	       ;  STARTING FIELDS
	 MOV	 BAD_SEC,0	       ;CLEAR BAD SEC COUNT
	 MOV	 ERR_CNT,0	       ;CLEAR THE ERROR COUNT
	 MOV	 NUM_SEC,1	       ;NUMBER OF SECTORS
	 CALL	 UPD_CYL	       ;DISPLAY CYLINDER NUMBER
	 CALL	 UPD_ERR	       ;DISPLAY ERROR COUNT
	 WRITE	 XS2		       ;STATUS
	 CLS	 LO,4,2,16,78	       ;CLEAR THE SCREEN
	 CALL	 HIDE_CUR	       ;HIDE THE CURSOR
; *********************************************************************
; *			   BEGIN THE TEST			      *
; *********************************************************************
	 CALL	 CTLR_DIAG	       ;EXECUTE CTLR HDNOSTICS
	 JNC	 SK_30		       ;SUCESSFULL
	 PMSG	 34,HI		       ;FAILED
	 MOV	 SEEK_X,34	       ;SET CODE
	 CALL	 UPD_ERR	       ;DISPLAY ERROR COUNT
	 CMP	 ALL_SW,0FFH	       ;RUN ALL TEST??
	 JE	 SK_28		       ;YES
	 JMP	 SK_00		       ;TERMINATE FORMAT
SK_28:
	 JMP	 EXIT		       ;EXIT
SK_30:
	 PUSH	 DS		       ;ESTABLISG
	 POP	 ES		       ;  SEGMENT
; *********************************************************************
; *			   SEQUENTIAL TEST			      *
; *********************************************************************
SK_40:
	 MOV	 AH,0BH 	       ;CHECK FOR
	 INT	 21H		       ;  CONTROL BREAK
	 CALL	 UPD_CYL	       ;DISPLAY CURRENT CYLINDER
	 MOV	 HD_CMD,SEEK_CMD       ;SEEK COMMAND
	 MOV	 NUM_SEC,1	       ;NUMBER OF SECTORS
	 CALL	 EXEC_CMD	       ;VERIFY THE SECTOR
	 JNC	 SK_50		       ;SUCESSFULL
	 CMP	 AL,0FFH	       ;CTLR BROKE??
	 JNE	 SK_48		       ;NO
	 JMP	 SK_99		       ;YES
SK_48:
	 CALL	 UPD_ERR	       ;DISPLAY ERROR COUNT
SK_50:
	 CALL	 NEXT_CYL	       ;NEXT CYLINDER
	 JNC	 SK_40		       ;PROCESS IT
	 MOV	 CUR_HD,0	       ;INITIALIZE
	 MOV	 CUR_SEC,1	       ; THE
	 MOV	 CUR_CYL,0	       ;  STARTING FIELDS
	 MOV	 DI,MAX_CYL	       ;SAVE LAST CYLINDER
	 XOR	 SI,SI		       ;SAVE FIRST CYLINDER
; *********************************************************************
; *			     RANDOM TEST			      *
; *********************************************************************
SK_60:
	 MOV	 AH,0BH 	       ;CHECK FOR
	 INT	 21H		       ;  CONTROL BREAK
	 MOV	 CUR_CYL,SI	       ;FIRST CYLINDER
	 CALL	 UPD_CYL	       ;DISPLAY CURRENT CYLINDER
	 CALL	 EXEC_CMD	       ;VERIFY THE SECTOR
	 JNC	 SK_70		       ;SUCESSFULL
	 CMP	 AL,0FFH	       ;CTLR BROKE??
	 JNE	 SK_68		       ;NO
	 JMP	 SK_99		       ;YES
SK_68:
	 CALL	 UPD_ERR	       ;DISPLAY ERROR COUNT
SK_70:
	 MOV	 CUR_CYL,DI	       ;NEW CYLINDER
	 CALL	 UPD_CYL	       ;DISPLAY CURRENT CYLINDER
	 CALL	 EXEC_CMD	       ;VERIFY THE SECTOR
	 JNC	 SK_80		       ;SUCESSFULL
	 CMP	 AL,0FFH	       ;CTLR BROKE??
	 JNE	 SK_78		       ;NO
	 JMP	 SK_99		       ;YES
SK_78:
	 CALL	 UPD_ERR	       ;DISPLAY ERROR COUNT
SK_80:
	 SUB	 DI,4		       ;5 CYLINDERS LESS
	 JC	 SK_90		       ;DONE
	 ADD	 SI,4		       ;PLUSS 5 CYLINDERS
	 CMP	 SI,MAX_CYL	       ;DONE??
	 JB	 SK_60		       ;NO
SK_90:
	 MOV	 HD_CMD,SEEK_CMD       ;LETS
	 MOV	 CUR_CYL,0	       ; BRING
	 MOV	 CUR_HD,0	       ;  THE HEADS
	 CALL	 EXEC_CMD	       ;  HOME
	 CMP	 ERR_CNT,0	       ;ERRORS??
	 JNE	 SK_100 	       ;YES
SK_98:
	 PMSG	 33,HI		       ;TEST COMPLETE
	 MOV	 SEEK_X,33	       ;SET CODE
SK_99:
	 CMP	 ALL_SW,0FFH	       ;RUN ALL TEST??
	 JE	 EXIT		       ;YES - EXIT
	 LEA	 BX,XI4 	       ;Y/N ENTRY
	 CMP	 [BX].S_DATA,'Y'       ;RUN FOREVER??
	 JE	 SK_110 	       ;YES
	 JMP	 SK_00		       ;NEXT
SK_100:
	 MOV	 AX,BAD_SEC	       ;FETCH BAD TRK COUNT
	 CMP	 ERR_CNT,AX	       ;SAME
	 JE	 SK_98		       ;YES
	 PMSG	 34,HI		       ;TEST COMPLETE
	 MOV	 SEEK_X,34	       ;SET CODE
	 CMP	 ALL_SW,0FFH	       ;RUN ALL TEST??
	 JE	 EXIT		       ;YES - EXIT
	 LEA	 BX,XI4 	       ;Y/N ENTRY
	 CMP	 [BX].S_DATA,'Y'       ;RUN FOREVER??
	 JE	 SK_110 	       ;YES
	 JMP	 SK_00		       ;NEXT
SK_110:
	 JMP	 SK_30		       ;CONTINUE
; *********************************************************************
; *				E X I T 			      *
; *********************************************************************
EXIT:
	 RET			       ;RETURN
SEEK	 ENDP
; *********************************************************************
; *			DISPLAY CURRENT CYLINDER		      *
; *********************************************************************
UPD_CYL  PROC
	 PUSHALL
	 MOV	 AX,CUR_CYL	       ;FORMAT
	 LEA	 BX,XC1 	       ; CYLINDER
	 CALL	 CONV_ASCII	       ;  DISPLAY
	 WRITE	 XC0		       ;CYLINDER
	 POPALL
	 RET			       ;RETURN
UPD_CYL  ENDP
; *********************************************************************
; *			   DISPLAY ERROR COUNT			      *
; *********************************************************************
UPD_ERR  PROC
	 PUSHALL
	 XOR	 AX,AX		       ;CLEAR AX
	 MOV	 AX,ERR_CNT	       ;FORMAT
	 LEA	 BX,XE1 	       ; ERROR COUNT
	 CALL	 CONV_ASCII	       ;  DISPLAY
	 WRITE	 XE0		       ;ERROR COUNT
	 POPALL
	 RET			       ;RETURN
UPD_ERR  ENDP
CSEG	 ENDS
	 END	 HDSEEK
