	 PAGE	 64,132 	       ;PAGE WIDTH,LENGTH
	 .SALL
	 TITLE	 PC/AT DIAGNOSTIC - HEAD SELECT TEST
; **********************************************************************
; *								       *
; *	MODULE NAME    HDHS					       *
; *	AUTHOR	       JIM BRACKING				       *
; *								       *
; *	DECSRIPTION    THIS PROGRAM PERFORMS THE FOLLOWING	       *
; *		       FUNCTIONS:				       *
; *								       *
; *		       1. EXECUTE A VERIFY READ TO EVERY HEAD ON       *
; *			  EVERY 10th CYLINDER.			       *
; *								       *
; **********************************************************************
;
; **********************************************************************
; *			EXTERNAL PROGRAM REFERENCES		       *
; **********************************************************************
	 EXTRN	 SCRMGR:NEAR
; **********************************************************************
; *			  EXTERNAL DATA REFERENCES		       *
; **********************************************************************
	 INCLUDE HDDATA.ASM
; **********************************************************************
; *			EXTERNAL SUBROUTINE REFERENCES		       *
; **********************************************************************
	 INCLUDE HDSUB.ASM
; **********************************************************************
; *			    PUBLIC DECLARES			       *
; **********************************************************************
	 PUBLIC  HDHS
; **********************************************************************
; *				 MACROS 			       *
; **********************************************************************
;
	 IF1
	 INCLUDE HD.MAC
	 INCLUDE \SCRMGR\SCRNWORK.MAC
	 ENDIF
; **********************************************************************
; *								       *
; *			       BEGIN				       *
; *								       *
; **********************************************************************
CSEG	 SEGMENT PARA PUBLIC 'CODE'
	 ASSUME CS:CSEG
HDHS   PROC    NEAR
	 ASSUME  DS:CSEG	       ;DATA SEGMENT
	 JMP	 BY_ID		       ;JMP AROUND ID
	 ID	 HDHS
	 INCLUDE \SCRMGR\SCRNWORK.ASM
; **********************************************************************
; *			 EQUATES AND STRUCTURES 		       *
; **********************************************************************
	 INCLUDE HDEQU.ASM
; **********************************************************************
; *				 SCREENS			       *
; **********************************************************************
;
  SFIELD X00,X01,,@LABEL,RV,23,02,'CTRL-F1 TO START'
  SFIELD X01,X02,,@LABEL,RV,23,29,'ESC FOR THE MAIN MENU'
  SFIELD X02,X00,,@LABEL,RV,23,62,'CTRL-BRK TO STOP'
;
  SFIELD XI0,XI1,,@LABEL,LO,19,05,'DRIVE =>'
  SFIELD XI1,XI2,1,@EX+@NUM+@UC+@NFULL+@REQ,LO,19,14
  SFIELD XI2,XI3,,@LABEL,LO,20,05,'(1 OR 2)'
  SFIELD XI3,XI4,,@LABEL,LO,19,20,'RUN CONTINIOUSLY =>'
  SFIELD XI4,XI5,1,@UC+@EX+@YN+@NFULL+@REQ,LO,19,40
  SFIELD XI5,XI0,,@LABEL,LO,20,26,'(Y OR N)'
;
  SFIELD XS0,XS1,,@LABEL,LO,19,46,'STATUS =>'
  SFIELD XS1,XS0,,@LABEL,LO,19,56,'** IDLE **   '
;
  SFIELD XS2,XS3,,@LABEL,LO,19,46,'STATUS =>'
  SFIELD XS3,XS2,,@LABEL,HI,19,56,'** WORKING **'
;
  SFIELD XC0,XC1,,@LABEL,LO,20,46,'CYLINDER =>'
  SFIELD XC1,XC0,04,@LABEL,LO,20,58
;
  SFIELD XE0,XE1,,@LABEL,LO,21,46,'ERRORS =>'
  SFIELD XE1,XE0,05,@LABEL,LO,21,56
;
  SFIELD T05,T05,,@LABEL,RV,17,33,'HEAD SELECT'
;
;
BY_ID:
HDHS   ENDP
; *********************************************************************
; *								      *
; *			    HEAD SELECT TEST			      *
; *								      *
; *********************************************************************
HS	 PROC
	 CLS	 LO,4,1,23,78	       ;CLEAR THE SCREEN
	 BOX	 17,0,08,80,LO	       ;OUTLINE
	 WRITEC  0CCH,LO,17,0,1        ;  THE
	 WRITEC  0B9H,LO,17,79,1       ;  SCREEN
	 WRITE	 T05		       ;TYPE OF TEST
	 WRITE	 X00		       ;COMMANDS
HS_00:
	 WRITE	 XS0		       ;STATUS
	 LEA	 BX,XI1 	       ;DRIVE ENTRY
	 MOV	 [BX].S_ATTR,LO        ;RESTORE ATTRIBUTE
	 CMP	 ALL_SW,0FFH	       ;RUN ALL TEST??
	 JE	 HS_01		       ;YES
	 MOV	 [BX].S_DATA,' '       ;CLEAR DRIVE
	 JMP	 HS_01A
HS_01:
	 LEA	 BX,XI4 	       ;Y/N ENTRY
	 MOV	 [BX].S_ATTR,LO        ;RESTORE ATTRIBUTE
	 MOV	 [BX].S_DATA,'Y'       ;DEFAULT NO
	 MOV	 AL,DR		       ;FETCH DRIVE
	 INC	 AL		       ;NUMBER
	 OR	 AL,30H 	       ;MAKE IT A NUMBER
	 MOV	 [BX].S_DATA,AL        ;SET IT IN THE MSG
	 WRITE	 XI0		       ;DRIVE + INTERLEAVE
	 JMP	 HS_20		       ;CONTINUE
HS_01A:
	 LEA	 BX,XI4 	       ;Y/N ENTRY
	 MOV	 [BX].S_ATTR,LO        ;RESTORE ATTRIBUTE
	 MOV	 [BX].S_DATA,'N'       ;DEFAULT NO
	 WRITE	 XI0		       ;DRIVE + INTERLEAVE
HS_02:
	 READR	 BX		       ;FETCH DRIVE AND INTERLEAVE
	 CALL	 TRANS_KEY	       ;TRANSLATE THE KEY
	 JNC	 HS_04		       ;SUCESSFULL
HS_03:
	 CALL	 BEEP		       ;RING THE BELL
	 JMP	 HS_02		       ;TRY AGAIN
HS_04:
	 CMP	 AL,ESC_KEY	       ;ESCAPE KEY??
	 JNE	 HS_05		       ;NO
	 JMP	 EXIT		       ;RETURN
HS_05:
	 CMP	 AL,C_BRK	       ;CONTROL BREAK KEY??
	 JNE	 HS_07		       ;NO
	 JMP	 HS		       ;YES - START OVER
HS_07:
	 CMP	 AL,C_F1	       ;CTRL_F1??
	 JNE	 HS_03		       ;NO - INVALID KEY
	 LEA	 BX,XI1 	       ;DRIVE ENTRY
	 MOV	 [BX].S_ATTR,LO        ;RESTORE ATTRIBUTE
	 MOV	 AL,[BX].S_DATA        ;FETCH DRIVE LETTER
	 CMP	 AL,'1'                ;VALID DRIVE??
	 JE	 HS_08		       ;YES
	 CMP	 AL,'2'                ;VALID DRIVE??
	 JE	 HS_08		       ;YES
	 MOV	 [BX].S_ATTR,HI        ;HIGHLIGHT IT
	 PMSG	 22		       ;DISPLAY THE MESSAGE
	 CALL	 BEEP		       ;RING THE BELL
	 WRITE	 XI0		       ;DRIVE + INTERLEAVE
	 JMP	 HS_02		       ;TRY AGAIN
HS_08:
	 AND	 AL,0FH 	       ;ADJUST
	 DEC	 AL		       ;  DRIVE NUMBER
	 CMP	 AL,NUM_DR	       ;DRIVE INSTALLED
	 JB	 HS_10		       ;YES
	 MOV	 [BX].S_ATTR,HI        ;HIGHLIGHT IT
	 PMSG	 21		       ;DISPLAY THE MESSAGE
	 CALL	 BEEP		       ;RING THE BELL
	 WRITE	 XI0		       ;DRIVE + INTERLEAVE
	 JMP	 HS_02		       ;TRY AGAIN
HS_10:
	 MOV	 DR,AL		       ;SAVE DRIVE NUMBER
	 LEA	 BX,XI1 	       ;DRIVE ENTRY
	 MOV	 [BX].S_ATTR,LO        ;RESTORE ATTRIBUTE
	 WRITE	 XI0		       ;DRIVE
HS_20:
	 CALL	 READ_PARMS	       ;FETCH DRIVE PARMS
	 MOV	 CUR_HD,0	       ;INITIALIZE
	 MOV	 CUR_SEC,1	       ; THE
	 MOV	 CUR_CYL,0	       ;  STARTING FIELDS
	 MOV	 BAD_SEC,0	       ;CLEAR THE BAD SEC COUNT
	 MOV	 ERR_CNT,0	       ;CLEAR THE ERROR COUNT
	 MOV	 NUM_SEC,1	       ;NUMBER OF SECTORS
	 CALL	 UPD_CYL	       ;DISPLAY CYLINDER NUMBER
	 CALL	 UPD_ERR	       ;DISPLAY ERROR COUNT
	 WRITE	 XS2		       ;STATUS
	 CLS	 LO,4,2,16,78	       ;CLEAR THE SCREEN
	 CALL	 HIDE_CUR	       ;HIDE THE CURSOR
; *********************************************************************
; *			   BEGIN THE TEST			      *
; *********************************************************************
	 CALL	 CTLR_DIAG	       ;EXECUTE CTLR HDNOSTICS
	 JNC	 HS_30		       ;SUCESSFULL
	 PMSG	 30,HI		       ;FAILED
	 MOV	 HS_X,30	       ;SET CODE
	 CMP	 ALL_SW,0FFH	       ;RUN ALL TEST??
	 JE	 HS_28		       ;YES
	 CALL	 UPD_ERR	       ;DISPLAY ERROR COUNT
	 JMP	 HS_00		       ;TERMINATE FORMAT
HS_28:
	 JMP	 EXIT		       ;BYE
HS_30:
	 PUSH	 DS		       ;ESTABLISG
	 POP	 ES		       ;  SEGMENT
HS_40:
	 MOV	 AH,0BH 	       ;CHECK FOR
	 INT	 21H		       ;  CONTROL BREAK
	 CALL	 UPD_CYL	       ;DISPLAY CURRENT CYLINDER
	 MOV	 HD_CMD,VER_CMD        ;VERIFY COMMAND
	 MOV	 NUM_SEC,1	       ;NUMBER OF SECTORS
	 CALL	 EXEC_CMD	       ;VERIFY THE SECTOR
	 JNC	 HS_50		       ;SUCESSFULL
	 CMP	 AL,0FFH	       ;CTLR BROKE??
	 JNE	 HS_48		       ;NO
	 JMP	 HS_70		       ;YES
HS_48:
	 CALL	 UPD_ERR	       ;DISPLAY ERROR COUNT
HS_50:
	 MOV	 AL,CUR_HD	       ;FETCH HEAD NUMBER
	 INC	 AL		       ;NEXT HEAD
	 MOV	 CUR_HD,AL	       ;UPDATE HEAD
	 CMP	 AL,MAX_HD	       ;NEXT CYLINDER??
	 JBE	 HS_40		       ;NO
	 MOV	 CUR_HD,00H	       ;FIRST HEAD
	 MOV	 AX,CUR_CYL	       ;FETCH CURRENT CYLINDER
	 ADD	 AX,10		       ;BUMP CYLINDER COUNT
	 MOV	 CUR_CYL,AX	       ;AND SAVE IT
	 CMP	 AX,MAX_CYL	       ;ALL DONE??
	 JB	 HS_40		       ;NO - PROCESS THIS CYLINDER
	 MOV	 HD_CMD,SEEK_CMD       ;LETS
	 MOV	 CUR_CYL,0	       ; BRING
	 MOV	 CUR_HD,0	       ;  THE HEADS
	 CALL	 EXEC_CMD	       ;  HOME
	 CMP	 ERR_CNT,0	       ;ERRORS??
	 JNE	 HS_60		       ;YES
HS_58:
	 PMSG	 29,HI		       ;COMPLETE
	 MOV	 HS_X,29	       ;SET CODE
	 CMP	 ALL_SW,0FFH	       ;RUN ALL TEST??
	 JE	 EXIT		       ;YES
	 LEA	 BX,XI4 	       ;Y/N ENTRY
	 CMP	 [BX].S_DATA,'Y'       ;RUN FOREVER??
	 JE	 HS_80		       ;YES
	 JMP	 HS_00		       ;NEXT
HS_60:
	 MOV	 AX,BAD_SEC	       ;FETCH BAD TRK COUNT
	 CMP	 ERR_CNT,AX	       ;SAME??
	 JE	 HS_58		       ;YES
	 PMSG	 30,HI		       ;FORMAT COMPLETE
	 MOV	 HS_X,30	       ;SET CODE
HS_70:
	 CMP	 ALL_SW,0FFH	       ;RUN ALL TEST??
	 JE	 EXIT		       ;YES
	 LEA	 BX,XI4 	       ;Y/N ENTRY
	 CMP	 [BX].S_DATA,'Y'       ;RUN FOREVER??
	 JE	 HS_80		       ;YES
	 JMP	 HS_00		       ;NEXT
HS_80:
	 JMP	 HS_30		       ;CONTINUE
; *********************************************************************
; *				E X I T 			      *
; *********************************************************************
EXIT:
	 RET			       ;RETURN
HS	 ENDP
; *********************************************************************
; *			DISPLAY CURRENT CYLINDER		      *
; *********************************************************************
UPD_CYL  PROC
	 PUSHALL
	 MOV	 AX,CUR_CYL	       ;FORMAT
	 LEA	 BX,XC1 	       ; CYLINDER
	 CALL	 CONV_ASCII	       ;  DISPLAY
	 WRITE	 XC0		       ;CYLINDER
	 POPALL
	 RET			       ;RETURN
UPD_CYL  ENDP
; *********************************************************************
; *			   DISPLAY ERROR COUNT			      *
; *********************************************************************
UPD_ERR  PROC
	 PUSHALL
	 XOR	 AX,AX		       ;CLEAR AX
	 MOV	 AX,ERR_CNT	       ;FORMAT
	 LEA	 BX,XE1 	       ; ERROR COUNT
	 CALL	 CONV_ASCII	       ;  DISPLAY
	 WRITE	 XE0		       ;ERROR COUNT
	 POPALL
	 RET			       ;RETURN
UPD_ERR  ENDP
CSEG	 ENDS
	 END	 HDHS
