	 PAGE	 64,132 	       ;PAGE WIDTH,LENGTH
	 .SALL
	 TITLE	 PC/AT DIAGNOSTIC - RUN ALL TESTS
; **********************************************************************
; *								       *
; *	MODULE NAME    HDALL					       *
; *	AUTHOR	       JIM BRACKING				       *
; *								       *
; *	DECSRIPTION    THIS PROGRAM PERFORMS THE FOLLOWING	       *
; *		       FUNCTIONS:				       *
; *								       *
; *		       1.  SETS THE RUN ALL TEST FLAG AND CALLS        *
; *			   HDRW, HDHS, HDECC AND HDSEEK 	       *
; *								       *
; **********************************************************************
;
; **********************************************************************
; *			EXTERNAL PROGRAM REFERENCES		       *
; **********************************************************************
	 EXTRN	 SCRMGR:NEAR,HDRW:NEAR,HDHS:NEAR
	 EXTRN	 HDSEEK:NEAR,HDECC:NEAR
; **********************************************************************
; *			  EXTERNAL DATA REFERENCES		       *
; **********************************************************************
	 INCLUDE HDDATA.ASM
; **********************************************************************
; *			EXTERNAL SUBROUTINE REFERENCES		       *
; **********************************************************************
	 INCLUDE HDSUB.ASM
; **********************************************************************
; *			    PUBLIC DECLARES			       *
; **********************************************************************
	 PUBLIC  HDALL
; **********************************************************************
; *				 MACROS 			       *
; **********************************************************************
;
	 IF1
	 INCLUDE HD.MAC
	 INCLUDE \SCRMGR\SCRNWORK.MAC
	 ENDIF
; **********************************************************************
; *								       *
; *			       BEGIN				       *
; *								       *
; **********************************************************************
CSEG	 SEGMENT PARA PUBLIC 'CODE'
	 ASSUME CS:CSEG
HDALL  PROC    NEAR
	 ASSUME  DS:CSEG	       ;DATA SEGMENT
	 JMP	 BY_ID		       ;JMP AROUND ID
	 ID	 HDALL
	 INCLUDE \SCRMGR\SCRNWORK.ASM
; **********************************************************************
; *			 EQUATES AND STRUCTURES 		       *
; **********************************************************************
	 INCLUDE HDEQU.ASM
; **********************************************************************
; *				 SCREENS			       *
; **********************************************************************
  SFIELD X00,X01,,@LABEL,RV,23,02,'CTRL-F1 TO START'
  SFIELD X01,X02,,@LABEL,RV,23,29,'ESC FOR THE MAIN MENU'
  SFIELD X02,X00,,@LABEL,RV,23,62,'CTRL-BRK TO STOP'
;
  SFIELD XI0,XI1,,@LABEL,LO,19,05,'DRIVE =>'
  SFIELD XI1,XI2,1,@EX+@NUM+@UC+@NFULL+@REQ,LO,19,14
  SFIELD XI2,XI3,,@LABEL,LO,20,05,'(1 OR 2)'
  SFIELD XI3,XI4,,@LABEL,LO,19,20,'RUN CONTINIOUSLY =>'
  SFIELD XI4,XI5,1,@UC+@EX+@YN+@NFULL+@REQ,LO,19,40
  SFIELD XI5,XI0,,@LABEL,LO,20,26,'(Y OR N)'
;
  SFIELD XS0,XS1,,@LABEL,LO,19,46,'STATUS =>'
  SFIELD XS1,XS0,,@LABEL,LO,19,56,'** IDLE **   '
;
  SFIELD XS2,XS3,,@LABEL,LO,19,46,'STATUS =>'
  SFIELD XS3,XS2,,@LABEL,HI,19,56,'** WORKING **'
;
  SFIELD XP0,XP1,,@LABEL,LO,20,46,'PASS NUMBER =>'
  SFIELD XP1,XP0,5,@LABEL,LO,20,61
;
  SFIELD XE0,XE1,,@LABEL,LO,21,46,'ERRORS =>'
  SFIELD XE1,XE0,05,@LABEL,LO,21,56
;
  SFIELD T05,T05,,@LABEL,RV,17,32,'RUN ALL TESTS'
;
PASS	 DW	 0		       ;NUMBER OF COMPLETE PASSES
TERR_CNT DW	 0		       ;TOTAL ERROR COUNT
BY_ID:
HDALL  ENDP
; *********************************************************************
; *								      *
; *			     RUN ALL TEST			      *
; *								      *
; *********************************************************************
RALL	 PROC
	 CLS	 LO,4,1,23,78	       ;CLEAR THE SCREEN
	 BOX	 17,0,08,80,LO	       ;OUTLINE
	 WRITEC  0CCH,LO,17,0,1        ;  THE
	 WRITEC  0B9H,LO,17,79,1       ;  SCREEN
	 WRITE	 T05		       ;TYPE OF TEST
	 WRITE	 X00		       ;COMMANDS
RA_00:
	 WRITE	 XS0		       ;STATUS
	 LEA	 BX,XI1 	       ;DRIVE ENTRY
	 MOV	 [BX].S_ATTR,LO        ;RESTORE ATTRIBUTE
	 MOV	 [BX].S_DATA,' '       ;CLEAR DRIVE
	 LEA	 BX,XI4 	       ;Y/N ENTRY
	 MOV	 [BX].S_ATTR,LO        ;RESTORE ATTRIBUTE
	 MOV	 [BX].S_DATA,'N'       ;DEFAULT NO
	 WRITE	 XI0		       ;MSG
RA_02:
	 READR	 BX		       ;FETCH DRIVE AND INTERLEAVE
	 CALL	 TRANS_KEY	       ;TRANSLATE THE KEY
	 JNC	 RA_04		       ;SUCESSFULL
RA_03:
	 CALL	 BEEP		       ;RING THE BELL
	 JMP	 RA_02		       ;TRY AGAIN
RA_04:
	 CMP	 AL,ESC_KEY	       ;ESCAPE KEY??
	 JNE	 RA_05		       ;NO
	 JMP	 EXIT		       ;RETURN
RA_05:
	 CMP	 AL,C_BRK	       ;CONTROL BREAK KEY??
	 JNE	 RA_07		       ;NO
	 JMP	 RALL		       ;YES - START OVER
RA_07:
	 CMP	 AL,C_F1	       ;CTRL_F1??
	 JNE	 RA_03		       ;NO - INVALID KEY
	 LEA	 BX,XI1 	       ;DRIVE ENTRY
	 MOV	 [BX].S_ATTR,LO        ;RESTORE ATTRIBUTE
	 MOV	 AL,[BX].S_DATA        ;FETCH DRIVE NUMBER
	 CMP	 AL,'1'                ;VALID DRIVE??
	 JE	 RA_08		       ;YES
	 CMP	 AL,'2'                ;VALID DRIVE??
	 JE	 RA_08		       ;YES
	 MOV	 [BX].S_ATTR,HI        ;HIGHLIGHT IT
	 PMSG	 22		       ;DISPLAY THE MESSAGE
	 CALL	 BEEP		       ;RING THE BELL
	 WRITE	 XI0		       ;DRIVE + INTERLEAVE
	 JMP	 RA_02		       ;TRY AGAIN
RA_08:
	 AND	 AL,0FH 	       ;ADJUST
	 DEC	 AL		       ;  DRIVE NUMBER
	 CMP	 AL,NUM_DR	       ;DRIVE INSTALLED
	 JB	 RA_10		       ;YES
	 MOV	 [BX].S_ATTR,HI        ;HIGHLIGHT IT
	 PMSG	 21		       ;DISPLAY THE MESSAGE
	 CALL	 BEEP		       ;RING THE BELL
	 WRITE	 XI0		       ;DRIVE + INTERLEAVE
	 JMP	 RA_02		       ;TRY AGAIN
RA_10:
	 MOV	 DR,AL		       ;SAVE DRIVE NUMBER
	 LEA	 BX,XI1 	       ;DRIVE ENTRY
	 MOV	 [BX].S_ATTR,LO        ;RESTORE ATTRIBUTE
	 WRITE	 XI0		       ;DRIVE
RA_20:
	 CALL	 READ_PARMS	       ;FETCH DRIVE PARMS
	 CALL	 HIDE_CUR	       ;HIDE THE CURSOR
	 XOR	 AX,AX		       ;CLEAR AX
	 MOV	 TERR_CNT,AX	       ;CLEAR
	 MOV	 PASS,AX	       ;  COUNTS
	 INC	 PASS		       ;START WITH PASS 1
; *********************************************************************
; *			   BEGIN THE TEST			      *
; *********************************************************************
RA_30:
	 MOV	 RW_X,00H	       ;RESET
	 MOV	 HS_X,00H	       ; ALL
	 MOV	 SEEK_X,00H	       ;  THE
	 MOV	 ECC_X,00H	       ;   FLAGS
	 MOV	 ALL_SW,0FFH	       ;RUN ALL TEST
	 CALL	 HDRW		       ;READ/WRITE/VERIRY
	 MOV	 AX,ERR_CNT	       ;ACCUMULATE
	 ADD	 TERR_CNT,AX	       ;  ERROR COUNT
	 CALL	 DELAY		       ;DELAY FOR TWO SECONDS
	 CALL	 HDHS		       ;HEAD SELECT
	 MOV	 AX,ERR_CNT	       ;ACCUMULATE
	 ADD	 TERR_CNT,AX	       ;  ERROR COUNT
	 CALL	 DELAY		       ;DELAY FOR TWO SECONDS
	 CALL	 HDSEEK 	       ;SEEK TEST
	 MOV	 AX,ERR_CNT	       ;ACCUMULATE
	 ADD	 TERR_CNT,AX	       ;  ERROR COUNT
	 CALL	 DELAY		       ;DELAY FOR TWO SECONDS
	 CALL	 HDECC		       ;ECC TEST
	 MOV	 AX,ERR_CNT	       ;ACCUMULATE
	 ADD	 TERR_CNT,AX	       ;  ERROR COUNT
	 CALL	 DELAY		       ;DELAY FOR TWO SECONDS
	 MOV	 ALL_SW,00H	       ;RESET THE SWITCH
	 CLS	 LO,4,1,23,78	       ;CLEAR THE SCREEN
	 BOX	 17,0,08,80,LO	       ;OUTLINE
	 WRITEC  0CCH,LO,17,0,1        ;  THE
	 WRITEC  0B9H,LO,17,79,1       ;  SCREEN
	 WRITE	 T05		       ;TYPE OF TEST
	 WRITE	 X00		       ;COMMANDS
	 WRITE	 XI0		       ;MSG
	 WRITE	 XS2		       ;STATUS
	 CALL	 D_PASS 	       ;DISPLAY PASS NUMBER
	 CALL	 D_ERR		       ;DISPLAY TOTAL ERROR COUNT
	 MOV	 AL,RW_X	       ;READ_WRITE
	 PMSG	 AL,HI		       ;  STATUS
	 MOV	 AL,HS_X	       ; HEAD SELECT
	 PMSG	 AL,HI		       ;  STATUS
	 MOV	 AL,SEEK_X	       ;SEEK
	 PMSG	 AL,HI		       ;  STATUS
	 MOV	 AL,ECC_X	       ;ECC
	 PMSG	 AL,HI		       ;  STATUS
	 LEA	 BX,XI4 	       ;LIST ENTRY
	 CMP	 [BX].S_DATA,'Y'       ;RUN CONTINIOUSLY??
	 JNE	 RA_50		       ;NO
	 CALL	 DELAY		       ;LET THEM READ IT
	 INC	 PASS		       ;NEXT PASS
	 JMP	 RA_30		       ;DO IT AGAIN
RA_50:
	 JMP	 RA_00		       ;NEXT
; *********************************************************************
; *				E X I T 			      *
; *********************************************************************
EXIT:
	 RET			       ;RETURN
RALL	 ENDP
DELAY	 PROC
	 MOV	 BX,24		       ;OUTER DELAY
DELAY_00:
	 XOR	 CX,CX		       ;INNER DELAY
DELAY_10:
	 LOOP	 DELAY_10	       ;LOOP
	 DEC	 BX		       ;ONE LESS
	 JNZ	 DELAY_00	       ;DONE
	 RET			       ;RETURN
DELAY	 ENDP
; *********************************************************************
; *			DISPLAY PASSES COMPLETE 		      *
; *********************************************************************
D_PASS	 PROC
	 MOV	 AX,PASS	       ;FORMAT
	 LEA	 BX,XP1 	       ; PASSES COMPLETE
	 CALL	 CONV_ASCII	       ;  DISPLAY
	 WRITE	 XP0		       ;CYLINDER
	 RET			       ;RETURN
D_PASS	 ENDP
; *********************************************************************
; *			   DISPLAY ERROR COUNT			      *
; *********************************************************************
D_ERR	 PROC
	 PUSHALL
	 XOR	 AX,AX		       ;CLEAR AX
	 MOV	 AX,TERR_CNT	       ;FORMAT
	 LEA	 BX,XE1 	       ; ERROR COUNT
	 CALL	 CONV_ASCII	       ;  DISPLAY
	 WRITE	 XE0		       ;ERROR COUNT
	 POPALL
	 RET			       ;RETURN
D_ERR	 ENDP
CSEG	 ENDS
	 END	 HDALL
