	 PAGE	 64,132 	       ;PAGE WIDTH,LENGTH
	 .SALL
	 TITLE	 PC/AT HDNOSTIC - LAND THE HEADS
; **********************************************************************
; *								       *
; *	MODULE NAME    HDSHIP					       *
; *	AUTHOR	       JIM BRACKING				       *
; *								       *
; *	DECSRIPTION    THIS PROGRAM PERFORMS THE FOLLOWING	       *
; *		       FUNCTIONS:				       *
; *								       *
; *		       1. LAND THE HARD DISK HEADS		       *
; *								       *
; **********************************************************************
;
; **********************************************************************
; *			EXTERNAL PROGRAM REFERENCES		       *
; **********************************************************************
	 EXTRN	 SCRMGR:NEAR
; **********************************************************************
; *			  EXTERNAL DATA REFERENCES		       *
; **********************************************************************
	 INCLUDE HDDATA.ASM
; **********************************************************************
; *			EXTERNAL SUBROUTINE REFERENCES		       *
; **********************************************************************
	 INCLUDE HDSUB.ASM
; **********************************************************************
; *			    PUBLIC DECLARES			       *
; **********************************************************************
	 PUBLIC  HDSHIP
; **********************************************************************
; *				 MACROS 			       *
; **********************************************************************
	 IF1
	 INCLUDE HD.MAC
	 INCLUDE \SCRMGR\SCRNWORK.MAC
	 ENDIF
; **********************************************************************
; *								       *
; *			       BEGIN				       *
; *								       *
; **********************************************************************
CSEG	 SEGMENT PARA PUBLIC 'CODE'
	 ASSUME CS:CSEG
HDSHIP PROC    NEAR
	 ASSUME  DS:CSEG	       ;DATA SEGMENT
	 JMP	 BY_ID		       ;JMP AROUND ID
	 ID	 HDSHIP
	 INCLUDE \SCRMGR\SCRNWORK.ASM
; **********************************************************************
; *			 EQUATES AND STRUCTURES 		       *
; **********************************************************************
	 INCLUDE HDEQU.ASM
; **********************************************************************
; *				 SCREENS			       *
; **********************************************************************
  SFIELD X00,X01,,@LABEL,RV,23,02,'CTRL-F1 TO START'
  SFIELD X01,X02,,@LABEL,RV,23,29,'ESC FOR THE MAIN MENU'
  SFIELD X02,X00,,@LABEL,RV,23,62,'CTRL-BRK TO STOP'
;
  SFIELD XI0,XI1,,@LABEL,LO,19,15,'DRIVE =>'
  SFIELD XI1,XI2,1,@EX+@NUM+@UC+@NFULL+@REQ,LO,19,24
  SFIELD XI2,XI0,,@LABEL,LO,20,15,'(1 OR 2)'
;
  SFIELD XS0,XS1,,@LABEL,LO,19,46,'STATUS =>'
  SFIELD XS1,XS0,,@LABEL,LO,19,56,'** IDLE **   '
;
  SFIELD XS2,XS3,,@LABEL,LO,19,46,'STATUS =>'
  SFIELD XS3,XS2,,@LABEL,HI,19,56,'** WORKING **'
;
  SFIELD XC0,XC1,,@LABEL,LO,20,46,'CYLINDER =>'
  SFIELD XC1,XC0,04,@LABEL,LO,20,58
;
  SFIELD XE0,XE1,,@LABEL,LO,21,46,'ERRORS =>'
  SFIELD XE1,XE0,05,@LABEL,LO,21,56
;
  SFIELD T05,T05,,@LABEL,RV,17,23,'PREPARE FOR RELOCATION'
;
BY_ID:
HDSHIP ENDP
; *********************************************************************
; *								      *
; *			   LAND THE HEADS			      *
; *								      *
; *********************************************************************
LHDS	 PROC
	 CLS	 LO,4,1,23,78	       ;CLEAR THE SCREEN
	 BOX	 17,0,08,80,LO	       ;OUTLINE
	 WRITEC  0CCH,LO,17,0,1        ;  THE
	 WRITEC  0B9H,LO,17,79,1       ;  SCREEN
	 WRITE	 T05		       ;TYPE OF TEST
	 WRITE	 X00		       ;COMMANDS
LH_00:
	 WRITE	 XS0		       ;STATUS
	 LEA	 BX,XI1 	       ;DRIVE ENTRY
	 MOV	 [BX].S_ATTR,LO        ;RESTORE ATTRIBUTE
	 MOV	 [BX].S_DATA,' '       ;CLEAR DRIVE
	 WRITE	 XI0		       ;DRIVE + INTERLEAVE
LH_02:
	 READR	 BX		       ;FETCH DRIVE AND INTERLEAVE
	 CALL	 TRANS_KEY	       ;TRANSLATE THE KEY
	 JNC	 LH_04		       ;SUCESSFULL
LH_03:
	 CALL	 BEEP		       ;RING THE BELL
	 JMP	 LH_02		       ;TRY AGAIN
LH_04:
	 CMP	 AL,ESC_KEY	       ;ESCAPE KEY??
	 JNE	 LH_05		       ;NO
	 JMP	 EXIT		       ;RETURN
LH_05:
	 CMP	 AL,C_BRK	       ;CONTROL BREAK KEY??
	 JNE	 LH_07		       ;NO
	 JMP	 LHDS		       ;YES - START OVER
LH_07:
	 CMP	 AL,C_F1	       ;CTRL_F1??
	 JNE	 LH_03		       ;NO - INVALID KEY
	 LEA	 BX,XI1 	       ;DRIVE ENTRY
	 MOV	 [BX].S_ATTR,LO        ;RESTORE ATTRIBUTE
	 MOV	 AL,[BX].S_DATA        ;FETCH DRIVE NUMBER
	 CMP	 AL,'1'                ;VALID DRIVE??
	 JE	 LH_08		       ;YES
	 CMP	 AL,'2'                ;VALID DRIVE??
	 JE	 LH_08		       ;YES
	 MOV	 [BX].S_ATTR,HI        ;HIGHLIGHT IT
	 PMSG	 22		       ;DISPLAY THE MESSAGE
	 CALL	 BEEP		       ;RING THE BELL
	 WRITE	 XI0		       ;DRIVE + INTERLEAVE
	 JMP	 LH_02		       ;TRY AGAIN
LH_08:
	 AND	 AL,0FH 	       ;ADJUST
	 DEC	 AL		       ;  DRIVE NUMBER
	 CMP	 AL,NUM_DR	       ;DRIVE INSTALLED
	 JB	 LH_10		       ;YES
	 MOV	 [BX].S_ATTR,HI        ;HIGHLIGHT IT
	 PMSG	 21		       ;DISPLAY THE MESSAGE
	 CALL	 BEEP		       ;RING THE BELL
	 WRITE	 XI0		       ;DRIVE + INTERLEAVE
	 JMP	 LH_02		       ;TRY AGAIN
LH_10:
	 MOV	 DR,AL		       ;SAVE DRIVE NUMBER
	 LEA	 BX,XI1 	       ;DRIVE ENTRY
	 MOV	 [BX].S_ATTR,LO        ;RESTORE ATTRIBUTE
	 WRITE	 XI0		       ;DRIVE
LH_20:
	 CALL	 READ_PARMS	       ;FETCH DRIVE PARMS
	 MOV	 CUR_HD,0	       ;INITIALIZE
	 MOV	 CUR_SEC,1	       ; THE
	 MOV	 CUR_CYL,0	       ;  STARTING FIELDS
	 MOV	 ERR_CNT,0	       ;CLEAR THE ERROR COUNT
	 MOV	 NUM_SEC,1	       ;NUMBER OF SECTORS
	 CALL	 UPD_CYL	       ;DISPLAY CYLINDER NUMBER
	 CALL	 UPD_ERR	       ;DISPLAY ERROR COUNT
	 WRITE	 XS2		       ;STATUS
	 CLS	 LO,4,2,16,78	       ;CLEAR THE SCREEN
	 CALL	 HIDE_CUR	       ;HIDE THE CURSOR
	 CALL	 CTLR_DIAG	       ;CTLR HD
	 JC	 LH_70		       ;FAILED
; *********************************************************************
; *			   BEGIN THE TEST			      *
; *********************************************************************
LH_40:
	 MOV	 AH,0BH 	       ;CHECK FOR
	 INT	 21H		       ;  CONTROL BREAK
	 MOV	 AX,INT_AREA	       ;ESTABLISH
	 MOV	 ES,AX		       ;  SEGMENT
	 CMP	 DR,00H 	       ;DRIVE C??
	 JNE	 LH_50		       ;NO
	 LES	 SI,ES:INT_41	       ;FETCH PARM VECTORS
	 MOV	 AX,WORD PTR ES:[SI+12] ;LANDING ZONE
	 JMP	 LH_60		       ;CONTINUE
LH_50:
	 LES	 SI,ES:INT_46	       ;FETCH PARM VECTORS
	 MOV	 AX,WORD PTR ES:[SI+12] ;LANDING ZONE
LH_60:
	 MOV	 CUR_CYL,AX	       ;SET CYLINDER
	 CALL	 UPD_CYL	       ;DISPLAY CURRENT CYLINDER
	 MOV	 HD_CMD,SEEK_CMD       ;SEEK COMMAND
	 MOV	 NUM_SEC,1	       ;NUMBER OF SECTORS
	 CALL	 EXEC_CMD	       ;VERIFY THE SECTOR
	 CALL	 UPD_ERR	       ;DISPLAY ERROR COUNT
	 CMP	 ERR_CNT,0	       ;ANY ERRORS??
	 JNE	 LH_70		       ;YES
	 PMSG	 37,HI		       ;TEST COMPLETE
	 PMSG	 44,HI		       ;  COMPLETE
	 JMP	 LH_00		       ;NEXT
LH_70:
	 PMSG	 38,HI		       ;ERROR MSG
	 JMP	 LH_00		       ;NEXT
; *********************************************************************
; *				E X I T 			      *
; *********************************************************************
EXIT:
	 RET			       ;RETURN
LHDS	 ENDP
; *********************************************************************
; *			DISPLAY CURRENT CYLINDER		      *
; *********************************************************************
UPD_CYL  PROC
	 PUSHALL
	 MOV	 AX,CUR_CYL	       ;FORMAT
	 LEA	 BX,XC1 	       ; CYLINDER
	 CALL	 CONV_ASCII	       ;  DISPLAY
	 WRITE	 XC0		       ;CYLINDER
	 POPALL
	 RET			       ;RETURN
UPD_CYL  ENDP
; *********************************************************************
; *			   DISPLAY ERROR COUNT			      *
; *********************************************************************
UPD_ERR  PROC
	 PUSHALL
	 XOR	 AX,AX		       ;CLEAR AX
	 MOV	 AX,ERR_CNT	       ;FORMAT
	 LEA	 BX,XE1 	       ; ERROR COUNT
	 CALL	 CONV_ASCII	       ;  DISPLAY
	 WRITE	 XE0		       ;ERROR COUNT
	 POPALL
	 RET			       ;RETURN
UPD_ERR  ENDP
CSEG	 ENDS
	 END	 HDSHIP
