	 PAGE	 64,132 	       ;PAGE WIDTH,LENGTH
	 .SALL
	 TITLE	 PC/AT DIAGNOSTIC - FLAG SPECIFIC SECORS
; **********************************************************************
; *								       *
; *	MODULE NAME    HDFSEC					       *
; *	AUTHOR	       JIM BRACKING				       *
; *								       *
; *	DECSRIPTION    THIS PROGRAM PERFORMS THE FOLLOWING	       *
; *		       FUNCTIONS:				       *
; *								       *
; *		       1. FLAGS MANUFACTURING DEFECTS		       *
; *								       *
; **********************************************************************
;
; **********************************************************************
; *			EXTERNAL PROGRAM REFERENCES		       *
; **********************************************************************
	 EXTRN	 SCRMGR:NEAR,HDRW:NEAR,HDHS:NEAR
	 EXTRN	 HDSEEK:NEAR,HDECC:NEAR
; **********************************************************************
; *			  EXTERNAL DATA REFERENCES		       *
; **********************************************************************
	 INCLUDE HDDATA.ASM
; **********************************************************************
; *			EXTERNAL SUBROUTINE REFERENCES		       *
; **********************************************************************
	 INCLUDE HDSUB.ASM
	 EXTRN	 LOGERR:NEAR
; **********************************************************************
; *			    PUBLIC DECLARES			       *
; **********************************************************************
	 PUBLIC  HDFSEC
; **********************************************************************
; *				 MACROS 			       *
; **********************************************************************
	 IF1
	 INCLUDE HD.MAC
	 INCLUDE \SCRMGR\SCRNWORK.MAC
	 ENDIF
; **********************************************************************
; *								       *
; *			       BEGIN				       *
; *								       *
; **********************************************************************
CSEG	 SEGMENT PARA PUBLIC 'CODE'
	 ASSUME CS:CSEG
HDFSEC PROC    NEAR
	 ASSUME  DS:CSEG	       ;DATA SEGMENT
	 JMP	 BY_ID		       ;JMP AROUND ID
	 ID	 HDFSEC
	 INCLUDE \SCRMGR\SCRNWORK.ASM
; **********************************************************************
; *			 EQUATES AND STRUCTURES 		       *
; **********************************************************************
	 INCLUDE HDEQU.ASM
; **********************************************************************
; *				 SCREENS			       *
; **********************************************************************
  SFIELD X00,X01,,@LABEL,RV,23,02,'CTRL-F1 TO START'
  SFIELD X01,X02,,@LABEL,RV,23,29,'ESC FOR THE MAIN MENU'
  SFIELD X02,X00,,@LABEL,RV,23,62,'CTRL-BRK TO STOP'
;
  SFIELD XI0,XI1,,@LABEL,LO,19,05,'DRIVE =>'
  SFIELD XI1,XI2,1,@EX+@NUM+@UC+@NFULL+@REQ,LO,19,14
  SFIELD XI2,XI3,,@LABEL,LO,20,05,'(1 OR 2)'
  SFIELD XI3,XI4,,@LABEL,LO,19,20,'CYLINDER =>'
  SFIELD XI4,XI5,4,@EX+@NUM+@NFULL+@REQ,LO,19,32
  SFIELD XI5,XI6,,@LABEL,LO,20,20,'HEAD =>'
  SFIELD XI6,XI9,2,@EX+@NUM+@NFULL+@REQ,LO,20,28
  SFIELD XI9,XIA,,@LABEL,LO,19,46,'INTERLEAVE =>'
  SFIELD XIA,XIB,1,@EX+@NUM+@NFULL+@REQ,LO,19,60
  SFIELD XIB,XI0,,@LABEL,LO,20,50,'(1-8)'
;
  SFIELD XS0,XS1,,@LABEL,LO,21,46,'STATUS =>'
  SFIELD XS1,XS0,,@LABEL,LO,21,56,'** IDLE **   '
;
  SFIELD XS2,XS3,,@LABEL,LO,21,46,'STATUS =>'
  SFIELD XS3,XS2,,@LABEL,HI,21,56,'** WORKING **'
  SFIELD T05,T05,,@LABEL,RV,17,33,'FLAG DEFECTS'
;
  SFIELD E01,E02,,@LABEL,LO,16,02,'  CYL XXXX HEAD XX HAS BEEN FLAGGED'
  SFIELD E02,E03,04,@LABEL,LO,16,08
  SFIELD E03,E01,02,@LABEL,LO,16,18
BY_ID:
HDFSEC ENDP
; *********************************************************************
; *								      *
; *			  FLAG MANUFACTORINT DEFECTS		      *
; *								      *
; *********************************************************************
FSEC	 PROC
	 CLS	 LO,4,1,23,78	       ;CLEAR THE SCREEN
	 BOX	 17,0,08,80,LO	       ;OUTLINE
	 WRITEC  0CCH,LO,17,0,1        ;  THE
	 WRITEC  0B9H,LO,17,79,1       ;  SCREEN
	 WRITE	 T05		       ;TYPE OF TEST
	 WRITE	 X00		       ;COMMANDS
FS_00:
	 LEA	 BX,XIA 	       ;INTERLEAVE ENTRY
	 MOV	 [BX].S_ATTR,LO        ;RESTORE ATTRIBUTE
	 MOV	 [BX].S_DATA,'3'       ;DEFAULT INTERLEAVE OF 3 (AT)
	 CMP	 PCT,00H	       ;IBM/AT??
	 JE	 FS_01		       ;YES
	 MOV	 [BX].S_DATA,'6'       ;DEFAULT INTERLEAVE OF 6 (PC)
FS_01:
	 WRITE	 XS0		       ;STATUS
	 LEA	 BX,XI1 	       ;DRIVE ENTRY
	 CALL	 CLR_FLD	       ;CLEAR THE ENTRY
	 LEA	 BX,XI4 	       ;CYLINDER
	 CALL	 CLR_FLD	       ;CLEAR THE ENTRY
	 LEA	 BX,XI6 	       ;HEAD
	 CALL	 CLR_FLD	       ;CLEAR THE ENTRY
	 WRITE	 XI0		       ;MSG
FS_02:
	 READR	 BX		       ;FETCH ANSWERS
	 CALL	 TRANS_KEY	       ;TRANSLATE THE KEY
	 JNC	 FS_04		       ;SUCESSFULL
FS_03:
	 CALL	 BEEP		       ;RING THE BELL
	 JMP	 FS_02		       ;TRY AGAIN
FS_04:
	 CMP	 AL,ESC_KEY	       ;ESCAPE KEY??
	 JNE	 FS_05		       ;NO
	 JMP	 EXIT		       ;RETURN
FS_05:
	 CMP	 AL,C_BRK	       ;CONTROL BREAK KEY??
	 JNE	 FS_07		       ;NO
	 JMP	 FSEC		       ;YES - START OVER
FS_07:
	 CMP	 AL,C_F1	       ;CTRL_F1??
	 JNE	 FS_03		       ;NO - INVALID KEY
	 LEA	 BX,XI1 	       ;DRIVE ENTRY
	 MOV	 [BX].S_ATTR,LO        ;RESTORE ATTRIBUTE
	 MOV	 AL,[BX].S_DATA        ;FETCH DRIVE NUMBER
	 CMP	 AL,'1'                ;VALID DRIVE??
	 JE	 FS_08		       ;YES
	 CMP	 AL,'2'                ;VALID DRIVE??
	 JE	 FS_08		       ;YES
	 MOV	 [BX].S_ATTR,HI        ;HIGHLIGHT IT
	 PMSG	 22		       ;DISPLAY THE MESSAGE
	 CALL	 BEEP		       ;RING THE BELL
	 WRITE	 XI0		       ;DRIVE + INTERLEAVE
	 JMP	 FS_02		       ;TRY AGAIN
FS_08:
	 AND	 AL,0FH 	       ;ADJUST
	 DEC	 AL		       ;  DRIVE NUMBER
	 CMP	 AL,NUM_DR	       ;DRIVE INSTALLED
	 JB	 FS_10		       ;YES
	 MOV	 [BX].S_ATTR,HI        ;HIGHLIGHT IT
	 PMSG	 21		       ;DISPLAY THE MESSAGE
	 CALL	 BEEP		       ;RING THE BELL
	 WRITE	 XI0		       ;DRIVE
	 JMP	 FS_02		       ;TRY AGAIN
FS_10:
	 MOV	 DR,AL		       ;SAVE DRIVE NUMBER
	 LEA	 BX,XI1 	       ;DRIVE ENTRY
	 MOV	 [BX].S_ATTR,LO        ;RESTORE ATTRIBUTE
	 WRITE	 XI0		       ;DRIVE
	 CALL	 READ_PARMS	       ;FETCH DRIVE PARMS
;
	 LEA	 BX,XI4 	       ;CONVERT CYLINDER
	 CALL	 CVT_HEX	       ;  TO HEX IN AX
	 JNC	 FS_20		       ;SUCESSFULL
FS_15:
	 MOV	 [BX].S_ATTR,HI        ;HIGHLIGHT IT
	 PMSG	 39		       ;DISPLAY THE MESSAGE
	 CALL	 BEEP		       ;RING THE BELL
	 WRITE	 XI0		       ;DRIVE
	 LEA	 BX,XI4 	       ;CYLINDER
	 JMP	 FS_02		       ;TRY AGAIN
FS_20:
	 CMP	 AX,MAX_CYL	       ;IN RANGE??
	 JA	 FS_15		       ;NO
	 MOV	 CUR_CYL,AX	       ;SAVE CYLINDER
	 LEA	 BX,XI6 	       ;CONVERT HEAD
	 CALL	 CVT_HEX	       ;  TO HEX IN AL
	 JNC	 FS_30		       ;SUCESSFULL
FS_25:
	 MOV	 [BX].S_ATTR,HI        ;HIGHLIGHT IT
	 PMSG	 40		       ;DISPLAY THE MESSAGE
	 CALL	 BEEP		       ;RING THE BELL
	 WRITE	 XI0		       ;DRIVE
	 LEA	 BX,XI6 	       ;HEAD
	 JMP	 FS_02		       ;TRY AGAIN
FS_30:
	 CMP	 AL,MAX_HD	       ;IN RANGE??
	 JA	 FS_25		       ;NO
	 MOV	 CUR_HD,AL	       ;SAVE HEAD
	 MOV	 AL,CUR_HD	       ;CONVERT HEAD
	 LEA	 BX,XI6 	       ; TO
	 CALL	 CONV_ASCII	       ;   ASCII
	 MOV	 [BX].S_ATTR,LO        ;RESTORE ATTRIBUTE
	 MOV	 AX,CUR_CYL	       ;CONVERT CYLINDER
	 LEA	 BX,XI4 	       ; TO
	 CALL	 CONV_ASCII	       ;   ASCII
	 MOV	 [BX].S_ATTR,LO        ;RESTORE ATTRIBUTE
; *********************************************************************
; *			   PROCESS INTERLEAVE			      *
; *********************************************************************
	 LEA	 BX,XIA 	       ;INTERLEAVE ENTRY
	 MOV	 [BX].S_ATTR,LO        ;RESTORE ATTRIBUTE
	 MOV	 AL,[BX].S_DATA        ;FETCH INTERLEAVE
	 CMP	 AL,'1'                ;IN RANGE??
	 JB	 FS_45		       ;NO
	 CMP	 AL,'8'                ;IN RANGE??
	 JA	 FS_45		       ;NO
	 JMP	 FS_50		       ;CONTINUE
FS_45:
	 MOV	 [BX].S_ATTR,HI        ;HIGHLIGHT IT
	 PMSG	 23		       ;DISPLAY THE MESSAGE
	 CALL	 BEEP		       ;RING THE BELL
	 WRITE	 XI9		       ;INTERLEAVE
	 JMP	 FS_02		       ;TRY AGAIN
FS_50:
	 XOR	 AH,AH		       ;CLEAR AH
	 AND	 AL,0FH 	       ;MAKE IT A DIGIT
	 DEC	 AL		       ;RELEATIVE TO ZERO
	 XOR	 DX,DX		       ;CLEAR DX
	 MOV	 CX,17		       ;SECTORS PER TRACK
	 MUL	 CX
	 LEA	 SI,INL_TBL	       ;INTERLEAVE TABLE
	 ADD	 SI,AX		       ;TABLE INDEX
	 XOR	 AX,AX		       ;PAD CHARACTER
	 MOV	 CX,512 	       ;BUFFER SIZE
	 CLD			       ;FORWARD DIRECTION
	 LEA	 DI,FMT_BUFF	       ;FORMAT BUFFER
	 PUSH	 DS		       ;ESTABLISH
	 POP	 ES		       ;  SEGMENT
	 REP	 STOSB		       ;ZERO THE BUFFER
	 MOV	 CX,17		       ;NUMBER OF SECTORS
	 LEA	 DI,FMT_BUFF	       ;FORMAT BUFFER
FS_60:
	 LODSB			       ;FETCH SECTOR NUMBER
	 MOV	 AH,80H 	       ;BAD SECTOR INDICATOR
	 XCHG	 AL,AH		       ;ADJUST FOR STOSW
	 STOSW			       ;SET SECTOR NUMBER
	 XOR	 AX,AX		       ;CLEAR AX
	 LOOP	 FS_60		       ;COMPLETE THE BUFFER
FS_65:
	 LEA	 BX,XIA 	       ;INTERLEAVE ENTRY
	 MOV	 [BX].S_ATTR,LO        ;RESTORE ATTRIBUTE
	 WRITE	 XI0		       ;REDISPLAY
	 CALL	 HIDE_CUR	       ;HIDE THE CURSOR
; *********************************************************************
; *			FORMAT THE TRACK			      *
; *********************************************************************
FS_90:
	 PUSH	 DS		       ;ESTABLISH
	 POP	 ES		       ;  SEGMENT
	 CMP	 PCT,00H	       ;IBM/AT??
	 JNE	 FS_95		       ;NO
	 MOV	 AH,FMT_CMD	       ;FORMAT TRACK COMMAND
	 MOV	 AL,17		       ;NUMBER OF SECTORS
	 JMP	 FS_100 	       ;CONTINUE
FS_95:
	 MOV	 AH,FMBT_CMD	       ;FORMAT BAD TRACK COMMAND
	 LEA	 BX,XIA 	       ;FETCH
	 MOV	 AL,[BX].S_DATA        ;  INTERLEAVE
	 AND	 AL,0FH 	       ;MAKE IT A DIGIT
FS_100:
	 MOV	 DX,CUR_CYL	       ;CURRENT CYLINDER
	 XCHG	 DH,DL		       ;ADJUST IT
	 MOV	 CX,6		       ;SHIFT COUNT
	 SHL	 DL,CL		       ;ADJUST CYL HIGH
	 OR	 DL,01H 	       ;SET SECTOR NUMBER
	 MOV	 CX,DX		       ;CX SET
	 MOV	 DH,CUR_HD	       ;SET HEAD
	 MOV	 DL,DR		       ;DRIVE
	 OR	 DL,80H 	       ;  NUMBER
	 LEA	 BX,FMT_BUFF	       ;FORMAT BUFFER
	 INT	 13H		       ;EXECUTE THE COMMAND
	 MOV	 AX,CUR_CYL	       ;FORMAT
	 LEA	 BX,E02 	       ;  CYLINDER
	 CALL	 CONV_ASCII
	 XOR	 AX,AX		       ;CLEAR AX
	 MOV	 AL,CUR_HD	       ;FORMAT
	 LEA	 BX,E03 	       ;  HEAD
	 CALL	 CONV_ASCII
	 SCROLL  LO,4,2,16,78	       ;SCROLL
	 WRITE	 E01		       ;DISPLAY THE MESSAGE
	 CALL	 LOGERR 	       ;PRINT THE MESSAGE
	 LEA	 BX,XI0 	       ;INPUT
	 JMP	 FS_02		       ;NEXT
; *********************************************************************
; *				E X I T 			      *
; *********************************************************************
EXIT:
	 RET			       ;RETURN
FSEC	 ENDP
; *********************************************************************
; *			   CONVERT TO HEX			      *
; *********************************************************************
CVT_HEX  PROC
	 PUSHALL
	 XOR	 CX,CX		       ;CLEAR CX
	 MOV	 CL,[BX].S_LEN	       ;FIELD LENGTH
	 LEA	 SI,[BX].S_DATA        ;BEGINING OF FIELD
	 ADD	 SI,CX		       ;POINT TO THE
	 DEC	 SI		       ;  LAST BYTE
	 STD			       ;REVERSE DIRECTION
	 XOR	 DI,DI		       ;CLEAR DI
	 MOV	 BP,1		       ;STARTING MULTIPLIER
CVT_00:
	 LODSB			       ;FETCH A BYTE
	 CMP	 AL,' '                ;FIRST BYTE??
	 JNE	 CVT_20 	       ;YES
	 LOOP	 CVT_00 	       ;NEXT BYTE
	 JMP	 CVT_ERR	       ;EXIT
CVT_10:
	 LODSB			       ;FETCH A BYTE
	 CMP	 AL,' '                ;LAST BYTE??
	 JE	 CVT_30 	       ;YES
CVT_20:
	 CMP	 AL,'.'                ;PERIOD??
	 JE	 CVT_ERR	       ;YES - ERROR
	 XOR	 AH,AH		       ;CLEAR AH
	 AND	 AL,0FH 	       ;MAKE IT A DIGIT
	 MUL	 BP		       ;UP IT AGAIN
	 ADD	 DI,AX		       ;ACCUMULATE IT
	 MOV	 AX,BP		       ;RAISE THE
	 MOV	 BP,10		       ; MULTIPLIER
	 MUL	 BP		       ; BY
	 MOV	 BP,AX		       ; 10X
	 LOOP	 CVT_10 	       ;NEXT BYTE
CVT_30:
	 MOV	 AX,DI		       ;HEX VALUE
	 POPALL
	 CLC			       ;SUCESSFULL
	 RET			       ;RETURN
CVT_ERR:
	 STC			       ;ERROR
	 POPALL
	 RET			       ;RETURN
CVT_HEX  ENDP
; *********************************************************************
; *			   CLEAR THE FIELD			      *
; *********************************************************************
CLR_FLD  PROC
	 PUSHALL
	 MOV	 [BX].S_ATTR,LO        ;RESTORE ATTRIBUTE
	 CLD			       ;FORWARD DIRECTION
	 LEA	 DI,[BX].S_DATA        ;FIELD ADDRESS
	 XOR	 CX,CX		       ;CLEAR CX
	 MOV	 CL,[BX].S_LEN	       ;FIELD LENGTH
	 MOV	 AL,' '                ;PAD CHARACTER
	 PUSH	 DS		       ;ESTABLISH
	 POP	 ES		       ;  SEGMENT
	 REP	 STOSB		       ;CLEAR THE FIELD
	 POPALL
	 RET			       ;RETURN
CLR_FLD  ENDP
CSEG	 ENDS
	 END	 HDFSEC
