	 PAGE	 64,132 	       ;PAGE WIDTH,LENGTH
	 .SALL
	 TITLE	 PC/AT DIAGNOSTIC - FORMAT ROUTINE
; **********************************************************************
; *								       *
; *	MODULE NAME    HDFMT					       *
; *	AUTHOR	       JIM BRACKING				       *
; *								       *
; *	DECSRIPTION    THIS PROGRAM PERFORMS THE FOLLOWING	       *
; *		       FUNCTIONS:				       *
; *								       *
; *		       1. FORMATS HARD DISKS			       *
; *								       *
; **********************************************************************
;
; **********************************************************************
; *			EXTERNAL PROGRAM REFERENCES		       *
; **********************************************************************
	 EXTRN	 SCRMGR:NEAR
; **********************************************************************
; *			  EXTERNAL DATA REFERENCES		       *
; **********************************************************************
	 INCLUDE HDDATA.ASM
; **********************************************************************
; *			EXTERNAL SUBROUTINE REFERENCES		       *
; **********************************************************************
	 INCLUDE HDSUB.ASM
	 EXTRN	 LOGERR:NEAR
; **********************************************************************
; *			    PUBLIC DECLARES			       *
; **********************************************************************
	 PUBLIC  HDFMT
; **********************************************************************
; *				 MACROS 			       *
; **********************************************************************
	 IF1
	 INCLUDE HD.MAC
	 INCLUDE \SCRMGR\SCRNWORK.MAC
	 ENDIF
; **********************************************************************
; *								       *
; *			       BEGIN				       *
; *								       *
; **********************************************************************
CSEG	 SEGMENT PARA PUBLIC 'CODE'
	 ASSUME CS:CSEG
HDFMT  PROC    NEAR
	 ASSUME  DS:CSEG	       ;DATA SEGMENT
	 JMP	 BY_ID		       ;JMP AROUND ID
	 ID	 HDFMT
	 INCLUDE \SCRMGR\SCRNWORK.ASM
; **********************************************************************
; *			 EQUATES AND STRUCTURES 		       *
; **********************************************************************
	 INCLUDE HDEQU.ASM
; **********************************************************************
; *				 SCREENS			       *
; **********************************************************************
  SFIELD FM0,FM1,,@LABEL,RV+BLINK,14,34,' WARNING '
  SFIELD FM1,FM2,,@LABEL,LO,15,18,'THIS WILL DESTROY ALL DATA ON THE HARD DISK'
  SFIELD FM2,FM3,,@LABEL,LO,16,22,'REPLY Y TO CONTINUE OR N TO STOP -'
  SFIELD FM3,FM0,,@YN+@UC+@NFULL+@REQ,LO,16,57,' '
  SFIELD T05,T05,,@LABEL,RV,17,33,'FORMAT DRIVE'
;
  SFIELD X00,X01,,@LABEL,RV,23,02,'CTRL-F1 TO START'
  SFIELD X01,X02,,@LABEL,RV,23,29,'ESC FOR THE MAIN MENU'
  SFIELD X02,X00,,@LABEL,RV,23,62,'CTRL-BRK TO STOP'
;
  SFIELD XI0,XI1,,@LABEL,LO,19,05,'DRIVE =>'
  SFIELD XI1,XI2,1,@EX+@NUM+@UC+@NFULL+@REQ,LO,19,14
  SFIELD XI2,XI3A,,@LABEL,LO,20,05,'(1 OR 2)'
  SFIELD XI3A,XI3B,,@LABEL,LO,21,05,'CLEAR DEFECTS =>'
  SFIELD XI3B,XI3,1,@EX+@YN+@UC+@NFULL+@REQ,LO,21,22
  SFIELD XI3,XI4,,@LABEL,LO,19,22,'INTERLEAVE =>'
  SFIELD XI4,XI5,1,@EX+@NUM+@NFULL+@REQ,LO,19,36
  SFIELD XI5,XI0,,@LABEL,LO,20,26,'(1-8)'
;
  SFIELD XS0,XS1,,@LABEL,LO,19,46,'STATUS =>'
  SFIELD XS1,XS0,,@LABEL,LO,19,56,'** IDLE **   '
;
  SFIELD XS2,XS3,,@LABEL,LO,19,46,'STATUS =>'
  SFIELD XS3,XS2,,@LABEL,HI,19,56,'** WORKING **'
;
  SFIELD XC0,XC1,,@LABEL,LO,20,46,'CYLINDER =>'
  SFIELD XC1,XC0,04,@LABEL,LO,20,58
;
  SFIELD XE0,XE1,,@LABEL,LO,21,46,'ERRORS =>'
  SFIELD XE1,XE0,04,@LABEL,LO,21,56
;
  SFIELD E01,E02,,@LABEL,LO,16,02,'  CYL XXXX HEAD XX HAS BEEN FLAGGED'
  SFIELD E02,E03,04,@LABEL,LO,16,08
  SFIELD E03,E01,02,@LABEL,LO,16,18
BY_ID:
HDFMT  ENDP
; *********************************************************************
; *								      *
; *			     FORMAT DRIVE			      *
; *								      *
; *********************************************************************
FMT	 PROC
	 CLS	 LO,4,1,23,78	       ;CLEAR THE SCREEN
	 BOX	 17,0,08,80,LO	       ;OUTLINE
	 WRITEC  0CCH,LO,17,0,1        ;  THE
	 WRITEC  0B9H,LO,17,79,1       ;  SCREEN
	 WRITE	 T05		       ;TYPE OF TEST
	 WRITE	 X00		       ;COMMANDS
FMT_00:
	 WRITE	 XS0		       ;STATUS
	 LEA	 BX,XI1 	       ;DRIVE ENTRY
	 MOV	 [BX].S_ATTR,LO        ;RESTORE ATTRIBUTE
	 MOV	 [BX].S_DATA,' '       ;CLEAR DRIVE
	 LEA	 BX,XI4 	       ;INTERLEAVE ENTRY
	 MOV	 [BX].S_ATTR,LO        ;RESTORE ATTRIBUTE
	 MOV	 [BX].S_DATA,'3'       ;DEFAULT INTERLEAVE OF 3 (AT)
	 CMP	 PCT,00H	       ;IBM/AT??
	 JE	 FMT_01 	       ;YES
	 MOV	 [BX].S_DATA,'6'       ;DEFAULT INTERLEAVE OF 6 (PC)
FMT_01:
	 LEA	 BX,XI3B	       ;DEFAULT NO TO
	 MOV	 [BX].S_DATA,'N'       ;  CLEAR DEFECTS
	 WRITE	 XI0		       ;DRIVE + INTERLEAVE
FMT_02:
	 READR	 BX		       ;FETCH DRIVE AND INTERLEAVE
	 CALL	 TRANS_KEY	       ;TRANSLATE THE KEY
	 JNC	 FMT_04 	       ;SUCESSFULL
FMT_03:
	 CALL	 BEEP		       ;RING THE BELL
	 JMP	 FMT_02 	       ;TRY AGAIN
FMT_04:
	 CMP	 AL,ESC_KEY	       ;ESCAPE KEY??
	 JNE	 FMT_05 	       ;NO
	 JMP	 EXIT		       ;RETURN
FMT_05:
	 CMP	 AL,C_BRK	       ;CONTROL BREAK KEY??
	 JNE	 FMT_07 	       ;NO
	 JMP	 FMT		       ;YES - START OVER
FMT_07:
	 CMP	 AL,C_F1	       ;CTRL_F1??
	 JNE	 FMT_03 	       ;NO - INVALID KEY
	 LEA	 BX,XI1 	       ;DRIVE ENTRY
	 MOV	 [BX].S_ATTR,LO        ;RESTORE ATTRIBUTE
	 MOV	 AL,[BX].S_DATA        ;FETCH DRIVE NUMBER
	 CMP	 AL,'1'                ;VALID DRIVE??
	 JE	 FMT_08 	       ;YES
	 CMP	 AL,'2'                ;VALID DRIVE??
	 JE	 FMT_08 	       ;YES
	 MOV	 [BX].S_ATTR,HI        ;HIGHLIGHT IT
	 PMSG	 22		       ;DISPLAY THE MESSAGE
	 CALL	 BEEP		       ;RING THE BELL
	 WRITE	 XI0		       ;DRIVE + INTERLEAVE
	 JMP	 FMT_02 	       ;TRY AGAIN
FMT_08:
	 AND	 AL,0FH 	       ;ADJUST
	 DEC	 AL		       ;  DRIVE NUMBER
	 CMP	 AL,NUM_DR	       ;DRIVE INSTALLED
	 JB	 FMT_10 	       ;YES
	 MOV	 [BX].S_ATTR,HI        ;HIGHLIGHT IT
	 PMSG	 21		       ;DISPLAY THE MESSAGE
	 CALL	 BEEP		       ;RING THE BELL
	 WRITE	 XI0		       ;DRIVE + INTERLEAVE
	 JMP	 FMT_02 	       ;TRY AGAIN
FMT_10:
	 MOV	 DR,AL		       ;SAVE DRIVE NUMBER
	 LEA	 BX,XI4 	       ;INTERLEAVE ENTRY
	 MOV	 [BX].S_ATTR,LO        ;RESTORE ATTRIBUTE
	 MOV	 AL,[BX].S_DATA        ;FETCH INTERLEAVE
	 CMP	 AL,'1'                ;IN RANGE??
	 JB	 FMT_15 	       ;NO
	 CMP	 AL,'8'                ;IN RANGE??
	 JA	 FMT_15 	       ;NO
	 JMP	 FMT_20 	       ;CONTINUE
FMT_15:
	 MOV	 [BX].S_ATTR,HI        ;HIGHLIGHT IT
	 PMSG	 23		       ;DISPLAY THE MESSAGE
	 CALL	 BEEP		       ;RING THE BELL
	 WRITE	 XI2		       ;DRIVE + INTERLEAVE
	 JMP	 FMT_02 	       ;TRY AGAIN
FMT_20:
	 CMP	 PCT,00H	       ;IBM/AT??
	 JNE	 FMT_35 	       ;NO
	 XOR	 AH,AH		       ;CLEAR AH
	 AND	 AL,0FH 	       ;MAKE IT A DIGIT
	 DEC	 AL		       ;RELEATIVE TO ZERO
	 XOR	 DX,DX		       ;CLEAR DX
	 MOV	 CX,17		       ;SECTORS PER TRACK
	 MUL	 CX
	 LEA	 SI,INL_TBL	       ;INTERLEAVE TABLE
	 ADD	 SI,AX		       ;TABLE INDEX
	 XOR	 AX,AX		       ;PAD CHARACTER
	 MOV	 CX,512 	       ;BUFFER SIZE
	 CLD			       ;FORWARD DIRECTION
	 LEA	 DI,FMT_BUFF	       ;FORMAT BUFFER
	 PUSH	 DS		       ;ESTABLISH
	 POP	 ES		       ;  SEGMENT
	 REP	 STOSB		       ;ZERO THE BUFFER
	 MOV	 CX,17		       ;NUMBER OF SECTORS
	 LEA	 DI,FMT_BUFF	       ;FORMAT BUFFER
FMT_30:
	 LODSB			       ;FETCH SECTOR NUMBER
	 XCHG	 AL,AH		       ;ADJUST FOR STOSW
	 STOSW			       ;SET SECTOR NUMBER
	 XOR	 AX,AX		       ;CLEAR AX
	 LOOP	 FMT_30 	       ;COMPLETE THE BUFFER
FMT_35:
	 LEA	 BX,XI1 	       ;DRIVE ENTRY
	 MOV	 [BX].S_ATTR,LO        ;RESTORE ATTRIBUTE
	 LEA	 BX,XI4 	       ;INTERLEAVE ENTRY
	 MOV	 [BX].S_ATTR,LO        ;RESTORE ATTRIBUTE
	 WRITE	 XI0		       ;DRIVE + INTERLEAVE
	 LEA	 BX,FM3 	       ;REPLY ENTRY
	 MOV	 [BX].S_DATA,' '       ;CLEAR REPLY
	 CLS	 LO,4,2,16,78	       ;CLEAR THE SCREEN
	 WRITE	 FM0		       ;DISPLAY FORMAT MESSAGE
	 READ	 FM0		       ;GET REPLY
	 LEA	 BX,FM3 	       ;REPLY ENTRY
	 CMP	 [BX].S_DATA,'Y'       ;CONTINUE??
	 JE	 FMT_40 	       ;YES
	 JMP	 FMT		       ;RESTART
FMT_40:
	 CALL	 READ_PARMS	       ;FETCH DRIVE PARMS
	 MOV	 CUR_HD,0	       ;INITIALIZE
	 MOV	 CUR_SEC,1	       ; THE
	 MOV	 CUR_CYL,0	       ;  STARTING FIELDS
	 MOV	 ERR_CNT,0	       ;CLEAR THE ERROR COUNT
	 MOV	 NUM_SEC,17	       ;NUMBER OF SECTORS
	 WRITE	 XS2		       ;STATUS
	 CLS	 LO,4,2,16,78	       ;CLEAR THE SCREEN
	 CALL	 HIDE_CUR	       ;HIDE THE CURSOR
; *********************************************************************
; *			 BEGIN THE FORMAT PROCESS		      *
; *********************************************************************
	 CALL	 CTLR_DIAG	       ;EXECUTE CTLR HDNOSTICS
	 JNC	 FMT_50 	       ;SUCESSFULL
	 PMSG	 24,HI		       ;FORMAT FAILED
	 CALL	 UPD_ERR	       ;DISPLAY ERROR COUNT
	 JMP	 FMT_00 	       ;TERMINATE FORMAT
; *********************************************************************
; *			   SCAN FOR DEFECTS			      *
; *********************************************************************
FMT_50:
	 PUSH	 DS		       ;ESTABLISH
	 POP	 ES		       ;  SEGMENT
	 LEA	 DI,DATA_BUF	       ;DEFECT BUFFER
	 MOV	 CX,516/2	       ;LENGTH IN WORDS
	 MOV	 AX,0FFFFH	       ;PAD DATA
	 CLD			       ;FORWARD DIRECTION
	 REP	 STOSW		       ;CLEAR THE BUFFER
	 MOV	 HD_CMD,VER_CMD        ;VERIFY COMMAND
	 MOV	 NUM_SEC,1	       ;NUMBER OF SECTORS
	 LEA	 DI,DATA_BUF	       ;FIRST ENTRY
	 LEA	 BX,XI3B	       ;DEFAULT NO TO
	 CMP	 [BX].S_DATA,'Y'       ;CLEAR DEFECTS??
	 JE	 FMT_65 	       ;YES - SKIP DEFECT SCAN
FMT_55:
	 CALL	 UPD_CYL	       ;DISPLAY CYLINDER NUMBER
	 MOV	 AH,HD_CMD	       ;FETCH COMMAND
	 MOV	 AL,NUM_SEC	       ;NUMBER OF SECTORS
	 MOV	 DX,CUR_CYL	       ;CURRENT CYLINDER
	 XCHG	 DH,DL		       ;ADJUST IT
	 MOV	 CX,6		       ;SHIFT COUNT
	 SHL	 DL,CL		       ;ADJUST CYL HIGH
	 OR	 DL,CUR_SEC	       ;SET SECTOR NUMBER
	 MOV	 CX,DX		       ;CX SET
	 MOV	 DH,CUR_HD	       ;SET HEAD
	 MOV	 DL,DR		       ;DRIVE
	 OR	 DL,80H 	       ;  NUMBER
	 INT	 13H		       ;EXECUTE THE COMMAND
	 JNC	 FMT_60 	       ;SUCESSFULL
	 CMP	 AH,BSEC_ER	       ;FLAGGED TRACK??
	 JE	 FMT_57 	       ;YES
	 CMP	 AH,BTRK_ER	       ;FLAGGED TRACK??
	 JNE	 FMT_60 	       ;NO
FMT_57:
	 MOV	 AX,CUR_CYL	       ;SAVE
	 STOSW			       ; ALL
	 MOV	 AL,CUR_HD	       ;  FLAGGED
	 STOSB			       ;   AREAS
FMT_60:
	 CALL	 NEXT_TRK	       ;NEXT TRACK
	 JNC	 FMT_55 	       ;AND PROCESS IT
FMT_65:
	 CMP	 PCT,00H	       ;IBM/AT??
	 JE	 FMT_70 	       ;YES
	 JMP	 FMT_200	       ;NO
; *********************************************************************
; *			      FMT IBM/AT			      *
; *********************************************************************
FMT_70:
	 MOV	 HD_CMD,FMT_CMD        ;FORMAT COMMAND
	 LEA	 BX,FMT_BUFF	       ;FORMAT BUFFER
	 PUSH	 DS		       ;ESTABLISH
	 POP	 ES		       ;  SEGMENT
	 MOV	 CUR_HD,0	       ;INITIALIZE
	 MOV	 CUR_SEC,1	       ; THE
	 MOV	 CUR_CYL,0	       ;  STARTING FIELDS
	 MOV	 ERR_CNT,0	       ;CLEAR THE ERROR COUNT
	 MOV	 NUM_SEC,17	       ;NUMBER OF SECTORS
FMT_80:
	 MOV	 AH,0BH 	       ;CHECK FOR
	 INT	 21H		       ;  CONTROL BREAK
	 CALL	 UPD_CYL	       ;DISPLAY CURRENT CYLINDER
	 CALL	 EXEC_CMD	       ;FORMAT THE TRACK
	 JNC	 FMT_90 	       ;SUCESSFULL
	 CMP	 AL,0FFH	       ;CTLR BROKE??
	 JNE	 FMT_85 	       ;NO
	 JMP	 FMT_00
FMT_85:
	 CALL	 UPD_ERR	       ;DISPLAY ERROR COUNT
FMT_90:
	 CALL	 NEXT_TRK	       ;NEXT TRACK
	 JNC	 FMT_80 	       ;AND PROCESS IT
; *********************************************************************
; *			     FLAG DEFECTS			      *
; *********************************************************************
FMT_95:
	 LEA	 BX,XI3B	       ;DEFAULT NO TO
	 CMP	 DATA_BUF,0FFFFH       ;ANY DEFECTS FOUND??
	 JNE	 FMT_100	       ;YES
	 JMP	 FMT_150	       ;EXIT
FMT_100:
	 LEA	 DI,FMT_BUFF	       ;FORMAT BUFFER
	 MOV	 AL,80H 	       ;BAD SECTOR INDICATOR
	 MOV	 CX,17		       ;NUMBER OF SECTORS
	 CLD			       ;FORWARD DIRECTION
FMT_105:
	 STOSB			       ;SET BAD SECTOR INDICATOR
	 INC	 DI		       ;NEXT SECTOR
	 LOOP	 FMT_105	       ;AND PROCESS IT
;
	 LEA	 DI,DATA_BUF	       ;DEFECT BUFFER
FMT_110:
	 MOV	 AX,[DI]	       ;FETCH CYLINDER ADDRESS
	 CMP	 AX,0FFFFH	       ;ALL DONE??
	 JE	 FMT_150	       ;YES
	 MOV	 CUR_CYL,AX	       ;SET CYLINDER
	 MOV	 AL,[DI+2]	       ;FETCH HEAD
	 MOV	 CUR_HD,AL	       ;AND SAVE IT
	 LEA	 BX,FMT_BUFF	       ;FORMAT BUFFER
	 MOV	 HD_CMD,FMBT_CMD       ;FORMAT BAD TRACK COMMAND
	 CALL	 EXEC_CMD	       ;FLAG THE TRACK
	 MOV	 AX,CUR_CYL	       ;FORMAT
	 LEA	 BX,E02 	       ;  CYLINDER
	 CALL	 CONV_ASCII
	 XOR	 AX,AX		       ;CLEAR AX
	 MOV	 AL,CUR_HD	       ;FORMAT
	 LEA	 BX,E03 	       ;  HEAD
	 CALL	 CONV_ASCII
	 SCROLL  LO,4,2,16,78	       ;SCROLL
	 WRITE	 E01		       ;DISPLAY THE MESSAGE
	 CALL	 LOGERR 	       ;PRINT THE MESSAGE
	 ADD	 DI,3		       ;NEXT DEFECT
	 JMP	 FMT_110	       ;AND PROCESS IT
FMT_150:
	 MOV	 HD_CMD,SEEK_CMD       ;LETS
	 MOV	 CUR_CYL,0	       ; BRING
	 MOV	 CUR_HD,0	       ;  THE HEADS
	 CALL	 EXEC_CMD	       ;  HOME
	 PMSG	 25,HI		       ;FORMAT COMPLETE
	 JMP	 FMT_00 	       ;NEXT
; *********************************************************************
; *			      FMT IBM/PC			      *
; *********************************************************************
FMT_200:
	 MOV	 HD_CMD,WSEC_CMD       ;WRITE SECTOR BUFFER
	 LEA	 BX,FMT_BUFF	       ;FORMAT BUFFER
	 PUSH	 DS		       ;ESTABLISH
	 POP	 ES		       ;  SEGMENT
	 MOV	 CUR_HD,0	       ;INITIALIZE
	 MOV	 CUR_SEC,1	       ; THE
	 MOV	 CUR_CYL,0	       ;  STARTING FIELDS
	 MOV	 ERR_CNT,0	       ;CLEAR THE ERROR COUNT
	 MOV	 NUM_SEC,17	       ;NUMBER OF SECTORS
	 CALL	 EXEC_CMD	       ;CLEAR THE SECTOR BUFFER
;
	 MOV	 AH,FMD_CMD	       ;FORMAT DRIVE COMMAND
	 LEA	 BX,XI4 	       ;FETCH
	 MOV	 AL,[BX].S_DATA        ; INTERLEAVE
	 AND	 AL,0FH 	       ;MAKE IT A DIGIT
	 MOV	 DX,CUR_CYL	       ;CURRENT CYLINDER
	 XCHG	 DH,DL		       ;ADJUST IT
	 MOV	 CX,6		       ;SHIFT COUNT
	 SHL	 DL,CL		       ;ADJUST CYL HIGH
	 OR	 DL,CUR_SEC	       ;SET SECTOR NUMBER
	 MOV	 CX,DX		       ;CX SET
	 MOV	 DH,CUR_HD	       ;SET HEAD
	 MOV	 DL,DR		       ;DRIVE
	 OR	 DL,80H 	       ;  NUMBER
	 INT	 13H		       ;EXECUTE THE COMMAND
	 JNC	 FMT_210	       ;SUCESSFULL
	 PMSG	 24,HI		       ;FORMAT FAILED
	 JMP	 FMT_00
FMT_210:
	 JMP	 FMT_95 	       ;WRITE TRACK FLAGS
; *********************************************************************
; *				E X I T 			      *
; *********************************************************************
EXIT:
	 RET			       ;RETURN
FMT	 ENDP
; *********************************************************************
; *			DISPLAY CURRENT CYLINDER		      *
; *********************************************************************
UPD_CYL  PROC
	 PUSHALL
	 MOV	 AX,CUR_CYL	       ;FORMAT
	 LEA	 BX,XC1 	       ; CYLINDER
	 CALL	 CONV_ASCII	       ;  DISPLAY
	 WRITE	 XC0		       ;CYLINDER
	 POPALL
	 RET			       ;RETURN
UPD_CYL  ENDP
; *********************************************************************
; *			   DISPLAY ERROR COUNT			      *
; *********************************************************************
UPD_ERR  PROC
	 PUSHALL
	 XOR	 AX,AX		       ;CLEAR AX
	 MOV	 AX,ERR_CNT	       ;FORMAT
	 LEA	 BX,XE1 	       ; ERROR COUNT
	 CALL	 CONV_ASCII	       ;  DISPLAY
	 WRITE	 XE0		       ;ERROR COUNT
	 POPALL
	 RET			       ;RETURN
UPD_ERR  ENDP
CSEG	 ENDS
	 END	 HDFMT
