; **********************************************************************
; *		   SEGMENT TO MAP INTERRUPT VECTORS		       *
; **********************************************************************
INT_AREA SEGMENT AT 0
	 ORG	 4*13H		       ;HARD DISK VECTORS
INT_13	 LABEL	 WORD
	 ORG	 4*41H		       ;PARM VECTORS FOR DRIVE 0
INT_41	 LABEL	 DWORD
	 ORG	 4*46H		       ;PARM VECTORS FOR DRIVE 1
INT_46	 LABEL	 DWORD
INT_AREA ENDS
; **********************************************************************
; *		   SEGMENT TO MAP HARD DISK DATA AREAS		       *
; **********************************************************************
HD_DATA  SEGMENT AT 40H
	 ORG	 74H
HD_STATUS DB	 ?		       ;HARD DISK STATUS BYTE
HD_NUM	 DB	 ?		       ;NUMBER OF HARD DISK DRIVES
HD_DRIVE DB	 ?		       ;HARD DISK DRIVE NUMBER
HD_COMP  DB	 ?		       ;COMPATABILITY FLAG
;
;	 BITS 7-4 FOR DRIVE0 AND BITS 3-0 FOR DRIVE 1
;
HD_AT	 EQU	 00H		       ;NATIVE AT MODE
HD_PC	 EQU	 0FH		       ;PC MODE
	 ORG	 08CH
HD_STAT  DB	 ?		       ;STATUS REGISTER
HD_ERR	 DB	 ?		       ;ERROR REGISTER
HD_INT_FLAG DB	 ?		       ;HARD DISK INTERRUPT FLAG
;
HD_DATA  ENDS
; **********************************************************************
; *		       CONTROLLER PORT EQUATES			       *
; **********************************************************************
HD_P0	 EQU	 01F0H		       ;DATA/DATA
HD_P1	 EQU	 01F1H		       ;ERROR/WRITE PRE-COMP
HD_P2	 EQU	 01F2H		       ;SEC CNT/SEC CNT
HD_P3	 EQU	 01F3H		       ;SEC NUM/SEC NUM
HD_P4	 EQU	 01F4H		       ;CYL LO/CYL LO
HD_P5	 EQU	 01F5H		       ;CYL HI/CYL HI
HD_P6	 EQU	 01F6H		       ;DRIVE,HEAD/DRIVE,HEAD
HD_P7	 EQU	 01F7H		       ;STATUS/COMMAND
; **********************************************************************
; *			 ERROR	EQUATES 			       *
; **********************************************************************
CMD_ER	 EQU	 01H		       ;BAD COMMAND
ADMRK_ER EQU	 02H		       ;ADDRESS MARK NOT FOUND
NRF_ER	 EQU	 04H		       ;NO RECORD FOUND
RESET_ER EQU	 05H		       ;RESET ERROR
INIT_ER  EQU	 07H		       ;DRIVE INITIALIZATION ERROR
DMA_ER	 EQU	 09H		       ;DMA ACCROSS 64K BOUNDRY
BSEC_ER  EQU	 0AH		       ;BAD SECTOR FLAG DETECTED
BTRK_ER  EQU	 0BH		       ;BAD TRACK FLAG DETECTED
ECC_ER	 EQU	 10H		       ;BAD ECC ON READ
DATA_ER  EQU	 11H		       ;CORRECTED ECC ERROR
CTLR_ER  EQU	 20H		       ;CONTROLLER ERROR
SEEK_ER  EQU	 40H		       ;SEEK ERROR
TIME_ER  EQU	 80H		       ;DISK TIME OUT
NRDY_ER  EQU	 0AAH		       ;DRIVE NOT READY
UNDEF_ER EQU	 0BBH		       ;UNDEFINED ERROR
WRFLT_ER EQU	 0CCH		       ;WRITE FAULT
NO_ER	 EQU	 0E0H		       ;ERROR REG = 0
SENSE_ER EQU	 0FFH		       ;SENSE ERROR
; **********************************************************************
; *			 STATUS REGISTER EQUATES		       *
; **********************************************************************
S_BUSY	 EQU	 10000000B	       ;CONTROLLER BUSY
S_DRDY	 EQU	 01000000B	       ;DRIVE READY
S_WRFLT  EQU	 00100000B	       ;WRITE FAULT
S_SEKCMP EQU	 00010000B	       ;SEEK COMPLETE
S_DRQ	 EQU	 00001000B	       ;DATA REQUEST
S_CORECC EQU	 00000100B	       ;ECC CORRECTED DATA
S_INDEX  EQU	 00000010B	       ;INDEX PAULSE
S_ERROR  EQU	 00000001B	       ;E R R O R
; **********************************************************************
; *			  ERROR REGISTER EQUATES		       *
; **********************************************************************
;
;			 AFTER CTLR_DIAG_CMD
;
E_NOER	 EQU	 01H		       ;NO ERRORS
E_CTLR	 EQU	 02H		       ;CONTROLLER ERROR
E_SBUFF  EQU	 03H		       ;SECTOR BUFFER ERROR
E_ECCD	 EQU	 04H		       ;ECC DEVIVE ERROR
E_CPROC  EQU	 05H		       ;CONTROL PROCESSOR ERROR
;
;			 AFTER EXECUTING COMMANDS
;
E_ADMARK EQU	 00000001B	       ;ADDRESS MARK NOT FOUND
E_TRK0	 EQU	 00000010H	       ;NO TRACK ZERO FOUND
E_CMD	 EQU	 00000100H	       ;COMMAND ABORTED
E_SPARE1 EQU	 00001000H	       ;NOT USED
E_ID	 EQU	 00010000H	       ;ID NOT FOUND
E_SPARE2 EQU	 00100000H	       ;NOT USED
E_UNCORR EQU	 01000000H	       ;UNCORRECTABLE DATA ERROR
E_BADSEC EQU	 10000000H	       ;BAD SECTOR MARK DETECTED
; **********************************************************************
; *			     DISK COMMANDS			       *
; **********************************************************************
RS_CMD	 EQU	 00H		       ;RESET COMMAND
RD_CMD	 EQU	 02H		       ;READ SECTOR
WR_CMD	 EQU	 03H		       ;WRITE SECTOR
VER_CMD  EQU	 04H		       ;VERIFY SECTOR
FMT_CMD  EQU	 05H		       ;FORMAT TRACK
FMBT_CMD EQU	 06H		       ;FORMAT BAD TRACK
FMD_CMD  EQU	 07H		       ;FORMAT DRIVE
RDP_CMD  EQU	 08H		       ;FETCH DRIVE PARMS
WRP_CMD  EQU	 09H		       ;WRITE DRIVE PARMS
RDL_CMD  EQU	 0AH		       ;READ LONG
WRL_CMD  EQU	 0BH		       ;WRITE LONG
SEEK_CMD EQU	 0CH		       ;SEEK
WSEC_CMD EQU	 0FH		       ;WRITE SECTOR BUFFER
TRDY_CMD EQU	 10H		       ;TEST DRIVE READY
RCAL_CMD EQU	 11H		       ;RECALIBRATE
CTLR_CMD EQU	 14H		       ;CONTROLLER DIAGNOSTICS
;
F1	 EQU	 01H		       ;FUNCTION KEY 1
F2	 EQU	 02H		       ;FUNCTION KEY 2
F3	 EQU	 03H		       ;FUNCTION KEY 3
F4	 EQU	 04H		       ;FUNCTION KEY 4
F5	 EQU	 05H		       ;FUNCTION KEY 5
F6	 EQU	 06H		       ;FUNCTION KEY 6
F7	 EQU	 07H		       ;FUNCTION KEY 7
F8	 EQU	 08H		       ;FUNCTION KEY 8
F9	 EQU	 09H		       ;FUNCTION KEY 9
F10	 EQU	 0AH		       ;FUNCTION KEY 10
C_F1	 EQU	 21		       ;CTRL-F1
A_F1	 EQU	 31		       ;ALT_F1
A_F2	 EQU	 32		       ;ALT_F2
A_F3	 EQU	 33		       ;ALT_F3
A_F4	 EQU	 34		       ;ALT_F4
A_F5	 EQU	 35		       ;ALT_F5
A_F6	 EQU	 36		       ;ALT_F6
A_F7	 EQU	 37		       ;ALT_F7
A_F8	 EQU	 38		       ;ALT_F8
A_F9	 EQU	 39		       ;ALT_F9
A_F10	 EQU	 40		       ;ALT-F10
ENT_KEY  EQU	 00H		       ;ENTRY KEY
C_BRK	 EQU	 0FEH		       ;CONTROL BREAK
ESC_KEY  EQU	 41		       ;ESCAPE KEY
END_KEY  EQU	 42		       ;END KEY
; **********************************************************************
; *			      EQUATES FOR BOX			       *
; **********************************************************************
ULEFT	 EQU	 201		       ;UPPER LEFT CORNER
URIGHT	 EQU	 187		       ;UPPER RIGHT CORNER
LLEFT	 EQU	 200		       ;LOWER LEFT CORNER
LRIGHT	 EQU	 188		       ;LOWER RIGHT CORNER
HORZ	 EQU	 205		       ;HORTIZONTIAL LINE
VERT	 EQU	 186		       ;VERTICAL LINE
; **********************************************************************
; *			    FUNCTION CODES			       *
; **********************************************************************
ECC_F	 EQU	 1		       ;ECC TEST
RW_F	 EQU	 2		       ;READ/WRITE/VERIFY TEST
SEEK_F	 EQU	 3		       ;SEEK TEST
HS_F	 EQU	 4		       ;HEAD SELECT TEST
