	 PAGE	 64,132 	       ;PAGE WIDTH,LENGTH
	 .SALL
	 TITLE	 PC/AT DIAGNOSTIC - ECC TEST
; **********************************************************************
; *								       *
; *	MODULE NAME    HDECC					       *
; *	AUTHOR	       JIM BRACKING				       *
; *								       *
; *	DECSRIPTION    THIS PROGRAM PERFORMS THE FOLLOWING	       *
; *		       FUNCTIONS:				       *
; *								       *
; *		       1.  WRITE ALL SECTORS ON THE DIAG CYLINDER      *
; *			   WITH THE WORST CASE DATA PATTERN USING      *
; *			   THE WRITE LONG CMD. WHEN THEY ARE READ      *
; *			   BACK THE STATUS SHOULD BE A CORRECTABLE     *
; *			   DATA ERROR.				       *
; **********************************************************************
;
; **********************************************************************
; *			EXTERNAL PROGRAM REFERENCES		       *
; **********************************************************************
	 EXTRN	 SCRMGR:NEAR
; **********************************************************************
; *			  EXTERNAL DATA REFERENCES		       *
; **********************************************************************
	 INCLUDE HDDATA.ASM
; **********************************************************************
; *			EXTERNAL SUBROUTINE REFERENCES		       *
; **********************************************************************
	 INCLUDE HDSUB.ASM
; **********************************************************************
; *			    PUBLIC DECLARES			       *
; **********************************************************************
	 PUBLIC  HDECC
; **********************************************************************
; *				 MACROS 			       *
; **********************************************************************
	 IF1
	 INCLUDE HD.MAC
	 INCLUDE \SCRMGR\SCRNWORK.MAC
	 ENDIF
; **********************************************************************
; *								       *
; *			       BEGIN				       *
; *								       *
; **********************************************************************
CSEG	 SEGMENT PARA PUBLIC 'CODE'
	 ASSUME CS:CSEG
HDECC  PROC    NEAR
	 ASSUME  DS:CSEG	       ;DATA SEGMENT
	 JMP	 BY_ID		       ;JMP AROUND ID
	 ID	 HDECC
	 INCLUDE \SCRMGR\SCRNWORK.ASM
; **********************************************************************
; *			 EQUATES AND STRUCTURES 		       *
; **********************************************************************
	 INCLUDE HDEQU.ASM
; **********************************************************************
; *				 SCREENS			       *
; **********************************************************************
;
;
  SFIELD X00,X01,,@LABEL,RV,23,02,'CTRL-F1 TO START'
  SFIELD X01,X02,,@LABEL,RV,23,29,'ESC FOR THE MAIN MENU'
  SFIELD X02,X00,,@LABEL,RV,23,62,'CTRL-BRK TO STOP'
;
  SFIELD XI0,XI1,,@LABEL,LO,19,05,'DRIVE =>'
  SFIELD XI1,XI2,1,@EX+@NUM+@UC+@NFULL+@REQ,LO,19,14
  SFIELD XI2,XI3,,@LABEL,LO,20,05,'(1 OR 2)'
  SFIELD XI3,XI4,,@LABEL,LO,19,20,'RUN CONTINIOUSLY =>'
  SFIELD XI4,XI5,1,@UC+@EX+@YN+@NFULL+@REQ,LO,19,40
  SFIELD XI5,XI0,,@LABEL,LO,20,26,'(Y OR N)'
;
  SFIELD XS0,XS1,,@LABEL,LO,19,46,'STATUS =>'
  SFIELD XS1,XS0,,@LABEL,LO,19,56,'** IDLE **   '
;
  SFIELD XS2,XS3,,@LABEL,LO,19,46,'STATUS =>'
  SFIELD XS3,XS2,,@LABEL,HI,19,56,'** WORKING **'
;
  SFIELD XC0,XC1,,@LABEL,LO,20,46,'CYLINDER =>'
  SFIELD XC1,XC0,04,@LABEL,LO,20,58
;
  SFIELD XE0,XE1,,@LABEL,LO,21,46,'ERRORS =>'
  SFIELD XE1,XE0,05,@LABEL,LO,21,56
;
  SFIELD T05,T05,,@LABEL,RV,17,35,'ECC TEST'
BY_ID:
HDECC  ENDP
; *********************************************************************
; *								      *
; *			       ECC TEST 			      *
; *								      *
; *********************************************************************
ECC	 PROC
	 CLS	 LO,4,1,23,78	       ;CLEAR THE SCREEN
	 BOX	 17,0,08,80,LO	       ;OUTLINE
	 WRITEC  0CCH,LO,17,0,1        ;  THE
	 WRITEC  0B9H,LO,17,79,1       ;  SCREEN
	 WRITE	 T05		       ;TYPE OF TEST
	 WRITE	 X00		       ;COMMANDS
ECC_00:
	 WRITE	 XS0		       ;STATUS
	 LEA	 BX,XI1 	       ;DRIVE ENTRY
	 MOV	 [BX].S_ATTR,LO        ;RESTORE ATTRIBUTE
	 CMP	 ALL_SW,0FFH	       ;RUN ALL TEST??
	 JE	 ECC_01 	       ;YES
	 MOV	 [BX].S_DATA,' '       ;CLEAR DRIVE
	 JMP	 ECC_01A	       ;CONTINUE
ECC_01:
	 LEA	 BX,XI4 	       ;Y/N ENTRY
	 MOV	 [BX].S_ATTR,LO        ;RESTORE ATTRIBUTE
	 MOV	 [BX].S_DATA,'Y'       ;DEFAULT NO
	 MOV	 AL,DR		       ;FETCH DRIVE
	 INC	 AL		       ;NUMBER
	 OR	 AL,30H 	       ;MAKE IT A NUMBER
	 MOV	 [BX].S_DATA,AL        ;SET IT IN THE MSG
	 WRITE	 XI0		       ;DRIVE
	 JMP	 ECC_15 	       ;CONTINUE
ECC_01A:
	 LEA	 BX,XI4 	       ;Y/N ENTRY
	 MOV	 [BX].S_ATTR,LO        ;RESTORE ATTRIBUTE
	 MOV	 [BX].S_DATA,'N'       ;DEFAULT NO
	 WRITE	 XI0		       ;DRIVE
ECC_02:
	 READR	 BX		       ;FETCH DRIVE
	 CALL	 TRANS_KEY	       ;TRANSLATE THE KEY
	 JNC	 ECC_04 	       ;SUCESSFULL
ECC_03:
	 CALL	 BEEP		       ;RING THE BELL
	 JMP	 ECC_02 	       ;TRY AGAIN
ECC_04:
	 CMP	 AL,ESC_KEY	       ;ESCAPE KEY??
	 JNE	 ECC_05 	       ;NO
	 JMP	 EXIT		       ;RETURN
ECC_05:
	 CMP	 AL,C_BRK	       ;CONTROL BREAK KEY??
	 JNE	 ECC_07 	       ;NO
	 JMP	 ECC		       ;YES - START OVER
ECC_07:
	 CMP	 AL,C_F1	       ;CTRL_F1??
	 JNE	 ECC_03 	       ;NO - INVALID KEY
	 LEA	 BX,XI1 	       ;DRIVE ENTRY
	 MOV	 [BX].S_ATTR,LO        ;RESTORE ATTRIBUTE
	 MOV	 AL,[BX].S_DATA        ;FETCH DRIVE NUMBER
	 CMP	 AL,'1'                ;VALID DRIVE??
	 JE	 ECC_08 	       ;YES
	 CMP	 AL,'2'                ;VALID DRIVE??
	 JE	 ECC_08 	       ;YES
	 MOV	 [BX].S_ATTR,HI        ;HIGHLIGHT IT
	 PMSG	 22		       ;DISPLAY THE MESSAGE
	 CALL	 BEEP		       ;RING THE BELL
	 WRITE	 XI0		       ;DRIVE + INTERLEAVE
	 JMP	 ECC_02 	       ;TRY AGAIN
ECC_08:
	 AND	 AL,0FH 	       ;ADJUST
	 DEC	 AL		       ;  DRIVE NUMBER
	 CMP	 AL,NUM_DR	       ;DRIVE INSTALLED
	 JB	 ECC_10 	       ;YES
	 MOV	 [BX].S_ATTR,HI        ;HIGHLIGHT IT
	 PMSG	 21		       ;DISPLAY THE MESSAGE
	 CALL	 BEEP		       ;RING THE BELL
	 WRITE	 XI0		       ;DRIVE + INTERLEAVE
	 JMP	 ECC_02 	       ;TRY AGAIN
ECC_10:
	 MOV	 DR,AL		       ;SAVE DRIVE NUMBER
	 LEA	 BX,XI1 	       ;DRIVE ENTRY
	 MOV	 [BX].S_ATTR,LO        ;RESTORE ATTRIBUTE
	 WRITE	 XI0		       ;DRIVE
ECC_15:
	 XOR	 AX,AX		       ;DATA PATTERN
	 MOV	 CX,256 	       ;NUMBER OF WORDS
	 CLD			       ;FORWARD DIRECTION
	 LEA	 DI,DATA_BUF	       ;OUTPUT
	 PUSH	 CS		       ;ESTABLISH
	 POP	 ES		       ;  SEGMENT
	 REP	 STOSW		       ;FILE THE BUFFER
ECC_20:
	 CALL	 READ_PARMS	       ;FETCH DRIVE PARMS
	 MOV	 CUR_HD,0	       ;INITIALIZE
	 MOV	 CUR_SEC,1	       ; THE
	 MOV	 CUR_CYL,0	       ;  STARTING FIELDS
	 MOV	 BAD_SEC,0	       ;CLEAR THE BAD SEC COUNT
	 MOV	 ERR_CNT,0	       ;CLEAR THE ERROR COUNT
	 MOV	 NUM_SEC,1	       ;NUMBER OF SECTORS
	 CALL	 UPD_CYL	       ;DISPLAY CYLINDER NUMBER
	 CALL	 UPD_ERR	       ;DISPLAY ERROR COUNT
	 WRITE	 XS2		       ;STATUS
	 CLS	 LO,4,2,16,78	       ;CLEAR THE SCREEN
	 CALL	 HIDE_CUR	       ;HIDE THE CURSOR
; *********************************************************************
; *			   BEGIN THE TEST			      *
; *********************************************************************
	 MOV	 FUNC,ECC_F	       ;ECC FUNCTION
	 CALL	 CTLR_DIAG	       ;EXECUTE CTLR HDNOSTICS
	 JNC	 ECC_30 	       ;SUCESSFULL
	 PMSG	 36,HI		       ;FAILED
	 MOV	 ECC_X,36	       ;SET CODE
	 CALL	 UPD_ERR	       ;DISPLAY ERROR COUNT
	 CMP	 ALL_SW,0FFH	       ;RUN ALL TEST??
	 JE	 ECC_28 	       ;YES
	 JMP	 ECC_00 	       ;TERMINATE THE TEST
ECC_28:
	 JMP	 EXIT		       ;EXIT
ECC_30:
	 PUSH	 DS		       ;ESTABLISG
	 POP	 ES		       ;  SEGMENT
	 MOV	 AX,MAX_CYL	       ;POINT TO
	 MOV	 CUR_CYL,AX	       ;  HD CYLINDER
	 LEA	 BX,DATA_BUF	       ;BUFFER
	 PUSH	 DS		       ;ESTABLISH
	 POP	 ES		       ;  SEGMENT
ECC_40:
	 MOV	 AH,0BH 	       ;CHECK FOR
	 INT	 21H		       ;  CONTROL BREAK
	 CALL	 UPD_CYL	       ;DISPLAY CURRENT CYLINDER
	 MOV	 HD_CMD,WR_CMD	       ;WRITE COMMAND
	 MOV	 NUM_SEC,1	       ;NUMBER OF SECTORS
	 CALL	 EXEC_CMD	       ;WRITE THE SECTOR
	 JNC	 ECC_50 	       ;SUCESSFULL
	 CMP	 AL,0FFH	       ;CTLR BROKE??
	 JNE	 ECC_48 	       ;NO
	 JMP	 ECC_99 	       ;YES
ECC_48:
	 CALL	 UPD_ERR	       ;DISPLAY ERROR COUNT
	 CALL	 NEXT_SEC	       ;TRY ALL SECTORS
	 JNC	 ECC_40 	       ;NEXT
	 JMP	 ECC_100	       ;FAILED
ECC_50:
	 MOV	 HD_CMD,RD_CMD	       ;READ COMMAND
	 MOV	 NUM_SEC,1	       ;NUMBER OF SECTORS
	 CALL	 EXEC_CMD	       ;READ THE SECTOR
	 JNC	 ECC_60 	       ;SUCESSFULL
	 CMP	 AL,0FFH	       ;CTLR BROKE??
	 JNE	 ECC_58 	       ;NO
	 JMP	 ECC_99 	       ;YES
ECC_58:
	 JMP	 ECC_100	       ;FAILED
ECC_60:
	 MOV	 HD_CMD,RDL_CMD        ;READ LONG COMMAND
	 MOV	 NUM_SEC,1	       ;NUMBER OF SECTORS
	 CALL	 EXEC_CMD	       ;READ THE SECTOR
	 JNC	 ECC_70 	       ;SUCESSFULL
	 CMP	 AL,0FFH	       ;CTLR BROKE??
	 JNE	 ECC_68 	       ;NO
	 JMP	 ECC_99 	       ;YES
ECC_68:
	 JMP	 ECC_100	       ;FAILED
ECC_70:
	 MOV	 DATA_BUF,0FH	       ;FOUR BITS OF CORRECTION
	 MOV	 HD_CMD,WRL_CMD        ;WRITE LONG COMMAND
	 MOV	 NUM_SEC,1	       ;NUMBER OF SECTORS
	 CALL	 EXEC_CMD	       ;WRITE THE SECTOR
	 JNC	 ECC_80 	       ;SUCESSFULL
	 CMP	 AL,0FFH	       ;CTLR BROKE??
	 JNE	 ECC_78 	       ;NO
	 JMP	 ECC_99 	       ;YES
ECC_78:
	 JMP	 ECC_100	       ;FAILED
ECC_80:
	 MOV	 HD_CMD,RD_CMD	       ;READ COMMAND
	 MOV	 NUM_SEC,1	       ;NUMBER OF SECTORS
	 CALL	 EXEC_CMD	       ;READ THE SECTOR
	 JNC	 ECC_90 	       ;SUCESSFULL
	 CMP	 AL,0FFH	       ;CTLR BROKE??
	 JNE	 ECC_90 	       ;NO
	 JMP	 ECC_99 	       ;YES
ECC_90:
	 CMP	 AL,11H 	       ;CORRECTED DATA??
	 JE	 ECC_93 	       ;YES
	 PUSH	 DS		       ;SAVE DS
	 PUSH	 AX		       ;SAVE AX
	 MOV	 AX,40H 	       ;ESTABLISH
	 MOV	 DS,AX		       ;  SEGMENT
	 CMP	 BYTE PTR DS:74H,11H   ;ECC CORRECTED??
	 POP	 AX		       ;RESTORE AX
	 POP	 DS		       ;RESTORE DS
	 JNE	 ECC_100	       ;NO - FAILED
ECC_93:
	 MOV	 HD_CMD,WR_CMD	       ;WRITE COMMAND
	 MOV	 NUM_SEC,1	       ;NUMBER OF SECTORS
	 CALL	 EXEC_CMD	       ;GET RID OF THE CORRECTABLE
	 MOV	 HD_CMD,SEEK_CMD       ;SEEK COMMAND
	 MOV	 CUR_CYL,0	       ; BRING
	 MOV	 CUR_HD,0	       ;  THE HEADS
	 CALL	 EXEC_CMD	       ;  HOME
ECC_95:
	 PMSG	 35,HI		       ;DONE
	 MOV	 ECC_X,35	       ;SET CODE
ECC_99:
	 CMP	 ALL_SW,0FFH	       ;RUN ALL TEST??
	 JE	 EXIT		       ;YES
	 LEA	 BX,XI4 	       ;Y/N ENTRY
	 CMP	 [BX].S_DATA,'Y'       ;RUN FOREVER??
	 JE	 ECC_110	       ;YES
	 JMP	 ECC_00 	       ;NEXT
ECC_100:
	 PMSG	 36,HI		       ;FAILED
	 MOV	 ECC_X,36	       ;SET CODE
	 CMP	 ALL_SW,0FFH	       ;RUN ALL TEST??
	 JE	 EXIT		       ;YES
	 LEA	 BX,XI4 	       ;Y/N ENTRY
	 CMP	 [BX].S_DATA,'Y'       ;RUN FOREVER??
	 JE	 ECC_110	       ;YES
	 JMP	 ECC_00 	       ;NEXT
ECC_110:
	 JMP	 ECC_30 	       ;CONTINUE
; *********************************************************************
; *				E X I T 			      *
; *********************************************************************
EXIT:
	 RET			       ;RETURN
ECC	 ENDP
; *********************************************************************
; *			DISPLAY CURRENT CYLINDER		      *
; *********************************************************************
UPD_CYL  PROC
	 PUSHALL
	 MOV	 AX,CUR_CYL	       ;FORMAT
	 LEA	 BX,XC1 	       ; CYLINDER
	 CALL	 CONV_ASCII	       ;  DISPLAY
	 WRITE	 XC0		       ;CYLINDER
	 POPALL
	 RET			       ;RETURN
UPD_CYL  ENDP
; *********************************************************************
; *			   DISPLAY ERROR COUNT			      *
; *********************************************************************
UPD_ERR  PROC
	 PUSHALL
	 XOR	 AX,AX		       ;CLEAR AX
	 MOV	 AX,ERR_CNT	       ;FORMAT
	 LEA	 BX,XE1 	       ; ERROR COUNT
	 CALL	 CONV_ASCII	       ;  DISPLAY
	 WRITE	 XE0		       ;ERROR COUNT
	 POPALL
	 RET			       ;RETURN
UPD_ERR  ENDP
CSEG	 ENDS
	 END	 HDECC
