SUBTTL MS-DOS file interface words
PAGE


;FORTH - MSDOS file interface

;This is SYSTEM-DEPENDENT code and is normally INCLUDED by
;4TH-SYSD.ASM

REQUEST		EQU	33		;MSDOS function request intr.
FOPEN		EQU	15		;open file function no.
FCLOSE		EQU	16		;close file function no.
FREAD		EQU	20		;sequential read
FWRITE		EQU	21		;    "      write
FCREAT		EQU	22		;create file
SETDTA		EQU	26		;set disk transfer address
RANDRD		EQU	39		;random block read
RANDWRT		EQU	40		;random block write
FSIZE		EQU	35		;determine file size
PARSEFN		EQU	41		;parse file name function
SETVEC		EQU	37		;set interrupt vector
FATADDR		EQU	27		;get alloc. table info.

;=C+  (OPEN)	open FCB, f is TRUE if error		FCB -- f

	$CODE	86H,(OPEN,)
		POP	DX		;DX points to FCB
		MOV	AH,FOPEN
		INT	REQUEST
		SUB	AH,AH
		JMP	APUSH		;Leave 0FFH if not found

;=C+  (CLOSE)	close FCB, f is TRUE on error		FCB -- f

	$CODE	87H,(CLOSE,)
		POP	DX		;DX points to FCB
		MOV	AH,FCLOSE
		INT	REQUEST
		SUB	AH,AH
		JMP	APUSH		;leave 0FFH if not found

;=C+  (CREATE)	create file, f is TRUE on error		FCB -- f

	$CODE	88H,(CREATE,)
		POP	DX		;DX points to unopened FCB
		MOV	AH,FCREAT
		INT	REQUEST
		SUB	AH,AH
		JMP	APUSH		;leave 0FFH if no room

;=C+  (READ)	read next record from file to addr	FCB addr -- f

	$CODE	86H,(READ,)
		POP	DX		;DX has DTA
		MOV	AH,SETDTA
		INT	REQUEST
		POP	DX		;DX points to open FCB
		MOV	AH,FREAD
		INT	REQUEST
		SUB	AH,AH
		JMP	APUSH		;AL has condition code

;=C+  (WRITE)	write next record to file from addr	FCB addr -- f

	$CODE	87H,(WRITE,)
		POP	DX
		MOV	AH,SETDTA
		INT	REQUEST
		POP	DX		;DX points to open FCB
		MOV	AH,FWRITE
		INT	REQUEST
		SUB	AH,AH
		JMP	APUSH		;AL returns condition

;=C+  (FBLKRD)	read n blocks from file			FCB n -- f

	$CODE	88H,(FBLKRD,)
		MOV	DX,2[DTA]	;Set DTA
		MOV	AH,SETDTA
		INT	REQUEST
		POP	CX		;read this many records
		POP	DX		;DX has FCB address
		MOV	AX,2[REC]	;Read this record
		MOV	BX,DX
		MOV	33[BX],AX	;Set random record field
		MOV	AH,RANDRD
		INT	REQUEST
		SUB	AH,AH		;Return condition code
		JMP	APUSH

;=C+  (FBLKWRT)	write n blocks to file			FCB n -- f

	$CODE	89H,(FBLKWRT,)
		MOV	DX,2[DTA]	;Set DTA as for READ above
		MOV	AH,SETDTA
		INT	REQUEST
		POP	CX		;read this many records
		POP	DX		;FCB address
		MOV	AX,2[REC]
		MOV	BX,DX
		MOV	33[BX],AX
		MOV	AH,RANDWRT
		INT	REQUEST
		SUB	AH,AH
		JMP	APUSH

;=C+  B/SEC	get bytes/sector			-- n

	$CODE	86H,B/SEC,?
		PUSH	DS		;This fn. kills DS !
		MOV	AH,FATADDR
		INT	REQUEST
		POP	DS		;Don't lose it !
		PUSH	CX		;sector size
		JMP	NEXT

;=C+  (FNAME)	parse filename at addr using mode n	FCB addr1 n -- addr2 f

	$CODE	87H,(FNAME,)
		POP	AX		;mode in AL
		POP	BX		;pointer to string
		POP	DI		;pointer to FCB to fill in
		PUSH	SI		;save FORTH IP
		MOV	SI,BX
		MOV	AH,PARSEFN
		INT	REQUEST
		MOV	DX,SI		;return pointer to next char
		POP	SI
		SUB	AH,AH
		JMP	DPUSH		;...and flag for "*|?"

;=C+  DISK	set default drive to n, n2 is #drives	n -- n2

		$CODE	84H,DIS,K
		POP	DX
		SUB	DH,DH
		MOV	AH,14		;select disk function
		INT	REQUEST
		SUB	AH,AH
		JMP	APUSH		;return no. drives

;=C+  ?FIRST	search for first matching file		FCB addr -- f

		$CODE	86H,!!!?FIRS,T
		POP	DX		;destination addr.
		MOV	AH,SETDTA
		INT	REQUEST
		POP	DX		;search FCB addr.
		MOV	AH,17		;search for first entry
		INT	REQUEST
		SUB	AH,AH
		JMP	APUSH

;=C+  ?NEXT	search for next matching file		addr FCB -- f

		$CODE	85H,!!!?NEX,T
		POP	DX		;dest. addr.
		MOV	AH,SETDTA
		INT	REQUEST
		POP	DX		;search FCB addr.
		MOV	AH,18		;search for next entry
		INT	REQUEST
		SUB	AH,AH
		JMP	APUSH

;=C+  FDEL	delete file				FCB -- f

		$CODE	84H,FDE,L
		POP	DX		;unopened FCB
		MOV	AH,19		;delete file function
		INT	REQUEST
		SUB	AH,AH
		JMP	APUSH

;=C+  FREN	rename file				addr -- f

		$CODE	84H,FRE,N
		POP	DX		;special FCB
		MOV	AH,23		;rename file
		INT	REQUEST
		SUB	AH,AH
		JMP	APUSH

;=C+  DISK@	return default disk number		-- n

		$CODE	85H,DISK,@
		MOV	AH,25		;return default disk
		INT	REQUEST
		SUB	AH,AH
		JMP	APUSH

	$REPORT	<MS-DOS file interface included>
