;////////////////////////////////////////////////////////////////////////////
; FAST-DOS.ASM                                                             //
; This  program resets the system clock to a faster tick, and then uses    //
;  that faster tick to time a routine within a program. DO NOT run this    //
;  while windows is loaded.                                                //
;////////////////////////////////////////////////////////////////////////////

newspeed equ   222                ; Divisor  of the  original timer rate. Can
                                  ;  be any  number  from 2 to 65534. Keep in 
                                  ;  mind  that  only  certain  things can be 
                                  ;  done  at  an  extrememely  fast  rate. I 
                                  ;  would suggest  keeping  this value some-
                                  ;  what low unless you do a little research 
                                  ;  first.

;+++++++++++++++++++++++++++++++++++++++++++++
stac segment stack 'stack'
        db      0f00h dup(?)
stac ends

code segment 'code'
assume cs:code, ss:stac, ds:code
;+++++++++++++++++++++++++++++++++++++++++++++

;+++++++++++++++++++++++++++++++++++++++++++++
; The "DATA"
video_save      dw      0
old_int         dd      0
dot             db      " .","$"
rcx             dw      0
fast_message    db      12 dup(10,13)
                db      'Press  any  key  to  start  "fast"  screen-write...'
                db      12 dup(10,13),'$'
slow_message    db      2 dup(10,13)
                db      'Press  any  key  to  start  "slow"  screen-write...'
                db      12 dup(10,13),'$'
ending_message  db      2 dup(10,13)
                db      'Press any key to return timer to normal speed and exit...'
                db      2 dup(10,13),'$'
cls             db      24 dup(10,13),'$'
attribute       db      0
question        db      12 dup(10,13)
                db      'Are you currently running "Windows?"'
                db      12 dup (10,13),'$'
loaded          db      0
exit_message    db      12 dup(10,13)
                db      '"FAST-DOS"  _MUST NOT_  be run while "Windows" is loaded!!'
                db      2 dup(10,13)
                db      ' Please exit "Windows" and try again'
                db      2 dup(10,13)
                db      ' ... or run "FAST-WIN".'
                db      12 dup(10,13),'$'
;+++++++++++++++++++++++++++++++++++++++++++++

;+++++++++++++++++++++++++++++++++++++++++++++
; time_delay macro used when port-writing
wt macro
jmp $+2
jmp $+2
jmp $+2
endm wt

start:

;+++++++++++++++++++++++++++++++++++++++++++++
; question to see if "Windows" is loaded
call    cs:win_check
cmp     cs:[loaded],1
jne     cs:carry_on
xor     ax, ax
int     16h
jmp     exit
carry_on:
;++++++++++++++++++++++++++++++++++++++++++++++++

;++++++++++++++++++++++++++++++++++++++++++++++++
; Get current screen attributes (in case someone
;  is using a "colored" screen
mov     ax, 0b800h
mov     ds, ax
mov     al, ds:0001h
mov     cs:[attribute], al

;+++++++++++++++++++++++++++++++++++++++++++++++
; Reset  video  mode  to  suit  our  application
;  after first saving current font size, in case
;  tiny fonts are being used.... ;}
mov     ah, 11h
mov     al, 30h
int     10h
mov     cs:[video_save], cx
xor     ax, ax
mov     al, 03h
int     10h

; Reset  screen  attributes  destroyed in  above
;  routine
mov     ax, 0b800h
mov     es, ax
mov     di, 0000h
xor     ax, ax
mov     ah, cs:[attribute]
mov     cx, 0fa0h
cld
repz
stosw

;++++++++++++++++++++++++++++++++++++++++++++++++

;++++++++++++++++++++++++++++++++++++++++++++++++
; set up ISRs
call    set_int
call    install
;+++++++++++++++++++++++++++++++++++++++++++++++++

;!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
; below  is  where  the  actual program code would 
;  go of the calling program.
; here I've written two sample routines that write
;  a series of dots
;!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

;+++++++++++++++++++++++++++++++++++++++++++++++++
; display first message
push    cs
pop     ds
mov     ah, 09h
mov     dx, offset fast_message
int     21h
xor     ax,ax
int     16h
;+++++++++++++++++++++++++++++++++++++++++++++++++

;+++++++++++++++++++++++++++++++++++++++++++++++++
; first we'll do a series of dots with fast timer.
mov     cs:[rcx],1e0h
again:
push    cs
pop     ds
mov     ah, 09h
mov     dx, offset dot
int     21h
;+++++++++++++++++++++++++++++++++++++++++++++++++++

;+++++++++++++++++++++++++++++++++++++++++++++++++++
; This  is  routine that actually creates the amount 
;  of delay. Make multiple calls  to the "time" rou-
;  tine (as I haven't done here) while  manipulating 
;  "newpseed"  equate  to  fine_tune various delays.
call    time
;+++++++++++++++++++++++++++++++++++++++++++++++++++

;+++++++++++++++++++++++++++++++++++++++++++++++++++
; loop  routine  used  to  display  qauntity of dots
;  stored in variable "rcx"
dec     cs:[rcx]
cmp     cs:[rcx],0
jne     cs:again
;+++++++++++++++++++++++++++++++++++++++++++++++++++

;+++++++++++++++++++++++++++++++++++++++++++++++++++
; display  second  message  for  "slow" screen-write
push    cs
pop     ds
mov     ah, 09h
mov     dx, offset slow_message
int     21h

; backspace cursor
mov     ah, 02h
mov     bh, 00h
xor     dl, dl
mov     dh, 15
int     10h

xor     ax, ax
int     16h
;+++++++++++++++++++++++++++++++++++++++++++++++++++

;+++++++++++++++++++++++++++++++++++++++++++++++++++
; now  we'll  do  a series of dots, written "slowly"
;  by counter-acting  fast timer by creating more of
;  a loop seequence.

mov     cs:[rcx],0f0h
again2:
push    cs
pop     ds
mov     ah, 09h
mov     dx, offset dot
int     21h

;+++++++++++++++++++++++++++++++++++++++++++++++++++
; This  is  routine that actually creates the amount 
;  of delay.  Make multiple calls to the "time" rou-
;  tine ( as  I've  done  here ) while  manipulating 
;  "newpseed"  equate  to  fine_tune various delays.
mov     cx,newspeed
loop_time:
call    time
loop loop_time

dec     cs:[rcx]
cmp     cs:[rcx],0
jne     cs:again2
;+++++++++++++++++++++++++++++++++++++++++++++++++++
; Display ending message
push    cs
pop     ds
mov     ah, 09h
mov     dx, offset ending_message
int     21h
xor     ax,ax
int     16h
;++++++++++++++++++++++++++++++++++++++++++++++++++++

;++++++++++++++++++++++++++++++++++++++++++++++++++++
; Clear the screen and return cursor to top
push    cs
pop     ds
mov     ah, 09h
mov     dx, offset cls
int     21h
mov     ah, 02h
mov     bh, 00h
xor     dl, dl
mov     dh, 01
int     10h

;++++++++++++++++++++++++++++++++++++++++++++++++++++

; !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
; End your fast code here                           !
;!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

;++++++++++++++++++++++++++++++++++++++++++++++++++++
; Return timer to normal speed

call    return_int

mov     dx, word ptr cs:old_int
mov     ds, word ptr cs:old_int+2
mov     ax, 2560h
int     21h
;++++++++++++++++++++++++++++++++++++++++
; Return video as_it_was
call video_return
;++++++++++++++++++++++++++++++++++++++++


;++++++++++++++++++++++++++++++++++++++++
; Exit program
exit:
mov     ah,04ch
int     21h
;++++++++++++++++++++++++++++++++++++++++

;****************************************
;****************************************
in_progress     db      0

handler proc near 
cmp     cs:[in_progress], 0
jne     se_la_vee
inc     cs:[in_progress]

cli
push    ax
mov     al, 20h
out     20h, al
pop     ax
sti

pushf
push    cx
push    ax

cmp     cs:[count],0
je      cs:over
dec     cs:[count]
over:

cli
dec     cs:[in_progress]
pop     ax
pop     cx
popf

se_la_vee:

iret
handler endp 

;****************************************
;****************************************
count           dw      0

time proc near
pushf
push    cx

mov     cs:[count],01h
looper:
cmp     cs:[count],0
je      cs:done
jmp     cs:looper

done:
pop cx
popf
ret
time endp 
;****************************************
;****************************************

install proc 
push    es
push    bx
push    ax
mov     al, 60h
mov     ah, 35h
int     21h
mov     word ptr cs:old_int, bx
mov     word ptr cs:old_int+2, es
mov     dx, offset handler
mov     al, 60h
mov     ah, 25h
int     21h
pop     ax
pop     bx
pop     es
ret
install endp

fast_set        db      0
countdown       dw      newspeed    ; used  to reference  original processing
                                    ;  of int 08 service routine
old_int_8       dd      0           ; pointer to origninal int 8 routine

set_int proc 
; Set Vector and speed up timer chip

push    cs
pop     ds

; get  the  current  interrupt  08  vector  and save using the "reset vector" 
;  function of int 21h supplied by DOS

push    es
mov     ax, 3508h
int     21h                      ; get current int 8 pointer

; placeing it all into one variable, makes it easier to do a jump to later on        
mov word ptr cs:[old_int_8],bx
mov word ptr cs:[old_int_8+2],es
pop     es

; install new interrupt 8 routine
push    cs
pop     ds
mov     dx, offset handler_08
mov     ax, 2508h
int     21h             ; install our interrupt 
ret
set_int endp 

return_int proc 
push    cs      
pop     ds      
        
cli
mov     al, 36h
out     43h, al
xor     ax, ax          ; This value will be immediately decremented to ffffh
                        ;  (which is the original setting of this register at
                        ;  boot-up by BIOS) so it is the correct value to use 
                        ;  instead  of  the supected 0ffffh. Not "really" all
                        ;  that "critical"......... :)
; The following  nop's  are a precautionary measure to create a delay between
; writing to the ports, required by most modern systems due to fast bus speed.
wt
out     40h, al         ; LSB  (least  significant  byte must go in first, so 
                        ;  this  is  a two-step process to load register cor-
                        ;  rectly
mov     al, ah

wt        
out     40h, al
sti                     ; Re-enable interrupts
        
mov     dx, word ptr [cs:old_int_8]     ; Move  offset  address of old inter-
                                        ;  rupt handler (saved earlier in the 
                                        ;  program into DX
mov     ds, word ptr [cs:old_int_8+2]   ; Move segment address  of old inter-
                                        ;  rupt  handler  into  DS.  prior to 
                                        ;  reassigning interrupt handler.
mov     ax, 2508h       ; Reset interrupt vector to address of previous inter-
                        ;  rupt handler (now loaded into DS:DX) using the DOS
                        ;  routine designed to do so.

int     21h             ; Immediately after this line, old interrupt handler
                        ;  will be back in place in interrupt vector.

ret
return_int endp 


;****************************************************************************
;****************************************************************************
; This is  the  new handler  for interrupt 08. What it does, is it resets the 
;  system  timer  to  a  faster  rate.  The system timer is controlled by the 
;  system clock.  The  system  clock pulses the timer at a rate of 1,1931,180 
;  times  per second (1,1931,180/65535=18.27  which  is the normal  speed  of  
;  the  system  timer).   BIOS  preloads  the  timer  with  the  value  0  at  
;  boot-up. That  value  is  immediately   decremented  to  the  value  65535  
;  (0ffffh).  With each  pulse,  the  value  is  decremented  by 1. When  the 
;  value reaches 0, it  then issues an interrupt #8.  Actually  what  happens  
;  is the following:  Because  it  is a hardware device, it issues an "IRQ 0"  
;  which then issues a software  interrupt 08.  Anyhow,  once  the  value has 
;  reached 0,  the  whole  process repeats itself. Now, since we are going to 
;  reset the timer to a faster rate, it is important to still service all the 
;  routines that are dependent on the signal from int 8,,, the time of day as 
;  well  as  the  timeing  of certain hardware devices.
;****************************************************************************
;****************************************************************************
                                
Handler_08 Proc                 ; Name of the new int 8 handler. Can of 
                                ;  course be any name.
push    ax
push    es
pushf

cmp     cs:[fast_set],0
je      cs:set_fast
jmp     cs:fast_already_set
set_fast:
cli                     ; Do not allow  interrupts while fiddling with ports!
mov     al, 36h         ; This value is  hard to explain here. It essentially
                        ;  sets  the  bit  pattern for 16-bit, mode 3, binary
                        ;  operation.
out     43h, al         ; "Out" this value to port 43h which will be 8253 on
                        ;  an XT  and 8254 on an AT
mov ax, 65532/newspeed  ; Reset  speed  to  current rate divided by new rate. 
                        ;  The idea is,  that  the  lower  the number in this 
                        ;  register, the faster it counts down. Upon reaching 
                        ;  zero, it sends a pulse.
; The following nop's are a precautionary measure to create a delay between
;  writing to the ports, required by most systems due to fast bus speeds.
wt
out     40h, al
mov     al, ah

wt
out     40h, al
inc     cs:[fast_set]
sti

fast_already_set:

;****************************************************************************
;********* This is where your "fast" routine would go ***********************
; -> Of course care MUST be taken to preserve flags and registers since your
;     routine "will" be interrupted at currently reset fast rate
;----------------------------------------------------------------------------

;----------------------------------------------------------------------------
; Actual code to be executed at faster rate 
int     60h
;----------------------------------------------------------------------------

;****************************************************************************
;------->  E N D   O F    F A S T   C O D E
;****************************************************************************

;----------------------------------------------------------------------------
; This is the "important" step mentioned above. What it does, is it takes the
;  divisor  of  the  "rate  change"  and decrements it by one, each time this
;  routine  is  re-entered.  Once  it  reaches  0,  then we know it's time to 
;  service the original routines that are ordinarily serviced  at  the normal 
;  rate.                                                       

dec     cs:[countdown]
;----------------------------------------------------------------------------

;----------------------------------------------------------------------------
; Go back to our routine that is making use of the faster clock-ticks, if the
;  value in "countdown" hasn't yet reached zero.
jnz     cs:bypass_old_int_8
;----------------------------------------------------------------------------

;----------------------------------------------------------------------------
; The  handling  of  the  old  interrupt  handler  dependents are serviced by 
;  redirecting the int 08  to address the old interrupt handler who's address 
;  has been saved previously in the variable "old_int_8"
mov     cs:[countdown],newspeed
popf
pop     es
pop     ax

jmp     cs:[old_int_8]
;---------------------------------------------------------------------------

;-----------------------------------------
bypass_old_int_8:
;-----------------------------------------

popf        
pop     es

;----------------------------------------------------------------------------
; This  interrupt  has  been  taken  care  of  and  other  interrupts  can be 
;  processed.  Followed  by  a  command to once again allow all interrupts to 
;  occur.  Prevent  interrupts  from  occuring  while we fiddle with the port 
;  registers.

cli
mov     al, 20h
out     20h, al
pop ax
sti

; An interrupt handler procedure is returned from by using "iret"

iret

Handler_08 endp    

; Video character height return 

video_return proc 

mov     ax, cs:[video_save]
cmp     ax, 0008h
je      cs:a8
cmp     ax, 000eh
je      cs:a14
cmp     ax, 0010h
je      cs:a16
jmp     cs:skip
a8:
mov     ah, 11h
mov     al, 12h
mov     bl, 00h
int     10h
jmp     cs:skip
a14:
mov     ah, 11h
mov     al, 11h
mov     bl, 00h
int     10h
jmp     cs:skip
a16:
mov     ah, 11h
mov     al, 14h
mov     bl, 00h
int     10h
jmp     cs:skip
skip:
ret
video_return endp 

win_check proc
push    cs
pop     ds
mov     dx, offset question
mov     ah, 09h
int     21h

answercheck:
mov     ah, 00h
int     16h
cmp     al, 'n'
je      finished
cmp     al, 'N'
je      finished
cmp     al, 'y'
jne     not_y
push    cs
pop     ds
mov     dx, offset exit_message
mov     ah, 09h
int     21h
mov     cs:[loaded],1
jmp     cs:finished
not_y:
cmp     al, 'Y'
jne     cs:answercheck
push    cs
pop     ds
mov     dx, offset exit_message
mov     ah, 09h
int     21h
mov     cs:[loaded],1

finished:
ret
win_check endp

code ends
end start
end
