;
; This program demonstrates the usage of the DOS EXEC function from
; assembler.  The code is written for the A86 assembler (which happens
; to be the best assembler for MS-DOS), but can be easily modified for
; any other assembler.
;
; Note that in order to use the EXEC function, you must first use
; DOS function 4Ah to free up memory since COM files (and most EXE files)
; are initially allocated all of free memory.
;
; You must also make sure the program is in the path specified or
; nothing at all will happen.  For example, this program assumes that
; COMMAND.COM is in the current directory.  If it is not, nothing will
; happen when you run the program.  You cannot use wildcards on the file name.
;
; Note that if the program to be run does not use file control blocks,
; then the FCB fields are not necessary.
;
; If you have any questions, address them to DAVID ALBERT
; at NETEAST on the Relay net in the programming conference and I'll
; try to help.  Good Luck!

                jmp     Start                   ; jump to program start

; *** DATA SEGMENT **************************************************

; -- Program name and parameters for EXEC function ------------------
cmdname         DB      'COMMAND.COM', 0        ; name of program to EXEC
cmdtail         DB      8, '/c dir/w', 0Dh      ; parameters for program
                                                ;  (first byte = length)
; -- Parameter block for EXEC function (required) -------------------
ParamBlk        DW      0                       ; Environment Seg (0=Default)
                DW      0, 0                    ; Command Tail    (ofs, seg )
                DW      0, 0                    ; FCB1            (ofs, seg )
                DW      0, 0                    ; FCB2            (ofs, seg )
; -- File control blocks (only if needed by program being EXEC'd) ---
FCB1            DB      256 DUP (?)
FCB2            DB      256 DUP (?)
; -- Storage for status returned by EXEC'd program when done --------
RetCode         DW      0

; -- Local variables ------------------------------------------------
                DB      256 DUP (?)             ; internal stack
MyStack         EQU     $
SaveSP          DW      0

; *** CODE SEGMENT **************************************************

Start:          mov     ax, cs                  ; Setup for tiny memory model
                mov     ds, ax
                mov     es, ax
                mov     ss, ax                  ; Initialize stack
                mov     sp, mystack

; -- Modify memory allocation to make room for new program ----------

                mov     ah, 04Ah                ; DOS modify memory allocation
                mov     bx, 0100h               ; reserve 4K of memory
                int     21h                     ; Free rest of memory
                jc      mem_error               ; Make sure memory available.

; -- Setup Parameter block for DOS EXEC call ---------------------------

                mov     word [ParamBlk][0], 0               ; environment seg
                mov     word [ParamBlk][2], offset cmdtail  ; program parms ofs
                mov     word [paramBlk][4], cs              ; program parms seg
                mov     word [paramblk][6], offset fcb1     ; fcb 1 ofs
                mov     word [paramblk][8], cs              ; fcb 1 seg
                mov     word [paramblk][0Ah], offset fcb2   ; fcb 2 ofs
                mov     word [paramblk][0Ch], cs            ; fcb 2 seg

;-- Save all registers since EXEC will corrupt them -----------------

                mov     word [savesp], sp       ; save stack location
                pusha                           ; save g.p. registers

; -- Call DOS EXEC function ------------------------------------------

                mov     ah, 04Bh                ; DOS EXEC function call
                mov     al, 00h                 ; to a program (not overlay)
                mov     dx, offset cmdname      ; DS:DX points to program name
                mov     bx, offset paramblk     ; ES:BX points to parameter blk
                int     21h                     ; Execute program

; -- Get return status code -----------------------------------------

                mov     ah, 04Dh
                int     21h
                mov     word CS:[RetCode], ax

; -- Restore registers used -----------------------------------------

                mov     ax, cs                  ; restore segment registers
                mov     ds, ax
                mov     es, ax
                mov     ss, ax
                mov     sp, word [savesp]       ; restore stack
                popa                            ; restore g.p. registers

; -- Program finished, exit to DOS ----------------------------------

exit:           mov     ax, 04C00h              ; return to DOS
                int     21h                     ;   with no error code.

; -- MEM_ERROR : insufficient memory error handler ------------------

mem_msg         db      'Error: insufficient memory.', 0Dh, 0Ah, '$'
mem_error:      mov     dx, offset mem_msg
                mov     ah, 09h
                int     21h
                jmp     exit
                           
