; ENTER.ASM      "This program is used to preload the keyboard buffer"

; The buffer is loaded with the return character code so that the next check
;  of the keyboard buffer will find that code as if you physically hit the
;  "enter" key.

; stack not really needed in this program,  so if you want, you can eliminate
;  it before you assemble, and ignore the  "no stack"  warning.  
stac         segment stack   'stack'
                db      80h dup (?)
stac ends

data segment                    'data'
                db      25h dup (?)
data ends

code segment                    'code'
assume cs:code, ds:data, ss:stac

mov ax,0040h    ; ROM BIOS Data area segment

mov ds,ax       ; Make it current data segment

mov ax,1c0dh    ; Move into AX, the scan code for the  "enter" key.  The com-
                ;  plete code  for  "enter"  which is used by BIOS is "1C0D". 

mov ds:001eh,ax ; Move  this  into  keyboard  buffer. Buffer starts at 40:1E. 
                ;  Each  entry  is one word long, so the next scan code entry 
                ;  read by the BIOS will be "1C0D", the same as would be read
                ;  if you had physically pushed the "enter" key.

mov ax,001eh    ; Move into AX, address of  next "beginning_of_read" location

mov ds:001ah,ax ;  and on into  the  "read pointer",  also known as the "head
                ;  pointer" location in the ROM BIOS keyboard data area.  

mov ax,0020h    ; Now to end it all, place the  address of the where the next 
                ;  keystroke  "write"  will  take place. This is known as the  
                ;  "tail pointer" and is determined by  adding  to  the  head  
                ;  pointer,  the  amount  (in word values) of keystrokes cur-
                ;  rently in buffer. This  is  essentially  the "end_of_read"
                ;  location.

;mov ax, 001eh   ;  To make the buffer empty, simply use this value. In other
                ;  words,  when  the value at 0040:001ah = 1eh, and the value
                ;  at 0040:001ch = 1eh,  the keyboard buffer is concidered to
                ;  be "empty".

mov ds:001ch,ax ; Do it. After this  memory_write,  the  keyboard buffer will
                ;  contain  the  scan  code for the "enter" key which will be
                ;  read when the next buffer read takes place.

mov ax,04ch
int 21h
code ends
end
