;-----------------------------------------------------------------------------;
;      MODULE NAME:   EMM21_A.ASM                                             ;
;                                                                             ;
;    FUNCTION NAME:   get_handle_dir                                          ;
;                                                                             ;
;      DESCRIPTION:   This function returns an array containing all           ;
;                     active handles and the names associated with each.      ;
;                     Any handles which has not been assigned a name has a    ;
;                     default name of all ASCII nulls (binary zeros).  When a ;
;                     handle is first allocated, or when all the pages        ;
;                     belonging to a handle are deallocated (that is, an open ;
;                     handle is closed), its default name is set to ASCII     ;
;                     nulls.  In order to name a handle, you must assign      ;
;                     the name after the handle has been opened.  The         ;
;                     full range of values may be assigned to each character  ;
;                     in a name (that is, 00h through FFh).                   ;
;                                                                             ;
;                     The number of bytes required by the array is:           ;
;                         10 bytes * total number of handles                  ;
;                                                                             ;
;                     The maximum size of this array is:                      ;
;                         (10 bytes/entry) * 255 entries = 2550 bytes         ;
;                                                                             ;
;           PASSED:   &hd_count:                                              ;
;                        is a far pointer to the number of entries in the     ;
;                        handle directory array of structures.                ;
;                                                                             ;
;                     handle_dir:                                             ;
;                        is a far pointer to a structure into which the       ;
;                        memory manager will copy the handle directory.  The  ;
;                        handle directory is an array of structures.  There   ;
;                        are as many entries in the array of structures as    ;
;                        there are open EMM handles.                          ;
;                                                                             ;
;         RETURNED:   status:                                                 ;
;                        is the status EMM returns from the call.  All other  ;
;                        returned results are valid only if the status        ;
;                        returned is zero.  Otherwise they are undefined.     ;
;                                                                             ;
;                     hd_count:                                               ;
;                        is the number of entries in the handle directory     ;
;                        structure.  This is also the same as the number of   ;
;                        open handles.  For example, if only one handle is    ;
;                        active, hd_count will be 1.                          ;
;                                                                             ;
;                     handle_dir:                                             ;
;                        is a structure which contains the handle values and  ;
;                        handle names associated with each handle value.      ;
;                        The structure members are described here:            ;
;                                                                             ;
;                        handle_dir.handle:                                   ;
;                           is the open EMM handle.                           ;
;                                                                             ;
;                        handle_dir.name:                                     ;
;                           is a character array which contains the ASCII     ;
;                           name associated with the EMM handle.  If there    ;
;                           is no name currently associated with the handle,  ;
;                           it has a value of all zeros (ASCII nulls).        ;
;                                                                             ;
; C USE CONVENTION:   unsigned int      status;                               ;
;                     unsigned int      hd_count;                             ;
;                     HANDLE_DIR_STRUCT handle_dir;                           ;
;                                                                             ;
;                     status = get_handle_dir (&hd_count,                     ;
;                                              handle_dir);                   ;
;-----------------------------------------------------------------------------;
.XLIST
PAGE	60,132

IFDEF SMALL
   .MODEL SMALL, C
ENDIF
IFDEF MEDIUM
   .MODEL MEDIUM, C
ENDIF
IFDEF LARGE
   .MODEL LARGE, C
ENDIF
IFDEF COMPACT
   .MODEL COMPACT, C
ENDIF
IFDEF HUGE
   .MODEL HUGE, C
ENDIF

INCLUDE emmlib.equ
INCLUDE emmlib.str
INCLUDE emmlib.mac
.LIST
.CODE

get_handle_dir		PROC                                                  \
			USES DI,                                              \
			ptr_handle_dir_count:FAR PTR WORD,                        \
			ptr_handle_dir:FAR PTR BYTE                              

	;---------------------------------------------------------------------;
	;   do;                                                               ;
	;   .   get the current "directory" of handle names;                  ;
	;---------------------------------------------------------------------;
	MOVE		AX, get_handle_dir_fcn
	MOVE		ES:DI, ptr_handle_dir
	INT     	EMM_int

	;---------------------------------------------------------------------;
	;   .   pass the count of "directory" entries back to the caller;     ;
	;---------------------------------------------------------------------;
	MOVE		DH:DL, 0:AL
	MOVE		ES:BX, ptr_handle_dir_count
	MOVE		ES:[BX], DX

	;---------------------------------------------------------------------;
	;   .   return (EMM status);                                          ;
	;   end;                                                              ;
	;---------------------------------------------------------------------;
	RET_EMM_STAT	AH

get_handle_dir		ENDP

END
