;-----------------------------------------------------------------------------;
;      MODULE NAME:   EMM28_I.ASM                                             ;
;                                                                             ;
; OS FUNCTION NAME:   dealloc_DMA_reg_set                                     ;
;                                                                             ;
;      DESCRIPTION:   This function deallocates the specified DMA register    ;
;                     set.                                                    ;
;                                                                             ;
;           PASSED:   DMA_reg_set:                                            ;
;                        is the DMA register set which should not be used for ;
;                        DMA operations any longer.  The DMA register set     ;
;                        would have been previously allocated and enabled for ;
;                        DMA operations on a specific DMA channel.  If the    ;
;                        DMA register set specified is zero, no action will   ;
;                        be taken.                                            ;
;                                                                             ;
;         RETURNED:   status:                                                 ;
;                        is the status EMM returns from the call.  All other  ;
;                        returned results are valid only if the status        ;
;                        returned is zero.  Otherwise they are undefined.     ;
;                                                                             ;
; C USE CONVENTION:   unsigned int status;                                    ;
;                     unsigned int DMA_reg_set;                               ;
;                                                                             ;
;                     status = dealloc_DMA_reg_set (DMA_reg_set);             ;
;-----------------------------------------------------------------------------;
.XLIST
PAGE	60,132

IFDEF SMALL
   .MODEL SMALL, C
ENDIF
IFDEF MEDIUM
   .MODEL MEDIUM, C
ENDIF
IFDEF LARGE
   .MODEL LARGE, C
ENDIF
IFDEF COMPACT
   .MODEL COMPACT, C
ENDIF
IFDEF HUGE
   .MODEL HUGE, C
ENDIF

INCLUDE emmlib.equ
INCLUDE emmlib.str
INCLUDE emmlib.mac
.LIST
.CODE

dealloc_DMA_reg_set	PROC	                                              \
			DMA_reg_set:WORD

	;---------------------------------------------------------------------;
	;   do;                                                               ;
	;   .   return the DMA register set previously allocated to the OS    ;
	;   .   back to EMM;                                                  ;
	;---------------------------------------------------------------------;
	MOVE		AX, deallocate_dma_reg_set_fcn
	MOVE		BX, DMA_reg_set
	INT     	EMM_int

	;---------------------------------------------------------------------;
	;   .   return (EMM status);                                          ;
	;   end;                                                              ;
	;---------------------------------------------------------------------;
	RET_EMM_STAT	AH

dealloc_DMA_reg_set		ENDP

END
