;-----------------------------------------------------------------------------;
;      MODULE NAME:   EMM25_C.ASM                                             ;
;                                                                             ;
;    FUNCTION NAME:   get_mappable_region_count                               ;
;                                                                             ;
;      DESCRIPTION:   This function gets the number of entries which will be  ;
;                     required for the array of structures the                ;
;                     get_mappable_regions function returns.  Note that       ;
;                     this function does not actually return the array but    ;
;                     merely a count of the entries in the array returned     ;
;                     by the get_mappable_regions function.  This number also ;
;                     represents the total number of mappable memory pages in ;
;                     the system.                                             ;
;                                                                             ;
;           PASSED:   &mr_count:                                              ;
;                        is a far pointer to a count of the number of entries ;
;                        in the array of structures that are returned by the  ;
;                        get_mappable_regions function.                       ;
;                                                                             ;
;         RETURNED:   status:                                                 ;
;                        is the status EMM returns from the call.  All other  ;
;                        returned results are valid only if the status        ;
;                        returned is zero.  Otherwise they are undefined.     ;
;                                                                             ;
;                     mr_count:                                               ;
;                        is a count of the number of entries in the mr        ;
;                        array of structures returned by the                  ;
;                        get_mappable_regions function.                       ;
;                                                                             ;
; C USE CONVENTION:   unsigned int status;                                    ;
;                     unsigned int mr_count;                                  ;
;                                                                             ;
;                     status = get_mappable_region_count (&mr_count);         ;
;-----------------------------------------------------------------------------;
.XLIST
PAGE	60,132

IFDEF SMALL
   .MODEL SMALL, C
ENDIF
IFDEF MEDIUM
   .MODEL MEDIUM, C
ENDIF
IFDEF LARGE
   .MODEL LARGE, C
ENDIF
IFDEF COMPACT
   .MODEL COMPACT, C
ENDIF
IFDEF HUGE
   .MODEL HUGE, C
ENDIF

INCLUDE emmlib.equ
INCLUDE emmlib.str
INCLUDE emmlib.mac
.LIST
.CODE

get_mappable_region_count	PROC                                          \
				ptr_mappable_region_count:FAR PTR WORD

	;---------------------------------------------------------------------;
	;   do;                                                               ;
	;   .   get the mappable region count from EMM;                       ;
	;---------------------------------------------------------------------;
	MOVE		AX, get_mappable_array_entries_fcn
	INT     	EMM_int

	;---------------------------------------------------------------------;
	;   .   pass the mappable region count back to the caller;            ;
	;---------------------------------------------------------------------;
	MOVE		ES:BX, ptr_mappable_region_count
	MOVE		ES:[BX], CX

	;---------------------------------------------------------------------;
	;   .   return (EMM status);                                          ;
	;   end;                                                              ;
	;---------------------------------------------------------------------;
	RET_EMM_STAT	AH

get_mappable_region_count	ENDP

END
