;-----------------------------------------------------------------------------
; file: EGA_PAL.ASM -- switches EGA during horiz retrace to display all 64   -
; possible EGA colors at once.						     -
;									     -
; This program was inspired by a utility from PC magazine.  I have tried to  -
; duplicate the function of the original, but I have added the numbers for   -
; each color as a quick reference for setting palettes with other programs   -
; which require octal or hex color numbers. There are three rows of numbers  -
; for each block:  one in decimal, one hex, one octal.			     -
;									     -
; The program counts horizontal retraces by looking at the EGA registers     -
; and, after counting up to 'V_PIXEL_HEIGHT', it sets the palette registers  -
; to the next set of colors.  This 'tricks' the EGA into displaying all 64   -
; colors at the same time.  The low-intensity colors are displayed on the    -
; left-hand side of the screen, and the hi-intensity colors are displayed    -
; across the top.  Combinations are displayed at the intersections and are   -
; easily traced by looking at the octal numbers: the low 3 bits are hi-	     -
; intensity colors (RGB); the next 3 bits are low-intensity (rgb).  Some of  -
; the color bands may not seem to vary much, usually due to the greater	     -
; influence of the hi-intensity (RGB) bits.  Try changing briteness and	     -
; contrast on your monitor for the best effect.				     -
;									     -
; The equ: 'V_PIXEL_HEIGHT' should be adjusted to control matchup between    -
;  numbers and screen colors. Delays are used for display stability.	     -
; Adjust no. of wait cycles in delay macro-- just one "jmp $+2" for my	     -
; 8Mhz AT, but this will depend on CPU speed.  Some screen jitter is normal. -
; This can't be avoided, due to the variables involved in monitoring and     -
; changing the EGA's registers on the fly.				     -
;									     -
; rev. date 4-10-92							     -
; M. Garvin - Xymetric Productions - 211 W.Broadway, NYC, NY 10013	     -
;-----------------------------------------------------------------------------


stk	segment para stack
	dw	256 dup (0)
stk	ends

;
;  The following param: V_PIXEL_HEIGHT should be adjusted if the color blocks
;   on the screen do not match up with the numbers underneath.  A good median
;   value might be around 40
;
V_PIXEL_HEIGHT	equ	48	; no of vert pixels per color block

delay	macro
;	jmp	$+2		; uncomment jmp's to experiment with
;	jmp	$+2		;  screen raster stability (jitter)
;	jmp	$+2		; more or fewer jmp's may have an effect
	endm


cseg	segment para public 'cseg'
	assume	cs:cseg

	public	start
start	proc	far
	push	ds
	xor	ax,ax
	push	ax		; push location for ret to dos
	;
	cld
	;
	mov	ax,0003
	int	10h		; init EGA for TEXT MODE display
	;
	mov	ax,0B800h	; point at EGA color screen at CGA loc
	mov	es,ax
	;
	xor	si,si		; point at top left char on screen
	mov	ah,01h		; video attrib -- left-hand column gets white
	mov	cl,0		; CL = color number
	;
  next_color:
	mov	di,si		; get screen pointer
	mov	al,' '
	stosw
	stosw
	stosw
	;
	; color no in octal
	;
	mov	al,cl
	shr	al,1
	shr	al,1
	shr	al,1
	add	al,'0'		; ascii offset
	stosw
	mov	al,cl
	and	al,07h
	add	al,'0'
	stosw
	mov	al,'o'		; 'o' for octal
	stosw
	mov	al,' '
	stosw
	stosw
	stosw
	stosw
	;
	; color no in decimal
	;
	add	di,140		; next row minus 10 chars just printed
	mov	al,' '
	stosw
	stosw
	stosw
	mov	ch,0		; accumulate 'tens' digit
	mov	al,cl		; color no / 10
  tens:
	cmp	al,10
	jc	tens_done
	sub	al,10
	inc	ch
	jmp	short tens
  tens_done:			; now CH has tens, AL has remainder
	xchg	al,ch
	add	al,'0'
	stosw
	mov	al,ch
	add	al,'0'
	stosw
	mov	al,'d'
	stosw
	mov	al,' '
	stosw
	stosw
	stosw
	stosw
	;
	; color no in hexadec
	;
	add	di,140		; adjust ptr by 80 chars minus 10 just printed
	mov	al,' '
	stosw
	stosw
	stosw
	mov	al,cl
	shr	al,1
	shr	al,1
	shr	al,1
	shr	al,1
	add	al,'0'
	cmp	al,'9'+1	; higher than 9? then adjust for hex A-F digit
	jc	not_hx1
	add	al,('A'-'0')-10
  not_hx1:
	stosw
	mov	al,cl
	and	al,0fh		; print out low 4 bits
	add	al,'0'
	cmp	al,'9'+1	; higher than 9? then adjust for hex A-F digit
	jc	not_hx2
	add	al,('A'-'0')-10
  not_hx2:
	stosw
	mov	al,'h'
	stosw
	mov	al,' '
	stosw
	stosw
	stosw
	stosw
	;
	; do next color
	;
	add	si,20		; point to next color block
	inc	cl		; next color number
	add	ah,10h		; inc attr. for backgnd color
	and	ah,0f0h
	test	ah,80h
	jz	no_reload
	mov	ah,01h		; first row gets blue lettering
  no_reload:
	mov	al,cl
	and	al,07h		; 8 blocks wide
	jz	next_row
	jmp	next_color
  next_row:
	add	si,320		; past next two rows
	cmp	cl,64
	jnc	last_line
	jmp	next_color	; next row of color blocks
	;
  last_line:			; bottom screen line set to blanks
	mov	di,24*160
	mov	al,' '
	mov	ah,0h		; ***
	mov	cx,80
    rep	stosw
	;
	; drop into loop which changes palettes on horizontal interrupt
	;
  top_screen:
	cli
	mov	dx,03DAh	; EGA input status reg
	;
	; check for exit on key hit
	;
	push	dx
	mov	ah,1
	int	16h		; key hit?
	pop	dx
	jnz	exit
	;
	; start hardware timeouts
	;
	sti
	xor	ah,ah
  wait_vhi:
	in	al,dx		; wait for vert retrace high
	test	al,08
	jz	wait_vhi
  wait_vlo:
	in	al,dx		; wait for vert retrace low
	test	al,08
	jnz	wait_vlo
	;
  wait_hhi_1:			; wait for horiz retrace hi
	delay			; delay stabilizes scrn - macro at top of file
	in	al,dx
	test	al,1
	jz	wait_hhi_1
	;
  change_palette:
	mov	cx,08
	mov	dl,0C0h		; 3c0h = EGA attrib control reg
  nxt_pal:
	mov	al,ah
	and	al,07		; palette register number
	out	dx,al
	mov	al,ah		; color number
	out	dx,al
	inc	ah
	loop	nxt_pal
	;
	mov	al,20h		; activate new palette
	out	dx,al
	;
	mov	dl,0DAh		; point at EGA input status reg again
	mov	bl,V_PIXEL_HEIGHT
	;
  wait_hlo:			; wait for horiz retrace lo
	delay
	in	al,dx
	test	al,1
	jnz	wait_hlo
  wait_hhi:			; wait for horiz retrace hi
	delay			; delay stabilizes scrn - macro at top of file
	in	al,dx
	test	al,1
	jz	wait_hhi
	;
	dec	bl		; sit thru required no of vert pixels
	jnz	wait_hlo
	;
	cmp	ah,64		; display 64 colors - then repeat
	jc	short change_palette
	;
	mov	dl,0C0h		; 3c0h = EGA attrib control reg
	xor	al,al		; palette register number
	out	dx,al
	out	dx,al
	mov	al,20h		; activate new palette
	out	dx,AL
	mov	dl,0DAh		; point at EGA input status reg again
	;
	jmp	short top_screen
	;
	;
  exit:
	mov	ah,0
	int	16h		; key was hit, so read it before exit
	;
	mov	ax,0003
	int	10h		; reset video
	ret			; far ret back to dos
start	endp

cseg	ends

	end	start
