
.MODEL tiny

COMMENT # 

                               DVCAL11.COM
                               DVCAL Version 1.1
                               No future versions anticipated

                               Written in MASM 6.1   8/93
                               Copyright: Miles Pawski
                               All rights reserved.

                               Calendar utility.  DV aware.
                               Valid from 1900 through 2021
  
                               Page-up or Page-down through the months
                               and years. 

                               Uses int 21h, function 2ah to get date info.

                               EGA+ only.

                               This code may be compiled with MASM 6.0-6.1
                               by doing the following: ML dvcal.asm         

 #

make_table_two macro
local i,t                  ;individual screen offsets for all possible day
 t=4                       ;positions in calendar
 i = (t*160)+(2*2)
 WORD i,i+8,i+16,i+24,i+32,i+40,i+48 
 t=t+1
 i = (t*160)+(2*2)
 WORD i,i+8,i+16,i+24,i+32,i+40,i+48 
 t=t+1
 i = (t*160)+(2*2)
 WORD i,i+8,i+16,i+24,i+32,i+40,i+48 
 t=t+1
 i = (t*160)+(2*2)
 WORD i,i+8,i+16,i+24,i+32,i+40,i+48 
 t=t+1
 i = (t*160)+(2*2)
 WORD i,i+8,i+16,i+24,i+32,i+40,i+48 
 t=t+1
 i = (t*160)+(2*2)
 WORD i,i+8,i+16,i+24,i+32,i+40,i+48 
 endm


make_year_table macro     ;makes year table BYTE "1900" through BYTE "2021"  
a  TEXTEQU <19>           ;make first two letters "19"
yr TEXTEQU <>             ;initialize empty work string
num = 00                  ;start at 1900

 REPEAT 122
  n TEXTEQU %num          ;convert numerical num to text string n
  q SIZESTR n             ;q = length of n       
  IF q EQ 1               ;if n is 1 digit long (1,2,3,4...9)
    n CATSTR <0>,n        ;add a leading zero  
  ELSEIF q EQ 0           ;if n is 0 digits long (happens with 0 value)
    n CATSTR <0>,<0>      ;make n = "00"  
  ENDIF
  yr CATSTR <">,a,n,<">   ;year string: a=first 2 digits;n=last two digits      
% Echo BYTE yr            ;check values during assembly
  BYTE yr                 ;actual data entry
  num = num + 1           ;increase numerical num  
  IF num EQ 100           ;century change
    a TEXTEQU <20>        ;make first two letters "20"     
    num = 00              ;zero counter
  ENDIF
  endm
endm

 delay2 PROTO near C,count:WORD


.DATA

 main_panel label BYTE
   BYTE  "ͻ"
   BYTE  "                             "
   BYTE  " $% "
   BYTE  " &S   M   T   W   T   F   S% " 
   BYTE  "                             "
   BYTE  "                             " 
   BYTE  "                             "
   BYTE  "                             " 
   BYTE  "                             "
   BYTE  "                             " 
   BYTE  "$%"
   BYTE  "$Esc-Cancel    PgUp&",24,"$PgDn&",25,"%"
   BYTE  "ͼ"


   dow_table label BYTE
     BYTE 0,1,2,3,4,5,6,0,1,2,3,4,5,6,0,1,2,3,4,5,6,0,1,2,3,4,5,6,
          0,1,2,3,4,5,6,0,1,2,3,4,5,6

   draw_table_one label WORD
     WORD (0*160)
     WORD (1*160)
     WORD (2*160)
     WORD (3*160)
     WORD (4*160)
     WORD (5*160)
     WORD (6*160)
     WORD (7*160)
     WORD (8*160)
     WORD (9*160)
     WORD (10*160)
     WORD (11*160)
     WORD (12*160)

   draw_table_two label WORD
      make_table_two

   day_table label BYTE
    BYTE  " 1"," 2"," 3"," 4"," 5"," 6"," 7"," 8"," 9","10" 
    BYTE  "11","12","13","14","15","16","17","18","19","20"   
    BYTE  "21","22","23","24","25","26","27","28","29","30"  
    BYTE  "31"     

   day_count_table_1  label BYTE
    BYTE 31,28,31,30,31,30,31,31,30,31,30,31

   day_count_table_2  label BYTE
    BYTE 31,29,31,30,31,30,31,31,30,31,30,31

   year_table label BYTE
     make_year_table

   month_table label BYTE
    BYTE "JANUARY         "
    BYTE "FEBRUARY        "
    BYTE "MARCH           "
    BYTE "APRIL           "
    BYTE "MAY             "
    BYTE "JUNE            "
    BYTE "JULY            "
    BYTE "AUGUST          "
    BYTE "SEPTEMBER       "
    BYTE "OCTOBER         "
    BYTE "NOVEMBER        "
    BYTE "DECEMBER        "    


   leap_year_flag    BYTE     00h
   month             BYTE     ?
   year              WORD     ?
   day               BYTE     ?
   dow               BYTE     ?  
   start_day         BYTE     ?
   end_day           BYTE     ?
   days_in_month     BYTE     ?
   sorry             BYTE     "Sorry, EGA/VGA+ color monitor only..."      
   mp                BYTE     "DVCAL11.COM    Copyright: Miles Pawski",13,10,
                              "Version 1.1  CIS: 70473,527"        

   PAGE_UP           EQU     4900h
   PAGE_DOWN         EQU     5100h
   BLUE_ON_WHITE     EQU     01110001y
   RED_ON_WHITE      EQU     01110100y    
   BLACK_ON_WHITE    EQU     01110000y

.CODE
.STARTUP

   mov ax,1a00h
   int 10h
   .IF al != 1ah                       ;check for vga/ega video card
       .IF bl != 4 && bl != 8
           mov ah,40h
           mov bx,1
           mov cx,SIZEOF sorry
           mov dx,offset sorry
           int 21h
           .EXIT 
       .ENDIF
   .ENDIF


  mov ah,40h
  mov bx,1
  mov cx,SIZEOF mp
  mov dx,offset mp
  int 21h

  invoke delay2,40


  mov ah,06h      ;select scroll function 06h to CLEAR THE SCREEN
  mov al,0        ;0 means blank the screen
  mov bh,2        ;attribute 0
  mov ch,0        ;start at row 0
  mov cl,0        ;start at column 0
  mov dh,24       ;end at row 24
  mov dl,79       ;end at column 79
  int 10h         ;do it

   mov ah,02h
   mov bh,00h
   mov dh,25                 ;put cursor off page
   mov dl,00h
   int 10h
  

   mov di,0b800h
   mov es,di

   mov cx,"DE"
   mov dx,"SQ"
   mov ax,2b01h     ;in DESQview?
   int 21h
   cmp al,0ffh
   je @F   
  
     mov ah,0feh    ;if in DV, get DV's video buffer segment
     int 10h        ;which is returned in es
                    ;es will now have either 0b800h or DV's own segment
   @@:              ;many times they are the same. es never changes here. 


   xor dx,dx
   mov ah,BLUE_ON_WHITE
   mov si,offset main_panel
   .REPEAT
      mov bx,dx
      shl bx,1
      mov di,draw_table_one[bx]   ;fill the box with info fields
      mov cx,31
      @@:
        lodsb
        .IF al=="%"                       ;return to blue on white
            mov al,32
            mov ah,BLUE_ON_WHITE
        .ELSEIF al=="$"                   ;black on white
            mov al,32
            mov ah,BLACK_ON_WHITE
        .ELSEIF al=="&"                   ;red on white
            mov al,32
            mov ah,RED_ON_WHITE
        .ENDIF
        stosw
        loop @B
      inc dx
   .UNTIL dx == 13


 mov ah,2ah                               ;get date info
 int 21h

 mov year,cx                              ;store in variables
 mov dow,al
 mov day,dl
 mov month,dh 


 test cx,3
 .IF ZERO? 
    mov leap_year_flag,01h              ;see if leap year
 .ELSE                                  ;evenly divisible by 4
    mov leap_year_flag,00h              ;bits 0 & 1 will be clear
 .ENDIF


 mov si,offset dow_table
 add si,42                              ;go to end of table
 std
 xor cx,cx
 mov cl,10                              ;go back and find match of dow
 mov al,dow
 @@:
   dec si
   cmp al,[si]                          ;al==day of week
   loopne @B

   xor ax,ax
   mov al,day
   dec al                               ;0 orient day
   sub si,ax                            ;go back in table to find day
   mov bl,[si]                          ;of week in which month starts
   mov start_day,bl 


   cld
   xor bx,bx
   mov bl,month
   dec bl
   xor cx,cx
   .IF leap_year_flag == 01h
      mov cl,day_count_table_2[bx]      ;load days in month table
   .ELSE
      mov cl,day_count_table_1[bx]
   .ENDIF
      mov days_in_month,cl              ;get days in month count

   mov bl,start_day
   mov dl,dow_table[bx]                
   add dl,cl                            ;cl== days in month
   mov bl,dl
   dec bl
   mov dl,dow_table[bx]                 ;calculate last day of month (dow)
   mov end_day,dl   

 start_over:
   mov dx,4
   mov ah,BLACK_ON_WHITE
   mov al,32
   .REPEAT                              ;clear the entries in box
     mov bx,dx
     shl bx,1
     mov di,draw_table_one[bx]
     add di,4
     mov cx,26
     rep stosw
     inc dx
   .UNTIL dx == 10

   xor cx,cx
   mov cl,days_in_month
   mov bl,start_day                     ;move into screen table to start at
   shl bx,1                             ;the proper day 
   mov si,offset day_table
   mov ah,BLACK_ON_WHITE
   push bx
   .REPEAT
     mov di,draw_table_two[bx]          ;write the days of month in box
     lodsb
     stosw
     lodsb
     stosw 
     add bx,2
   .UNTILCXZ
   pop bx

   xor ax,ax
   mov al,day
   dec al                               ;0 adjust
   shl ax,1
   add bx,ax
   mov di,draw_table_two[bx]
   inc di                               ;attribute byte
   mov al,00001110y                     ;bright yellow on black
   stosb                                ;highlite the day         
   inc di
   stosb 

 xor bx,bx
 mov bl,month
 dec bl                                 ;make 0 start for table
 mov si,offset month_table
 shl bx,1
 shl bx,1
 shl bx,1
 shl bx,1                               ;write the month
 add si,bx          
 mov di,(1*160)+(3*2)
 mov ah,BLACK_ON_WHITE
 mov cx,16
 @@:
   lodsb
   stosw
   loop @B

 mov bx,year
 sub bx,1900
 shl bx,1
 shl bx,1
 mov si,offset year_table             ;write the year
 add si,bx
 mov cx,4
 mov di,(1*160)+(24*2)
 mov ah,BLACK_ON_WHITE
 @@:
    lodsb
    stosw
    loop @B  

getkey:

mov ah,00h
int 16h
  .IF ax==PAGE_DOWN
    .IF month > 1
       dec month
    .ELSE
       .IF year==1900
         jmp getkey
       .ENDIF
       mov month,12
       dec year
       mov cx,year  
       test cx,3
      .IF ZERO? 
        mov leap_year_flag,01h
      .ELSE
        mov leap_year_flag,00h
      .ENDIF
    .ENDIF 
     mov al,start_day
     .IF al > 0                         ;days code 0-6 (Sun through Sat)
       dec al
     .ELSE
       mov al,6
     .ENDIF
    mov end_day,al                      ;going backwards, end day of preivous
                                        ;month in one day less than start 
   xor bx,bx                            ;day of present month.
   mov bl,month
   dec bl
   xor cx,cx
   .IF leap_year_flag == 01h            ;load month table 
      mov cl,day_count_table_2[bx]
   .ELSE
      mov cl,day_count_table_1[bx]
   .ENDIF
      mov days_in_month,cl

      mov si,offset dow_table
      add si,42   
      std
      mov al,end_day
    @@:
      dec si
      cmp al,[si]              ;find end day match
      loopne @B
      cld

      xor ax,ax
      mov al,days_in_month
      dec ax                   ;go back to start of month to
      sub si,ax                ;get start day offset 

      mov al,[si]
      mov start_day,al
    jmp start_over
  .ELSEIF ax==PAGE_UP
    .IF month < 12
       inc month
    .ELSE
       .IF year==2021
          jmp getkey
       .ENDIF  
       mov month,1
       inc year
     mov cx,year  
     test cx,3
     .IF ZERO? 
        mov leap_year_flag,01h
     .ELSE
        mov leap_year_flag,00h
     .ENDIF
    .ENDIF 

     mov al,end_day
     .IF al < 6              ;days coded 0-6 (Sun through Sat)  
       inc al
     .ELSE
       mov al,0
     .ENDIF
    mov start_day,al

   xor bx,bx
   mov bl,month
   dec bl
   xor cx,cx
   .IF leap_year_flag == 01h
      mov cl,day_count_table_2[bx]
   .ELSE
      mov cl,day_count_table_1[bx]
   .ENDIF
      mov days_in_month,cl

      mov si,offset dow_table
      dec si
      mov al,start_day
    @@:
      inc si
      cmp al,[si]
      loopne @B

      xor ax,ax
      mov al,days_in_month
      dec ax                       ;go forward to find end day (dow)
      add si,ax                    ;calculate end day of week of month

      mov al,[si]
      mov end_day,al
    jmp start_over

  .ELSEIF al==27
     .EXIT
  .ENDIF
 jmp getkey

 delay2 proc near C,count:WORD
     mov di,40h
     mov es,di
     mov di,6ch
     mov dx,word ptr es:[di]
     mov bx,dx              ;save clock count
     mov ax,dx
     xor si,si              ;zero si for counter
     mov si,count
     add bx,si
     .IF CARRY?
      @@:
        mov dx,word ptr es:[di]
        cmp dx,ax
        jae @B
     .ENDIF
 @@:        
    mov dx,word ptr es:[di]
    cmp dx,bx             ; compare to start + count
    jb @B                ;if over total, then leave
    ret    
 delay2 endp



END

