;****************************************************************************
; HMAGAUGE displays the number of free bytes in the HMA and the percentage
; of HMA space in use. Its syntax is:
;
;       HMAGAUGE
;
; HMAGAUGE relies on undocumented DOS function 4A01h (accessed through
; interrupt 2Fh) to get information about the HMA.
;****************************************************************************

code            segment
                assume  cs:code,ds:code
                org     100h
begin:          jmp     main

copyright       db      "HMAGAUGE 1.0 Copyright (c) 1993 Jeff Prosise",13,10
                db      "From: PC Magazine DOS 6 Memory Management "
                db      "with Utilities",13,10,13,10

                db      "Remaining Free Space: $"
txt2            db      " bytes",13,10,"Current HMA Utilization: $"
txt3            db      "%",13,10,"$"

helpmsg         db      "Displays statistics concerning DOS's utilization "
                db      "of the High Memory Area.",13,10,13,10
                db      "HMAGAUGE",13,10,"$"

errmsg1         db      "Requires DOS 5 or higher",13,10,"$"
errmsg2         db      "DOS is not loaded in the HMA",13,10,"$"

;****************************************************************************
; Procedure MAIN
;****************************************************************************

main            proc    near
                cld                             ;Clear direction flag
                mov     si,81h                  ;Point SI to the command line
                call    scanhelp                ;Scan for a "/?" switch
                jnc     main1                   ;Branch if not found

                mov     ah,09h                  ;Display help text
                mov     dx,offset helpmsg
                int     21h
                jmp     exit                    ;Exit

main1:          mov     ah,30h                  ;Check the DOS version and
                int     21h                     ;abort if it's not 5.0 or
                cmp     al,5                    ;later
                jae     main2

                mov     dx,offset errmsg1       ;Display error message
error:          mov     ah,09h                  ;and terminate
                int     21h
                mov     ax,4C01h
                int     21h

main2:          mov     ax,3306h                ;Make sure DOS is loaded
                int     21h                     ;in the HMA
                test    dh,10h
                jnz     main3
                mov     dx,offset errmsg2       ;Error if it is not
                jmp     error
;
; Compute and display HMA utilization statistics.
;
main3:          mov     ax,4A01h                ;Get free space
                int     2Fh

                mov     ah,09h                  ;Display header
                mov     dx,offset copyright
                int     21h

                push    bx                      ;Save byte count in BX
                mov     ax,bx                   ;Display number of bytes
                call    bin2asc                 ;unallocated
                pop     bx                      ;Restore byte count

                mov     ah,09h                  ;Display "bytes" and
                mov     dx,offset txt2          ;"Current HMA Utilization"
                int     21h

                mov     ax,0FFF0h               ;Compute percent utilized
                sub     ax,bx
                mov     bx,100
                mul     bx
                mov     bx,0FFF0h
                div     bx
                call    bin2asc                 ;Display the result

                mov     ah,09h                  ;Display percent sign
                mov     dx,offset txt3
                int     21h

exit:           mov     ax,4C00h                ;Exit with ERRORLEVEL=0
                int     21h
main            endp

;****************************************************************************
; BIN2ASC displays the number in AX.
;****************************************************************************

bin2asc         proc    near
                mov     bx,10                   ;Initialize divisor word and
                xor     cx,cx                   ;digit counter
b2a1:           inc     cx                      ;Increment digit count
                xor     dx,dx                   ;Divide by 10
                div     bx
                push    dx                      ;Save remainder on stack
                or      ax,ax                   ;Loop until quotient is zero
                jnz     b2a1
b2a2:           pop     dx                      ;Retrieve a digit from stack
                add     dl,30h                  ;Convert it to ASCII
                mov     ah,2                    ;Display it
                int     21h
                loop    b2a2                    ;Loop until done
                ret
bin2asc         endp

;****************************************************************************
; SCANHELP scans the command line for a /? switch. If the switch is found,
; carry returns set and SI contains the switch offset. If the switch is not
; found, carry returns clear.
;****************************************************************************

scanhelp        proc    near
                push    si                      ;Save SI
scanloop:       lodsb                           ;Get a character
                cmp     al,0Dh                  ;Exit if end of line
                je      scan_exit
                cmp     al,"?"                  ;Loop if not "?"
                jne     scanloop
                cmp     byte ptr [si-2],"/"     ;Loop if not "/"
                jne     scanloop

                add     sp,2                    ;Clear the stack
                sub     si,2                    ;Adjust SI
                stc                             ;Set carry and exit
                ret

scan_exit:      pop     si                      ;Restore SI
                clc                             ;Clear carry and exit
                ret
scanhelp        endp

code            ends
                end     begin
code            ends
                end     begin

