;----------------------------------------------------------------------------
; File: DOS.ASM  -  VBDOS 1.0 MS-DOS subroutines.
;----------------------------------------------------------------------------
; (c) 1995 Adam Wheeler   (adamwheeler@bix.com)
;----------------------------------------------------------------------------
; Downloaded from:
;  Professional Programmers' Pages
;  http://www.fys.ruu.nl/~faber
;----------------------------------------------------------------------------
; Permission granted to use these routines freely.  The author assumes
;no responsibility for your ability or inability to use or misuse these
;routines.
;
; Written in Microsoft MASM 6.11.  Will probably work with 6.0 or greater
;with minimal modification. TASM compatibility is unknown.
;
; Wanted: Microsoft MASM v6.0 with OS/2 help files! Email author if you
;         have a copy for sale. (Original manuals and diskettes required.)
;         Could also use IBM MASM for OS/2. (if it even exists!)
;
;Use the following declarations in your BASIC program.
;(DOS.BI)
;DECLARE FUNCTION EXIST% (filename$)
;'returns 0 if file exists else returns error code
;
;DECLARE FUNCTION FINDFIRST% (findname$, BYVAL findattr%,
;                             fattr%, filtime%, fildate%, filsize&)
;'returns 0 if file exists or error. Sets filattr, filtime, fildate, filsize.
;
;DECLARE SUB TruncateFile (filename$, BYVAL FileLength&)
;'truncates or expands file to FileLength&.  Returns error or 0 as function
;
;DECLARE SUB SetFileDateTime (FileName$, BYVAL FileDate%, BYVAL FileTime%)
;'sets file date and time. Returns error or 0 as function
;
;DECLARE FUNCTION PeekLong (BYVAL LongSeg%, BYVAL LongOff%) AS LONG
;'returns longint found at SEG:OFF
;
;DECLARE SUB PokeLong (BYVAL LongSeg%, BYVAL LongOff%, BYVAL LongInt as LONG)
;'pokes longint into SEG:OFF
;

.MODEL medium, BASIC, os_dos

;prototype externals
StringLength  PROTO descriptor:PTR WORD
StringRelease PROTO descriptor:PTR WORD
StringAddress PROTO descriptor:WORD         ;returns addr in dx:ax, len in cx
StringAssign  PROTO srcAddr:FAR PTR DWORD, srcLen:WORD,
                    destAddr:FAR PTR DWORD, destLen:WORD

;prototype library functions
Exist           PROTO string:WORD
FindFirst       PROTO string:WORD, attr:WORD,
                      fileattr:PTR WORD, filetime:PTR WORD,
                      filedate:PTR WORD, filesize:PTR WORD
TruncateFile    PROTO FileName$:PTR WORD, FileLength:DWORD
SetFileDateTime PROTO FileName$:PTR WORD, NewFileDate:WORD, NewFileTime:WORD
PeekLong        PROTO LongSeg:WORD, LongOff:WORD
PokeLong        PROTO LongSeg:WORD, LongOff:WORD, LongInt:DWORD

;define constants
True            EQU     -1
False           EQU     0

;define DTA structure for findfirst.
DTA     STRUC
    DTAreserved     db  15h dup (0)
    DTAattribute    db  0
    DTAfiletime     dw  0
    DTAfiledate     dw  0
    DTAfilesize     dd  0
    DTAfilename     db  0Dh dup (0)     ;ASCIIZ filename
DTA     ENDS

.DATA
;declare global vars
buffer          db      0FFh dup (0)
olddtaoff       dw      ?               ;storage for old DTA offset
olddtaseg       dw      ?               ;storage for old DTA segment
newdta          DTA <>

.CODE
;------------------------------------------------------------------
; Exist function - returns True (-1) if file exists else False (0)
;
;DECLARE FUNCTION EXIST% (filename$)
;'returns 0 if file exists else returns error code
;
Exist           PROC    FAR USES    ES DS SI DI, string:WORD

                INVOKE  StringAddress, string   ;get string address
                jcxz    exitexist               ;abort if nul string
                mov     si, ax              ;set si to string offset
                mov     ds, dx              ;set string segment
                mov     ax, @data           ;get data segment
                mov     es, ax              ;set es to @data
                mov     di, offset buffer   ;set di to data buffer
                cld                         ;count up
                rep     movsb               ;copy filename to buffer
                push    es                  ;put data seg on stack
                pop     ds                  ;set ds to @data
                mov     dx, offset buffer   ;set filename to buffer
                mov     byte ptr es:[di], 0 ;asciiz string
                mov     ax, 3D00h           ;open file read access
                int     21h             ;call dos
                jc      notexist        ;if error set ax=False
                mov     bx, ax          ;put handle in bx
                mov     ah, 3Eh         ;close file
                int     21h             ;call dos
                jc      exitexist       ;if some error abort w.error code
                mov     ax, True
                jmp     SHORT exitexist ;exit w.True
notexist:       mov     ax, False       ;file does not exist
exitexist:      ret
Exist           ENDP


;--------------------------------------------------------------------------
; FindFirst - find first file matching [INFILES.PEC] and [INFILE.ATTRIBUTE]
;             Returns: File attribute, time, date, and size.
;                      FindFirst%=0 IF FILE EXISTS ELSE = ERRORCODE
;
FindFirst       PROC    FAR USES ES DS SI DI,
                                 string:WORD, attr:WORD,
                                 fileattr:PTR WORD, filetime:PTR WORD,
                                 filedate:PTR WORD, filesize:PTR WORD

                mov     ah, 2Fh         ;get DTA address
                int     21h                     ;call DOS
                mov     olddtaoff, bx           ;store offset
                mov     olddtaseg, es           ;store segment
                push    ds                      ;save ds
                mov     ax, @data           ;get data segment
                mov     ds, ax              ;set ds to new DTA seg
                mov     dx, offset newdta   ;get offset of new DTA
                mov     ah, 1Ah             ;set new DTA
                int     21h                 ;call DOS
                pop     ds                  ;restore DS
                INVOKE  StringAddress,string;get string address
                jcxz    exitfindfirst       ;abort if nul string
                push    ds                  ;save ds
                mov     si, ax              ;set si to string offset
                mov     ds, dx              ;set string segment
                mov     ax, @data           ;get data segment
                mov     es, ax              ;set es to @data
                mov     di, offset buffer   ;set di to data buffer
                cld                         ;count up
                rep     movsb               ;copy filename to buffer
                mov     cx, attr            ;get attribute for findfirst
                push    es                  ;put data seg on stack
                pop     ds                  ;set ds to @data
                mov     dx, offset buffer   ;set filename to buffer
                mov     byte ptr es:[di], 0 ;asciiz string
                mov     ah, 4Eh             ;findfirst file
                int     21h                 ;call DOS
                pop     ds                  ;restore data segment
                jnc     okfindfirst         ;abort if error
                jmp     SHORT exitfindfirst ;abort w.ax=errorcode
okfindfirst:
                mov     bx, fileattr                ;get ptr to fileattr%
                mov     al, newdta.DTAattribute     ;get file attribute
                xor     ah, ah                      ;zero high byte
                mov     [bx], ax                    ;store attribute byte
                mov     bx, filetime                ;get ptr to filetime%
                mov     ax, newdta.DTAfiletime      ;get file time
                mov     [bx], ax                    ;store file time
                mov     bx, filedate                ;get ptr to filedate%
                mov     ax, newdta.DTAfiledate      ;get file date
                mov     [bx], ax                    ;store file date
                mov     bx, filesize                    ;get ptr to filesize&
                mov     ax, word ptr newdta.DTAfilesize ;get lsw filesize
                mov     [bx], ax                          ;store file size lsw
                mov     ax, word ptr newdta.DTAfilesize+2 ;get msw filesize
                mov     2[bx], ax                         ;store file size msw
                xor     ax, ax                      ;ax=0=file exists.
exitfindfirst:
                push    ax              ;save exit code
                mov     dx, olddtaoff   ;set dx to orig DTA offset
                mov     ax, olddtaseg   ;get old DTA segment
                mov     ds, ax
                mov     ah, 1Ah         ;set DTA address
                int     21h             ;call DOS
                pop     ax              ;restore exit code
                ret
FindFirst       ENDP


;------------------------------------------------------------------
; TruncateFile - Truncate (or expand) file to FileLength&
;
;DECLARE SUB TruncateFile (FileName$, BYVAL FileLength&)
;
TruncateFile    PROC    FAR USES DS ,
                                 FileName$:ptr word,
                                 FileLength:dword

                        LOCAL    handle:word

;get filename address
                INVOKE  StringAddress, FileName$
                mov     ds, dx              ;set string segment
                mov     dx, ax              ;set si to string offset
;open file
                mov     ax, 3D42h           ;open file deny write read/write
                int     21h                 ;call DOS
                jc      errorTruncateFile   ;exit on error
;seek to length specified
                mov     bx, ax              ;save handle
                mov     ax, 4200h               ;seek absolute from start
                mov     dx, word ptr FileLength     ;get LSW
                mov     cx, word ptr FileLength+2   ;get MSW
                int     21h                         ;call DOS
                jc      errorTruncateFile   ;exit on error
;write 0 bytes to file, forcing size to current pointer.
                mov     ah, 40h             ;write file
                xor     cx, cx              ;zero bytes
                int     21h                 ;call DOS
                jc      errorTruncateFile   ;exit on error
;close file and exit
                mov     ah, 3Eh             ;close file BX has handle
                int     21h
                jc      errorTruncateFile   ;exit on error
                xor     ax, ax              ;exit code 0
errorTruncateFile:
                ret
TruncateFile    ENDP

;------------------------------------------------------------------
; SetFileDateTime - Set file date and time.
;
;DECLARE SUB SetFileDateTime (FileName$, BYVAL FileDate, BYVAL FileTime)
;
SetFileDateTime PROC    FAR USES DS,
                                 FileName$:ptr word,
                                 NewFileDate:word,
                                 NewFileTime:word

                        LOCAL    handle:word

;get filename address
                INVOKE  StringAddress, FileName$
                mov     ds, dx              ;set string segment
                mov     dx, ax              ;set si to string offset
;open file
                mov     ax, 3D42h           ;open file deny write read/write
                int     21h                 ;call DOS
                jc      errorSetFileDateTime;exit on error
;set time/date
                mov     bx, ax              ;save handle
                mov     ax, 5701h           ;set file timestamp
                mov     cx, NewFileTime     ;get file time
                mov     dx, NewFileDate     ;get file date
                int     21h                 ;call DOS
                jc      errorSetFileDateTime;exit on error
;close and exit
                mov     ah, 3Eh             ;close file BX has handle
                int     21h
                jc      errorSetFileDateTime;exit on error
                xor     ax, ax              ;exit code 0
errorSetFileDateTime:
                ret
SetFileDateTime ENDP

;------------------------------------------------------------------
; PeekLong - return contents of longint at seg:off in dx:ax
;
;DECLARE FUNCTION PeekLong (BYVAL LongSeg%, BYVAL LongOff%) AS LONG
;
PeekLong        PROC    FAR USES DS,
                                 LongSeg:word,
                                 LongOff:word

                mov     bx, LongOff
                mov     ax, LongSeg
                mov     ds, ax
                mov     ax, [bx]
                mov     dx, [bx+2]
                ret
PeekLong        ENDP

;------------------------------------------------------------------
; PokeLong - put contents of longint in seg:off
;
;DECLARE SUB PokeLong (BYVAL LongSeg%, BYVAL LongOff%, BYVAL LongInt as LONG)
;
PokeLong        PROC    FAR USES DS,
                                 LongSeg:word,
                                 LongOff:word,
                                 LongInt:dword

                mov     cx, word ptr LongInt
                mov     dx, word ptr LongInt+2
                mov     bx, LongOff
                mov     ax, LongSeg
                mov     ds, ax
                mov     [bx], cx
                mov     [bx+2], dx
                ret
PokeLong        ENDP

END

