;DIALER.ASM TSR VERSION 2.1  November 1992
;assemble and link as DIALER.COM
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; Author:
;    Robert Ree
; Downloaded from:
;    Professional Programmers' Pages
;    http://www.fys.ruu.nl/~faber
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
code          segment para public 'CODE'
              assume cs:code,ds:code
              org 100h
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
cr            equ  0dh                      ;
lf            equ  0ah                      ;
row           equ  0a0h                     ;
new_stack     equ  0ffh                     ;local stack address
dbox_pos      equ  94                       ;
dialer_pos    equ  256                      ;
menu_pos      equ  1698                     ;
dfieldn_pos   equ  576                      ;
drec_pos      equ  582                      ;
recnr_pos     equ  472                      ;
prompt_pos    equ  1728                     ;
drow_len      equ  26                       ;
drec_len      equ  156                      ;

port_config   equ  83h                      ;
our_dta       equ  80h                      ;
                                            ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
start:        jmp  install_tsr              ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

programmer    db   'Robert Re',0           ;
dialer_ttle   db   '@Dialer',0              ;
field_names   db   'Nm:& :Ad:dr:Fx:Ph:',0   ;
d_functions   db   'Add',0,'Rmv',0,'Edt',0,'Fnd',0         ;
              db   'Cll',0,'Phn',0,'Xit',0,24h             ;
find_msg      db   ' Name to find:',0      ;
anykey_msg    db   ' Spacebar Continues Search ',0        ;
remove_msg    db   ' Remove This Record? (Y/N) ',0        ;
edit_msg      db   ' <Ctrl> + <End> Saves Entry',0        ;
sort_msg      db   'Sorting ....................',0
box          db   'Ŀ'               ;

dfirst_row    db   3                        ;
dlast_row     db   8                        ;
dleft_margin  db   51                       ;
drite_margin  db   77                       ;

mod_nr_msg    db   ' Modem Not Present or Ready',0        ;
dial_msg      db   ' Nmbr to Dial:',0      ;
dialing_msg   db   ' Dialing ..................',0
pickup_msg    db   ' Hit Spacebar After Dialing',0        ;

modem_strng   db   'AT&F2E1L1M1Q0V1X6&C1&D2S11=60',cr,0
dial_code     db   'ATDT',0                 ;
hangup_code   db   '+++ATH',cr,0            ;
                                            ;
df_handle     dw   00                       ;
vid_seg       dw   0b800h                   ;
no_mouse      db   00                       ;
reg_cursor    dw   0607h                    ;
big_cursor    dw   0107h                    ;
cmod_saved    dw   00                       ;
cpos_saved    dw   00                       ;
x_pos         db   00                       ;
y_pos         db   00                       ;
xy_pos        dw   00                       ;
start_pos     dw   00                       ;
rec_pos       db   00                       ;

reg_attr      db   0fh                      ;VGA color attributes
rev_attr      db   34h                      ;
msg_attr      db   47h                      ;
lne_attr      db   04h                      ;
txt_attr      db   70h                      ;
mnu_attr      db   4fh                      ;

rec_nr        dw   00                       ;
rec_nr_sav    dw   00                       ;
drec_total    dw   00                       ;
save_edit     db   00                       ;
rec_counter   dw   00
                                            ;
phone_req     db   00                       ;
dial_flag     db   00                       ;
com_flag      db   00                       ;
com_n         dw   0ffh                     ;no modem is default
com_data      dw   00                       ;data port
com_sts       dw   00                       ;line status port
com_int       db   00                       ;
asc_in        dw   00                       ;
asc_out       dw   00
                                            ;
next_tdpos    db   00                       ;
ins_on        db   00                       ;
                                            ;
cef_ptr       dd   00                       ;
in_dos        dd   00                       ;

int_8         dd   00                       ;saved interrupts
int_9         dd   00                       ;
int_13        dd   00                       ;
int_28        dd   00                       ;

vect_1b       dd   00                       ;more saved vectors
vect_23       dd   00                       ;
vect_24       dd   00                       ;
                                            ;
active        db   00                       ;
disk_flag     db   00                       ;
keyb_flag     db   00                       ;
                                            ;
ss_register   dw   00                       ;
sp_register   dw   00                       ;
saved_psp     dw   00                       ;
dta_sav       dd   00                       ;


dfile_name    db   40 dup (?)               ;

dmenu_keys    db   'AERFCPX',1bh            ;menu choices

dmenu_choice  dw   do_add,do_edit,do_remove ;menu dispatch table
              dw   do_find,do_call,do_phone ;
              dw   dialer_xit, dialer_xit   ;
                                            ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
keyb_int      proc  far                     ;
              assume cs:code,ds:nothing,es:nothing

              sti                           ;interrupts back on
              pushf                         ;
              call int_9                    ;process interrup

              push ax                       ;
              push ds                       ;
              mov  ax,40h                   ;
              mov  ds,ax                    ;bios segment
              mov  ah,ds:[17h]              ;keyb flag byte
              and  ah,0fh                   ;
              cmp  ah,5                     ;Ctrl + right shift down?
              pop  ds                       ;
              pop  ax                       ;
              jz   chk_active               ;if not, leave
              iret                          ;

chk_active:   cmp  cs:[active],0            ;are we up already?
              jnz  keyb_exit                ;if so, leave
              mov  cs:[keyb_flag],12h       ;set flag for a few runs
keyb_exit:    iret                          ;continue interrupt
keyb_int      endp                          ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
timer_int     proc far                      ;
              assume cs:code,ds:nothing,es:nothing

              sti
              pushf                         ;
              call int_8                    ;process call further
              cli                           ;
              cmp  cs:[keyb_flag],0         ;keyb flag set?
              jnz  chk_dosflag              ;
              iret                          ;

chk_dosflag:  cmp  cs:[disk_flag],0         ;disk busy?
              jnz  dec_time                 ;if so, wait ...
              push es                       ;
              push di                       ;
              les  di,in_dos                ;INDOS flag
              cmp  byte ptr es:[di],0       ;DOS busy?
              pop  di                       ;
              pop  es                       ;
              jnz  timer_exit               ;
              mov  cs:[keyb_flag],0         ;remove keyb flag
              call tsr_prog                 ;and do our thing
timer_exit:   iret                          ;
dec_time:     dec  cs:[keyb_flag]           ;
              iret                          ;
timer_int     endp                          ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
disk_int      proc far                      ;
              assume cs:code, ds:nothing,es:nothing
              pushf                         ;
              inc  cs:[disk_flag]           ;set flag
              popf                          ;
              pushf                         ;
              call int_13                   ;process call
              pushf                         ;
              dec  cs:[disk_flag]           ;remove flag
              popf                          ;
              ret  2                        ;
disk_int      endp                          ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
idle_int      proc far                      ;
              assume cs:code,ds:nothing,es:nothing

              sti
              pushf                         ;
              call int_28                   ;process call
              cli                           ;

              cmp  cs:[keyb_flag],0         ;etc
              jnz  chk_cef                  ;
              iret                          ;

chk_cef:      cmp  cs:[disk_flag],0         ;
              jne idle_exit                 ;
              push es                       ;
              push di                       ;
              les  di,cs:cef_ptr            ;cef flag set?
              cmp  byte ptr es:[di],0       ;if not ...
              pop  di                       ;
              pop  es                       ;
              jne  idle_exit                ;
              mov  cs:[keyb_flag],0         ;remove keyb flag
              call tsr_prog                 ;and get'r going ...
idle_exit:    iret                          ;
idle_int      endp                          ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
critic_err    proc far                      ;
              assume cs:code,ds:nothing,es:nothing
              mov  al,3                     ;signal Fail Function to caller
              iret                          ;
critic_err    endp                          ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
tsr_prog      proc near                     ;
              assume cs:code, ds:nothing, es:nothing
              inc cs:[active]               ;we're live ...
                                            ;
              cli                           ;clear interrupts
              mov  cs:ss_register,ss        ;save current stack
              mov  cs:sp_register,sp        ;pointers
              mov  ax,cs                    ;
              mov  ss,ax                    ;
              mov  sp,offset new_stack      ;
              sti                           ;enable interrupts
                                            ;
              push ax                       ;save all registers
              push bx                       ;
              push cx                       ;
              push dx                       ;
              push si                       ;
              push di                       ;
              push ds                       ;
              push es                       ;
              push bp                       ;
                                            ;
              mov  ah,0fh                   ;
              int  10h                      ;get current video state
              cmp  al,2                     ;color text mode ok
              jz   video_ok                 ;
              cmp  al,3                     ;
              jz   video_ok                 ;
              cmp  al,7                     ;
              jz   video_ok                 ;
              jmp  short_xit                ;no other video modes allowed

video_ok:     mov  ax,cs                    ;make local data
              mov  ds,ax                    ;addressable

              assume ds:code                ;

              mov  ax,351bh                 ;divert CtrlBreak vector
              int  21h                      ;
              mov  word ptr vect_1b,bx      ;
              mov  word ptr vect_1b[2],es   ;
              mov  ax,251bh                 ;
              mov  dx,offset idle_exit      ;
              int  21h                      ;

              mov  ax,3523h                 ;divert CtrlC vector
              int  21h                      ;
              mov  word ptr vect_23,bx      ;
              mov  word ptr vect_23[2],es   ;
              mov  ax,2523h                 ;
              mov  dx,offset idle_exit      ;
              int  21h                      ;

              mov  ax,3524h                 ;divert critical error
              int  21h                      ;vector
              mov  word ptr vect_24,bx      ;
              mov  word ptr vect_24[2],es   ;
              mov  ax,cs                    ;
              mov  ds,ax                    ;
              mov  ax,2524h                 ;
              mov  dx,offset critic_err     ;
              int  21h                      ;

              mov  ah,2fh                   ;get current DTA
              int  21h                      ;
              mov  word ptr dta_sav,bx      ;and save it
              mov  word ptr dta_sav+2,es    ;

              mov  ah,1ah                   ;replace with our own
              mov  dx,offset our_dta        ;
              int  21h                      ;

save_psp:     mov  ah,51h                   ;save psp and
              int  21h                      ;
              mov  word ptr saved_psp,bx    ;
              push cs                       ;put our code segment
              pop  bx                       ;into bx
              mov  ah,50h                   ;switch to internal psp
              int  21h                      ;

              mov  ax,cs                    ;
              mov  es,ax                    ;
                                            ;
;save interrupted program's video configuration
                                            ;
              mov  ah,3                     ;get cursor position
              xor  bh,bh                    ;0 page
              int  10h                      ;
              mov  [cmod_saved],cx          ;store cursor model
              mov  [cpos_saved],dx          ;store cursor position
              call cursor_off               ;;switch cursor off
                                            ;
              call dialer_prog              ;
                                            ;
              mov  ah,1                     ;restore cursor model
              mov  cx,[cmod_saved]          ;
              int  10h                      ;
              mov  ah,2                     ;restore cursor position
              mov  dx,[cpos_saved]          ;
              mov  bh,0                     ;
              int  10h                      ;
                                            ;
;restore vectors and interrupted program
                                            ;
do_psp:       mov  bx,[saved_psp]           ;restore psp
              mov  ah,50h                   ;
              int  21h                      ;

              push ds                       ;

              mov  ah,1ah                   ;reset DTA
              lds  dx,cs:[dta_sav]          ;
              int  21h                      ;                              ;

              mov  ax,2524h                 ;critical error
              lds  dx,cs:[vect_24]          ;
              int  21h                      ;
                                            ;
              mov  ax,2523h                 ;ctrl/c
              lds  dx,cs:[vect_23]          ;
              int  21h                      ;
                                            ;
              mov  ax,251bh                 ;ctrl/break
              lds  dx,cs:[vect_1b]          ;
              int  21h                      ;

              pop  ds                       ;


short_xit:    pop  bp                       ;
              pop  es                       ;
              pop  ds                       ;
              pop  di                       ;
              pop  si                       ;
              pop  dx                       ;
              pop  cx                       ;
              pop  bx                       ;
              pop  ax                       ;

              assume ds:nothing             ;
              cli                           ;clear interrupts
              mov  ss,cs:ss_register        ;and restore stack
              mov  sp,cs:sp_register        ;pointers
              sti                           ;set interrupts
              dec  cs:[active]              ;back to 0
              ret                           ;restore to interrupted program
tsr_prog      endp                          ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
dialer_prog   proc near                     ;
              assume ds:code                ;

              mov  bx,dbox_pos              ;screen location
              push ds                       ;
              mov  ds,[vid_seg]             ;make video segment
              mov  di,offset scrn_buffer    ;and place to save
              mov  dx,11                    ;nr of rows to save
main_1:       mov  si,bx                    ;
              mov  cx,33                    ;nr of bytes per row
              cld                           ;all string ops foreward
              rep  movsw                    ;current display to
              add  bx,row                   ;add a row
              dec  dx                       ;reduce row count
              jnz  main_1                   ;if not 0, repeat!
              pop  ds                       ;restore our data segment
                                            ;
              mov  es,[vid_seg]             ;load video segment
              mov  al,20h                   ;load a space char
              mov  ah,[rev_attr]            ;negative video
              mov  dx,9                     ;9 rows
              mov  bx,dialer_pos            ;
main_2:       mov  di,bx                    ;point to screen pos
              mov  cx,31                    ;31 columns
              rep  stosw                    ;write one row to screen
              add  bx,row                   ;add a row
              dec  dx                       ;reduce row count
              jnz  main_2                   ;if not, repeat
                                            ;
              mov  cx,31                    ;width
              mov  dx,9                     ;hight
              mov  bx,dbox_pos              ;
              call draw_box                 ;

              call draw_menu                ;draw menu string

              mov  bx,dialer_pos            ;
              add  bx,row                   ;field name string
              mov  di,bx                    ;
              inc  di                       ;
              inc  di                       ;
              mov  cx,29                    ;nr of columns
              mov  ah,rev_attr              ;
              mov  al,205                   ;
              rep  stosw                    ;draw crossbar

              mov  bx,dialer_pos            ;
              add  bx,24                    ;
              mov  di,bx                    ;
              mov  si,offset dialer_ttle    ;
ttle_t_scrn:  lodsb                         ;
              or   al,al                    ;
              jz   do_fldnames              ;
              stosw                         ;
              jmp  ttle_t_scrn              ;

do_fldnames:  mov  si,offset field_names    ;
              mov  bx,dfieldn_pos           ;

main_3:       mov  di,bx                    ;start position
              mov  cx,3                     ;load 10 chars
main_4:       lodsb                         ;char in al
              stosw                         ;add attribute and to the screen
              loop main_4                   ;until done
              add  bx,row                   ;next row
              cmp  byte ptr [si],0          ;fieldname string done?
              jnz  main_3                   ;get next name

              mov  ax,cs                    ;restore scratch register now
              mov  es,ax                    ;
                                            ;
;open file and display next record

rec_to_scrn:  inc  [rec_nr]                 ;next record
              mov  ax,3d02h                 ;open file
                                            ;mode 2=read/write
              mov  dx,offset dfile_name     ;
              int  21h                      ;dos function
              jnc  find_eof                 ;no carry, so ...
                                            ;
              mov  ah,3ch                   ;no file exists, try create one ...
              xor  cx,cx                    ;regular attrib
              int  21h                      ;dos function
              jnc  find_eof                 ;if all clear

              jmp  dialer_xit               ;else something fishy here - quit!

find_eof:     mov  [df_handle],ax           ;save file handle
              mov  bx,ax                    ;use it to
              mov  ax,4202h                 ;set file pointer
              mov  cx,0                     ;offset 0
              mov  dx,cx                    ;returns file length in AX
              int  21h                      ;dos
                                            ;AX=file length
              mov  cx,drec_len              ;get dialer record length
              div  cx                       ;
              mov  [drec_total],ax          ;gives us all records on file

              cmp  [drec_total],0           ;is this a new file?
              ja   not_newfile              ;
              call flush_bufs               ;clear out read record buffer
              call blank_record             ;
              jmp  init_modem               ;set modem up
                                            ;
not_newfile:  call read_record              ;1st record to the screen

;check if modem is present or ready

init_modem:   cmp  com_n,0ffh               ;modem required?
              jz   get_dkey                 ;skip next if not required
              call test_modem               ;

;wait for user input
                                            ;
get_dkey:     call wait_f_inp               ;wait for user input
              cmp  al,00h                   ;special key?
              jz   spec_keys1               ;then jump
              jmp  reg_key_on               ;else keep looking

spec_keys1:   cmp  ah,50h                   ;down arrow?
              jnz  spec_keys2               ;if not, look further
mkey_down:    mov  ax,[rec_nr]              ;else get last record pulled
              cmp  ax,[drec_total]          ;did we get them all?
              jnl  spec_keys2               ;yes, so move on
              inc  [rec_nr]                 ;
              call read_record              ;redraw the screen
              jmp  get_dkey                 ;

spec_keys2:   cmp  ah,48h                   ;up arrow?
              jnz  spec_keys3               ;
mkey_up:      mov  ax,[rec_nr]              ;
              cmp  ax,1                     ;start of file?
              ja   ok_up                    ;ok
              jmp  get_dkey                 ;get next key

ok_up:        dec  [rec_nr]                 ;
              call read_record              ;and redraw screen
xit_spkeys:   jmp get_dkey                  ;

spec_keys3:   cmp  ah,47h                   ;'Home' key?
              jnz  spec_keys4               ;
              mov  [rec_nr],1               ;
              call read_record              ;
              jmp  get_dkey                 ;

spec_keys4:   cmp  ah,4fh                   ;'End' key?
              jnz  xit_spkeys               ;
              mov  ax,[drec_total]          ;get the last record number
              mov  [rec_nr],ax              ;
              call read_record              ;
all_keys_dne: jmp  get_dkey                 ;

reg_key_on:   and  al,5fh                   ;convert to upper case
              mov  di,offset dmenu_keys     ;available key codes
              mov  cx,8                     ;8 choices
              repnz scasb                   ;look for it
              jnz  all_keys_dne             ;get next key if not found
              mov  di,offset dmenu_choice+14;else point to end of menu choices
              shl  cx,1                     ;multiply for word size
              sub  di,cx                    ;point to choice item
              jmp  cs:[di]                  ;go to requested routine

;dialer routine

do_phone:     inc [phone_req]               ;phone requested
do_call:      cmp  com_n,0ffh               ;com-port specified??
              jz   dd_exit                  ;no, so quit routine
              call dial_prog                ;activate dialer
              call draw_menu                ;restore menubar
dd_exit:      mov  [phone_req],0            ;make sure is now zero
              jmp  get_dkey                 ;and wait for input

;add record routine

do_add:       mov  si,offset edit_msg       ;edit and save message
              call echo_msg                 ;message to screen

              call flush_bufs               ;clear read buffer
              mov  ax,[rec_nr]              ;get current record nr
              mov  [rec_nr_sav],ax          ;and save it
              mov  [rec_nr],0               ;show 0 while adding

              call blank_record             ;blank record to scrn
              mov  [start_pos],drec_pos     ;
              call _editor                  ;get data entry routine
              cmp  [save_edit],0            ;save record flag set?
              jnz  add_new_rec              ;
              jmp  xit_do_add               ;no, so quit routine

add_new_rec:  dec  [save_edit]              ;reset save edit flag
              call load_writebuf            ;new record to write buffer

sort_n_store: mov  ax,4200h                 ;set file pointer
                                            ;to start of file
              mov  bx,df_handle             ;
              mov  cx,0                     ;
              mov  dx,0                     ;
              int  21h                      ;

              cmp  [drec_total],0           ;is this a new file?
              ja   step_1                   ;if not, skip next
              inc  [rec_nr]                 ;else 1st record nr
              jmp  write_rec                ;straight to the file

step_1:       mov  si,offset sort_msg       ;display "Sorting ..." msg
              mov  di,menu_pos              ;
              mov  ah,0fh                   ;
              call echo_string

              call read_dfile               ;one record to the buffer
              mov  ax,offset read_buffer    ;point to buffer start

look_f_spot:  mov  di,ax                    ;starting offset
              mov  si,offset write_buffer   ;string we want to match
              mov  bx,si                    ;
              mov  cx,drow_len              ;only the first field
              inc  [rec_nr]                 ;next record
              mov  ax,[rec_nr]              ;
              cmp  ax,[drec_total]          ;last record  checked yet?
              ja   write_rec                ;yes, write to file

nxt_char:     mov  al,[bx]                  ;char in al
              cmp  al,20h                   ;is it a space?
              jz   skip_and                 ;
              and  al,5fh                   ;check upper case first
skip_and:     cmp  byte ptr es:[di],'Z'     ;
              jna  chk_upper                ;check upper case
              add  al,20h                   ;check lower case
chk_upper:    scasb                         ;
              jnz  no_match                 ;
              inc  bx                       ;
              loop nxt_char                 ;

no_match:     cmp  al,[di - 1]              ;
              ja   step_1                   ;

write_rec:    mov ax,[rec_nr]               ;this record nr we
              mov [rec_nr_sav],ax           ;want to show
              inc [drec_total]              ;
              push ax                       ;save record nr

wr_1:         call set_f_ptr                ;backup pointer
              mov  dx,offset write_buffer   ;write new
              mov  cx,drec_len              ;record to
              call write_dfile              ;the file

              pop  ax                       ;retrieve this record nr
              cmp  ax,[drec_total]          ;last record on file?
              je   xit_do_add               ;if so, quit ...
              inc  ax                       ;
              mov  [rec_nr],ax              ;

              push ax                       ;save record nr
              mov  si,offset read_buffer    ;move current record
              mov  di,offset write_buffer   ;free up file buffer
              mov  cx,drec_len              ;
              shr  cx,1                     ;
              rep  movsw                    ;move words
              call read_dfile               ;get next record
              jmp  wr_1                     ;

xit_do_add:   jmp  ret_t_menu               ;

;edit existing record routine

do_edit:      mov  ax,[rec_nr]              ;save record nr
              mov  [rec_nr_sav],ax          ;for later
              mov  si,offset edit_msg       ;edit and save message
              call echo_msg                 ;message to screen
              call read_record              ;highlight object record
              mov  [start_pos],drec_pos     ;
              call _editor                  ;go to data entry

              cmp  [save_edit],1            ;save this?
              jnz  xit_do_edit              ;no, so leave routine
              dec  [save_edit]              ;switch edit flag off
              call load_writebuf            ;yes,to write buffer
              call set_f_ptr                ;set pointer in reg file

              mov  cx,drec_len              ;nr of bytes to write
              mov  dx,offset write_buffer   ;from temporary buffer
              mov  ah,40h                   ;write function
              mov  bx,df_handle             ;reg file handle
              int  21h                      ;dos functionmov ah,40h

xit_do_edit:  jmp  ret_t_menu               ;

;remove record on file routine

do_remove:    mov  ax,[rec_nr]              ;save current record nr
              mov  [rec_nr_sav],ax          ;
              mov  si,offset remove_msg     ;remove prompt
              call echo_msg                 ;message to screen
              mov  dl,7                     ;beep
              mov  ah,2                     ;
              int  21h                      ;

wait_f_resp:  call wait_f_inp               ;
              cmp  al,1bh                   ;escape key?
              jz   remove_xit               ;if so, leave
              and  al,5fh                   ;convert to UPPER CASE
              cmp  al,'Y'                   ;is it a 'Y'?
              jz   remove_ok                ;go remove
              cmp  al,'N'                   ;is it a 'N'?
              jz   remove_xit               ;then quit
              jmp  wait_f_resp              ;

remove_ok:    mov  ax,[rec_nr_sav]          ;retrieve rec nr
              cmp  ax,[drec_total]          ;last record?
              jnz  not_lastrec              ;if not,continue
              dec  [rec_nr_sav]             ;else
              call set_f_ptr                ;backup file pointer
              jmp xit_remove                ;and truncate file now

not_lastrec:  call read_dfile               ;retrieve next record

del_1:        call set_f_ptr                ;backup file pointer
              mov  cx,drec_len              ;one record
              mov  dx,offset read_buffer    ;
              call write_dfile               ;write to the file
              inc  [rec_nr]                 ;
              inc  [rec_nr]                 ;

              mov  ax,[rec_nr]              ;
              cmp  ax,[drec_total]          ;all done yet?
              ja   xit_remove               ;
              call set_f_ptr                ;
              call read_dfile               ;
              dec  [rec_nr]                 ;
              jmp  del_1                    ;

xit_remove:   xor  cx,cx                    ;truncate file
              mov  dx,offset read_buffer    ;
              call write_dfile              ;at current position
              dec  [drec_total]             ;one less record
remove_xit:   jmp  ret_t_menu               ;

;find string and display record routine

do_find:      mov  ax,[rec_nr]              ;
              mov  [rec_nr_sav],ax          ;
              mov  ax,[drec_total]          ;
              mov  [rec_counter],ax         ;
              call flush_bufs               ;make sure buffers empty
              mov  si,offset find_msg       ;prompt for string to match
              call echo_msg                 ;
              call get_string               ;fetch string to search for
              jnc  start_search             ;if no carry ...
xit_find:     jmp  ret_t_menu               ;else return

start_search: mov  ax,4200h                 ;reset pointer for our data
              mov  bx,[df_handle]           ;to start
              mov  cx,0                     ;
              mov  dx,0                     ;
              int  21h                      ;
              mov  [rec_nr],0               ;

search_loop:  dec  [rec_counter]            ;
              jns  rec_start                ;
              jmp  ret_t_menu               ;we're all done

rec_start:    call read_dfile               ;one record to buffer
              mov  dx,offset read_buffer    ;point to string search

              mov  di,dx                    ;point to it
              mov  si,offset write_buffer   ;string to match
              mov  cx,drow_len - 1          ;nr of chars to search
              inc  [rec_nr]                 ;

next_string:  mov  bx,si                    ;point to char to match
              mov  al,[bx]                  ;get one byte
              cmp  al,es:[di]               ;does this byte match?
              jz   next_char                ;check successive bytes
              add  al,20h                   ;else check lower case
              cmp  al,es:[di]               ;does this byte match?
              jz   next_char                ;check successive bytes
              inc  di                       ;advance record pointer
              dec  cx                       ;
              jz   search_loop              ;
              jmp  next_string              ;search whole field

next_char:    inc  bx                       ;char matched, advance
              inc  di                       ;both pointers
              dec  cx                       ;
              jz   search_loop              ;
              mov  al,[bx]                  ;and compare next byte
              or   al,al                    ;a zero: end of string to match?
              jz   string_found             ;yes, we found it
              cmp  al,es:[di]               ;still matching?
              jz   next_char                ;check next character
              cmp  al,5ah                   ;else, was this an upper case?
              ja   next_string              ;if above jmp
              add  al,20h                   ;else conv to lower case
              cmp  al,es:[di]               ;and check it
              jz   next_char                ;if it fits, jump
              jmp  next_string              ;or get the next string

string_found: mov  ax,[rec_nr]              ;
              mov  [rec_nr_sav],ax          ;
              call read_record              ;this record to the screen
              mov  si,offset anykey_msg     ;
              call echo_msg                 ;
              call wait_f_inp               ;
              cmp  al,1bh                   ;esc key?
              jz   ret_t_menu               ;jmp to menu
              cmp  al,20h                   ;spacebar?
              jz   search_loop              ;if so, continue search
              and  al,5fh                   ;convert to upper case
              cmp  al,'C'                   ;Call requested?
              jne  ret_t_menu               ;
set_dial_f:   inc  [dial_flag]              ;dial required

ret_t_menu:   mov  ax,[rec_nr_sav]          ;
              mov  [rec_nr],ax              ;
              call read_record              ;
              call draw_menu                ;

              cmp  [dial_flag],1            ;dial requested?
              jz   dial_requ                ;
              jmp  get_dkey                 ;

dial_requ:    dec  [dial_flag]              ;reset dial flag
              jmp  do_call                  ;jump to dial program

;exit from main program

dialer_xit:   dec  [rec_nr]                 ;
              mov  bx,df_handle             ;get file handle
              mov  ah,3eh                   ;close the file
              int  21h                      ;

redo_displ:   push es                       ;save our scratch register
              mov  es,[vid_seg]             ;
              mov  bx,dbox_pos              ;point to screen pos
              mov  si,offset scrn_buffer    ;and place to save
              mov  dx,11                    ;rows to move
rd_1:         mov  di,bx                    ;
              mov  cx,33                    ;nr of words per row
              rep  movsw                    ;
              add  bx,row                   ;add a row
              dec  dx                       ;reduce row count
              jnz  rd_1                     ;if not, repeat!
              pop  es                       ;
              ret                           ;return to tsr exit routine
dialer_prog   endp                          ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;subroutines are next                       ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
wait_f_inp    proc near                     ;check keyb
              mov  ah,1                     ;
              int  16h                      ;
              jnz  got_one                  ;key pressed
              int  28h                      ;idle clear
              jmp  wait_f_inp               ;

got_one:      mov  ax,0                     ;get key codes
              int  16h                      ;
              ret                           ;return with key code in AX
wait_f_inp    endp                          ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
dial_prog     proc near                     ;
              cmp  [phone_req],0            ;flag set?
              jz   start_dial               ;if so, jump
              mov  si,offset dial_msg       ;direct dial message
              call echo_msg                 ;
              call get_string               ;fetch instant dial string
              jnc  start_dial               ;if carry flag not set
              jmp  xit_dial                 ;escape key encountered

start_dial:   mov  si,offset dial_code      ;write "ATDT" to com port
              mov  dx,[com_n]               ;
              call write_t_port             ;
              test ah,80h                   ;bit 7 set?
              jz   coms_ok                  ;if not, skip next
              jmp  modem_bad                ;

coms_ok:      mov  cx,drow_len              ;number of digits to dial
              cmp  [phone_req],1            ;flag set?
              jz   dial_wbuf                ;
              mov  si,offset read_buffer + 130 ;point to record start
              jmp  getnmbr_loop             ;
dial_wbuf:    mov  si,offset write_buffer   ;
getnmbr_loop: lodsb                         ;get a byte in AL
              cmp  al,','                   ;","
              jz   nr_ok                    ;
              cmp  al,'0'                   ;"0"
              jb   nxt_nr                   ;
              cmp  al,'9'                   ;"9"
              ja   nxt_nr                   ;
nr_ok:        mov  ah,1                     ;
              int  14h                      ;
              test ah,80h                   ;
              jnz  modem_bad                ;
nxt_nr:       loop getnmbr_loop             ;until done

              mov  al,';'                   ;
              mov  ah,1                     ;
              int  14h                      ;
              test ah,80h                   ;
              jnz  modem_bad                ;

              mov  al,0dh                   ;send "enter" to
              mov  ah,1                     ;
              int  14h                      ;
              test ah,80h                   ;
              jnz  modem_bad                ;

              mov  si,offset pickup_msg     ;"pickup phone" message
              call echo_msg                 ;write string to screen
hangup_lp:    call wait_f_inp               ;
              cmp  al,20h                   ;space bar?
              jnz  hangup_lp                ;

              mov  si,offset hangup_code    ;point to "ATH0" code
              mov  dx,[com_n]
              call write_t_port             ;
xit_dial:     ret                           ;return to main program

test_modem:   mov  ah,0                     ;config communications
              mov  al,port_config           ;port
              mov  dx,[com_n]               ;port nr
              int  14h                      ;

              mov  si,offset modem_strng    ;
              mov  dx,[com_n]               ;
              call write_t_port             ;
              test ah,80h                   ;bit 7 set?
              jz   xit_dial                 ;if not, skip next

modem_bad:    mov  si,offset mod_nr_msg     ;
              call echo_msg                 ;
              mov  dl,7                     ;beep
              mov  ah,2                     ;via
              int  21h                      ;dos
              call wait_f_inp               ;
              call draw_menu                ;
              ret                           ;
dial_prog     endp                          ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
write_t_port  proc near                     ;
              lodsb                         ;load byte at si in al
              or   al,al                    ;is it a zero?
              jz   exit_wtp                 ;then return
              mov  ah,1                     ;write char to port
              int  14h                      ;
              test ah,80h                   ;ok?
              jz   write_t_port             ;yes, repeat
exit_wtp:     ret                           ;
write_t_port  endp                          ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
get_string    proc near                     ;
              push es                       ;
              mov  es,[vid_seg]             ;
              mov  [x_pos],64               ;
              mov  [y_pos],10               ;
              call get_pos                  ;
              mov  di,bx                    ;point to it
              mov  [xy_pos],bx              ;
              call cursor_on                ;
next_key:     call set_cursor               ;
              call wait_f_inp               ;
              cmp  al,1bh                   ;esc key?
              jnz  key_good                 ;
              call cursor_off               ;
              stc                           ;set carry flag
              pop  es                       ;
              ret                           ;and return now

key_good:     cmp  al,0dh                   ;enter key?
              jz   save_string              ;yes, end of string
              cmp  al,8                     ;backspace?
              jne  good_key                 ;if not, good key
bk_space:     cmp  x_pos,64                 ;at the left margin?
              je   next_key                 ;yes, so don't do it
              mov  ah,[msg_attr]            ;bright
              mov  al,20h                   ;space
              stosw                         ;write it
              sub  di,4                     ;back  4 spaces
              stosw                         ;write the space
              dec  di                       ;and backup
              dec  di                       ;some more
              dec  x_pos                    ;update screen pos
              jmp  next_key                 ;and get next key
good_key:     cmp  al,20h                   ;
              jb   next_key                 ;
              cmp  al,64                    ;
              jna  write_key                ;
              and  al,5fh                   ;upper case only
write_key:    mov  ah,msg_attr              ;
              stosw                         ;and write it
              inc  x_pos                    ;
              cmp  x_pos,77                 ;let's stay on the screen
              jne  next_key                 ;
              dec  di                       ;
              dec  di                       ;
              dec  x_pos                    ;
              jmp  next_key                 ;
                                            ;
save_string:  mov  ax,00                    ;mark end of string to
              stosw                         ;match with double 0
              call cursor_off               ;don't need cursor
              pop  es                       ;restore scratch register
                                            ;
              mov  cx,12                    ;12 bytes to search
              mov  ax,[xy_pos]              ;load starting offset
              mov  si,ax                    ;and point to it
              mov  di,offset write_buffer   ;point to temp buffer
              call scrn_t_buf               ;xfer screen bytes to buffer
              clc                           ;clear CF
              ret                           ;

scrn_t_buf:   push ds                       ;
              mov  ds,[vid_seg]             ;
bytes_t_bufr: movsb                         ;move screen bytes to rec buffer
              inc  si                       ;
              loop bytes_t_bufr             ;
              pop  ds                       ;restore data segment
              ret                           ;
get_string    endp                          ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
echo_string   proc near                     ;call with AH=attribute
                                            ;SI and DI set
              push es                       ;write 0 terminated string
              mov  es,[vid_seg]             ;directly to screen
es_1:         lodsb                         ;
              or   al,al                    ;
              jz   xit_es                   ;
              stosw                         ;
              jmp  es_1                     ;
xit_es:       pop  es                       ;
              ret                           ;
echo_string   endp                          ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
echo_msg      proc near                     ;
              push es                       ;
              mov  es,[vid_seg]             ;
              mov  di,menu_pos              ;
              mov  ah,[msg_attr]            ;
              mov  al,0                     ;
              mov  cx,29                    ;
              rep  stosw                    ;
              mov  di,menu_pos              ;retrieve di
em_1:         lodsb                         ;byte at SI in AL
              or  al,al                     ;is it a zero?
              jz  quit_em                   ;we're done, so quit
              stosw                         ;
              jmp em_1                      ;continue ...

quit_em:      pop es                        ;
              ret                           ;
echo_msg      endp                          ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
draw_menu     proc near                     ;
              push si                       ;
              push di                       ;
              push es                       ;
              mov  es,[vid_seg]             ;
              mov  di,menu_pos              ;
              mov  ah,msg_attr              ;
              mov  al,20h                   ;
              mov  cx,29                    ;
              rep  stosw                    ;
              mov  di,menu_pos              ;point to offset
              inc  di                       ;
              inc  di                       ;
              mov  si,offset d_functions    ;point to menu strings
firs_t:       mov  ah,mnu_attr            ;1st char is bright
x_fer1:       lodsb                         ;get char
              stosw                         ;put it on the screen
              cmp  byte ptr[si],0           ;end of tittle?
              jz   next_func                ;then get next one
              mov  ah,msg_attr            ;regular attribute
              jmp  x_fer1                   ;other chars to screen
next_func:    cmp  byte ptr[si+1],24h       ;end of string?
              jz   all_dne                  ;then quit
              add  di,2                     ;advance screen pointer
              inc  si                       ;point to next title
              jmp  firs_t                   ;repeat process
all_dne:      pop  es                       ;
              pop  di                       ;
              pop  si                       ;
              ret                           ;
              endp draw_menu                ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
read_record   proc near                     ;
              call set_f_ptr                ;
              mov  cx,drec_len              ;get one record
              mov  dx,offset read_buffer    ;start of buffer for write
              mov  ah,3fh                   ;read service
              int  21h                      ;
                                            ;
blank_record: push ax                       ;
              push bx                       ;
              push cx                       ;
              push dx                       ;
              push si                       ;
              push di                       ;
              push es                       ;
              mov  si,offset read_buffer    ;point to buffer for read
              mov  es,[vid_seg]             ;
              mov  bx,drec_pos              ;offset
              mov  di,bx                    ;point to it
              mov  dl,6                     ;6 rows of data
xfer_bytes:   mov  cx,drow_len              ;1st field
              call xfer_t_scrn              ;
              dec  dl                       ;
              jnz  xfer_bytes               ;
              mov  al,20h                   ;
              mov  cx,drow_len              ;
              rep  stosw                    ;
write_recno:  mov  di,recnr_pos             ;measure from here
              mov  ax,[rec_nr]              ;load record no
              mov  cx,3                     ;assume three digits
do_digits:    mov  bl,0ah                   ;divide by 10
              div  bl                       ;
              mov  dx,ax                    ;save AX
              mov  al,ah                    ;
              add  al,30h                   ;
              mov  ah,[rev_attr]          ;
              stosw                         ;one digit to the screen
              mov  ax,dx                    ;retrieve AX
              xor  ah,ah                    ;
              sub  di,4                     ;place ahead of previous digit
              loop do_digits                ;for value in cx
              pop  es                       ;
              pop  di                       ;
              pop  si                       ;
              pop  dx                       ;
              pop  cx                       ;
              pop  bx                       ;
              pop  ax                       ;
              ret                           ;
read_record   endp                          ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
set_f_ptr     proc near                     ;
              mov  bx,[df_handle]            ;
              mov  ax,[rec_nr]              ;
              dec  ax                       ;we want the start
              mov  cx,drec_len               ;
              mul  cx                       ;record nr * record size
              xor  cx,cx                    ;will give us offset in
              mov  dx,ax                    ;file
              mov  ax,4200h                 ;set file pointer
              int  21h                      ;dos does it
              ret                           ;
              endp set_f_ptr
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
flush_bufs    proc near                     ;
              push es                       ;
              mov  ax,cs                    ;restore extra segment
              mov  es,ax                    ;
                                            ;
              mov  di,offset read_buffer    ;point to record buffer
              mov  al,20h                   ;load with spaces
              mov  cx,drec_len * 2          ;no of bytes to write
              rep  stosb                    ;fill the buffer
              pop  es                       ;
              ret                           ;
flush_bufs    endp                          ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
load_writebuf proc near                     ;
              push ds                       ;
              mov  ds,[vid_seg]             ;si segment
              mov  ax,cs                    ;restore extra segment
              mov  es,ax                    ;
              mov  bx,drec_pos              ;
              mov  si,bx                    ;point to it
              mov  di,offset write_buffer   ;point to start of rec buffer
              mov  dl,6                     ;7 rows
lw_1:         mov  cx,drow_len              ;bytes in first field
lw_2:         movsb                         ;field from the screen buffer
              inc  si                       ;dont want attribute
              loop lw_2                     ;
              add  bx,row                   ;then adds a row  to source
              mov  si,bx                    ;pointer, ready for next call
              dec  dl                       ;
              jnz  lw_1                     ;
              pop  ds                       ;restore our data segment
              ret                           ;
load_writebuf endp                          ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
read_dfile    proc near                     ;
              push bx                       ;
              push cx                       ;
              push dx                       ;
              mov  bx,df_handle             ;our data file handle
              mov  cx,drec_len              ;pull record at file ptr
              mov  dx,offset read_buffer    ;point to the buffer
              mov  ah,3fh                   ;dos read service
              int  21h                      ;
              pop  dx                       ;
              pop  cx                       ;
              pop  bx                       ;
              ret                           ;
read_dfile    endp                          ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
write_dfile   proc near                     ;cx has bytes to write
                                            ;dx has offset to write from
              mov ah,40h                    ;write function
              mov bx,df_handle              ;temp file handle
              int 21h                       ;dos function
              ret                           ;
write_dfile   endp                          ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
xfer_t_scrn   proc near                     ;
              mov ah,[txt_attr]             ;start with reg attribute
xfer_loop:    lodsb                         ;
              stosw                         ;
              loop xfer_loop                ;
              add  bx,row                   ;
              mov  di,bx                    ;
              ret                           ;
xfer_t_scrn   endp                          ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
get_pos       proc near                     ;calculate screen x,y coordinates
              push ax                       ;destroys ax
              push cx                       ;etc
              xor  bx,bx                    ;screen pos returned in bx
              mov  cx,bx                    ;
              mov  bl,x_pos                 ;
              mov  cl,y_pos                 ;
              mov  ax,160                   ;
              mul  cx                       ;
              shl  bx,1                     ;
              add  bx,ax                    ;
              pop  cx                       ;
              pop  ax                       ;
              ret                           ;
              endp get_pos                  ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
_editor       proc near                     ;

              push es                       ;
              push si                       ;preserve source and
              push di                       ;destination registers

              mov  es,[vid_seg]             ;point ES to video segment

              xor  bx,bx                    ;set register to 0
              mov  cx,bx                    ;as well

              mov  ax,[start_pos]           ;
              mov  di,ax                    ;pointer to starting offset

              mov  al,dleft_margin          ;
              mov  [x_pos],al               ;
              mov  bl,dfirst_row            ;
              mov  al,[next_tdpos]          ;
              add  bl,al                    ;
              mov  [y_pos],bl               ;
              inc  ins_on                   ;default
              call cursor_on                ;show the cursor

get_key:      call set_cursor               ;update cursor position
i_dle:        call wait_f_inp               ;

              cmp  al,1bh                   ;escape key?
              jnz  check_more               ;no, check further
quick_xit:    jmp  e_xit                    ;

check_more:   cmp  al,0dh                   ;is it the enter key?
              jz   next_field               ;it is, so jmp
              cmp  al,020h                  ;is it less than a space?
              jae  ok_char                  ;
              jmp  spec_key                 ;

ok_char:      xor bh,bh                     ;reset bx
              mov bl,drite_margin           ;check the right margin
              cmp x_pos,bl                  ;are we there yet?
              jl  ok_to_add                 ;no, so continue
              jmp char_added                ;otherwise return
ok_to_add:    cmp  ins_on,01                ;is insert on?
              jnz  no_insert                ;no, so jmp
              mov  cx,bx                    ;get the right margin
              sub  cl,x_pos                 ;and subtract cursor
              dec  cx                       ;chars to move minus one
              push di                       ;save di for now
              push ds                       ;
              mov  ds,[vid_seg]             ;make video segment
              push cx                       ;preserve cx for moment
              shl  cx,1                     ;times 2 to incl attributes
              add  di,cx                    ;and add it to di, to point
              mov  si,di                    ;to end of field
              dec  si                       ;then, back up si one char
              dec  si                       ;and attribute
              pop  cx                       ;number of words to move
              std                           ;in reverse
              repnz                         ;
              movsw                         ;move field up one char
              cld                           ;restore direction
              pop  ds                       ;restore data segment
              pop  di                       ;restore pointer
no_insert:    mov  ah,txt_attr              ;reverse attrib
              stosw                         ;char to the screen
              inc  x_pos                    ;and update the cursor
              mov  al,x_pos                 ;get cursor pos
              cmp  al,drite_margin          ;at the right margin now?
              jl   char_added               ;not yet
              jmp  next_field               ;down a row
char_added:   jmp  get_key                  ;now wait for next key

next_field:   mov  al,dlast_row
              cmp  [y_pos],al               ;at the bottom row yet?
              jnz  ok_next_row              ;if not, continue
              dec  di                       ;otherwise
              dec  di                       ;undo cursor
              dec  x_pos                    ;advance
              jmp  get_key                  ;yes, so quit
ok_next_row:  inc  y_pos                    ;go to next row
              mov  al,dleft_margin          ;
              mov  x_pos,al                 ;start of row
              call get_pos                  ;get new screen position
              mov  di,bx                    ;update screen pointer
              jmp  get_key                  ;and wait for next key

back_space:   mov  al,dleft_margin          ;
              inc  al                       ;
              cmp  x_pos,al                 ;can we go back?
              jae  backsp_on                ;we're still ok
              mov  ah,dfirst_row            ;
              cmp  y_pos,ah                 ;are we on the first row?
              je   quit_backsp              ;if we are, no more backspace
              dec  y_pos                    ;go up a row
              mov  ah,drite_margin          ;
              mov  x_pos,ah                 ;
              call get_pos                  ;
              mov  di,bx                    ;
              call set_cursor               ;
backsp_on:    mov  ah,txt_attr              ;highligthed character
              mov  al,20h                   ;load a space char
              dec  di                       ;back up
              dec  di                       ;one more
              stosw                         ;add the space
              dec  di                       ;back up some more
              dec  di                       ;
              dec  x_pos                    ;adjust cursor
quit_backsp:  jmp  get_key                  ;

spec_key:     cmp  ah,75h                   ;"end" key?
              jne  spec_key2                ;
              push ax                       ;save keycode
              mov  ah,2                     ;check keyb status byte
              int  16h                      ;
              test ax,4                     ;Ctrl key down too?
              pop  ax                       ;retrieve it
              jz   spec_key2                ;no, continue
              inc  [save_edit]              ;yes, set flag
              jmp  e_xit                    ;and quit routine

spec_key2:    cmp  al,08                    ;backspace key?
              je   back_space               ;yes it is
              cmp  ah,4bh                   ;
              je   left_key                 ;
              cmp  ah,4dh                   ;
              je   right_key                ;
              cmp  ah,48h                   ;
              je   up_key                   ;
              cmp  ah,50h                   ;
              je   dwn_key                  ;
              jmp  more_keys                ;

left_key:     mov  al,dleft_margin          ;
              cmp  x_pos,al                 ;at the left margin yet?
              jle  quit_left                ;yes we are, so quit
              dec  di                       ;otherwise, back up
              dec  di                       ;one word
              dec  x_pos                    ;and update the cursor
quit_left:    jmp  get_key                  ;and wait for next key

right_key:    mov  al,drite_margin          ;get the right margin
              dec  al                       ;
              cmp  x_pos,al                 ;can we still move?
              jz   quit_rite                ;no we can't, so quit
              inc  di                       ;otherwise, move up
              inc  di                       ;one word
              inc  x_pos                    ;and update the cursor
quit_rite:    jmp  get_key                  ;and wait for next key

up_key:       mov  al,dfirst_row            ;
              cmp  [y_pos],al               ;are we at the top yet?
              jz   quit_up                  ;if so, quit
              dec  y_pos                    ;up a row
              call get_pos                  ;and move screen
              mov  di,bx                    ;pointer up one row
quit_up:      jmp  get_key                  ;now wait for next key

dwn_key:      mov  al,dlast_row             ;
              cmp  [y_pos],al               ;at the bottom yet?
              jz   quit_down                ;if so, quit
              inc  y_pos                    ;cursor down a row
              mov  al,drite_margin           ;get right margin
              cmp  x_pos,al                 ;are we ok?
              jl   go_down                  ;if so, do it
              mov  x_pos,al                 ;adjust cursor position
              dec  x_pos                    ;minus 1
go_down:      call get_pos                  ;
              mov  di,bx                    ;
quit_down:    jmp  get_key                  ;

more_keys:    cmp  ah,52h                   ;insert key down?
              je   ins_key                  ;
              cmp  ah,53h                   ;remove key down?
              je   del_key                  ;
x_keys:       jmp  get_key                  ;

ins_key:      cmp  ins_on,1                 ;is the insert mode one?
              jnz  switch_on                ;if not, switch it on
              mov  ah,1                     ;otherwise
              mov  cx,reg_cursor            ;restore regular
              int  10h                      ;cursor
              dec  ins_on                   ;and switch flag off
              jmp  get_key                  ;wait for next key
switch_on:    mov  ah,1                     ;draw cursor
              mov  cx,big_cursor            ;large model
              int  10h                      ;dos function
              inc  ins_on                   ;set insert flag
              jmp  get_key                  ;wait for next key

del_key:      push di                       ;save our screen pointer
              mov  al,drite_margin          ;get the right margin
              sub  al,x_pos                 ;and subtract cursor location
              mov  cl,al                    ;balance in counter
              xor  ch,ch                    ;then,
              dec  cx                       ;subtract one char + attribute
              push es                       ;make video segment
              pop  ds                       ;our data address
              mov  si,di                    ;line up to and fro pointers
              inc  si                       ;move source up one
              inc  si                       ;plus attribute byte
              rep  movsw                    ;move string back one char

              mov  ax,cs                    ;restore data segment
              mov  ds,ax                    ;

              mov  ah,txt_attr              ;and add a
              mov  al,20h                   ;blank space
              stosw                         ;print this word
              pop   di                      ;restore our pointer
              jmp  get_key                  ;
                                            ;
e_xit:        mov [ins_on],0                ;insert flag to 0
              call cursor_off               ;remove cursor
              pop  di                       ;
              pop  si                       ;
              pop  es                       ;
              ret                           ;return to caller
_editor       endp                          ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
cursor_off    proc near                     ;
              mov  ah,01                    ;make cursor
              mov  cx,2000h                 ;invisible
              int  10h                      ;
              ret                           ;
              endp cursor_off               ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
cursor_on     proc near                     ;
              mov  ah,1                     ;make cursor
              mov  cx,cs:big_cursor         ;visible
              int  10h                      ;dos service
              ret                           ;
              endp cursor_on                ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
set_cursor    proc near                     ;
              xor  bx,bx                    ;0 page
              mov  dh,[y_pos]               ;y pos
              mov  dl,[x_pos]               ;and our cursor
              mov  ah,02                    ;and now set the cursor
              int  10h                      ;dos function
              ret                           ;go back
              endp set_cursor               ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
draw_box      proc near                     ;BX=xy position
                                            ;CX=width
                                            ;DX=hight
              mov  di,bx                    ;point to screen position
              mov  ah,lne_attr              ;attribute
              mov  si,offset box            ;point to box parts
              lodsb                         ; in al
              stosw                         ;write to screen                             ;retrieve width
              mov  bx,cx                    ;save width
              lodsb                         ; in al
              rep  stosw                    ;until done
              lodsb                         ;  in al
              stosw                         ;write to screen
              lodsb                         ; in al
              mov  cx,dx                    ;save it
r_ight:       add  di,(row - 2)             ;advance a row
              stosw                         ;write to screen
              loop r_ight                   ;
              add  di,(row - 2)             ;add a row
              lodsb                         ;D9h 
              stosw                         ;
              sub  di,+04                   ;
              mov  cx,bx                    ;retrieve width
              lodsb                         ; in al
              std                           ;from right to left
              repz stosw                    ;until all done
              cld                           ;normal direction
              lodsb                         ; in al
              stosw                         ;to the screen
              mov  cx,dx                    ;retrieve hight
              lodsb                         ;
l_eft:        sub  di,(row + 2)             ;reduce a row
              stosw                         ;to the screen
              loop l_eft                    ;until done - window done
              ret                           ;
draw_box      endp                          ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;local buffer space is next

EVEN
rr            =$                            ;peg offset
read_buffer   =rr                           ;up from here
rr            =rr + drec_len                ;record buffer 1
write_buffer  =rr                           ;
rr            =rr + drec_len                ;record buffer 2
scrn_buffer   =rr                           ;
rr            =rr + 972                     ;display save buffer
end_of_bufrs  =rr                           ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;NON RESIDENT PART OF PROGRAM STARTS HERE;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;DISPOSABLE DATA AREA

sign_on_msg   db  cr,lf
              db  'DIALER.COM Installed',cr,lf
              db  '(c) R.Re, 1991, 1992',cr,lf
              db  'Hotkey is LEFT <Ctrl> + RIGHT <Shift>',cr,lf
              db  'DIALER /? for Info',cr,lf
              db  '$'
error_msg     db  cr,lf
              db  'DIALER.COM already installed ...',cr,lf
              db  'LEFT <Ctrl> + RIGHT <Shift> to activate ...',cr,lf,lf,'$'
old_dos_msg   db  cr,lf
              db  'Sorry, DIALER.COM requires DOS Version 3 or higher ...',cr,lf,'$'
error_msg2    db  cr,lf
              db  'Sorry, file creation error found. DIALER.COM NOT installed ...',cr,lf,'$'
info_msg      db  cr,lf
              db  ' DIALER.COM is a TSR requiring 4k of RAM.',cr,lf
              db  'Hotkey is LEFT <Ctrl> + RIGHT <Shift>',cr,lf,lf
              db  ' DIALER.COM can be pulled up anywhere EXCEPT in ',cr,lf
              db  'graphics modes.',cr,lf,lf
              db  ' If you have a modem DIALER can be configured',cr,lf
              db  'with a [1] or a [2] at the command line to specify',cr,lf
              db  'the COM1 or COM2 port (default is COM1) -- as follows:',cr,lf
              db  'DIALER /1',44,' or DIALER /2 ',cr,lf,lf
              db  ' Program designed to run with MDA or VGA adapters',cr,lf
              db  'only. Requires DOS 3 or higher and can be safely ',cr,lf
              db  'loaded high under DOS 5,6.',cr,lf,lf
              db  ' DIALER.COM Version 2.1 - (c) 1991, 1992, Robert Re',cr,lf
              db  'West Vancouver, B.C, Canada.',cr,lf,'$'

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;INSTALL RESIDENT PART;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
install_tsr:  cld                           ;all string ops fwd
              mov  ax,3000h                 ;get dos version
              int  21h                      ;
              cmp  al,3                     ;are we at least DOS 3?
              jae  chk_ctail                ;jmp if ok
              mov  dx,offset old_dos_msg    ;
              jmp  xit_install              ;

chk_ctail:    mov  di,81h                   ;point to command tail arg
              mov  cl,[di-1]                ;get arg length
              or   cl,cl                    ;
              jz   find_copy                ;jump if not zero
              mov  al,'/'                   ;
              repne scasb                   ;find switch character
              jne  find_copy                ;if not found
              mov  al,[di]                  ;get next byte in ctail
              cmp  al,'?'                   ;info request?
              jnz  chk_switch2              ;jump if not
              mov  dx,offset info_msg       ;else program info to the screen
              jmp  xit_install              ;

chk_switch2:  cmp  al,'1'                   ;less than 1?
              jl   find_copy                ;jump if less
              cmp  al,'4'                   ;
              ja   find_copy                ;jump if more
              sub  al,31h                   ;
              xor  ah,ah                    ;
              mov  com_n,ax                 ;save com port nr

find_copy:    mov  bx,offset start          ;
              not  byte ptr [bx]            ;fingerprint
              xor  dx,dx                    ;
              mov  ax,cs                    ;
next_parag:   inc  dx                       ;
              mov  es,dx                    ;
              cmp  dx,ax                    ;
              jz   get_psp                  ;ok to continue
              mov  si,bx                    ;
              mov  di,bx                    ;
              mov  cx,16                    ;
              rep  cmpsb                    ;
              jnz  next_parag               ;
              mov  dx,offset error_msg      ;already installed message
              jmp  xit_install              ;

get_psp:      mov  ah,62h                   ;get psp address
              int  21h                      ;
              mov  es,bx                    ;put in bx

get_envseg:   mov  ax,es:[002ch]            ;get segment of env block
              mov  es,ax                    ;point to it
              xor  di,di                    ;zero pointer

              xor  al,al                    ;
              mov  cx,8000h                 ;max len of block
              cld                           ;
find_00:      repnz scasb                   ;find a zero
              cmp  byte ptr es:[di],0       ;is next byte also 0?
              jne  find_00                  ;keep looking if not

              inc  di                       ;past one 0
              inc  di                       ;and the final 0
              inc  di                       ;
              mov  si,di                    ;make this our source

              mov ax,es                     ;save envir segment
              push ds                       ;
              pop  es                       ;
              push ds                       ;save our data segment
              mov  ds,ax                    ;envir seg is data segment

              mov  di,offset dfile_name     ;
xfer_path:    lodsb                         ;
              or   al,al                    ;end of path string?
              jz   path_done                ;
              stosb                         ;
              jmp  xfer_path                ;
path_done:    stosb                         ;we want this last zero
              pop  ds                       ;restore our data segment

              mov  byte ptr [di-4],'D'      ;change .COM extention
              mov  byte ptr [di-3],'B'      ;to .DBS for data file
              mov  byte ptr [di-2],'S'      ;

try_open:     mov  ah,3dh                   ;open file
              mov  al,2                     ;mode 2=read/write
              mov  dx,offset dfile_name     ;
              int  21h                      ;dos function
              jnc  file_ok                  ;no carry, so ...

              mov  ah,3ch                   ;no file exists, try create one ...
              xor  cx,cx                    ;regular attrib
              int  21h                      ;dos function
              jnc  file_ok                  ;if no problem ...
              mov  dx,offset error_msg2     ;there was a problem ...

xit_install:  mov  ah,9                     ;DX has offset for error msg
              int  21h                      ;
              mov  ax,4c01h                 ;leave with error code 1
              int  21h                      ;

file_ok:      mov  bx,ax                    ;file handle
              mov  ah,3eh                   ;close file
              int  21h                      ;dos does it

;load communication defaults for current setup

assign_ports: cmp  com_n,0ffh               ;com port specified?
              jz   cfg_video                ;if not, skip routine
              cmp  com_n,0                  ;com1 specified?
              ja   ap_1                     ;
              mov  [com_data],03f8h         ;com1
              mov  [com_sts],03fdh          ;
ap_1:         cmp  com_n,1                  ;
              ja   ap_2                     ;
              mov  [com_data],02f8h         ;com2
              mov  [com_sts],02fdh          ;
ap_2:         cmp  com_n,2                  ;
              ja   ap_3                     ;
              mov  [com_data],03e8h         ;com3
              mov  [com_sts],03edh          ;
              jmp  cfg_video                ;
ap_3:         mov  [com_data],02e8h         ;com4
              mov  [com_sts],02edh          ;

;check video card

cfg_video:    mov  ax,40h                   ;
              mov  es,ax                    ;point to bios
              cmp  word ptr es:[63h],03b4h  ;is this a mono card?

              mov  ax,cs                    ;restore data segment
              mov  es,ax                    ;

              jne  drop_envir               ;if not, skip next

              sub  [vid_seg],0800h          ;load mono video defaults
              mov  reg_cursor,0b0ch         ;install bw cursors
              mov  big_cursor,070ah         ;
              mov  reg_attr,7               ;and bw attributes
              mov  rev_attr,70h             ;
              mov  msg_attr,7               ;
              mov  lne_attr,7               ;
              mov  txt_attr,7               ;
              mov  mnu_attr,0fh             ;

drop_envir:   push es                       ;
              mov  ax,ds:[02ch]             ;get environment
              mov  es,ax                    ;
              mov  ah,49h                   ;
              int  21h                      ;and release environment block
              pop  es                       ;

check_mouse:  mov  ax,0                     ;is there mouse support?
              int  33h                      ;
              or   ax,ax                    ;
              jnz  get_indos                ;
              inc  [no_mouse]               ;save no_mouse status
                                                                                        ;
get_indos:    mov  ah,34h                   ;
              int  21h                      ;
              mov  word ptr in_dos,bx       ;store INDOS address
              mov  word ptr in_dos[2],es    ;

get_ceflag:   dec bx                        ;assume dos v3 and up
              mov word ptr cef_ptr,bx       ;store address of ceflag
              mov word ptr cef_ptr[2],es    ;etc

;install our interrupt handlers

              mov  ax,3508h                 ;get timer interrupt
              int  21h                      ;
              mov  word ptr int_8,bx        ;
              mov  word ptr int_8[2],es     ;
              mov  ah,25h                   ;
              lea  dx,[timer_int]           ;
              int  21h                      ;

              mov  ax,3509h                 ;get keyb int
              int  21h                      ;
              mov  word ptr int_9,bx        ;
              mov  word ptr int_9[2],es     ;
              mov  ah,25h                   ;
              lea  dx,[keyb_int]            ;new interrupt calling address
              int  21h                      ;

              mov  ax,3528h                 ;get idle_int
              int  21h                      ;
              mov  word ptr int_28,bx       ;
              mov  word ptr int_28[2],es    ;
              mov  ah,25h                   ;
              lea  dx,[idle_int]            ;
              int  21h                      ;

;our sign on message to the screen

              mov  dx,offset sign_on_msg    ;point to sign on msg
              mov  ah,9                     ;string to screen
              int  21h                      ;

;terminate program and install resident portion

              mov  dx,(offset end_of_bufrs - offset code + 15) shr 4
              mov  ax,3100h                 ;amount of memory to keep resident
              int 21h                       ;in paragraphs
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
code          ends                          ;
end           start                         ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;



