;*******************************************************************************
;* Assembly Subroutines For DECGIF3.BAS
;* By Rich Geldreich 1992
;* Assembled with TASM v2.00
;*
;* Routines to set lines of pixels for the 320x200x256 mode, 
;* X320x240x256 & X360x480x256 undocumented modes, and 16 color modes.
;*
;* (Sorry it's not documented yet!) 
.286
Ideal
Model Small

Public SetPixels, SetMode, SetWidth

Macro   SepPlanes
        Lodsb
        Inc     si
        Shr     al, 1
        Rcl     bl, 1
        Shr     al, 1
        Rcl     bh, 1
        Shr     al, 1
        Rcl     dl, 1
        Shr     al, 1
        Rcl     dh, 1
Endm


Codeseg
Even
ScreenWidth     dw 90
ScreenOffset    dw 0
JumpTable       dw VGAN, VGAX, EGA
VidMode         dw VGAN

TStart          dw 0
TNum            dw 0

Even
Proc    SetPixels ;XOffset, A() X  Y N
                  ;   14    12  10 8 6
                  
        Push    bp
        Mov     bp, sp
        Push    es ds si di
        
        Mov     ax, 0A000h
        Mov     es, ax
        
        Mov     di, [ss:bp+12]
        Mov     si, [ds:di+0Ah]
        Mov     ds, [ds:di+02h]
        Mov     ax, [ss:bp+14]
        Shl     ax, 1
        Add     si, ax
        
        Jmp     [cs:VidMode]
        Even
VGAN:
        Imul    di, [ss:bp+8], 320
        Add     di, [ss:bp+10]
        Mov     cx, [ss:bp+6]
        Jcxz    @@7
;This *should* be in-line coded for maximum speed, but the decompressor
;is so slow it didn't make much of a difference so I left out this 
;optimization.
        Even
@@5:
        Movsb
        Inc     si
        Loop    @@5
@@7:                
        Pop     di si ds es bp
        Retf    10
        Even
VGAX:                   
        Mov     cx, [ss:bp+10]
        Mov     di, cx
        Shr     di, 2
        
        Mov     ax, [cs:ScreenWidth]
        Mul     [word ss:bp+08]
        Add     di, ax
        Add     di, [cs:ScreenOffset]
        
        Mov     dx, 03C4h
        Mov     al, 2
        Out     dx, al

        And     cl, 03h
        Mov     al, 1
        Shl     al, cl
        Mov     cx, [ss:bp+06]
        Jcxz    @@exit
        Mov     bp, 4
@@10:
        Mov     dx, 03C5h
        Out     dx, al
        
        Push    si di cx
        
        Add     cx, 3
        Shr     cx, 2
        Mov     dx, cx
        Shr     cx, 3
        And     dx, 07h
        Mov     bx, dx
        Shl     dx, 1
        Add     dx, bx
        Neg     dx
        Add     dx, offset @@20
        Mov     bx, 7
        Jmp     dx
        
        Rept    7
        Movsb
        Add     si, bx
        Endm
@@20:
        Jcxz    @@40
        Even
@@30:
        Rept    8
        Movsb
        Add     si, bx
        Endm
        Loop    @@30                                                
@@40:
        Pop     cx di si
        Inc     si
        Inc     si
        
        Shl     al, 1
        Cmp     al, 16
        Je      @@Sp1

        Dec     bp
        Loopnz  @@10
@@Exit:        
        Pop     di si ds es bp
        Retf    10
        Even
@@Sp1:
        Inc     di
        Mov     al, 1
        Dec     bp
        Loopnz  @@10
        Jmp     @@Exit
        Even
EGA:
        Mov     ax, [cs:ScreenWidth]
        Mul     [word ss:bp+8]
        Mov     di, ax
        Mov     ax, [ss:bp+10]
        Mov     cx, ax
        Shr     ax, 3
        Add     di, ax
        Add     di, [cs:ScreenOffset]

        Mov     bp, [ss:bp+06]
        And     bp, bp
        Jz      @@Exit
        Mov     [cs:TNum], bp
        
        Mov     dx, 03C4h
        Mov     al, 2
        Out     dx, al
        
        Mov     dl, 0CEh        
        Mov     al, 8
        Out     dx, al
        
        And     cx, 7
        
        Jcxz    @@ByteAligned
        Neg     cx
        Add     cx, 8
                
        Xor     bx, bx
        Mov     dx, bx
        Mov     ah, 0ffh
        Even
@@EG1:        
        SepPlanes
        Shl     ah, 1
        Dec     bp
        Loopnz  @@EG1
        Shl     bx, cl
        Shl     dx, cl
        Rol     ah, cl
        Mov     [cs:TNum], bp
        
        Mov     bp, dx
        Mov     dx, 03CFh
        Mov     al, ah
        Not     al
        Out     dx, al
        Mov     dl, 0C5h
        Mov     al, [es:di]
        
        Mov     al, 1
        Out     dx, al
        Mov     [es:di], bl
        Shl     al, 1
        Out     dx, al
        Mov     [es:di], bh
        Shl     al, 1
        Out     dx, al
        Mov     bx, bp
        Mov     [es:di], bl
        Shl     al, 1
        Out     dx, al
        Mov     [es:di], bh
        
        Mov     dl, 0CFh
        Mov     al, 0ffh
        Out     dx, al
        
        Inc     di
        Even
@@ByteAligned:
        Mov     bp, 03C5h
        Mov     cx, [cs:TNum]
        Shr     cx, 3
        And     cx, cx
        Jnz     @@EG2
        Jmp     @@NoRuns
        Even
@@EG2:
        Xor     bx, bx
        Mov     dx, bx
        
        Rept    8
        SepPlanes
        Endm
                        
        Xchg    bp, dx
        Mov     al, 1
        Out     dx, al
        Mov     [es:di], bl
        Shl     al, 1
        Out     dx, al
        Mov     [es:di], bh
        Shl     al, 1
        Out     dx, al
        Mov     bx, bp
        Mov     [es:di], bl
        Shl     al, 1
        Out     dx, al
        Mov     [es:di], bh
        Mov     bp, dx
        
        Inc     di
        Dec     cx
        Jz      @@NoRuns
        Jmp     @@EG2
        Even        
@@NoRuns:
        Mov     cx, [cs:TNum]
        And     cx, 7
        Jcxz    @@AllDone
        
        Xor     bx, bx
        Mov     dx, bx
        Mov     ah, 0ffh

        Push    cx
        Even
@@EG3:
        SepPlanes
        Shl     ah, 1
        Loop    @@EG3
        Pop     cx

        Neg     cl
        Add     cl, 8
        Shl     bx, cl
        Shl     dx, cl
        Rol     ah, cl
        
        Xchg    bp, dx
        Mov     dl, 0CFh
        Mov     al, ah
        Not     al
        Out     dx, al
        Mov     dl, 0C5h
        Mov     al, [es:di]
        
        Mov     al, 1
        Out     dx, al
        Mov     [es:di], bl
        Shl     al, 1
        Out     dx, al
        Mov     [es:di], bh
        Shl     al, 1
        Out     dx, al
        Mov     bx, bp
        Mov     [es:di], bl
        Shl     al, 1
        Out     dx, al
        Mov     [es:di], bh
        
        Mov     al, 0fh
        Out     dx, al
        
        Mov     dl, 0CFh
        Mov     al, 0ffh
        Out     dx, al
@@AllDone:
        Pop     di si ds es bp
        Retf    10        
Endp    SetPixels

Proc    SetMode
        Push    bp
        Mov     bp, sp

        Mov     bx, [ss:bp+06]
        Shl     bx, 1
        Add     bx, offset JumpTable
        Mov     ax, [cs:bx]
        Mov     [cs:VidMode], ax
        
        Pop     bp
        Retf    2
Endp    SetMode
Proc    SetWidth
        Push    bp
        Mov     bp, sp
        
        Mov     ax, [ss:bp+06]
        Mov     [cs:ScreenWidth], ax
        
        Pop     bp
        Retf    2
Endp    SetWidth
End
                
