;*******************************************************************************
;* Assembly Subroutines For DECGIF3.BAS 
;* By Rich Geldreich 1992
;* Assembled with TASM v2.00
;*
;* Routines to set an RGB palette for VGA/EGA.
;* 
;* 
;*
.286
Ideal
Model Small

Public  ShowRGB

Codeseg

PalOffset       equ [ss:bp+12]
PalSegment      equ [ss:bp+10]
NumColors       equ [ss:bp+08]
VGA             equ [word ss:bp+06]

Proc    ShowRGB
        Push    bp                      ;Make stack frame.
        Mov     bp, sp
        Push    ds si di                ;Save regs
        
        Mov     si, PalOffset           ;ds:si addresses palette now.
        Mov     ds, PalSegment
        Mov     cx, NumColors           ;cx has number of colors in palette.
        
        Cmp     VGA, 0
        Jz      @@EGA                   
        
        Mov     ax, cx                  ;*3
        Shl     ax, 1
        Add     cx, ax
        
        Mov     dx, 03C7h               
        Xor     al, al
        Out     dx, al
        Inc     dx
        Out     dx, al
        Inc     dx
        
        Even
@@PalLoop1:
        Lodsb
        Shr     al, 2
        Out     dx, al
        Loop    @@PalLoop1              ;Jump if more left.
        
        Pop     di si ds bp              
        Retf    8        

@@EGA:
        Mov     bl, ch

@@PalLoop2:
        Xor     bh, bh
        
        ;**** Red
        Lodsb                           ;Converts an 8-Bit RGB palette
        Test    al, 128                 ;into something the BIOS can
        Jz      @@10                    ;handle.
        Or      bh, 4
@@10:
        Test    al, 64
        Jz      @@20
        Or      bh, 32
@@20:

        ;**** Green
        Lodsb
        Test    al, 128
        Jz      @@30
        Or      bh, 2
@@30:
        Test    al, 64
        Jz      @@40
        Or      bh, 16
@@40:

        ;**** Blue
        Lodsb
        Test    al, 128
        Jz      @@50
        Or      bh, 1
@@50:
        Test    al, 64
        Jz      @@60
        Or      bh, 8
@@60:
        Mov     ax, 01000h              ;Let BIOS do the dirty work this time.
        Int     010h                    
        
        Inc     bl                      
        
        Loop    @@PalLoop2              ;Loop if more colors.
        
        Pop     di si ds bp             
        Retf    8
Endp    ShowRGB
End
