;	DESC:	Takes in parameter string retrieved from DOS level   V1.00
;		and breaks the string into separate elements using
;		commas and the end of line as the only breaks.
;	IN:	*{SEG_VAL} segment and
;		*{OFFSET} offset of parameter string
;		*{LENGTH} length of parameter string
;	OUT:	*{N} n is the number of sets of segment,offset  and length
;		 groups returned, which indicates the number of total
;		 parameters passed to the program.
;		*{OSEG_VAL,OOFFSET,OLENGTH} repeated N times
;		 and returned in reverse order (i.e. P3, P2 , P1)
;	SAMPLE:	Callm	PARM_BRK,<SEG_VAL,OFFSET,LENGTH>,
;		                 <N,<OSEG_VAL,OOFFSET,OLENGTH>>
;	################################################################### 

	Extrn	PUSHALL:Near
	Extrn	POPALL:Near
	Extrn	SCAN_BYT:Near


PARM_BRC	Segment Para Public 'CODE'
	Assume	CS:PARM_BRC
	Public	PARM_BRK

	Include	CALLM.MAC

						;notice.
	DB	'PARM_BRK - V1.00, Copyright 1987, CoreTechs   ',0DH,0AH

PARM_BRK	Proc	Near

	Call	PUSHALL				;save registers.

	Pop	CX				;recover length.
	Pop	BP				;recover offset.
	Pop	ES				;recover segment.

	Jcxz	OUT0				;if no parameters exit.
	Jmp	CONT1
OUT0:	Jmp	OUT

CONT1:	Mov	CX,0				;clear N.

						;scan for commas or spaces
						;as the delimiting character.
CONT2:	Cld					;in the forward direction.
	Callm	SCAN_BYT,<',',ES,BP,0,2>,<AX,BX>

	Mov	DX,BX				;save beginning of next
	Inc	DX				;parameter.

	Mov	ES:BYTE PTR[BX],0		;place zero byte at end.
	Sub	BX,BP				;find length of string.

	Push	BX
	Push	BP
	Push	ES

	Mov	BP,DX				;move pointer along

	Inc	CX				;increment N.

	Cmp	AX,0				;if end of par. block
	Jz	OUT				;then return.

	Jmp	CONT2				;else continue.

OUT:	Push	CX				;save N.

	Call	POPALL				;recover registers.
	Ret

PARM_BRK	Endp
PARM_BRC	Ends
	End
